/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import javolution.util.FastList;

public class PcInventory
extends Inventory {
    public static final int ADENA_ID = 57;
    public static final int ANCIENT_ADENA_ID = 5575;
    public static final long MAX_ADENA = 99900000000L;
    private final L2PcInstance _owner;
    private L2ItemInstance _adena;
    private L2ItemInstance _ancientAdena;

    public PcInventory(L2PcInstance owner) {
        this._owner = owner;
    }

    @Override
    public L2PcInstance getOwner() {
        return this._owner;
    }

    @Override
    protected L2ItemInstance.ItemLocation getBaseLocation() {
        return L2ItemInstance.ItemLocation.INVENTORY;
    }

    @Override
    protected L2ItemInstance.ItemLocation getEquipLocation() {
        return L2ItemInstance.ItemLocation.PAPERDOLL;
    }

    public L2ItemInstance getAdenaInstance() {
        return this._adena;
    }

    @Override
    public long getAdena() {
        return this._adena != null ? this._adena.getCount() : 0L;
    }

    public L2ItemInstance getAncientAdenaInstance() {
        return this._ancientAdena;
    }

    public long getAncientAdena() {
        return this._ancientAdena != null ? this._ancientAdena.getCount() : 0L;
    }

    public L2ItemInstance[] getUniqueItems(boolean allowAdena, boolean allowAncientAdena) {
        return this.getUniqueItems(allowAdena, allowAncientAdena, true);
    }

    public L2ItemInstance[] getUniqueItems(boolean allowAdena, boolean allowAncientAdena, boolean onlyAvailable) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (!allowAdena && item.getItemId() == 57 || !allowAncientAdena && item.getItemId() == 5575) continue;
            boolean isDuplicate = false;
            for (L2ItemInstance litem : list) {
                if (item == null || litem.getItemId() != item.getItemId()) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate || onlyAvailable && (!item.isSellable() || !item.isAvailable(this.getOwner(), false, false))) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getUniqueItemsByEnchantLevel(boolean allowAdena, boolean allowAncientAdena) {
        return this.getUniqueItemsByEnchantLevel(allowAdena, allowAncientAdena, true);
    }

    public L2ItemInstance[] getUniqueItemsByEnchantLevel(boolean allowAdena, boolean allowAncientAdena, boolean onlyAvailable) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !allowAdena && item.getItemId() == 57 || !allowAncientAdena && item.getItemId() == 5575) continue;
            boolean isDuplicate = false;
            for (L2ItemInstance litem : list) {
                if (litem.getItemId() != item.getItemId() || litem.getEnchantLevel() != item.getEnchantLevel()) continue;
                isDuplicate = true;
                break;
            }
            if (isDuplicate || onlyAvailable && (!item.isSellable() || !item.isAvailable(this.getOwner(), false, false))) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId) {
        return this.getAllItemsByItemId(itemId, true);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, boolean includeEquipped) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItemId() != itemId || !includeEquipped && item.isEquipped()) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, int enchantment) {
        return this.getAllItemsByItemId(itemId, enchantment, true);
    }

    public L2ItemInstance[] getAllItemsByItemId(int itemId, int enchantment, boolean includeEquipped) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getItemId() != itemId || item.getEnchantLevel() != enchantment || !includeEquipped && item.isEquipped()) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAvailableItems(boolean allowAdena, boolean allowNonTradeable) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.isAvailable(this.getOwner(), allowAdena, allowNonTradeable)) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getAugmentedItems() {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || !item.isAugmented()) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public L2ItemInstance[] getElementItems() {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            if (item == null || item.getElementals() == null) continue;
            list.add((Object)item);
        }
        L2ItemInstance[] result = (L2ItemInstance[])list.toArray((Object[])new L2ItemInstance[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public TradeList.TradeItem[] getAvailableItems(TradeList tradeList) {
        FastList list = FastList.newInstance();
        for (L2ItemInstance item : this._items) {
            TradeList.TradeItem adjItem;
            if (item == null || !item.isAvailable(this.getOwner(), false, false) || (adjItem = tradeList.adjustAvailableItem(item)) == null) continue;
            list.add((Object)adjItem);
        }
        TradeList.TradeItem[] result = (TradeList.TradeItem[])list.toArray((Object[])new TradeList.TradeItem[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    public void adjustAvailableItem(TradeList.TradeItem item) {
        boolean notAllEquipped = false;
        for (L2ItemInstance adjItem : this.getItemsByItemId(item.getItem().getItemId())) {
            if (adjItem.isEquipable()) {
                if (adjItem.isEquipped()) continue;
                notAllEquipped |= true;
                continue;
            }
            notAllEquipped |= true;
            break;
        }
        if (notAllEquipped) {
            L2ItemInstance adjItem = this.getItemByItemId(item.getItem().getItemId());
            item.setObjectId(adjItem.getObjectId());
            item.setEnchant(adjItem.getEnchantLevel());
            if (adjItem.getCount() < item.getCount()) {
                item.setCount(adjItem.getCount());
            }
            return;
        }
        item.setCount(0L);
    }

    public void addAdena(String process, long count, L2PcInstance actor, L2Object reference) {
        if (count > 0L) {
            this.addItem(process, 57, count, actor, reference);
        }
    }

    public boolean reduceAdena(String process, long count, L2PcInstance actor, L2Object reference) {
        if (count > 0L) {
            return this.destroyItemByItemId(process, 57, count, actor, reference) != null;
        }
        return false;
    }

    public void addAncientAdena(String process, long count, L2PcInstance actor, L2Object reference) {
        if (count > 0L) {
            this.addItem(process, 5575, count, actor, reference);
        }
    }

    public boolean reduceAncientAdena(String process, long count, L2PcInstance actor, L2Object reference) {
        if (count > 0L) {
            return this.destroyItemByItemId(process, 5575, count, actor, reference) != null;
        }
        return false;
    }

    @Override
    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, L2Object reference) {
        if ((item = super.addItem(process, item, actor, reference)) != null && item.getItemId() == 57 && !item.equals(this._adena)) {
            this._adena = item;
        }
        if (item != null && item.getItemId() == 5575 && !item.equals(this._ancientAdena)) {
            this._ancientAdena = item;
        }
        return item;
    }

    @Override
    public L2ItemInstance addItem(String process, int itemId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = super.addItem(process, itemId, count, actor, reference);
        if (item != null && item.getItemId() == 57 && !item.equals(this._adena)) {
            this._adena = item;
        }
        if (item != null && item.getItemId() == 5575 && !item.equals(this._ancientAdena)) {
            this._ancientAdena = item;
        }
        if (item != null && actor != null) {
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate playerIU = new InventoryUpdate();
                playerIU.addItem(item);
                actor.sendPacket(playerIU);
            } else {
                actor.sendPacket(new ItemList(actor, false));
            }
            StatusUpdate su = new StatusUpdate(actor.getObjectId());
            su.addAttribute(14, actor.getCurrentLoad());
            actor.sendPacket(su);
        }
        return item;
    }

    @Override
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = super.transferItem(process, objectId, count, target, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        return item;
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, L2PcInstance actor, L2Object reference) {
        return this.destroyItem(process, item, item.getCount(), actor, reference);
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, L2Object reference) {
        item = super.destroyItem(process, item, count, actor, reference);
        if (this._adena != null && this._adena.getCount() <= 0L) {
            this._adena = null;
        }
        if (this._ancientAdena != null && this._ancientAdena.getCount() <= 0L) {
            this._ancientAdena = null;
        }
        return item;
    }

    @Override
    public L2ItemInstance destroyItem(String process, int objectId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = this.getItemByObjectId(objectId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance destroyItemByItemId(String process, int itemId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (item == null) {
            return null;
        }
        return this.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance dropItem(String process, L2ItemInstance item, L2PcInstance actor, L2Object reference) {
        item = super.dropItem(process, item, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        return item;
    }

    @Override
    public L2ItemInstance dropItem(String process, int objectId, long count, L2PcInstance actor, L2Object reference) {
        L2ItemInstance item = super.dropItem(process, objectId, count, actor, reference);
        if (this._adena != null && (this._adena.getCount() <= 0L || this._adena.getOwnerId() != this.getOwnerId())) {
            this._adena = null;
        }
        if (this._ancientAdena != null && (this._ancientAdena.getCount() <= 0L || this._ancientAdena.getOwnerId() != this.getOwnerId())) {
            this._ancientAdena = null;
        }
        return item;
    }

    @Override
    protected boolean removeItem(L2ItemInstance item) {
        this.getOwner().removeItemFromShortCut(item.getObjectId());
        if (item.equals(this.getOwner().getActiveEnchantItem())) {
            this.getOwner().setActiveEnchantItem(null);
        }
        if (item.getItemId() == 57) {
            this._adena = null;
        } else if (item.getItemId() == 5575) {
            this._ancientAdena = null;
        }
        return super.removeItem(item);
    }

    @Override
    public void refreshWeight() {
        super.refreshWeight();
        this.getOwner().refreshOverloaded();
    }

    @Override
    public void restore() {
        super.restore();
        this._adena = this.getItemByItemId(57);
        this._ancientAdena = this.getItemByItemId(5575);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[][] restoreVisibleInventory(int objectId) {
        int[][] paperdoll = new int[31][3];
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement2 = con.prepareStatement("SELECT object_id,item_id,loc_data,enchant_level FROM items WHERE owner_id=? AND loc='PAPERDOLL'");
            statement2.setInt(1, objectId);
            ResultSet invdata = statement2.executeQuery();
            while (invdata.next()) {
                int slot = invdata.getInt("loc_data");
                paperdoll[slot][0] = invdata.getInt("object_id");
                paperdoll[slot][1] = invdata.getInt("item_id");
                paperdoll[slot][2] = invdata.getInt("enchant_level");
                if (slot != 16) continue;
                paperdoll[9][0] = invdata.getInt("object_id");
                paperdoll[9][1] = invdata.getInt("item_id");
                paperdoll[9][2] = invdata.getInt("enchant_level");
            }
            invdata.close();
            statement2.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore inventory: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return paperdoll;
    }

    public boolean validateCapacity(L2ItemInstance item) {
        int slots = 0;
        if (!(item.isStackable() && this.getItemByItemId(item.getItemId()) != null || item.getItemType() == L2EtcItemType.HERB)) {
            ++slots;
        }
        return this.validateCapacity(slots);
    }

    public boolean validateCapacity(List<L2ItemInstance> items) {
        int slots = 0;
        for (L2ItemInstance item : items) {
            if (item.isStackable() && this.getItemByItemId(item.getItemId()) != null) continue;
            ++slots;
        }
        return this.validateCapacity(slots);
    }

    public boolean validateCapacityByItemId(int ItemId) {
        int slots = 0;
        L2ItemInstance invItem = this.getItemByItemId(ItemId);
        if (invItem == null || !invItem.isStackable()) {
            ++slots;
        }
        return this.validateCapacity(slots);
    }

    @Override
    public boolean validateCapacity(int slots) {
        return this._items.size() + slots <= this._owner.getInventoryLimit();
    }

    @Override
    public boolean validateWeight(int weight) {
        return this._totalWeight + weight <= this._owner.getMaxLoad();
    }
}

