/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SiegeSummonInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.zone.L2SpawnZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import javolution.util.FastList;

public class L2CastleZone
extends L2SpawnZone {
    private int _castleId;
    private Castle _castle = null;
    private boolean _isActiveSiege = false;
    private static final int DISMOUNT_DELAY = 5;

    public L2CastleZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("castleId")) {
            this._castleId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        if (this.getCastle() != null) {
            if (this._isActiveSiege) {
                character.setInsideZone((byte)0, true);
                character.setInsideZone((byte)2, true);
                character.setInsideZone((byte)12, true);
                if (character instanceof L2PcInstance) {
                    if (((L2PcInstance)character).isRegisteredOnThisSiegeField(this.getCastle().getCastleId())) {
                        ((L2PcInstance)character).setIsInSiege(true);
                        ((L2PcInstance)character).startFameTask(Config.CASTLE_ZONE_FAME_TASK_FREQUENCY * 1000, Config.CASTLE_ZONE_FAME_AQUIRE_POINTS);
                    }
                    ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE));
                    if (!Config.ALLOW_WYVERN_DURING_SIEGE && ((L2PcInstance)character).getMountType() == 2) {
                        character.sendPacket(new SystemMessage(SystemMessageId.AREA_CANNOT_BE_ENTERED_WHILE_MOUNTED_WYVERN));
                        ((L2PcInstance)character).enteredNoLanding(5);
                    }
                }
            }
            character.setInsideZone((byte)10, true);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (this.getCastle() != null) {
            if (this._isActiveSiege && character instanceof L2PcInstance) {
                ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
                if (((L2PcInstance)character).getMountType() == 2) {
                    ((L2PcInstance)character).exitedNoLanding();
                }
                if (((L2PcInstance)character).getPvpFlag() == 0) {
                    ((L2PcInstance)character).startPvPFlag();
                }
            }
            if (character instanceof L2PcInstance) {
                ((L2PcInstance)character).stopFameTask();
                ((L2PcInstance)character).setIsInSiege(false);
            }
            character.setInsideZone((byte)0, false);
            character.setInsideZone((byte)2, false);
            character.setInsideZone((byte)10, false);
            character.setInsideZone((byte)12, false);
        }
        if (character instanceof L2SiegeSummonInstance) {
            ((L2SiegeSummonInstance)character).unSummon(((L2SiegeSummonInstance)character).getOwner());
        }
    }

    @Override
    public void onDieInside(L2Character character) {
        if (this.getCastle() != null && this._isActiveSiege && character instanceof L2PcInstance && ((L2PcInstance)character).isRegisteredOnThisSiegeField(this.getCastle().getCastleId())) {
            L2Skill skill;
            int lvl = 1;
            L2Effect e = character.getFirstEffect(5660);
            if (e != null) {
                lvl = Math.min(lvl + e.getLevel(), 5);
            }
            if ((skill = SkillTable.getInstance().getInfo(5660, lvl)) != null) {
                skill.getEffects(character, character);
            }
        }
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public void updateZoneStatusForCharactersInside() {
        if (this.getCastle() != null && this._isActiveSiege) {
            for (L2Character character : this._characterList.values()) {
                try {
                    this.onEnter(character);
                }
                catch (NullPointerException e) {}
            }
        } else {
            for (L2Character character : this._characterList.values()) {
                try {
                    character.setInsideZone((byte)0, false);
                    character.setInsideZone((byte)2, false);
                    character.setInsideZone((byte)12, false);
                    if (character instanceof L2PcInstance) {
                        ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
                        ((L2PcInstance)character).stopFameTask();
                        if (((L2PcInstance)character).getMountType() == 2) {
                            ((L2PcInstance)character).exitedNoLanding();
                        }
                    }
                    if (!(character instanceof L2SiegeSummonInstance)) continue;
                    ((L2SiegeSummonInstance)character).unSummon(((L2SiegeSummonInstance)character).getOwner());
                }
                catch (NullPointerException nullPointerException) {}
            }
        }
    }

    public void banishForeigners(int owningClanId) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance) || ((L2PcInstance)temp).getClanId() == owningClanId) continue;
            ((L2PcInstance)temp).teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }

    public void announceToPlayers(String message) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            ((L2PcInstance)temp).sendMessage(message);
        }
    }

    public void announceToPlayers(SystemMessage message) {
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            ((L2PcInstance)temp).sendPacket(message);
        }
    }

    public FastList<L2PcInstance> getAllPlayers() {
        FastList players = new FastList();
        for (L2Character temp : this._characterList.values()) {
            if (!(temp instanceof L2PcInstance)) continue;
            players.add((Object)((L2PcInstance)temp));
        }
        return players;
    }

    public int getCastleId() {
        return this._castleId;
    }

    public boolean isActive() {
        return this._isActiveSiege;
    }

    public void setIsActive(boolean val) {
        this._isActiveSiege = val;
    }

    private final Castle getCastle() {
        if (this._castle == null) {
            this._castle = CastleManager.getInstance().getCastleById(this._castleId);
        }
        return this._castle;
    }
}

