/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class L2OlympiadStadiumZone
extends L2ZoneType {
    private int _stadiumId;

    public L2OlympiadStadiumZone(int id) {
        super(id);
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("stadiumId")) {
            this._stadiumId = Integer.parseInt(value);
        } else {
            super.setParameter(name, value);
        }
    }

    @Override
    protected void onEnter(L2Character character) {
        L2PcInstance player;
        character.setInsideZone((byte)0, true);
        character.setInsideZone((byte)12, true);
        character.setInsideZone((byte)6, true);
        if (character instanceof L2PcInstance) {
            ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.ENTERED_COMBAT_ZONE));
        }
        if (character instanceof L2Playable && (player = character.getActingPlayer()) != null && !player.isGM() && !player.isInOlympiadMode() && !player.inObserverMode()) {
            if (character instanceof L2Summon) {
                ((L2Summon)character).unSummon(player);
            }
            player.teleToLocation(MapRegionTable.TeleportWhereType.Town);
        }
    }

    @Override
    protected void onExit(L2Character character) {
        character.setInsideZone((byte)0, false);
        character.setInsideZone((byte)12, false);
        character.setInsideZone((byte)6, false);
        if (character instanceof L2PcInstance) {
            ((L2PcInstance)character).sendPacket(new SystemMessage(SystemMessageId.LEFT_COMBAT_ZONE));
        }
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    public int getStadiumId() {
        return this._stadiumId;
    }
}

