/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2SummonInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public class PetInfo
extends L2GameServerPacket {
    private static final String _S__B2_PETINFO = "[S] b2 PetInfo";
    private L2Summon _summon;
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private boolean _isSummoned;
    private int _val;
    private int _mAtkSpd;
    private int _pAtkSpd;
    private int _runSpd;
    private int _walkSpd;
    private int _swimRunSpd;
    private int _swimWalkSpd;
    private int _flRunSpd;
    private int _flWalkSpd;
    private int _flyRunSpd;
    private int _flyWalkSpd;
    private int _maxHp;
    private int _maxMp;
    private int _maxFed;
    private int _curFed;
    private float _multiplier;

    public PetInfo(L2Summon summon, int val) {
        this._summon = summon;
        this._isSummoned = this._summon.isShowSummonAnimation();
        this._x = this._summon.getX();
        this._y = this._summon.getY();
        this._z = this._summon.getZ();
        this._heading = this._summon.getHeading();
        this._mAtkSpd = this._summon.getMAtkSpd();
        this._pAtkSpd = this._summon.getPAtkSpd();
        this._multiplier = this._summon.getMovementSpeedMultiplier();
        this._runSpd = this._summon.getPetSpeed();
        this._walkSpd = this._summon.isMountable() ? 45 : 30;
        this._flRunSpd = this._flyRunSpd = this._runSpd;
        this._swimRunSpd = this._flyRunSpd;
        this._flWalkSpd = this._flyWalkSpd = this._walkSpd;
        this._swimWalkSpd = this._flyWalkSpd;
        this._maxHp = this._summon.getMaxHp();
        this._maxMp = this._summon.getMaxMp();
        this._val = val;
        if (this._summon instanceof L2PetInstance) {
            L2PetInstance pet = (L2PetInstance)this._summon;
            this._curFed = pet.getCurrentFed();
            this._maxFed = pet.getMaxFed();
        } else if (this._summon instanceof L2SummonInstance) {
            L2SummonInstance sum = (L2SummonInstance)this._summon;
            this._curFed = sum.getTimeRemaining();
            this._maxFed = sum.getTotalLifeTime();
        }
    }

    @Override
    protected final void writeImpl() {
        this.writeC(178);
        this.writeD(this._summon.getSummonType());
        this.writeD(this._summon.getObjectId());
        this.writeD(this._summon.getTemplate().idTemplate + 1000000);
        this.writeD(0);
        this.writeD(this._x);
        this.writeD(this._y);
        this.writeD(this._z);
        this.writeD(this._heading);
        this.writeD(0);
        this.writeD(this._mAtkSpd);
        this.writeD(this._pAtkSpd);
        this.writeD(this._runSpd);
        this.writeD(this._walkSpd);
        this.writeD(this._swimRunSpd);
        this.writeD(this._swimWalkSpd);
        this.writeD(this._flRunSpd);
        this.writeD(this._flWalkSpd);
        this.writeD(this._flyRunSpd);
        this.writeD(this._flyWalkSpd);
        this.writeF(this._multiplier);
        this.writeF(1.0);
        this.writeF(this._summon.getTemplate().fCollisionRadius);
        this.writeF(this._summon.getTemplate().fCollisionHeight);
        this.writeD(this._summon.getWeapon());
        this.writeD(this._summon.getArmor());
        this.writeD(0);
        this.writeC(this._summon.getOwner() != null ? 1 : 0);
        this.writeC(1);
        this.writeC(this._summon.isInCombat() ? 1 : 0);
        this.writeC(this._summon.isAlikeDead() ? 1 : 0);
        this.writeC(this._isSummoned ? 2 : this._val);
        this.writeS(this._summon.getName());
        this.writeS(this._summon.getTitle());
        this.writeD(1);
        this.writeD(this._summon.getOwner() != null ? (int)this._summon.getOwner().getPvpFlag() : 0);
        this.writeD(this._summon.getOwner() != null ? this._summon.getOwner().getKarma() : 0);
        this.writeD(this._curFed);
        this.writeD(this._maxFed);
        this.writeD((int)this._summon.getCurrentHp());
        this.writeD(this._maxHp);
        this.writeD((int)this._summon.getCurrentMp());
        this.writeD(this._maxMp);
        this.writeD(this._summon.getStat().getSp());
        this.writeD(this._summon.getLevel());
        this.writeQ(this._summon.getStat().getExp());
        if (this._summon.getExpForThisLevel() > this._summon.getStat().getExp()) {
            this.writeQ(this._summon.getStat().getExp());
        } else {
            this.writeQ(this._summon.getExpForThisLevel());
        }
        this.writeQ(this._summon.getExpForNextLevel());
        this.writeD(this._summon instanceof L2PetInstance ? this._summon.getInventory().getTotalWeight() : 0);
        this.writeD(this._summon.getMaxLoad());
        this.writeD(this._summon.getPAtk(null));
        this.writeD(this._summon.getPDef(null));
        this.writeD(this._summon.getMAtk(null, null));
        this.writeD(this._summon.getMDef(null, null));
        this.writeD(this._summon.getAccuracy());
        this.writeD(this._summon.getEvasionRate(null));
        this.writeD(this._summon.getCriticalHit(null, null));
        this.writeD((int)this._summon.getStat().getMoveSpeed());
        this.writeD(this._summon.getPAtkSpd());
        this.writeD(this._summon.getMAtkSpd());
        this.writeD(this._summon.getAbnormalEffect());
        int npcId = this._summon.getTemplate().npcId;
        this.writeH(this._summon.isMountable() ? 1 : 0);
        this.writeC(0);
        this.writeH(0);
        this.writeC(this._summon.getOwner() != null ? this._summon.getOwner().getTeam() : 0);
        this.writeD(this._summon.getSoulShotsPerHit());
        this.writeD(this._summon.getSpiritShotsPerHit());
        int form = 0;
        if (npcId == 16041 || npcId == 16042) {
            if (this._summon.getLevel() > 84) {
                form = 3;
            } else if (this._summon.getLevel() > 79) {
                form = 2;
            } else if (this._summon.getLevel() > 74) {
                form = 1;
            }
        } else if (npcId == 16025 || npcId == 16037) {
            if (this._summon.getLevel() > 69) {
                form = 3;
            } else if (this._summon.getLevel() > 64) {
                form = 2;
            } else if (this._summon.getLevel() > 59) {
                form = 1;
            }
        }
        this.writeD(form);
        this.writeD(this._summon.getSpecialEffect());
    }

    @Override
    public String getType() {
        return _S__B2_PETINFO;
    }
}

