/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import java.util.logging.Logger;

public class EffectEnemyCharge
extends L2Effect {
    static final Logger _log = Logger.getLogger(EffectEnemyCharge.class.getName());
    private int _x;
    private int _y;
    private int _z;

    public EffectEnemyCharge(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.BUFF;
    }

    @Override
    public boolean onStart() {
        int curX = this.getEffector().getX();
        int curY = this.getEffector().getY();
        int curZ = this.getEffector().getZ();
        double dx = this.getEffected().getX() - curX;
        double dy = this.getEffected().getY() - curY;
        double dz = this.getEffected().getZ() - curZ;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > 2000.0) {
            _log.info("EffectEnemyCharge was going to use invalid coordinates for characters, getEffector: " + curX + "," + curY + " and getEffected: " + this.getEffected().getX() + "," + this.getEffected().getY());
            return false;
        }
        int offset = Math.max((int)distance - this.getSkill().getFlyRadius(), 30);
        if ((offset = (int)((double)offset - Math.abs(dz))) < 5) {
            offset = 5;
        }
        if (distance < 1.0 || distance - (double)offset <= 0.0) {
            return false;
        }
        double sin = dy / distance;
        double cos = dx / distance;
        this._x = curX + (int)((distance - (double)offset) * cos);
        this._y = curY + (int)((distance - (double)offset) * sin);
        this._z = this.getEffected().getZ();
        if (Config.GEODATA > 0) {
            Location destiny = GeoData.getInstance().moveCheck(this.getEffector().getX(), this.getEffector().getY(), this.getEffector().getZ(), this._x, this._y, this._z, this.getEffector().getInstanceId());
            this._x = destiny.getX();
            this._y = destiny.getY();
        }
        this.getEffector().broadcastPacket(new FlyToLocation(this.getEffector(), this._x, this._y, this._z, FlyToLocation.FlyType.CHARGE));
        this.getEffector().setXYZ(this._x, this._y, this._z);
        this.getEffector().broadcastPacket(new ValidateLocation(this.getEffector()));
        return true;
    }

    @Override
    public boolean onActionTime() {
        return false;
    }
}

