/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.Manager.favorite;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.communitybbs.Manager.favorite.BaseFavoriteManager;
import com.l2jserver.gameserver.datatables.MapRegionTable;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.AskJoinParty;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.TextReplacer;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.logging.Logger;

public class PartyMatch
extends BaseFavoriteManager {
    private static Logger _log = Logger.getLogger(PartyMatch.class.getName());
    private static PartyMatch _instance = new PartyMatch();

    public static PartyMatch getInstance() {
        return _instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void parsecmd(String command, L2PcInstance activeChar) {
        if (activeChar == null) {
            return;
        }
        String subcmd = this.getArgs(command);
        if (subcmd.startsWith("_menu")) {
            int roomId = this.getRoomIdByCharId(activeChar.getObjectId());
            if (roomId != -1) {
                this.showPartyRoom(activeChar, roomId);
                return;
            } else {
                String[] values = subcmd.split(" ");
                if (values.length == 3) {
                    this.showPartyRoomList(activeChar, values[1], values[2]);
                    return;
                } else {
                    this.showPartyRoomList(activeChar, null, null);
                }
            }
            return;
        } else {
            if (subcmd.startsWith("_createRoomWindow")) {
                this.showConfigWindow(activeChar, "party_match/createPartyRoom.htm");
                return;
            }
            if (subcmd.startsWith("_createRoom")) {
                String[] values = subcmd.split(" *\\| *", 7);
                if (values.length != 7) {
                    activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u306e\u958b\u8a2d\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    return;
                }
                try {
                    int roomId = this.getRoomIdByCharId(activeChar.getObjectId());
                    int min = Integer.parseInt(values[2]);
                    int max = Integer.parseInt(values[3]);
                    int limit = Integer.parseInt(values[4]);
                    int lootdist = Integer.parseInt(values[5]);
                    String title = values[6];
                    if (roomId != -1) {
                        this.modifyPartyRoom(activeChar, roomId, min, max, limit, lootdist, title);
                    } else {
                        roomId = this.createPartyRoom(activeChar, min, max, limit, lootdist, title);
                    }
                    if (roomId <= -1) return;
                    this.showPartyRoom(activeChar, roomId);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u306e\u958b\u8a2d\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                    return;
                }
            } else {
                if (subcmd.startsWith("_modifyRoomWindow")) {
                    this.showConfigWindow(activeChar, "party_match/modifyPartyRoom.htm");
                    return;
                }
                if (subcmd.startsWith("_modifyRoom")) {
                    String[] values = subcmd.split(" *\\| *", 7);
                    if (values.length != 7) {
                        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u8a2d\u5b9a\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return;
                    }
                    try {
                        int roomId = Integer.parseInt(values[1]);
                        PartyRoomInfo pi = this.getPartyRoomInfo(roomId);
                        int min = values[2].matches("\\d+") ? Integer.parseInt(values[2]) : pi.min;
                        int max = values[3].matches("\\d+") ? Integer.parseInt(values[3]) : pi.max;
                        int limit = values[4].matches("\\d+") ? Integer.parseInt(values[4]) : pi.limit;
                        int lootdist = values[5].matches("\\d+") ? Integer.parseInt(values[5]) : pi.type;
                        String title = values[6].length() > 0 ? values[6] : pi.title;
                        this.modifyPartyRoom(activeChar, roomId, min, max, limit, lootdist, title);
                        this.showPartyRoom(activeChar, roomId);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u8a2d\u5b9a\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return;
                    }
                } else if (subcmd.startsWith("_joinRoom")) {
                    String[] values = subcmd.split(" ");
                    if (values.length < 2) {
                        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3078\u306e\u5165\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return;
                    }
                    try {
                        int roomId = Integer.parseInt(values[1]);
                        if (!this.joinPartyRoom(activeChar, roomId)) {
                            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3078\u306e\u5165\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            return;
                        }
                        this.showPartyRoom(activeChar, roomId);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3078\u306e\u5165\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return;
                    }
                } else if (subcmd.startsWith("_leaveRoom")) {
                    String[] values = subcmd.split(" ");
                    if (values.length < 2) {
                        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u304b\u3089\u306e\u9000\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return;
                    }
                    try {
                        int roomId = Integer.parseInt(values[1]);
                        this.leavePartyRoom(activeChar, roomId);
                        this.showPartyRoomList(activeChar, null, null);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u304b\u3089\u306e\u9000\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                        return;
                    }
                } else {
                    if (subcmd.startsWith("_kickRoom")) {
                        String[] values = subcmd.split(" ");
                        if (values.length < 3) {
                            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u304b\u3089\u306e\u5f37\u5236\u9000\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            return;
                        }
                        try {
                            int roomId = Integer.parseInt(values[1]);
                            int objectId = Integer.parseInt(values[2]);
                            L2PcInstance character = (L2PcInstance)L2World.getInstance().findObject(objectId);
                            if (character == null) return;
                            this.leavePartyRoom(character, roomId);
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u304b\u3089\u306e\u5f37\u5236\u9000\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            return;
                        }
                    }
                    if (subcmd.startsWith("_joinParty")) {
                        String[] values = subcmd.split(" ");
                        if (values.length < 3) {
                            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u3078\u306e\u52e7\u8a98\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            return;
                        }
                        try {
                            int roomId = Integer.parseInt(values[1]);
                            int objectId = Integer.parseInt(values[2]);
                            L2PcInstance target = (L2PcInstance)L2World.getInstance().findObject(objectId);
                            if (this.requestJoinParty(activeChar, target, roomId)) return;
                            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u3078\u306e\u52e7\u8a98\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            return;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u3078\u306e\u52e7\u8a98\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                            return;
                        }
                    }
                    this.separateAndSend("<html><body><br><center> the command: " + command + " is not implemented yet</center><br></body></html>", activeChar);
                    return;
                }
            }
        }
    }

    @Override
    public void parsewrite(String ar1, String ar2, String ar3, String ar4, String ar5, L2PcInstance activeChar) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized int createPartyRoomId() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT MAX(id) FROM party_match_list");
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                int n = result.getInt(1) + 1;
                return n;
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int createPartyRoom(L2PcInstance activeChar, int min, int max, int limit, int lootdist, String title) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO party_match_list VALUES (?,?,?,?,?,?,?,?)");
            int nextId = this.createPartyRoomId();
            if (nextId == -1) {
                activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u306e\u958b\u8a2d\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
                int n = -1;
                return n;
            }
            statement.setInt(1, nextId);
            statement.setInt(2, activeChar.getObjectId());
            statement.setInt(3, min);
            statement.setInt(4, max);
            statement.setInt(5, limit);
            int castleIndex = CastleManager.getInstance().findNearestCastleIndex(activeChar);
            if (castleIndex < 0) {
                statement.setString(6, "\u4e0d\u660e");
            } else {
                statement.setString(6, CastleManager.getInstance().getCastles().get(castleIndex).getNameJA());
            }
            statement.setInt(7, lootdist);
            statement.setString(8, title);
            statement.execute();
            statement.close();
            statement = con.prepareStatement("INSERT INTO party_match_room VALUES(?,?,?)");
            statement.setInt(1, nextId);
            statement.setInt(2, activeChar.getObjectId());
            statement.setInt(3, 0);
            statement.execute();
            statement.close();
            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3092\u958b\u8a2d\u3057\u307e\u3057\u305f\u3002");
            int n = nextId;
            return n;
        }
        catch (Exception e) {
            _log.info("could not create Party Room: " + e);
            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u306e\u958b\u8a2d\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            int n = -1;
            return n;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void modifyPartyRoom(L2PcInstance activeChar, int roomId, int min, int max, int limit, int lootdist, String title) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE party_match_list SET min = ?, max = ?, `limit` = ?, loc = ?, type = ?, title = ? WHERE id = ?");
            statement.setInt(1, min);
            statement.setInt(2, max);
            statement.setInt(3, limit);
            int castleIndex = CastleManager.getInstance().findNearestCastleIndex(activeChar);
            if (castleIndex < 0) {
                statement.setString(4, "\u4e0d\u660e");
            } else {
                statement.setString(4, CastleManager.getInstance().getCastles().get(castleIndex).getNameJA());
            }
            statement.setInt(5, lootdist);
            statement.setString(6, title);
            statement.setInt(7, roomId);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.info("could not modify Party Room: " + e);
            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u8a2d\u5b9a\u306e\u5909\u66f4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.brodeCastRoomInfo(activeChar, roomId);
        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u8a2d\u5b9a\u3092\u5909\u66f4\u3057\u307e\u3057\u305f\u3002");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean joinPartyRoom(L2PcInstance activeChar, int roomId) {
        PartyRoomInfo pi = this.getPartyRoomInfo(roomId);
        if (pi.limit == -1 || pi.count == -1) {
            activeChar.sendMessage("\u30eb\u30fc\u30e0\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
            return false;
        }
        if (pi.limit <= pi.count) {
            activeChar.sendMessage("\u4eba\u6570\u306e\u4e0a\u9650\u306b\u9054\u3057\u3066\u3044\u308b\u305f\u3081\u3001\u5165\u5ba4\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        if (activeChar.getLevel() < pi.min || pi.max < activeChar.getLevel()) {
            activeChar.sendMessage("\u30ec\u30d9\u30eb\u5236\u9650\u306b\u5408\u3063\u3066\u3044\u306a\u3044\u305f\u3081\u3001\u5165\u5ba4\u3067\u304d\u307e\u305b\u3093\u3002");
            return false;
        }
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO party_match_room VALUES(?,?,?)");
            statement.setInt(1, roomId);
            statement.setInt(2, activeChar.getObjectId());
            if (activeChar.getParty() != null && activeChar.getParty() == ((L2PcInstance)L2World.getInstance().findObject(pi.owner_id)).getParty()) {
                statement.setInt(3, 1);
            } else {
                statement.setInt(3, 2);
            }
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.info("could not join Party Room: " + e);
            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3078\u306e\u5165\u5ba4\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            boolean bl = false;
            return bl;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.brodeCastRoomInfo(activeChar, roomId);
        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3078\u5165\u5ba4\u3057\u307e\u3057\u305f\u3002");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void leavePartyRoom(L2PcInstance activeChar, int roomId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT owner_id FROM party_match_list WHERE id = ?");
            statement.setInt(1, roomId);
            ResultSet result = statement.executeQuery();
            int owner_id = 0;
            while (result.next()) {
                owner_id = result.getInt(1);
            }
            result.close();
            statement.close();
            if (owner_id == activeChar.getObjectId()) {
                statement = con.prepareStatement("SELECT char_obj_id FROM party_match_room WHERE room_id = ?");
                statement.setInt(1, roomId);
                result = statement.executeQuery();
                while (result.next()) {
                    int object_id = result.getInt(1);
                    L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(object_id);
                    if (member == null) continue;
                    this.showPartyRoomList(member, null, null);
                    member.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u304c\u89e3\u6563\u3055\u308c\u307e\u3057\u305f\u3002");
                }
                result.close();
                statement.close();
                statement = con.prepareStatement("DELETE FROM party_match_list WHERE id = ?");
                statement.setInt(1, roomId);
                statement.execute();
                statement.close();
                statement = con.prepareStatement("DELETE FROM party_match_room WHERE room_id = ?");
                statement.setInt(1, roomId);
                statement.execute();
                statement.close();
            } else {
                statement = con.prepareStatement("SELECT char_obj_id FROM party_match_room WHERE room_id = ?");
                statement.setInt(1, roomId);
                result = statement.executeQuery();
                while (result.next()) {
                    int object_id = result.getInt(1);
                    L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(object_id);
                    if (member == null) continue;
                    if (object_id == activeChar.getObjectId()) {
                        this.showPartyRoomList(member, null, null);
                        member.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc\u30eb\u30fc\u30e0\u304b\u3089\u9000\u5ba4\u3057\u307e\u3057\u305f\u3002");
                        continue;
                    }
                    this.showPartyRoom(member, roomId);
                    member.sendMessage(activeChar.getName() + "\u304c\u9000\u5ba4\u3057\u307e\u3057\u305f\u3002");
                }
                result.close();
                statement.close();
                statement = con.prepareStatement("DELETE FROM party_match_room WHERE room_id = ? AND char_obj_id = ?");
                statement.setInt(1, roomId);
                statement.setInt(2, activeChar.getObjectId());
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            _log.info("could not delete Party Room: " + e);
            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u306e\u7d42\u4e86\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        this.brodeCastRoomInfo(activeChar, roomId);
        activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u3092\u7d42\u4e86\u3057\u307e\u3057\u305f\u3002");
    }

    private boolean requestJoinParty(L2PcInstance requestor, L2PcInstance target, int roomId) {
        PartyRoomInfo pi = this.getPartyRoomInfo(roomId);
        if (requestor == null) {
            return false;
        }
        if (target == null) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
            return false;
        }
        if (target.getAppearance().getInvisible()) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.TARGET_IS_INCORRECT));
            return false;
        }
        if (target.isInParty()) {
            SystemMessage msg = new SystemMessage(SystemMessageId.C1_IS_ALREADY_IN_PARTY);
            msg.addString(target.getName());
            requestor.sendPacket(msg);
            return false;
        }
        if (BlockList.isBlocked(target, requestor)) {
            SystemMessage sm = new SystemMessage(SystemMessageId.S1_HAS_ADDED_YOU_TO_IGNORE_LIST);
            sm.addCharName(target);
            requestor.sendPacket(sm);
            return false;
        }
        if (target == requestor) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_TARGET));
            return false;
        }
        if (target.isCursedWeaponEquipped() || requestor.isCursedWeaponEquipped()) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.INCORRECT_TARGET));
            return false;
        }
        if (target.isInJail() || requestor.isInJail()) {
            requestor.sendMessage("Player is in Jail");
            return false;
        }
        if (target.isInOlympiadMode() || requestor.isInOlympiadMode()) {
            return false;
        }
        if (!requestor.getParty().isLeader(requestor)) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.ONLY_LEADER_CAN_INVITE));
            return false;
        }
        if (requestor.getParty() != null && requestor.getParty().getMemberCount() >= 9) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.PARTY_FULL));
            return false;
        }
        if (requestor.getParty().getPendingInvitation()) {
            requestor.sendPacket(new SystemMessage(SystemMessageId.WAITING_FOR_ANOTHER_REPLY));
            return false;
        }
        if (!target.isProcessingRequest()) {
            if (requestor.getParty() == null) {
                requestor.setParty(new L2Party(requestor, pi.type));
            }
            requestor.onTransactionRequest(target);
            target.sendPacket(new AskJoinParty(requestor.getName(), pi.type));
            requestor.getParty().setPendingInvitation(true);
            if (Config.DEBUG) {
                _log.fine("sent out a party invitation to:" + target.getName());
            }
        } else {
            SystemMessage msg = new SystemMessage(SystemMessageId.C1_IS_BUSY_TRY_LATER);
            msg.addString(target.getName());
            requestor.sendPacket(msg);
            if (Config.DEBUG) {
                _log.warning(requestor.getName() + " already received a party invitation");
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPartyRoomList(L2PcInstance activeChar, String optionArea, String optionLevel) {
        String html = HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/party_match/partyRoomList.htm");
        StringBuilder where_str = new StringBuilder(256);
        if (optionArea != null && !optionArea.equals("\u5168\u4f53")) {
            where_str.append(" loc = '").append(optionArea).append('\'');
        }
        if (optionLevel != null && !optionLevel.equals("\u5168\u4f53")) {
            String[] v = optionLevel.split("-");
            int minlevel = Integer.parseInt(v[0]);
            int maxlevel = Integer.parseInt(v[1]);
            if (where_str.length() != 0) {
                where_str.append(" AND");
            }
            where_str.append(" min <= '").append(minlevel).append("' AND max >= '").append(maxlevel).append('\'');
        }
        if (where_str.length() != 0) {
            where_str.append(" WHERE").append((CharSequence)where_str);
        }
        where_str.append(" ORDER BY id");
        StringBuilder roomList = new StringBuilder(256);
        StringBuilder DelRoom = new StringBuilder(256);
        int roomCount = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT id FROM party_match_list" + where_str);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                PartyRoomInfo pi = this.getPartyRoomInfo(result.getInt(1));
                L2PcInstance leader = (L2PcInstance)L2World.getInstance().findObject(pi.owner_id);
                if (leader == null) {
                    if (DelRoom.length() != 0) {
                        DelRoom.append(',');
                    }
                    DelRoom.append(pi.roomId);
                    continue;
                }
                if (pi.roomId == -1 || pi.owner_id == -1) continue;
                roomList.append("<table width=610><tr><td width=30 align=center>").append(pi.roomId).append("</td><td width=160>").append(pi.title).append("</td><td width=120>").append(leader.getName()).append("</td><td width=120>").append(pi.loc).append("</td><td width=50 align=center>").append(pi.min).append(" - ").append(pi.max).append("</td><td width=50 align=center>").append(pi.count).append(" / ").append(pi.limit).append("</td><td width=80 align=center><button value=\"\u5165\u5ba4\" action=\"bypass _bbsgetfav;bbs_party_match;_joinRoom ").append(pi.roomId).append("\" width=65 height=21 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\"></td></tr></table>");
                ++roomCount;
            }
            result.close();
            statement.close();
            if (DelRoom.length() != 0) {
                statement = con.prepareStatement("DELETE FROM party_match_list WHERE id in (?)");
                statement.setString(1, DelRoom.toString());
                statement.execute();
                statement.close();
                statement = con.prepareStatement("DELETE FROM party_match_room WHERE room_id in (?)");
                statement.setString(1, DelRoom.toString());
                statement.execute();
                statement.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.separateAndSend("<html><body><br><center>\u30d1\u30fc\u30c6\u30a3\u30fc\u30eb\u30fc\u30e0\u30ea\u30b9\u30c8\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002</center><br></body></html>", activeChar);
            return;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        html = html.replace("%roomList%", roomList);
        this.separateAndSend(html.toString(), activeChar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showPartyRoom(L2PcInstance activeChar, int roomId) {
        PartyRoomInfo pi = this.getPartyRoomInfo(roomId);
        if (pi.roomId == -1 && pi.owner_id == -1) {
            return;
        }
        StringBuilder memberList = new StringBuilder(256);
        int memberCount = 0;
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM party_match_room WHERE room_id = ? ORDER BY memberType");
            statement.setInt(1, roomId);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                L2Object obj = L2World.getInstance().findObject(result.getInt(2));
                if (obj == null || !(obj instanceof L2PcInstance)) continue;
                L2PcInstance member = (L2PcInstance)obj;
                memberList.append("<table width=610><tr><td width=120>").append(member.getName()).append("</td><td width=130 align=center>").append(member.getTemplate().className).append("</td><td width=40 align=center>").append(member.getLevel()).append("</td><td width=130 align=center>").append(MapRegionTable.getInstance().getClosestTownName(member)).append("</td>");
                if (result.getInt(3) == 0) {
                    memberList.append("<td width=120 align=center>\u30eb\u30fc\u30e0\u30ea\u30fc\u30c0\u30fc</td>");
                } else if (result.getInt(3) == 1) {
                    memberList.append("<td width=120 align=center>\u30d1\u30fc\u30c6\u30a3\u30fc\u30e1\u30f3\u30d0</td>");
                } else {
                    memberList.append("<td width=120 align=center>\u30d1\u30fc\u30c6\u30a3\u30fc\u5e0c\u671b\u8005</td>");
                }
                if (activeChar.getObjectId() == pi.owner_id && activeChar.getObjectId() != member.getObjectId()) {
                    memberList.append("<td width=70 align=center>");
                    if (result.getInt(3) == 2) {
                        memberList.append("<button value=\"\uff30\uff34\u52e7\u8a98\" action=\"bypass _bbsgetfav;bbs_party_match;_joinParty ").append(roomId).append(' ').append(member.getObjectId()).append("\" width=65 height=21 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\">");
                    }
                    memberList.append("<button value=\"\u5f37\u5236\u8ffd\u653e\" action=\"bypass _bbsgetfav;bbs_party_match;_kickRoom ").append(roomId).append(' ').append(member.getObjectId()).append("\" width=65 height=21 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\"></td>");
                } else {
                    memberList.append("<td width=70 align=center></td>");
                }
                memberList.append("</tr></table>");
                ++memberCount;
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            this.separateAndSend("<html><body><br><center>\u30d1\u30fc\u30c6\u30a3\u30fc\u30eb\u30fc\u30e0\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002</center><br></body></html>", activeChar);
            return;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        TextReplacer html = new TextReplacer(HtmCache.getInstance().getHtm(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/party_match/partyRoom.htm"));
        html.replace((CharSequence)"%roomId%", pi.roomId);
        html.replace((CharSequence)"%title%", this.htmlescape(pi.title));
        html.replace((CharSequence)"%location%", pi.loc);
        html.replace((CharSequence)"%current%", pi.count);
        html.replace((CharSequence)"%max%", pi.limit);
        String lootdistribution = "";
        switch (pi.type) {
            case 0: {
                lootdistribution = "\u62fe\u3063\u305f\u4eba\u304c\u6240\u6709";
                break;
            }
            case 1: {
                lootdistribution = "\u30e9\u30f3\u30c0\u30e0\u306b\u5206\u914d";
                break;
            }
            case 2: {
                lootdistribution = "\u30b9\u30dd\u30a4\u30eb\u3092\u542b\u3081\u30e9\u30f3\u30c0\u30e0\u306b";
                break;
            }
            case 3: {
                lootdistribution = "\u9806\u756a\u306b\u53d6\u5f97";
                break;
            }
            case 4: {
                lootdistribution = "\u30b9\u30dd\u30a4\u30eb\u3092\u542b\u3081\u9806\u756a\u306b";
            }
        }
        html.replace((CharSequence)"%rootType%", lootdistribution);
        html.replace((CharSequence)"%minlevel%", pi.min);
        html.replace((CharSequence)"%maxlevel%", pi.max);
        html.replace((CharSequence)"%memberList%", memberList);
        String modifyButton = "";
        if (activeChar.getObjectId() == pi.owner_id) {
            modifyButton = "<button value=\"\u30eb\u30fc\u30e0\u8a2d\u5b9a\" action=\"bypass _bbsgetfav;bbs_party_match;_modifyRoomWindow\" width=80 height=21 back=\"L2UI_CT1.BUTTON_DF_DOWN\" fore=\"L2UI_CT1.BUTTON_DF\">";
        }
        html.replace((CharSequence)"%modifyPartyRoom%", modifyButton);
        this.separateAndSend(html.toString(), activeChar);
    }

    private void showConfigWindow(L2PcInstance activeChar, String filename) {
        NpcHtmlMessage html = new NpcHtmlMessage(5);
        html.setFile(activeChar.getHtmlPrefix(), "data/html/CommunityBoard/" + filename);
        html.replace((CharSequence)"%roomId%", this.getRoomIdByCharId(activeChar.getObjectId()));
        activeChar.sendPacket(html);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRoomIdByCharId(int char_obj_id) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT room_id FROM party_match_room WHERE char_obj_id = ?");
            statement.setInt(1, char_obj_id);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                int n = result.getInt(1);
                return n;
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            int n = -1;
            return n;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartyRoomInfo getPartyRoomInfo(int roomId) {
        PartyRoomInfo pi = new PartyRoomInfo(roomId);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT owner_id, min, max, `limit`, loc, type, title FROM party_match_list WHERE id = ?");
            statement.setInt(1, roomId);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                pi.owner_id = result.getInt(1);
                pi.min = result.getInt(2);
                pi.max = result.getInt(3);
                pi.limit = result.getInt(4);
                pi.loc = result.getString(5);
                pi.type = result.getInt(6);
                pi.title = result.getString(7);
            }
            result.close();
            statement.close();
            statement = con.prepareStatement("SELECT COUNT(*) FROM party_match_room WHERE room_id = ?");
            statement.setInt(1, roomId);
            result = statement.executeQuery();
            while (result.next()) {
                pi.count = result.getInt(1);
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            PartyRoomInfo partyRoomInfo = pi;
            return partyRoomInfo;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
        return pi;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brodeCastRoomInfo(L2PcInstance activeChar, int roomId) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT char_obj_id, memberType FROM party_match_room WHERE room_id = ?");
            statement.setInt(1, roomId);
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                int object_id = result.getInt(1);
                int member_type = result.getInt(2);
                L2PcInstance member = (L2PcInstance)L2World.getInstance().findObject(object_id);
                if (member == null) continue;
                if (member_type != 0) {
                    PreparedStatement statement2 = con.prepareStatement("UPDATE party_match_room SET memberType = ? WHERE room_id = ? AND char_obj_id = ?");
                    statement2.setInt(1, member.isInParty() ? 1 : 2);
                    statement2.setInt(2, roomId);
                    statement2.setInt(3, member.getObjectId());
                    statement2.executeUpdate();
                    statement2.close();
                }
                this.showPartyRoom(member, roomId);
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            _log.info("could not update Party Room Info: " + e);
            activeChar.sendMessage("\u30d1\u30fc\u30c6\u30a3\u30fc \u30eb\u30fc\u30e0\u60c5\u5831\u306e\u66f4\u65b0\u306b\u5931\u6557\u3057\u307e\u3057\u305f\u3002");
            return;
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    class PartyRoomInfo {
        int roomId;
        int owner_id = 0;
        int min = 1;
        int max = 100;
        int limit = -1;
        String loc = "";
        int type = 0;
        String title = "";
        int count = -1;

        PartyRoomInfo(int _roomId) {
            this.roomId = _roomId;
        }
    }
}

