/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor;

import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PlayableKnownList;
import com.l2jserver.gameserver.model.actor.stat.PlayableStat;
import com.l2jserver.gameserver.model.actor.status.PlayableStatus;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.templates.chars.L2CharTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;

public abstract class L2Playable
extends L2Character {
    private boolean _isNoblesseBlessed = false;
    private boolean _getCharmOfLuck = false;
    private boolean _isPhoenixBlessed = false;
    private boolean _isSilentMoving = false;
    private boolean _ProtectionBlessing = false;
    private L2Character _lockedTarget = null;

    public L2Playable(int objectId, L2CharTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2Playable);
        this.setIsInvul(false);
    }

    @Override
    public PlayableKnownList getKnownList() {
        return (PlayableKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new PlayableKnownList(this));
    }

    @Override
    public PlayableStat getStat() {
        return (PlayableStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PlayableStat(this));
    }

    @Override
    public PlayableStatus getStatus() {
        return (PlayableStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new PlayableStatus(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDie(L2Character killer) {
        L2PcInstance player;
        L2Playable l2Playable = this;
        synchronized (l2Playable) {
            if (this.isDead()) {
                return false;
            }
            this.setCurrentHp(0.0);
            this.setIsDead(true);
        }
        this.setTarget(null);
        this.stopMove(null);
        this.getStatus().stopHpMpRegeneration();
        if (this.isPhoenixBlessed()) {
            if (this.getCharmOfLuck()) {
                this.stopCharmOfLuck(null);
            }
            if (this.isNoblesseBlessed()) {
                this.stopNoblesseBlessing(null);
            }
        } else if (this.isNoblesseBlessed()) {
            this.stopNoblesseBlessing(null);
            if (this.getCharmOfLuck()) {
                this.stopCharmOfLuck(null);
            }
        } else {
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        this.broadcastStatusUpdate();
        if (this.getWorldRegion() != null) {
            this.getWorldRegion().onDeath(this);
        }
        L2PcInstance actingPlayer = this.getActingPlayer();
        for (QuestState qs : actingPlayer.getNotifyQuestOfDeath()) {
            qs.getQuest().notifyDeath(killer == null ? this : killer, this, qs);
        }
        if (killer != null && (player = killer.getActingPlayer()) != null) {
            player.onKillUpdatePvPKarma(this);
        }
        this.getAI().notifyEvent(CtrlEvent.EVT_DEAD);
        return true;
    }

    public boolean checkIfPvP(L2Character target) {
        if (target == null) {
            return false;
        }
        if (target == this) {
            return false;
        }
        if (!(target instanceof L2Playable)) {
            return false;
        }
        L2PcInstance player = null;
        if (this instanceof L2PcInstance) {
            player = (L2PcInstance)this;
        } else if (this instanceof L2Summon) {
            player = ((L2Summon)this).getOwner();
        }
        if (player == null) {
            return false;
        }
        if (player.getKarma() != 0) {
            return false;
        }
        L2PcInstance targetPlayer = null;
        if (target instanceof L2PcInstance) {
            targetPlayer = (L2PcInstance)target;
        } else if (target instanceof L2Summon) {
            targetPlayer = ((L2Summon)target).getOwner();
        }
        if (targetPlayer == null) {
            return false;
        }
        if (targetPlayer == this) {
            return false;
        }
        if (targetPlayer.getKarma() != 0) {
            return false;
        }
        return targetPlayer.getPvpFlag() != 0;
    }

    @Override
    public boolean isAttackable() {
        return true;
    }

    public final boolean isNoblesseBlessed() {
        return this._isNoblesseBlessed;
    }

    public final void setIsNoblesseBlessed(boolean value) {
        this._isNoblesseBlessed = value;
    }

    public final void startNoblesseBlessing() {
        this.setIsNoblesseBlessed(true);
        this.updateAbnormalEffect();
    }

    public final void stopNoblesseBlessing(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2EffectType.NOBLESSE_BLESSING);
        } else {
            this.removeEffect(effect);
        }
        this.setIsNoblesseBlessed(false);
        this.updateAbnormalEffect();
    }

    public final boolean isPhoenixBlessed() {
        return this._isPhoenixBlessed;
    }

    public final void setIsPhoenixBlessed(boolean value) {
        this._isPhoenixBlessed = value;
    }

    public final void startPhoenixBlessing() {
        this.setIsPhoenixBlessed(true);
        this.updateAbnormalEffect();
    }

    public final void stopPhoenixBlessing(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2EffectType.PHOENIX_BLESSING);
        } else {
            this.removeEffect(effect);
        }
        this.setIsPhoenixBlessed(false);
        this.updateAbnormalEffect();
    }

    public void setSilentMoving(boolean flag) {
        this._isSilentMoving = flag;
    }

    public boolean isSilentMoving() {
        return this._isSilentMoving;
    }

    public final boolean getProtectionBlessing() {
        return this._ProtectionBlessing;
    }

    public final void setProtectionBlessing(boolean value) {
        this._ProtectionBlessing = value;
    }

    public void startProtectionBlessing() {
        this.setProtectionBlessing(true);
        this.updateAbnormalEffect();
    }

    public void stopProtectionBlessing(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2EffectType.PROTECTION_BLESSING);
        } else {
            this.removeEffect(effect);
        }
        this.setProtectionBlessing(false);
        this.updateAbnormalEffect();
    }

    public final boolean getCharmOfLuck() {
        return this._getCharmOfLuck;
    }

    public final void setCharmOfLuck(boolean value) {
        this._getCharmOfLuck = value;
    }

    public final void startCharmOfLuck() {
        this.setCharmOfLuck(true);
        this.updateAbnormalEffect();
    }

    public final void stopCharmOfLuck(L2Effect effect) {
        if (effect == null) {
            this.stopEffects(L2EffectType.CHARM_OF_LUCK);
        } else {
            this.removeEffect(effect);
        }
        this.setCharmOfLuck(false);
        this.updateAbnormalEffect();
    }

    @Override
    public void updateEffectIcons(boolean partyOnly) {
        this._effects.updateEffectIcons(partyOnly);
    }

    public boolean isLockedTarget() {
        return this._lockedTarget != null;
    }

    public L2Character getLockedTarget() {
        return this._lockedTarget;
    }

    public void setLockedTarget(L2Character cha) {
        this._lockedTarget = cha;
    }

    public abstract int getKarma();

    public abstract byte getPvpFlag();

    public abstract void useMagic(L2Skill var1, boolean var2, boolean var3);
}

