/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.AbstractNpcInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.Collection;

public final class L2EventChestInstance
extends L2EventMonsterInstance {
    private boolean _isVisible = false;
    private boolean _isTriggered = false;

    public L2EventChestInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setIsNoRndWalk(true);
        this.disableCoreAI(true);
        this.eventSetDropOnGround(true);
        this.eventSetBlockOffensiveSkills(true);
    }

    public boolean canSee(L2Character cha) {
        if (cha == null) {
            return false;
        }
        if (cha.isGM()) {
            return true;
        }
        return this._isVisible;
    }

    public void trigger() {
        this._isTriggered = true;
        this.broadcastPacket(new AbstractNpcInfo.NpcInfo(this, null));
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this._isTriggered || this.canSee(activeChar)) {
            activeChar.sendPacket(new AbstractNpcInfo.NpcInfo(this, activeChar));
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this._isTriggered && !this.canSee(player)) continue;
            player.sendPacket(mov);
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        Collection<L2PcInstance> plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false) || !this._isTriggered && !this.canSee(player)) continue;
            player.sendPacket(mov);
        }
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return !this.canSee(attacker);
    }
}

