/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2MinionInstance;
import com.l2jserver.gameserver.model.actor.knownlist.MonsterKnownList;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.util.MinionList;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class L2MonsterInstance
extends L2Attackable {
    private boolean _enableMinions = true;
    protected final MinionList _minionList;
    protected MinionList _DynamicMinionList = null;
    protected ScheduledFuture<?> _maintenanceTask = null;
    private static final int MONSTER_MAINTENANCE_INTERVAL = 1000;

    public L2MonsterInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2MonsterInstance);
        this.setAutoAttackable(true);
        this._minionList = this.getTemplate().getMinionData() != null ? new MinionList(this) : null;
    }

    @Override
    public final MonsterKnownList getKnownList() {
        return (MonsterKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new MonsterKnownList(this));
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        return super.isAutoAttackable(attacker) && !this.isEventMob;
    }

    @Override
    public boolean isAggressive() {
        return this.getAggroRange() > 0 && !this.isEventMob;
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        if (this._minionList != null) {
            try {
                for (L2MinionInstance minion : this.getSpawnedMinions()) {
                    if (minion == null) continue;
                    this.getSpawnedMinions().remove(minion);
                    minion.deleteMe();
                }
                this._minionList.clearRespawnList();
            }
            catch (NullPointerException e) {
                e.printStackTrace();
            }
        }
        this.startMaintenanceTask();
    }

    protected int getMaintenanceInterval() {
        return 1000;
    }

    protected void startMaintenanceTask() {
        if (this._minionList == null) {
            return;
        }
        this._maintenanceTask = ThreadPoolManager.getInstance().scheduleGeneral(new Runnable(){

            @Override
            public void run() {
                if (L2MonsterInstance.this._enableMinions) {
                    L2MonsterInstance.this._minionList.spawnMinions();
                }
            }
        }, this.getMaintenanceInterval() + Rnd.get(1000));
    }

    public void callMinions() {
        int minionY;
        int minionX;
        if (this._minionList != null) {
            for (L2MinionInstance minion : this._minionList.getSpawnedMinions()) {
                if (minion == null || minion.isDead() || minion.isMovementDisabled() || this.isInsideRadius(minion, 200, false, false)) continue;
                minionX = Rnd.nextInt(340);
                minionY = Rnd.nextInt(340);
                minionX = minionX < 171 ? this.getX() + minionX + 30 : this.getX() - minionX + 140;
                minionY = minionY < 171 ? this.getY() + minionY + 30 : this.getY() - minionY + 140;
                if (minion.isInCombat() || minion.isDead() || minion.isMovementDisabled()) continue;
                minion.moveToLocation(minionX, minionY, this.getZ(), 0);
            }
        }
        if (this._DynamicMinionList != null) {
            for (L2MinionInstance minion : this._DynamicMinionList.getSpawnedMinions()) {
                if (minion == null || minion.isDead() || minion.isMovementDisabled() || this.isInsideRadius(minion, 200, false, false)) continue;
                minionX = Rnd.nextInt(340);
                minionY = Rnd.nextInt(340);
                minionX = minionX < 171 ? this.getX() + minionX + 30 : this.getX() - minionX + 140;
                minionY = minionY < 171 ? this.getY() + minionY + 30 : this.getY() - minionY + 140;
                if (minion.isInCombat() || minion.isDead() || minion.isMovementDisabled()) continue;
                minion.moveToLocation(minionX, minionY, this.getZ(), 0);
            }
        }
    }

    public void callMinionsToAssist(L2Character attacker) {
        if (this._minionList != null) {
            for (L2MinionInstance minion : this._minionList.getSpawnedMinions()) {
                if (minion == null || attacker == null || minion.isDead() || minion.isInCombat()) continue;
                if (this.isRaid() && !this.isRaidMinion()) {
                    minion.addDamageHate(attacker, 0, 100);
                    continue;
                }
                minion.addDamageHate(attacker, 0, 1);
            }
        }
        if (this._DynamicMinionList != null) {
            for (L2MinionInstance minion : this._DynamicMinionList.getSpawnedMinions()) {
                if (minion == null || attacker == null || minion.isDead() || minion.isInCombat()) continue;
                if (this.isRaid() && !this.isRaidMinion()) {
                    minion.addDamageHate(attacker, 0, 100);
                    continue;
                }
                minion.addDamageHate(attacker, 0, 1);
            }
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this._maintenanceTask != null) {
            this._maintenanceTask.cancel(true);
        }
        if (this.hasMinions() && this.isRaid()) {
            this.deleteSpawnedMinions();
        }
        return true;
    }

    public List<L2MinionInstance> getSpawnedMinions() {
        if (this._minionList == null) {
            return null;
        }
        return this._minionList.getSpawnedMinions();
    }

    public int getTotalSpawnedMinionsInstances() {
        if (this._minionList == null) {
            return 0;
        }
        return this._minionList.countSpawnedMinions();
    }

    public int getTotalSpawnedMinionsGroups() {
        if (this._minionList == null) {
            return 0;
        }
        return this._minionList.lazyCountSpawnedMinionsGroups();
    }

    public void notifyMinionDied(L2MinionInstance minion) {
        if (this._DynamicMinionList != null) {
            this._DynamicMinionList.removeSpawnedMinion(minion);
        }
        if (this._minionList == null) {
            return;
        }
        this._minionList.moveMinionToRespawnList(minion);
    }

    public void notifyMinionSpawned(L2MinionInstance minion) {
        if (this._DynamicMinionList != null) {
            this._DynamicMinionList.addSpawnedMinion(minion);
        }
        if (this._minionList == null) {
            return;
        }
        this._minionList.addSpawnedMinion(minion);
    }

    public void notifyMinionAttacked(L2Character attacker, L2MinionInstance minion) {
        this.addDamageHate(attacker, 0, 1);
        this.callMinionsToAssist(attacker);
    }

    public boolean hasMinions() {
        boolean ret = false;
        ret = this._minionList == null ? false : this._minionList.hasMinions();
        if (this._DynamicMinionList != null) {
            ret = ret || this._DynamicMinionList.hasMinions();
        }
        return ret;
    }

    @Override
    public void deleteMe() {
        if (this.hasMinions()) {
            if (this._maintenanceTask != null) {
                this._maintenanceTask.cancel(true);
            }
            this.deleteSpawnedMinions();
        }
        super.deleteMe();
    }

    public void deleteSpawnedMinions() {
        if (this._minionList == null) {
            return;
        }
        for (L2MinionInstance minion : this.getSpawnedMinions()) {
            if (minion == null) continue;
            minion.abortAttack();
            minion.abortCast();
            minion.deleteMe();
            this.getSpawnedMinions().remove(minion);
        }
        this._minionList.clearRespawnList();
    }

    public void enableMinions(boolean b) {
        this._enableMinions = b;
    }

    public void enableDynamicMinions(boolean b) {
        this._enableMinions = b;
        if (b && this._minionList == null) {
            this._DynamicMinionList = new MinionList(this);
        }
    }
}

