/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.zone.type;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.util.Rnd;
import com.l2jserver.util.StringUtil;
import gnu.trove.TIntIntHashMap;
import java.util.Collection;
import java.util.concurrent.Future;

public class L2EffectZone
extends L2ZoneType {
    private int _chance = 100;
    private int _initialDelay = 0;
    private int _reuse = 30000;
    private boolean _enabled = true;
    private boolean _bypassConditions;
    private boolean _isShowDangerIcon;
    private Future<?> _task;
    private TIntIntHashMap _skills;

    public L2EffectZone(int id) {
        super(id);
        this.setTargetType(L2Object.InstanceType.L2Playable);
        this._bypassConditions = false;
        this._isShowDangerIcon = true;
    }

    @Override
    public void setParameter(String name, String value) {
        if (name.equals("chance")) {
            this._chance = Integer.parseInt(value);
        } else if (name.equals("initialDelay")) {
            this._initialDelay = Integer.parseInt(value);
        } else if (name.equals("default_enabled")) {
            this._enabled = Boolean.parseBoolean(value);
        } else if (name.equals("reuse")) {
            this._reuse = Integer.parseInt(value);
        } else if (name.equals("bypassSkillConditions")) {
            this._bypassConditions = Boolean.parseBoolean(value);
        } else if (name.equals("maxDynamicSkillCount")) {
            this._skills = new TIntIntHashMap(Integer.parseInt(value));
        } else if (name.equals("skillIdLvl")) {
            String[] propertySplit = value.split(";");
            this._skills = new TIntIntHashMap(propertySplit.length);
            for (String skill : propertySplit) {
                String[] skillSplit = skill.split("-");
                if (skillSplit.length != 2) {
                    _log.warning(StringUtil.concat("[L2PoisonZone]: invalid config property -> skillsIdLvl \"", skill, "\""));
                    continue;
                }
                try {
                    this._skills.put(Integer.parseInt(skillSplit[0]), Integer.parseInt(skillSplit[1]));
                }
                catch (NumberFormatException nfe) {
                    if (skill.isEmpty()) continue;
                    _log.warning(StringUtil.concat("[L2PoisonZone]: invalid config property -> skillsIdLvl \"", skillSplit[0], "\"", skillSplit[1]));
                }
            }
        } else if (name.equals("showDangerIcon")) {
            this._isShowDangerIcon = Boolean.parseBoolean(value);
        } else {
            super.setParameter(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEnter(L2Character character) {
        if (this._skills != null && this._task == null) {
            L2EffectZone l2EffectZone = this;
            synchronized (l2EffectZone) {
                if (this._task == null) {
                    this._task = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new ApplySkill(), this._initialDelay, this._reuse);
                }
            }
        }
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)19, true);
            if (this._isShowDangerIcon) {
                character.setInsideZone((byte)18, true);
                character.sendPacket(new EtcStatusUpdate((L2PcInstance)character));
            }
        }
    }

    @Override
    protected void onExit(L2Character character) {
        if (character instanceof L2PcInstance) {
            character.setInsideZone((byte)19, false);
            if (this._isShowDangerIcon) {
                character.setInsideZone((byte)18, false);
                if (!character.isInsideZone((byte)18)) {
                    character.sendPacket(new EtcStatusUpdate((L2PcInstance)character));
                }
            }
        }
        if (this._characterList.isEmpty() && this._task != null) {
            this._task.cancel(true);
            this._task = null;
        }
    }

    private L2Skill getSkill(int skillId, int skillLvl) {
        return SkillTable.getInstance().getInfo(skillId, skillLvl);
    }

    public boolean isEnabled() {
        return this._enabled;
    }

    public int getChance() {
        return this._chance;
    }

    public void addSkill(int skillId, int skillLvL) {
        if (skillLvL < 1) {
            this.removeSkill(skillId);
            return;
        }
        if (this._skills == null) {
            this._skills = new TIntIntHashMap(3);
        }
        this._skills.put(skillId, skillLvL);
    }

    public void removeSkill(int skillId) {
        if (this._skills != null) {
            this._skills.remove(skillId);
        }
    }

    public void clearSkills() {
        if (this._skills != null) {
            this._skills.clear();
        }
    }

    public void setZoneEnabled(boolean val) {
        this._enabled = val;
    }

    public int getSkillLevel(int skillId) {
        if (this._skills == null) {
            return 0;
        }
        return this._skills.get(skillId);
    }

    protected Collection<L2Character> getCharacterList() {
        return this._characterList.values();
    }

    @Override
    public void onDieInside(L2Character character) {
    }

    @Override
    public void onReviveInside(L2Character character) {
    }

    class ApplySkill
    implements Runnable {
        ApplySkill() {
            if (L2EffectZone.this._skills == null) {
                throw new IllegalStateException();
            }
        }

        @Override
        public void run() {
            if (L2EffectZone.this.isEnabled()) {
                for (L2Character temp : L2EffectZone.this.getCharacterList()) {
                    if (temp == null || temp.isDead() || Rnd.get(100) >= L2EffectZone.this.getChance()) continue;
                    for (int skillId : L2EffectZone.this._skills.keys()) {
                        if (!L2EffectZone.this._bypassConditions && !L2EffectZone.this.getSkill(skillId, L2EffectZone.this._skills.get(skillId)).checkCondition(temp, temp, false) || temp.getFirstEffect(skillId) != null) continue;
                        L2EffectZone.this.getSkill(skillId, L2EffectZone.this._skills.get(skillId)).getEffects(temp, temp);
                    }
                }
            }
        }
    }
}

