/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import gnu.trove.TIntObjectHashMap;
import java.util.Arrays;

public abstract class AbstractEnchantPacket
extends L2GameClientPacket {
    public static final TIntObjectHashMap<EnchantScroll> _scrolls = new TIntObjectHashMap();
    public static final TIntObjectHashMap<EnchantItem> _supports = new TIntObjectHashMap();

    protected static final EnchantScroll getEnchantScroll(L2ItemInstance scroll) {
        return (EnchantScroll)_scrolls.get(scroll.getItemId());
    }

    protected static final EnchantItem getSupportItem(L2ItemInstance item) {
        return (EnchantItem)_supports.get(item.getItemId());
    }

    protected static final boolean isEnchantable(L2ItemInstance item) {
        if (item.isHeroItem()) {
            return false;
        }
        if (item.isShadowItem()) {
            return false;
        }
        if (item.isCommonItem()) {
            return false;
        }
        if (item.isEtcItem()) {
            return false;
        }
        if (item.isTimeLimitedItem()) {
            return false;
        }
        if (item.isWear()) {
            return false;
        }
        if (item.getItem().getItemType() == L2WeaponType.ROD) {
            return false;
        }
        if (item.getItem().getBodyPart() == 0x200000) {
            return false;
        }
        if (item.getItem().getBodyPart() == 0x100000) {
            return false;
        }
        if (item.getItem().getBodyPart() == 8192) {
            return false;
        }
        if (Arrays.binarySearch(Config.ENCHANT_BLACKLIST, item.getItemId()) >= 0) {
            return false;
        }
        return item.getLocation() == L2ItemInstance.ItemLocation.INVENTORY || item.getLocation() == L2ItemInstance.ItemLocation.PAPERDOLL;
    }

    static {
        _scrolls.put(729, (Object)new EnchantScroll(true, false, false, false, 4, 0, 0, null));
        _scrolls.put(730, (Object)new EnchantScroll(false, false, false, false, 4, 0, 0, null));
        _scrolls.put(731, (Object)new EnchantScroll(true, false, true, false, 4, 0, 0, null));
        _scrolls.put(732, (Object)new EnchantScroll(false, false, true, false, 4, 0, 0, null));
        _scrolls.put(947, (Object)new EnchantScroll(true, false, false, false, 3, 0, 0, null));
        _scrolls.put(948, (Object)new EnchantScroll(false, false, false, false, 3, 0, 0, null));
        _scrolls.put(949, (Object)new EnchantScroll(true, false, true, false, 3, 0, 0, null));
        _scrolls.put(950, (Object)new EnchantScroll(false, false, true, false, 3, 0, 0, null));
        _scrolls.put(951, (Object)new EnchantScroll(true, false, false, false, 2, 0, 0, null));
        _scrolls.put(952, (Object)new EnchantScroll(false, false, false, false, 2, 0, 0, null));
        _scrolls.put(953, (Object)new EnchantScroll(true, false, true, false, 2, 0, 0, null));
        _scrolls.put(954, (Object)new EnchantScroll(false, false, true, false, 2, 0, 0, null));
        _scrolls.put(955, (Object)new EnchantScroll(true, false, false, false, 1, 0, 0, null));
        _scrolls.put(956, (Object)new EnchantScroll(false, false, false, false, 1, 0, 0, null));
        _scrolls.put(957, (Object)new EnchantScroll(true, false, true, false, 1, 0, 0, null));
        _scrolls.put(958, (Object)new EnchantScroll(false, false, true, false, 1, 0, 0, null));
        _scrolls.put(959, (Object)new EnchantScroll(true, false, false, false, 5, 0, 0, null));
        _scrolls.put(960, (Object)new EnchantScroll(false, false, false, false, 5, 0, 0, null));
        _scrolls.put(961, (Object)new EnchantScroll(true, false, true, false, 5, 0, 0, null));
        _scrolls.put(962, (Object)new EnchantScroll(false, false, true, false, 5, 0, 0, null));
        _scrolls.put(6569, (Object)new EnchantScroll(true, true, false, false, 4, 0, 0, null));
        _scrolls.put(6570, (Object)new EnchantScroll(false, true, false, false, 4, 0, 0, null));
        _scrolls.put(6571, (Object)new EnchantScroll(true, true, false, false, 3, 0, 0, null));
        _scrolls.put(6572, (Object)new EnchantScroll(false, true, false, false, 3, 0, 0, null));
        _scrolls.put(6573, (Object)new EnchantScroll(true, true, false, false, 2, 0, 0, null));
        _scrolls.put(6574, (Object)new EnchantScroll(false, true, false, false, 2, 0, 0, null));
        _scrolls.put(6575, (Object)new EnchantScroll(true, true, false, false, 1, 0, 0, null));
        _scrolls.put(6576, (Object)new EnchantScroll(false, true, false, false, 1, 0, 0, null));
        _scrolls.put(6577, (Object)new EnchantScroll(true, true, false, false, 5, 0, 0, null));
        _scrolls.put(6578, (Object)new EnchantScroll(false, true, false, false, 5, 0, 0, null));
        _scrolls.put(22006, (Object)new EnchantScroll(true, false, false, false, 1, 0, 10, null));
        _scrolls.put(22007, (Object)new EnchantScroll(true, false, false, false, 2, 0, 10, null));
        _scrolls.put(22008, (Object)new EnchantScroll(true, false, false, false, 3, 0, 10, null));
        _scrolls.put(22009, (Object)new EnchantScroll(true, false, false, false, 4, 0, 10, null));
        _scrolls.put(22010, (Object)new EnchantScroll(false, false, false, false, 1, 0, 10, null));
        _scrolls.put(22011, (Object)new EnchantScroll(false, false, false, false, 2, 0, 10, null));
        _scrolls.put(22012, (Object)new EnchantScroll(false, false, false, false, 3, 0, 10, null));
        _scrolls.put(22013, (Object)new EnchantScroll(false, false, false, false, 4, 0, 10, null));
        _scrolls.put(22014, (Object)new EnchantScroll(true, false, false, true, 3, 16, 10, null));
        _scrolls.put(22015, (Object)new EnchantScroll(true, false, false, true, 4, 16, 10, null));
        _scrolls.put(22016, (Object)new EnchantScroll(false, false, false, true, 3, 16, 10, null));
        _scrolls.put(22017, (Object)new EnchantScroll(false, false, false, true, 4, 16, 10, null));
        _scrolls.put(22018, (Object)new EnchantScroll(true, false, false, false, 3, 0, 100, null));
        _scrolls.put(22019, (Object)new EnchantScroll(true, false, false, false, 4, 0, 100, null));
        _scrolls.put(22020, (Object)new EnchantScroll(false, false, false, false, 3, 0, 100, null));
        _scrolls.put(22021, (Object)new EnchantScroll(false, false, false, false, 4, 0, 100, null));
        _scrolls.put(13540, (Object)new EnchantScroll(true, false, false, false, 0, 0, 0, new int[]{13539}));
        _supports.put(12362, (Object)new EnchantItem(true, 1, 9, 20, null));
        _supports.put(12363, (Object)new EnchantItem(true, 2, 9, 18, null));
        _supports.put(12364, (Object)new EnchantItem(true, 3, 9, 15, null));
        _supports.put(12365, (Object)new EnchantItem(true, 4, 9, 12, null));
        _supports.put(12366, (Object)new EnchantItem(true, 5, 9, 10, null));
        _supports.put(12367, (Object)new EnchantItem(false, 1, 9, 35, null));
        _supports.put(12368, (Object)new EnchantItem(false, 2, 9, 27, null));
        _supports.put(12369, (Object)new EnchantItem(false, 3, 9, 23, null));
        _supports.put(12370, (Object)new EnchantItem(false, 4, 9, 18, null));
        _supports.put(12371, (Object)new EnchantItem(false, 5, 9, 15, null));
        _supports.put(14702, (Object)new EnchantItem(true, 1, 9, 20, null));
        _supports.put(14703, (Object)new EnchantItem(true, 2, 9, 18, null));
        _supports.put(14704, (Object)new EnchantItem(true, 3, 9, 15, null));
        _supports.put(14705, (Object)new EnchantItem(true, 4, 9, 12, null));
        _supports.put(14706, (Object)new EnchantItem(true, 5, 9, 10, null));
        _supports.put(14707, (Object)new EnchantItem(false, 1, 9, 35, null));
        _supports.put(14708, (Object)new EnchantItem(false, 2, 9, 27, null));
        _supports.put(14709, (Object)new EnchantItem(false, 3, 9, 23, null));
        _supports.put(14710, (Object)new EnchantItem(false, 4, 9, 18, null));
        _supports.put(14711, (Object)new EnchantItem(false, 5, 9, 15, null));
    }

    public static final class EnchantScroll
    extends EnchantItem {
        private final boolean _isBlessed;
        private final boolean _isCrystal;
        private final boolean _isSafe;

        public EnchantScroll(boolean wep, boolean bless, boolean crystal, boolean safe, int type, int level, int chance, int[] items) {
            super(wep, type, level, chance, items);
            this._isBlessed = bless;
            this._isCrystal = crystal;
            this._isSafe = safe;
        }

        public final boolean isBlessed() {
            return this._isBlessed;
        }

        public final boolean isCrystal() {
            return this._isCrystal;
        }

        public final boolean isSafe() {
            return this._isSafe;
        }

        public final boolean isValid(L2ItemInstance enchantItem, EnchantItem supportItem) {
            if (supportItem != null && (!supportItem.isValid(enchantItem) || this.isBlessed())) {
                return false;
            }
            return this.isValid(enchantItem);
        }

        public final int getChance(L2ItemInstance enchantItem, EnchantItem supportItem) {
            boolean fullBody;
            if (!this.isValid(enchantItem, supportItem)) {
                return -1;
            }
            if (enchantItem.getItemId() == 13540 && enchantItem.getEnchantLevel() >= 3) {
                return 66;
            }
            boolean bl = fullBody = enchantItem.getItem().getBodyPart() == 32768;
            if (enchantItem.getEnchantLevel() < Config.ENCHANT_SAFE_MAX || fullBody && enchantItem.getEnchantLevel() < Config.ENCHANT_SAFE_MAX_FULL) {
                return 100;
            }
            boolean isAccessory = enchantItem.getItem().getType2() == 2;
            int chance = 0;
            if (this._isBlessed) {
                if (supportItem != null) {
                    return -1;
                }
                chance = this._isWeapon ? Config.BLESSED_ENCHANT_CHANCE_WEAPON : (isAccessory ? Config.BLESSED_ENCHANT_CHANCE_JEWELRY : Config.BLESSED_ENCHANT_CHANCE_ARMOR);
            } else if (this._isCrystal) {
                if (supportItem != null) {
                    return -1;
                }
                chance = this._isWeapon ? Config.CRYSTAL_ENCHANT_CHANCE_WEAPON : (isAccessory ? Config.CRYSTAL_ENCHANT_CHANCE_JEWELRY : Config.CRYSTAL_ENCHANT_CHANCE_ARMOR);
            } else {
                chance = this._isWeapon ? Config.ENCHANT_CHANCE_WEAPON : (isAccessory ? Config.ENCHANT_CHANCE_JEWELRY : Config.ENCHANT_CHANCE_ARMOR);
            }
            chance += this._chanceAdd;
            if (supportItem != null) {
                chance += supportItem.getChanceAdd();
            }
            return chance;
        }
    }

    public static class EnchantItem {
        protected final boolean _isWeapon;
        protected final int _grade;
        protected final int _maxEnchantLevel;
        protected final int _chanceAdd;
        protected final int[] _itemIds;

        public EnchantItem(boolean wep, int type, int level, int chance, int[] items) {
            this._isWeapon = wep;
            this._grade = type;
            this._maxEnchantLevel = level;
            this._chanceAdd = chance;
            this._itemIds = items;
        }

        public final boolean isValid(L2ItemInstance enchantItem) {
            if (enchantItem == null) {
                return false;
            }
            int type2 = enchantItem.getItem().getType2();
            switch (type2) {
                case 0: {
                    if (this._isWeapon && (Config.ENCHANT_MAX_WEAPON <= 0 || enchantItem.getEnchantLevel() < Config.ENCHANT_MAX_WEAPON)) break;
                    return false;
                }
                case 1: {
                    if (!this._isWeapon && (Config.ENCHANT_MAX_ARMOR <= 0 || enchantItem.getEnchantLevel() < Config.ENCHANT_MAX_ARMOR)) break;
                    return false;
                }
                case 2: {
                    if (!this._isWeapon && (Config.ENCHANT_MAX_JEWELRY <= 0 || enchantItem.getEnchantLevel() < Config.ENCHANT_MAX_JEWELRY)) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (this._grade != enchantItem.getItem().getItemGradeSPlus()) {
                return false;
            }
            if (this._maxEnchantLevel != 0 && enchantItem.getEnchantLevel() >= this._maxEnchantLevel) {
                return false;
            }
            return this._itemIds == null || Arrays.binarySearch(this._itemIds, enchantItem.getItemId()) >= 0;
        }

        public final int getChanceAdd() {
            return this._chanceAdd;
        }
    }
}

