/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.KeyPacket;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public final class ProtocolVersion
extends L2GameClientPacket {
    private static final String _C__00_PROTOCOLVERSION = "[C] 00 ProtocolVersion";
    private static final Logger _log = Logger.getLogger(ProtocolVersion.class.getName());
    private static final Logger _logAccounting = Logger.getLogger("accounting");
    private int _version;

    @Override
    protected void readImpl() {
        this._version = this.readD();
    }

    @Override
    protected void runImpl() {
        if (this._version == -2) {
            if (Config.DEBUG) {
                _log.info("Ping received");
            }
            ((L2GameClient)this.getClient()).closeNow();
        } else if (!Config.PROTOCOL_LIST.contains(this._version)) {
            LogRecord record = new LogRecord(Level.WARNING, "Wrong protocol");
            record.setParameters(new Object[]{this._version, this.getClient()});
            _logAccounting.log(record);
            KeyPacket pk = new KeyPacket(((L2GameClient)this.getClient()).enableCrypt(), 0);
            ((L2GameClient)this.getClient()).sendPacket(pk);
            ((L2GameClient)this.getClient()).setProtocolOk(false);
        } else {
            if (Config.DEBUG) {
                _log.fine("Client Protocol Revision is ok: " + this._version);
            }
            KeyPacket pk = new KeyPacket(((L2GameClient)this.getClient()).enableCrypt(), 1);
            ((L2GameClient)this.getClient()).sendPacket(pk);
            ((L2GameClient)this.getClient()).setProtocolOk(true);
        }
    }

    @Override
    public String getType() {
        return _C__00_PROTOCOLVERSION;
    }
}

