/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutItemResultForVariationCancel;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;

public final class RequestConfirmCancelItem
extends L2GameClientPacket {
    private static final String _C__D0_2D_REQUESTCONFIRMCANCELITEM = "[C] D0:2D RequestConfirmCancelItem";
    private int _objectId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (item.getOwnerId() != activeChar.getObjectId()) {
            Util.handleIllegalPlayerAction(((L2GameClient)this.getClient()).getActiveChar(), "Warning!! Character " + ((L2GameClient)this.getClient()).getActiveChar().getName() + " of account " + ((L2GameClient)this.getClient()).getActiveChar().getAccountName() + " tryied to destroy augment on item that doesn't own.", Config.DEFAULT_PUNISH);
            return;
        }
        if (!item.isAugmented()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.AUGMENTATION_REMOVAL_CAN_ONLY_BE_DONE_ON_AN_AUGMENTED_ITEM));
            return;
        }
        if (item.isPvp()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.THIS_IS_NOT_A_SUITABLE_ITEM));
            return;
        }
        int price = 0;
        switch (item.getItem().getCrystalType()) {
            case 2: {
                if (item.getCrystalCount() < 1720) {
                    price = 95000;
                    break;
                }
                if (item.getCrystalCount() < 2452) {
                    price = 150000;
                    break;
                }
                price = 210000;
                break;
            }
            case 3: {
                if (item.getCrystalCount() < 1746) {
                    price = 240000;
                    break;
                }
                price = 270000;
                break;
            }
            case 4: {
                if (item.getCrystalCount() < 2160) {
                    price = 330000;
                    break;
                }
                if (item.getCrystalCount() < 2824) {
                    price = 390000;
                    break;
                }
                price = 420000;
                break;
            }
            case 5: {
                price = 480000;
                break;
            }
            case 6: 
            case 7: {
                price = 920000;
                break;
            }
            default: {
                return;
            }
        }
        activeChar.sendPacket(new ExPutItemResultForVariationCancel(item, price));
    }

    @Override
    public String getType() {
        return _C__D0_2D_REQUESTCONFIRMCANCELITEM;
    }
}

