/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import java.util.logging.Logger;

public final class RequestCrystallizeItem
extends L2GameClientPacket {
    private static final String _C__72_REQUESTDCRYSTALLIZEITEM = "[C] 72 RequestCrystallizeItem";
    private static Logger _log = Logger.getLogger(RequestCrystallizeItem.class.getName());
    private int _objectId;
    private long _count;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._count = this.readQ();
    }

    @Override
    protected void runImpl() {
        InventoryUpdate iu;
        L2ItemInstance itemToRemove;
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            _log.fine("RequestCrystalizeItem: activeChar was null");
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getTransaction().tryPerformAction("crystallize")) {
            activeChar.sendMessage("You crystallizing too fast.");
            return;
        }
        if (this._count <= 0L) {
            Util.handleIllegalPlayerAction(activeChar, "[RequestCrystallizeItem] count <= 0! ban! oid: " + this._objectId + " owner: " + activeChar.getName(), Config.DEFAULT_PUNISH);
            return;
        }
        if (activeChar.getPrivateStoreType() != 0 || activeChar.isInCrystallize()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE));
            return;
        }
        int skillLevel = activeChar.getSkillLevel(248);
        if (skillLevel <= 0) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CRYSTALLIZE_LEVEL_TOO_LOW));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            if (activeChar.getRace() != Race.Dwarf && activeChar.getClassId().ordinal() != 117 && activeChar.getClassId().ordinal() != 55) {
                _log.info("Player " + activeChar.getClient() + " used crystalize with classid: " + activeChar.getClassId().ordinal());
            }
            return;
        }
        PcInventory inventory = activeChar.getInventory();
        if (inventory != null) {
            L2ItemInstance item = inventory.getItemByObjectId(this._objectId);
            if (item == null || item.isWear()) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (item.isHeroItem()) {
                return;
            }
            if (this._count > item.getCount()) {
                this._count = activeChar.getInventory().getItemByObjectId(this._objectId).getCount();
            }
        }
        if ((itemToRemove = activeChar.getInventory().getItemByObjectId(this._objectId)) == null || itemToRemove.isWear() || itemToRemove.isShadowItem() || itemToRemove.isTimeLimitedItem()) {
            return;
        }
        if (!itemToRemove.getItem().isCrystallizable() || itemToRemove.getItem().getCrystalCount() <= 0 || itemToRemove.getItem().getCrystalType() == 0) {
            _log.warning(activeChar.getName() + " (" + activeChar.getObjectId() + ") tried to crystallize " + itemToRemove.getItem().getItemId());
            return;
        }
        if (!activeChar.getInventory().canManipulateWithItemId(itemToRemove.getItemId())) {
            activeChar.sendMessage("Cannot use this item.");
            return;
        }
        boolean canCrystallize = true;
        switch (itemToRemove.getItem().getItemGradeSPlus()) {
            case 2: {
                if (skillLevel > 1) break;
                canCrystallize = false;
                break;
            }
            case 3: {
                if (skillLevel > 2) break;
                canCrystallize = false;
                break;
            }
            case 4: {
                if (skillLevel > 3) break;
                canCrystallize = false;
                break;
            }
            case 5: {
                if (skillLevel > 4) break;
                canCrystallize = false;
            }
        }
        if (!canCrystallize) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CRYSTALLIZE_LEVEL_TOO_LOW));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        activeChar.setInCrystallize(true);
        if (itemToRemove.isEquipped()) {
            SystemMessage msg;
            L2ItemInstance[] unequiped = activeChar.getInventory().unEquipItemInSlotAndRecord(itemToRemove.getLocationSlot());
            iu = new InventoryUpdate();
            for (L2ItemInstance item : unequiped) {
                iu.addModifiedItem(item);
            }
            activeChar.sendPacket(iu);
            if (itemToRemove.getEnchantLevel() > 0) {
                msg = new SystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                msg.addNumber(itemToRemove.getEnchantLevel());
                msg.addItemName(itemToRemove);
            } else {
                msg = new SystemMessage(SystemMessageId.S1_DISARMED);
                msg.addItemName(itemToRemove);
            }
            activeChar.sendPacket(msg);
        }
        L2ItemInstance removedItem = activeChar.getInventory().destroyItem("Crystalize", this._objectId, this._count, activeChar, null);
        iu = new InventoryUpdate();
        iu.addRemovedItem(removedItem);
        activeChar.sendPacket(iu);
        int crystalId = itemToRemove.getItem().getCrystalItemId();
        int crystalAmount = itemToRemove.getCrystalCount();
        L2ItemInstance createditem = activeChar.getInventory().addItem("Crystalize", crystalId, crystalAmount, activeChar, activeChar);
        SystemMessage sm = new SystemMessage(SystemMessageId.S1_CRYSTALLIZED);
        sm.addItemName(removedItem);
        activeChar.sendPacket(sm);
        sm = new SystemMessage(SystemMessageId.EARNED_S2_S1_S);
        sm.addItemName(createditem);
        sm.addItemNumber(crystalAmount);
        activeChar.sendPacket(sm);
        activeChar.broadcastUserInfo();
        L2World world = L2World.getInstance();
        world.removeObject(removedItem);
        activeChar.setInCrystallize(false);
    }

    @Override
    public String getType() {
        return _C__72_REQUESTDCRYSTALLIZEITEM;
    }
}

