/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.AbstractEnchantPacket;
import com.l2jserver.gameserver.network.serverpackets.ExPutEnchantTargetItemResult;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;

public class RequestExTryToPutEnchantTargetItem
extends AbstractEnchantPacket {
    private int _objectId = 0;

    @Override
    public String getType() {
        return "[C] D0:4F RequestExTryToPutEnchantTargetItem".intern();
    }

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (this._objectId == 0) {
            return;
        }
        if (activeChar != null) {
            if (activeChar.isEnchanting()) {
                return;
            }
            L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
            L2ItemInstance scroll = activeChar.getActiveEnchantItem();
            if (item == null || scroll == null) {
                return;
            }
            AbstractEnchantPacket.EnchantScroll scrollTemplate = RequestExTryToPutEnchantTargetItem.getEnchantScroll(scroll);
            if (!scrollTemplate.isValid(item) || !RequestExTryToPutEnchantTargetItem.isEnchantable(item)) {
                activeChar.sendPacket(new SystemMessage(SystemMessageId.DOES_NOT_FIT_SCROLL_CONDITIONS));
                activeChar.setActiveEnchantItem(null);
                activeChar.sendPacket(new ExPutEnchantTargetItemResult(0));
                return;
            }
            activeChar.setIsEnchanting(true);
            activeChar.setActiveEnchantTimestamp(System.currentTimeMillis());
            activeChar.sendPacket(new ExPutEnchantTargetItemResult(this._objectId));
        }
    }
}

