/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.cache.CrestCache;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class RequestSetPledgeCrest
extends L2GameClientPacket {
    private static final String _C__53_REQUESTSETPLEDGECREST = "[C] 53 RequestSetPledgeCrest";
    static Logger _log = Logger.getLogger(RequestSetPledgeCrest.class.getName());
    private int _length;
    private byte[] _data;

    @Override
    protected void readImpl() {
        this._length = this.readD();
        if (this._length > 256) {
            return;
        }
        this._data = new byte[this._length];
        this.readB(this._data);
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        L2Clan clan = activeChar.getClan();
        if (clan == null) {
            return;
        }
        if (clan.getDissolvingExpiryTime() > System.currentTimeMillis()) {
            activeChar.sendPacket(new SystemMessage(SystemMessageId.CANNOT_SET_CREST_WHILE_DISSOLUTION_IN_PROGRESS));
            return;
        }
        if (this._length < 0) {
            activeChar.sendMessage("File transfer error.");
            return;
        }
        if (this._length > 256) {
            activeChar.sendMessage("The clan crest file size was too big (max 256 bytes).");
            return;
        }
        boolean updated = false;
        int crestId = -1;
        if ((activeChar.getClanPrivileges() & 0x80) == 128) {
            if (this._length == 0 || this._data.length == 0) {
                if (clan.getCrestId() == 0) {
                    return;
                }
                crestId = 0;
                activeChar.sendPacket(new SystemMessage(SystemMessageId.CLAN_CREST_HAS_BEEN_DELETED));
                updated = true;
            } else {
                if (clan.getLevel() < 3) {
                    activeChar.sendPacket(new SystemMessage(SystemMessageId.CLAN_LVL_3_NEEDED_TO_SET_CREST));
                    return;
                }
                crestId = IdFactory.getInstance().getNextId();
                if (!CrestCache.getInstance().savePledgeCrest(crestId, this._data)) {
                    _log.log(Level.INFO, "Error saving crest for clan " + clan.getName() + " [" + clan.getClanId() + "]");
                    return;
                }
                updated = true;
            }
        }
        if (updated && crestId != -1) {
            clan.changeClanCrest(crestId);
        }
    }

    @Override
    public String getType() {
        return _C__53_REQUESTSETPLEDGECREST;
    }
}

