/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.gameserver.templates.item.L2Item;
import javolution.util.FastList;

public class ConfirmDlg
extends L2GameServerPacket {
    private static final String _S__ED_CONFIRMDLG = "[S] f3 ConfirmDlg";
    private int _messageId;
    private int _skillLvL = 1;
    private static final int TYPE_ZONE_NAME = 7;
    private static final int TYPE_SKILL_NAME = 4;
    private static final int TYPE_ITEM_NAME = 3;
    private static final int TYPE_NPC_NAME = 2;
    private static final int TYPE_NUMBER = 1;
    private static final int TYPE_TEXT = 0;
    private final FastList<CnfDlgData> _info = new FastList();
    private int _time = 0;
    private int _requesterId = 0;

    public ConfirmDlg(int messageId) {
        this._messageId = messageId;
    }

    public ConfirmDlg addString(String text) {
        this._info.add((Object)new CnfDlgData(0, text));
        return this;
    }

    public ConfirmDlg addNumber(int number) {
        this._info.add((Object)new CnfDlgData(1, number));
        return this;
    }

    public ConfirmDlg addCharName(L2Character cha) {
        if (cha instanceof L2Npc) {
            return this.addNpcName((L2Npc)cha);
        }
        if (cha instanceof L2PcInstance) {
            return this.addPcName((L2PcInstance)cha);
        }
        if (cha instanceof L2Summon) {
            return this.addNpcName((L2Summon)cha);
        }
        return this.addString(cha.getName());
    }

    public ConfirmDlg addPcName(L2PcInstance pc) {
        return this.addString(pc.getAppearance().getVisibleName());
    }

    public ConfirmDlg addNpcName(L2Npc npc) {
        return this.addNpcName(npc.getTemplate());
    }

    public ConfirmDlg addNpcName(L2Summon npc) {
        return this.addNpcName(npc.getNpcId());
    }

    public ConfirmDlg addNpcName(L2NpcTemplate tpl) {
        if (tpl.isCustom()) {
            return this.addString(tpl.name);
        }
        return this.addNpcName(tpl.npcId);
    }

    public ConfirmDlg addNpcName(int id) {
        this._info.add((Object)new CnfDlgData(2, id));
        return this;
    }

    public ConfirmDlg addItemName(L2ItemInstance item) {
        return this.addItemName(item.getItem().getItemId());
    }

    public ConfirmDlg addItemName(L2Item item) {
        return this.addItemName(item.getItemId());
    }

    public ConfirmDlg addItemName(int id) {
        this._info.add((Object)new CnfDlgData(3, id));
        return this;
    }

    public ConfirmDlg addZoneName(int x, int y, int z) {
        int[] coord = new int[]{x, y, z};
        this._info.add((Object)new CnfDlgData(7, coord));
        return this;
    }

    public ConfirmDlg addSkillName(L2Effect effect) {
        return this.addSkillName(effect.getSkill());
    }

    public ConfirmDlg addSkillName(L2Skill skill) {
        if (skill.getId() != skill.getDisplayId()) {
            return this.addString(skill.getName());
        }
        return this.addSkillName(skill.getId(), skill.getLevel());
    }

    public ConfirmDlg addSkillName(int id) {
        return this.addSkillName(id, 1);
    }

    public ConfirmDlg addSkillName(int id, int lvl) {
        this._info.add((Object)new CnfDlgData(4, id));
        this._skillLvL = lvl;
        return this;
    }

    public ConfirmDlg addTime(int time) {
        this._time = time;
        return this;
    }

    public ConfirmDlg addRequesterId(int id) {
        this._requesterId = id;
        return this;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(243);
        this.writeD(this._messageId);
        if (this._info.isEmpty()) {
            this.writeD(0);
            this.writeD(this._time);
            this.writeD(this._requesterId);
        } else {
            this.writeD(this._info.size());
            for (CnfDlgData data : this._info) {
                this.writeD(data.type);
                switch (data.type) {
                    case 0: {
                        this.writeS((String)data.value);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        this.writeD((Integer)data.value);
                        break;
                    }
                    case 4: {
                        this.writeD((Integer)data.value);
                        this.writeD(this._skillLvL);
                        break;
                    }
                    case 7: {
                        int[] array = (int[])data.value;
                        this.writeD(array[0]);
                        this.writeD(array[1]);
                        this.writeD(array[2]);
                    }
                }
            }
            if (this._time != 0) {
                this.writeD(this._time);
            }
            if (this._requesterId != 0) {
                this.writeD(this._requesterId);
            }
        }
    }

    @Override
    public String getType() {
        return _S__ED_CONFIRMDLG;
    }

    protected static class CnfDlgData {
        protected final int type;
        protected final Object value;

        protected CnfDlgData(int t, Object val) {
            this.type = t;
            this.value = val;
        }
    }
}

