/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.PledgeReceiveSubPledgeCreated;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListAdd;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;

public class PledgeShowMemberListAll
extends L2GameServerPacket {
    private static final String _S__68_PLEDGESHOWMEMBERLISTALL = "[S] 5a PledgeShowMemberListAll";
    private L2Clan _clan;
    private L2PcInstance _activeChar;
    private L2ClanMember[] _members;
    private int _pledgeType;

    public PledgeShowMemberListAll(L2Clan clan, L2PcInstance activeChar) {
        this._clan = clan;
        this._activeChar = activeChar;
        this._members = this._clan.getMembers();
    }

    @Override
    protected final void writeImpl() {
        this._pledgeType = 0;
        this.writePledge(0);
        for (L2Clan.SubPledge subPledge : this._clan.getAllSubPledges()) {
            this._activeChar.sendPacket(new PledgeReceiveSubPledgeCreated(subPledge, this._clan));
        }
        for (L2ClanMember m : this._members) {
            if (m.getPledgeType() == 0) continue;
            this._activeChar.sendPacket(new PledgeShowMemberListAdd(m));
        }
        this._activeChar.sendPacket(new UserInfo(this._activeChar));
        this._activeChar.sendPacket(new ExBrExtraUserInfo(this._activeChar));
    }

    void writePledge(int mainOrSubpledge) {
        this.writeC(90);
        this.writeD(mainOrSubpledge);
        this.writeD(this._clan.getClanId());
        this.writeD(this._pledgeType);
        this.writeS(this._clan.getName());
        this.writeS(this._clan.getLeaderName());
        this.writeD(this._clan.getCrestId());
        this.writeD(this._clan.getLevel());
        this.writeD(this._clan.getHasCastle());
        this.writeD(this._clan.getHasHideout());
        this.writeD(this._clan.getHasFort());
        this.writeD(this._clan.getRank());
        this.writeD(this._clan.getReputationScore());
        this.writeD(0);
        this.writeD(0);
        this.writeD(this._clan.getAllyId());
        this.writeS(this._clan.getAllyName());
        this.writeD(this._clan.getAllyCrestId());
        this.writeD(this._clan.isAtWar() ? 1 : 0);
        this.writeD(0);
        this.writeD(this._clan.getSubPledgeMembersCount(this._pledgeType));
        for (L2ClanMember m : this._members) {
            if (m.getPledgeType() != this._pledgeType) continue;
            this.writeS(m.getName());
            this.writeD(m.getLevel());
            this.writeD(m.getClassId());
            L2PcInstance player = m.getPlayerInstance();
            if (player != null) {
                this.writeD(player.getAppearance().getSex() ? 1 : 0);
                this.writeD(player.getRace().ordinal());
            } else {
                this.writeD(1);
                this.writeD(1);
            }
            this.writeD(m.isOnline() ? m.getObjectId() : 0);
            this.writeD(m.getSponsor() != 0 ? 1 : 0);
        }
    }

    @Override
    public String getType() {
        return _S__68_PLEDGESHOWMEMBERLISTALL;
    }
}

