/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;
import com.l2jserver.util.Rnd;

public class EffectCancel
extends L2Effect {
    public EffectCancel(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.CANCEL;
    }

    @Override
    public boolean onStart() {
        return EffectCancel.cancel(this.getEffector(), this.getEffected(), this.getSkill(), this.getEffectTemplate().effectType);
    }

    @Override
    public boolean onActionTime() {
        return false;
    }

    private static boolean cancel(L2Character caster, L2Character target, L2Skill skill, L2SkillType effectType) {
        L2Effect effect;
        if (!(target instanceof L2PcInstance) || target.isDead()) {
            return false;
        }
        int cancelLvl = skill.getMagicLevel();
        int count = skill.getMaxNegatedEffects();
        double baseRate = Formulas.calcSkillTypeProficiency(skill.getPower(), caster, target, effectType);
        baseRate += Formulas.calcSkillTypeVulnerability(baseRate, caster, effectType);
        int lastCanceledSkillId = 0;
        L2Effect[] effects = target.getAllEffects();
        int i = effects.length;
        while (--i >= 0) {
            effect = effects[i];
            if (effect == null) continue;
            if (!effect.canBeStolen()) {
                effects[i] = null;
                continue;
            }
            if (!effect.getSkill().isDance()) continue;
            if (effect.getSkill().getId() == lastCanceledSkillId) {
                effect.exit();
                continue;
            }
            if (!EffectCancel.calcCancelSuccess(effect, cancelLvl, (int)baseRate)) continue;
            lastCanceledSkillId = effect.getSkill().getId();
            effect.exit();
            if (--count != 0) continue;
        }
        if (count != 0) {
            lastCanceledSkillId = 0;
            i = effects.length;
            while (--i >= 0) {
                effect = effects[i];
                if (effect == null || effect.getSkill().isDance()) continue;
                if (effect.getSkill().getId() == lastCanceledSkillId) {
                    effect.exit();
                    continue;
                }
                if (!EffectCancel.calcCancelSuccess(effect, cancelLvl, (int)baseRate)) continue;
                lastCanceledSkillId = effect.getSkill().getId();
                effect.exit();
                if (--count != 0) continue;
                break;
            }
        }
        return true;
    }

    private static boolean calcCancelSuccess(L2Effect effect, int cancelLvl, int baseRate) {
        int rate = 2 * (cancelLvl - effect.getSkill().getMagicLevel());
        rate += (effect.getPeriod() - effect.getTime()) / 1200;
        if ((rate += baseRate) < 25) {
            rate = 25;
        } else if (rate > 75) {
            rate = 75;
        }
        return Rnd.get(100) < rate;
    }
}

