/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import java.util.logging.Logger;

public class EffectThrowUp
extends L2Effect {
    static final Logger _log = Logger.getLogger(EffectThrowUp.class.getName());
    private int _x;
    private int _y;
    private int _z;

    public EffectThrowUp(Env env, EffectTemplate template) {
        super(env, template);
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.THROW_UP;
    }

    @Override
    public boolean onStart() {
        int curX = this.getEffected().getX();
        int curY = this.getEffected().getY();
        int curZ = this.getEffected().getZ();
        double dx = this.getEffector().getX() - curX;
        double dy = this.getEffector().getY() - curY;
        double dz = this.getEffector().getZ() - curZ;
        double distance = Math.sqrt(dx * dx + dy * dy);
        if (distance > 2000.0) {
            _log.info("EffectThrow was going to use invalid coordinates for characters, getEffected: " + curX + "," + curY + " and getEffector: " + this.getEffector().getX() + "," + this.getEffector().getY());
            return false;
        }
        int offset = Math.min((int)distance + this.getSkill().getFlyRadius(), 1400);
        if ((offset = (int)((double)offset + Math.abs(dz))) < 5) {
            offset = 5;
        }
        if (distance < 1.0) {
            return false;
        }
        double sin = dy / distance;
        double cos = dx / distance;
        this._x = this.getEffector().getX() - (int)((double)offset * cos);
        this._y = this.getEffector().getY() - (int)((double)offset * sin);
        this._z = this.getEffected().getZ();
        if (Config.GEODATA > 0) {
            Location destiny = GeoData.getInstance().moveCheck(this.getEffected().getX(), this.getEffected().getY(), this.getEffected().getZ(), this._x, this._y, this._z, this.getEffected().getInstanceId());
            this._x = destiny.getX();
            this._y = destiny.getY();
        }
        this.getEffected().startStunning();
        this.getEffected().broadcastPacket(new FlyToLocation(this.getEffected(), this._x, this._y, this._z, FlyToLocation.FlyType.THROW_UP));
        return true;
    }

    @Override
    public boolean onActionTime() {
        return false;
    }

    @Override
    public void onExit() {
        this.getEffected().stopStunning(false);
        this.getEffected().setXYZ(this._x, this._y, this._z);
        this.getEffected().broadcastPacket(new ValidateLocation(this.getEffected()));
    }
}

