/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.l2skills;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.BaseStats;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.Formulas;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class L2SkillChargeDmg
extends L2Skill {
    private static final Logger _logDamage = Logger.getLogger("damage");

    public L2SkillChargeDmg(StatsSet set) {
        super(set);
    }

    @Override
    public void useSkill(L2Character caster, L2Object[] targets) {
        L2ItemInstance weapon;
        if (caster.isAlikeDead()) {
            return;
        }
        double modifier = 0.0;
        if (caster instanceof L2PcInstance) {
            modifier = 0.8 + 0.201 * (double)(this.getNumCharges() + ((L2PcInstance)caster).getCharges());
        }
        boolean soul = (weapon = caster.getActiveWeaponInstance()) != null && weapon.getChargedSoulshot() == 1 && weapon.getItemType() != L2WeaponType.DAGGER;
        for (L2Character target : (L2Character[])targets) {
            if (target.isAlikeDead()) continue;
            boolean skillIsEvaded = Formulas.calcPhysicalSkillEvasion(target, this);
            if (skillIsEvaded) {
                SystemMessage sm;
                if (caster instanceof L2PcInstance) {
                    sm = new SystemMessage(SystemMessageId.C1_DODGES_ATTACK);
                    sm.addString(target.getName());
                    ((L2PcInstance)caster).sendPacket(sm);
                }
                if (!(target instanceof L2PcInstance)) continue;
                sm = new SystemMessage(SystemMessageId.AVOIDED_C1_ATTACK2);
                sm.addString(caster.getName());
                ((L2PcInstance)target).sendPacket(sm);
                continue;
            }
            byte shld = Formulas.calcShldUse(caster, target, this);
            boolean crit = false;
            if (this.getBaseCritRate() > 0) {
                crit = Formulas.calcCrit((double)(this.getBaseCritRate() * 10) * BaseStats.STR.calcBonus(caster), target);
            }
            double damage = Formulas.calcPhysDam(caster, target, this, shld, false, false, soul);
            if (crit) {
                damage *= 2.0;
            }
            if (damage > 0.0) {
                byte reflect = Formulas.calcSkillReflect(target, this);
                if (this.hasEffects()) {
                    if ((reflect & 1) != 0) {
                        caster.stopSkillEffects(this.getId());
                        this.getEffects(target, caster);
                        SystemMessage sm = new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                        sm.addSkillName(this);
                        caster.sendPacket(sm);
                    } else {
                        target.stopSkillEffects(this.getId());
                        if (Formulas.calcSkillSuccess(caster, target, this, shld, false, false, true)) {
                            this.getEffects(caster, target, new Env(shld, false, false, false));
                            SystemMessage sm = new SystemMessage(SystemMessageId.YOU_FEEL_S1_EFFECT);
                            sm.addSkillName(this);
                            target.sendPacket(sm);
                        } else {
                            SystemMessage sm = new SystemMessage(SystemMessageId.C1_RESISTED_YOUR_S2);
                            sm.addCharName(target);
                            sm.addSkillName(this);
                            caster.sendPacket(sm);
                        }
                    }
                }
                double finalDamage = damage * modifier;
                if (Config.LOG_GAME_DAMAGE && caster instanceof L2Playable && damage > (double)Config.LOG_GAME_DAMAGE_THRESHOLD) {
                    LogRecord record = new LogRecord(Level.INFO, "");
                    record.setParameters(new Object[]{caster, " did damage ", (int)damage, this, " to ", target});
                    record.setLoggerName("pdam");
                    _logDamage.log(record);
                }
                target.reduceCurrentHp(finalDamage, caster, this);
                if ((reflect & 2) != 0) {
                    caster.reduceCurrentHp(damage, target, this);
                }
                caster.sendDamageMessage(target, (int)finalDamage, false, crit, false);
                continue;
            }
            caster.sendDamageMessage(target, 0, false, false, true);
        }
        if (soul && weapon != null) {
            weapon.setChargedSoulshot(0);
        }
        if (this.hasSelfEffects()) {
            L2Effect effect = caster.getFirstEffect(this.getId());
            if (effect != null && effect.isSelfEffect()) {
                effect.exit();
            }
            this.getEffectsSelf(caster);
        }
    }
}

