DROP TABLE IF EXISTS `pets_stats`;
CREATE TABLE `pets_stats` (
  `type` varchar(25) NOT NULL default '',
  `typeID` int(5) NOT NULL default '0',
  `level` int(11) NOT NULL default '0',
  `expMax` BIGINT UNSIGNED NOT NULL DEFAULT 0,
  `hpMax` int(11) NOT NULL default '0',
  `mpMax` int(11) NOT NULL default '0',
  `patk` int(11) NOT NULL default '0',
  `pdef` int(11) NOT NULL default '0',
  `matk` int(11) NOT NULL default '0',
  `mdef` int(11) NOT NULL default '0',
  `acc` int(11) NOT NULL default '0',
  `evasion` int(11) NOT NULL default '0',
  `crit` int(11) NOT NULL default '0',
  `speed` int(11) NOT NULL default '0',
  `atk_speed` int(11) NOT NULL default '0',
  `cast_speed` int(11) NOT NULL default '0',
  `feedMax` int(11) NOT NULL default '0',
  `feedbattle` int(11) NOT NULL default '0',
  `feednormal` int(11) NOT NULL default '0',
  `loadMax` int(11) NOT NULL default '0',
  `hpregen` int(11) NOT NULL default '0',
  `mpregen` int(11) NOT NULL default '0',
  `owner_exp_taken` DECIMAL(3,2) DEFAULT '0' NOT NULL,
  `soulshot_count` int(4) default 1,
  `spiritshot_count` int(4) default 1,
  PRIMARY KEY (`typeID`,`level`)
);

INSERT INTO `pets_stats` VALUES
('wolf',12077,1,0,31,25,2,11,1,8,38,33,40,137,278,333,248,2,2,54510,2,1,0.27,1,1),
('wolf',12077,2,636,37,30,2,11,1,8,39,34,40,137,278,333,244,2,2,54510,2,1,0.27,1,1),
('wolf',12077,3,798,45,34,2,11,1,8,40,35,40,137,278,333,320,2,2,54510,2,1,0.27,1,1),
('wolf',12077,4,1236,53,39,2,12,1,9,41,36,40,137,278,333,400,3,2,54510,2,1,0.27,1,1),
('wolf',12077,5,2158,63,44,3,12,2,9,42,37,40,137,278,333,512,4,2,54510,2,1,0.27,1,1),
('wolf',12077,6,3836,73,49,3,13,2,9,43,38,40,137,278,333,624,5,2,54510,2,1,0.27,1,1),
('wolf',12077,7,6598,85,54,3,13,2,10,44,39,40,137,278,333,704,5,2,54510,2,1,0.27,1,1),
('wolf',12077,8,10836,98,59,4,14,2,10,45,40,40,137,278,333,808,6,2,54510,2,1,0.27,1,1),
('wolf',12077,9,16998,113,64,4,14,3,10,46,41,40,137,278,333,872,7,2,54510,2,1,0.27,1,1),
('wolf',12077,10,25596,128,69,4,15,3,11,47,42,40,137,278,333,948,7,2,54510,2,1,0.27,1,1),
('wolf',12077,11,37198,146,74,5,16,3,11,48,43,40,137,278,333,1160,9,2,54510,3,1,0.27,1,1),
('wolf',12077,12,52436,157,79,5,16,3,12,49,44,40,137,278,333,1168,9,2,54510,3,1,0.27,1,1),
('wolf',12077,13,71998,169,84,6,17,4,12,50,45,40,137,278,333,1160,9,2,54510,3,1,0.27,1,1),
('wolf',12077,14,96636,182,90,7,17,2,17,51,46,40,137,278,333,1160,9,2,54510,3,1,0.27,1,1),
('wolf',12077,15,127158,195,95,13,28,3,17,52,47,44,125,278,333,1160,9,2,54510,3,1,0.27,1,1),
('wolf',12077,16,164436,208,100,15,29,3,17,53,48,44,125,278,333,1148,9,2,54510,3,1,0.27,1,1),
('wolf',12077,17,209398,223,106,15,29,3,18,54,49,44,125,278,333,1140,9,2,54510,3,1,0.27,1,1),
('wolf',12077,18,263036,238,111,16,31,4,19,55,50,44,125,278,333,1132,9,2,54510,3,1,0.27,1,1),
('wolf',12077,19,326398,254,117,18,32,4,20,56,51,44,125,278,333,1124,9,2,54510,3,1,0.27,1,1),
('wolf',12077,20,400596,270,122,19,32,5,20,57,52,44,125,278,333,1116,9,2,54510,3,1,0.27,1,1),
('wolf',12077,21,486798,287,131,19,34,6,22,58,53,44,125,278,333,1480,12,2,54510,4,2,0.27,1,1),
('wolf',12077,22,586236,305,139,21,35,6,22,59,54,44,125,278,333,1512,12,2,54510,4,2,0.27,1,1),
('wolf',12077,23,700198,324,148,22,35,7,24,60,55,44,125,278,333,1468,12,2,54510,4,2,0.27,1,1),
('wolf',12077,24,830036,343,157,25,37,8,26,61,56,44,125,278,333,1552,12,2,54510,4,2,0.27,1,1),
('wolf',12077,25,977158,364,165,27,38,9,26,62,57,44,125,278,333,1572,13,2,54510,4,2,0.27,1,1),
('wolf',12077,26,1143036,385,174,28,40,9,27,63,58,44,125,278,333,1604,13,2,54510,4,2,0.27,1,1),
('wolf',12077,27,1329198,406,183,30,41,10,28,64,59,44,125,278,333,1616,13,2,54510,4,2,0.27,1,1),
('wolf',12077,28,1537236,429,192,33,42,11,29,65,60,44,125,278,333,1644,13,2,54510,4,2,0.27,1,1),
('wolf',12077,29,1768798,453,201,35,43,12,31,66,61,44,125,278,333,1664,13,2,54510,4,2,0.27,1,1),
('wolf',12077,30,2025596,477,210,38,45,13,31,67,62,44,125,278,333,1684,14,2,54510,4,2,0.27,1,1),
('wolf',12077,31,2309398,502,220,40,46,15,33,68,63,44,125,278,333,2116,17,3,54510,5,2,0.27,1,1),
('wolf',12077,32,2622036,528,229,43,48,17,34,69,64,44,125,278,333,2172,18,3,54510,5,2,0.27,1,1),
('wolf',12077,33,2965398,554,238,46,50,18,35,70,65,44,125,278,333,2236,18,3,54510,5,2,0.27,1,1),
('wolf',12077,34,3341436,582,248,50,51,19,37,71,66,44,125,278,333,2288,19,3,54510,5,2,0.27,1,1),
('wolf',12077,35,3752158,610,257,53,53,22,39,72,67,44,125,278,333,2348,19,3,54510,5,2,0.27,1,1),
('wolf',12077,36,4199636,639,267,57,55,23,40,73,68,44,125,278,333,2408,20,4,54510,5,2,0.27,1,1),
('wolf',12077,37,4685998,669,276,60,56,26,41,74,69,44,125,278,333,2464,20,4,54510,5,2,0.27,1,1),
('wolf',12077,38,5213436,700,286,65,58,27,43,75,70,44,125,278,333,2520,21,4,54510,5,2,0.27,1,1),
('wolf',12077,39,5784198,731,296,69,60,30,44,76,71,44,125,278,333,2580,21,4,54510,5,2,0.27,1,1),
('wolf',12077,40,6400596,763,306,74,61,32,46,77,72,44,125,278,333,2636,21,4,54510,5,2,0.27,2,2),
('wolf',12077,41,7064998,796,323,78,63,34,48,78,73,44,125,278,333,3168,26,5,54510,6,2,0.27,2,2),
('wolf',12077,42,7779836,830,339,83,65,37,50,79,74,44,125,278,333,3236,26,5,54510,6,2,0.27,2,2),
('wolf',12077,43,8547598,864,356,88,67,40,50,80,75,44,125,278,333,3308,27,5,54510,6,2,0.27,2,2),
('wolf',12077,44,9370836,899,373,94,69,42,52,81,76,44,125,278,333,3380,28,5,54510,6,2,0.27,2,2),
('wolf',12077,45,10252158,935,390,99,71,47,54,82,77,44,125,278,333,3452,28,5,54510,6,2,0.27,2,2),
('wolf',12077,46,11194236,971,408,106,72,50,57,83,78,44,125,278,333,3524,29,5,54510,6,2,0.27,2,2),
('wolf',12077,47,12199798,1008,425,112,74,53,59,84,79,44,125,278,333,3592,29,5,54510,6,2,0.27,2,2),
('wolf',12077,48,13271636,1045,443,118,76,57,59,85,80,44,125,278,333,3668,30,6,54510,6,2,0.27,2,2),
('wolf',12077,49,14412598,1084,460,125,78,61,61,86,81,44,125,278,333,3740,31,6,54510,6,2,0.27,2,2),
('wolf',12077,50,15625596,1122,478,133,82,65,64,87,82,44,125,278,333,3596,29,5,54510,6,2,0.27,2,2),
('wolf',12077,51,17557599,1161,496,141,84,69,66,88,83,44,125,278,333,4244,35,7,54510,7,2,0.27,2,2),
('wolf',12077,52,19606656,1201,514,148,86,74,68,89,84,44,125,278,333,4364,36,7,54510,7,2,0.27,2,2),
('wolf',12077,53,21777399,1240,532,156,88,79,70,90,85,44,125,278,333,4484,37,7,54510,7,2,0.27,2,2),
('wolf',12077,54,24074556,1281,551,164,90,84,73,91,86,44,125,278,333,4600,38,7,54510,7,2,0.27,2,2),
('wolf',12077,55,26502939,1321,569,174,92,89,73,92,87,44,125,278,333,4532,37,7,54510,7,2,0.27,2,2),
('wolf',12077,56,29922294,1362,588,182,95,95,76,93,88,44,125,278,333,4672,38,7,54510,7,2,0.27,2,2),
('wolf',12077,57,33529819,1403,606,192,97,100,78,94,89,44,125,278,333,4804,40,8,54510,7,2,0.27,2,2),
('wolf',12077,58,37332294,1444,625,201,99,106,80,95,90,44,125,278,333,4932,41,8,54510,7,2,0.27,2,2),
('wolf',12077,59,41336619,1485,644,211,102,112,83,96,91,44,125,278,333,5060,42,8,54510,7,2,0.27,2,2),
('wolf',12077,60,45549814,1527,663,221,104,119,85,97,92,44,125,278,333,4928,41,8,54510,7,2,0.27,2,2),
('wolf',12077,61,52193622,1568,682,232,108,125,88,98,93,44,125,278,333,5716,47,9,54510,8,3,0.27,2,2),
('wolf',12077,62,59172334,1609,702,242,110,131,90,99,94,44,125,278,333,5892,49,9,54510,8,3,0.27,2,2),
('wolf',12077,63,66497022,1651,721,253,112,139,91,100,95,44,125,278,333,6064,50,10,54510,8,3,0.27,2,2),
('wolf',12077,64,74178934,1692,741,264,114,145,94,101,96,44,125,278,333,6228,51,10,54510,8,3,0.27,2,2),
('wolf',12077,65,82229502,1732,760,275,117,154,96,102,97,44,125,278,333,6176,51,10,54510,8,3,0.27,2,2),
('wolf',12077,66,93470612,1773,780,286,120,162,99,103,98,44,125,278,333,6368,53,10,54510,8,3,0.27,2,2),
('wolf',12077,67,105234462,1813,800,299,123,169,101,104,99,44,125,278,333,6556,54,10,54510,8,3,0.27,2,2),
('wolf',12077,68,117537012,1853,820,310,125,177,104,105,100,44,125,278,333,6740,56,11,54510,8,3,0.27,2,2),
('wolf',12077,69,130394462,1892,840,322,127,185,107,106,101,44,125,278,333,6924,57,11,54510,8,3,0.27,2,2),
('wolf',12077,70,143823252,1931,861,335,130,194,109,108,103,44,125,278,333,7108,59,11,54510,8,3,0.27,2,2),
('wolf',12077,71,157840062,1969,881,347,134,203,112,110,105,44,125,278,333,7388,61,12,54510,8,3,0.27,2,2),
('wolf',12077,72,176117249,2006,902,359,136,210,113,112,107,44,125,278,333,7688,64,12,54510,8,3,0.27,2,2),
('wolf',12077,73,198983024,2043,923,373,139,220,116,114,109,44,125,278,333,7956,66,13,54510,8,3,0.27,2,2),
('wolf',12077,74,226778887,2079,944,385,141,230,118,116,111,44,125,278,333,8196,68,13,54510,8,3,0.27,2,2),
('wolf',12077,75,259859867,2114,964,397,144,238,121,118,113,44,125,278,333,8428,70,14,54510,8,3,0.27,2,2),
('wolf',12077,76,298594764,2148,986,409,146,248,124,120,115,44,125,278,333,8704,72,14,54510,8,3,0.27,2,2),
('wolf',12077,77,352320714,2182,1007,422,151,256,127,122,117,44,125,278,333,8916,74,14,54510,8,3,0.27,2,2),
('wolf',12077,78,412836202,2214,1028,434,153,267,128,126,121,44,125,278,333,9124,76,15,54510,8,3,0.27,2,2),
('wolf',12077,79,480562077,2245,1050,447,156,275,131,128,123,44,125,278,333,9340,77,15,54510,8,3,0.27,2,2),
('wolf',12077,80,555934039,2275,1071,460,158,284,134,130,126,44,125,278,333,9552,79,15,54510,8,3,0.27,2,2),
('wolf',12077,81,639402879,2304,1093,473,161,293,137,133,128,44,125,278,333,9838,79,15,54510,9,4,0.27,2,2),
('wolf',12077,82,786653819,2331,1115,484,164,305,137,135,130,44,125,278,333,10133,81,15,54510,9,4,0.27,2,2),
('wolf',12077,83,940290137,2358,1137,497,166,314,140,137,132,44,125,278,333,10436,83,16,54510,9,4,0.27,2,2),
('wolf',12077,84,1100512609,2383,1159,508,169,324,143,139,135,44,125,278,333,10749,85,16,54510,9,4,0.27,2,2),
('wolf',12077,85,1267526047,2406,1181,519,172,331,146,141,137,44,125,278,333,11071,86,16,54510,9,4,0.27,2,2),
('wolf',12077,86,1441539340,2429,1204,531,175,341,147,144,139,44,125,278,333,11403,88,17,54510,9,4,0.27,2,2);
 
INSERT INTO `pets_stats` VALUES
('great_wolf',16025,55,26502939,3489,512,335,159,216,300,92,87,44,170,278,333,11601,37,7,54510,7,2,0.35,2,2),
('great_wolf',16025,56,33396358,3596,529,351,165,228,309,93,88,44,170,278,333,12253,41,7,54510,7,2,0.35,2,2),
('great_wolf',16025,57,40719633,3705,546,371,169,241,317,94,89,44,170,278,333,12910,44,8,54510,7,2,0.35,2,2),
('great_wolf',16025,58,48491891,3813,562,389,173,256,327,95,90,44,170,278,333,13569,47,8,54510,7,2,0.35,2,2),
('great_wolf',16025,59,56732791,3922,580,408,179,271,335,96,91,44,170,278,333,14228,49,8,54510,7,2,0.35,2,2),
('great_wolf',16025,60,57333856,4031,597,429,183,286,345,97,92,44,170,278,333,14886,51,9,54510,7,2,0.35,2,2),
('great_wolf',16025,61,67877323,4141,614,450,189,302,353,98,93,44,170,278,333,15545,54,9,54510,8,3,0.35,2,2),
('great_wolf',16025,62,79651052,4250,631,471,193,318,363,99,94,44,170,278,333,16207,56,10,54510,8,3,0.35,2,2),
('great_wolf',16025,63,92801759,4358,649,492,199,335,371,100,95,44,170,278,333,16877,58,10,54510,8,3,0.35,2,2),
('great_wolf',16025,64,107445505,4466,667,515,203,353,381,101,96,44,170,278,333,17560,59,10,54510,8,3,0.35,2,2),
('great_wolf',16025,65,127540823,4574,684,537,207,370,390,102,97,44,170,278,333,18262,62,10,54510,8,3,0.35,2,2),
('great_wolf',16025,66,149929849,4681,702,559,213,389,400,103,98,44,170,278,333,18989,64,10,54510,8,3,0.35,2,2),
('great_wolf',16025,67,174840394,4787,720,584,218,408,411,104,99,44,170,278,333,19748,67,11,54510,8,3,0.35,2,2),
('great_wolf',16025,68,202429509,4892,738,608,224,426,420,105,100,44,170,278,333,20543,69,11,54510,8,3,0.35,2,2),
('great_wolf',16025,69,233104057,4995,756,631,229,447,430,106,101,44,170,278,333,21374,73,11,54510,8,3,0.35,2,2),
('great_wolf',16025,70,266966617,5098,775,656,233,467,439,108,103,44,170,278,333,22237,77,12,54510,8,3,0.35,2,2),
('great_wolf',16025,71,311043873,5198,793,681,240,487,450,110,105,44,170,278,333,23127,82,12,54510,9,3,0.35,2,2),
('great_wolf',16025,72,366944678,5297,812,705,244,508,459,112,107,44,170,278,333,24039,86,13,54510,9,3,0.35,2,2),
('great_wolf',16025,73,436722878,5394,830,730,251,530,468,114,109,44,170,278,333,24927,90,13,54510,9,3,0.35,2,2),
('great_wolf',16025,74,522505733,5489,849,755,255,552,479,116,111,44,170,278,333,25784,94,14,54510,9,3,0.35,2,2),
('great_wolf',16025,75,626774887,5582,868,781,260,573,489,118,113,44,170,278,333,26604,98,14,54510,9,3,0.35,2,2),
('great_wolf',16025,76,772136519,5672,887,805,265,596,498,120,115,44,170,278,256,27378,102,14,54510,9,3,0.35,2,2),
('great_wolf',16025,77,944761536,5760,906,830,272,618,509,122,117,44,170,278,333,27812,107,15,54510,9,3,0.35,2,2),
('great_wolf',16025,78,1148089335,5845,925,855,277,640,519,126,121,44,170,278,333,28230,112,15,54510,9,3,0.35,2,2),
('great_wolf',16025,79,1386786292,5928,945,880,282,662,528,128,123,44,170,278,333,28624,117,15,54510,9,3,0.35,2,2),
('great_wolf',16025,80,1664975622,6007,964,906,287,685,538,130,126,44,170,278,333,28987,122,15,54510,9,3,0.35,2,2),
('great_wolf',16025,81,1998969732,6083,965,930,292,709,548,133,128,44,170,278,333,29587,127,16,54510,10,4,0.35,2,2),
('great_wolf',16025,82,2379093816,6156,966,954,297,730,558,135,130,44,170,278,333,30154,132,16,54510,10,4,0.35,2,2),
('great_wolf',16025,83,2831502296,6225,968,978,302,755,568,137,132,44,170,278,333,30764,138,16,54510,10,4,0.35,2,2),
('great_wolf',16025,84,3340379889,6291,969,1002,307,777,577,139,135,44,170,278,333,31428,144,17,54510,10,4,0.35,2,2),
('great_wolf',16025,85,3905839397,6354,970,1025,313,798,587,141,137,44,170,278,333,32158,150,17,54510,10,4,0.35,2,2),
('great_wolf',16025,86,4567019890,6412,1083,1047,318,821,598,144,139,44,170,278,333,32972,156,17,54510,10,4,0.35,2,2);
 
INSERT INTO `pets_stats` VALUES
('great_wolf',16030,70,266966617,2461,1099,225,103,148,69,138,131,40,187,278,333,9234,77,12,54510,2,1,0.35,2,2),
('great_wolf',16030,71,311043873,2550,1145,235,106,154,70,142,135,40,187,278,333,9776,82,12,54510,2,1,0.35,2,2),
('great_wolf',16030,72,366944678,2640,1191,247,109,162,72,146,139,40,187,278,333,10290,86,13,54510,2,1,0.35,2,2),
('great_wolf',16030,73,436722878,2733,1239,258,112,170,75,150,143,40,187,278,333,10779,90,13,54510,2,1,0.35,2,2),
('great_wolf',16030,74,522505733,2827,1287,269,115,177,78,154,147,40,187,278,333,11269,94,14,54510,2,1,0.35,2,2),
('great_wolf',16030,75,626774887,2921,1339,280,118,185,81,158,151,40,187,278,333,11839,98,14,54510,2,1,0.35,2,2),
('great_wolf',16030,76,772136519,3018,1390,292,123,192,84,162,155,40,187,278,333,12329,102,14,54510,2,1,0.35,2,2),
('great_wolf',16030,77,944761536,3115,1443,304,126,201,85,166,159,40,187,278,333,12827,107,15,54510,2,1,0.35,2,2),
('great_wolf',16030,78,1148089335,3212,1498,316,130,209,88,170,163,40,187,278,333,13345,112,15,54510,2,1,0.35,2,2),
('great_wolf',16030,79,1386786292,3309,1554,329,134,217,91,174,167,40,187,278,333,13884,117,15,54510,2,1,0.35,2,2),
('great_wolf',16030,80,1664975622,3409,1612,342,138,225,94,179,171,40,187,278,333,14431,122,15,54510,2,1,0.35,2,2),
('great_wolf',16030,81,1998969732,3509,1672,355,142,233,97,184,175,40,187,278,333,14999,127,16,54510,2,1,0.35,2,2),
('great_wolf',16030,82,2379093816,3611,1733,369,146,241,100,189,180,40,187,278,333,15590,132,16,54510,2,1,0.35,2,2),
('great_wolf',16030,83,2831502296,3716,1796,383,150,250,103,194,185,40,187,278,333,16188,138,16,54510,2,1,0.35,2,2),
('great_wolf',16030,84,3340379889,3821,1861,398,154,259,106,199,190,40,187,278,333,16809,144,17,54510,2,1,0.35,2,2),
('great_wolf',16030,85,3905839397,3929,1927,413,158,268,109,204,195,40,187,278,333,17454,150,17,54510,2,1,0.35,2,2),
('great_wolf',16030,86,4567019890,4040,1995,428,162,277,112,209,200,40,187,278,333,18123,156,17,54510,2,1,0.35,2,2);
 
INSERT INTO `pets_stats` VALUES
('great_snow_wolf',16037,55,26502939,1321,569,101,64,66,40,92,87,40,187,278,333,4532,37,7,54510,7,2,0.35,2,2),
('great_snow_wolf',16037,56,31017026,1384,597,108,66,70,42,95,89,40,187,278,333,4738,40,8,54510,7,2,0.35,2,2),
('great_snow_wolf',16037,57,36040916,1448,626,114,68,74,44,98,92,40,187,278,333,4949,42,8,54510,7,2,0.35,2,2),
('great_snow_wolf',16037,58,41652775,1514,656,121,70,78,46,101,95,40,187,278,333,5164,44,8,54510,7,2,0.35,2,2),
('great_snow_wolf',16037,59,47921018,1583,687,128,72,83,48,104,98,40,187,278,333,5115,44,8,54510,7,2,0.35,2,2),
('great_snow_wolf',16037,60,57333856,1653,719,135,75,88,50,107,101,40,187,278,333,6034,51,9,54510,7,2,0.35,2,2),
('great_snow_wolf',16037,61,67877323,1725,752,143,77,93,52,110,104,40,187,278,333,6327,54,9,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,62,79651052,1800,785,151,79,99,53,113,107,40,187,278,333,6621,56,10,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,63,92801759,1876,821,159,81,104,55,116,110,40,187,278,333,6915,58,10,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,64,107445505,1954,857,167,83,110,57,119,113,40,187,278,333,6976,59,10,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,65,127540823,2035,894,176,87,116,59,122,116,40,187,278,333,7315,62,10,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,66,149929849,2117,933,186,90,121,61,125,119,40,187,278,333,7663,64,10,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,67,174840394,2200,973,195,93,128,63,128,122,40,187,278,333,8011,67,11,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,68,202429509,2284,1013,204,96,134,65,131,125,40,187,278,333,8367,69,11,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,69,233104057,2372,1056,215,99,141,67,134,128,40,187,278,333,8739,73,11,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,70,266966617,2461,1099,225,103,148,69,138,131,40,187,278,333,9234,77,12,54510,8,3,0.35,2,2),
('great_snow_wolf',16037,71,311043873,2550,1145,235,106,154,70,142,135,40,187,278,333,9776,82,12,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,72,366944678,2640,1191,247,109,162,72,146,139,40,187,278,333,10290,86,13,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,73,436722878,2733,1239,258,112,170,75,150,143,40,187,278,333,10779,90,13,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,74,522505733,2827,1287,269,115,177,78,154,147,40,187,278,333,11269,94,14,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,75,626774887,2921,1339,280,118,185,81,158,151,40,187,278,333,11839,98,14,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,76,772136519,3018,1390,292,123,192,84,162,155,40,187,278,333,12329,102,14,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,77,944761536,3115,1443,304,126,201,85,166,159,40,187,278,333,12827,107,15,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,78,1148089335,3212,1498,316,130,209,88,170,163,40,187,278,333,13345,112,15,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,79,1386786292,3309,1554,329,134,217,91,174,167,40,187,278,333,13884,117,15,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,80,1664975622,3409,1612,342,138,225,94,179,171,40,187,278,333,14431,122,15,54510,9,3,0.35,2,2),
('great_snow_wolf',16037,81,1998969732,3509,1672,355,142,233,97,184,175,40,187,278,333,14999,127,16,54510,10,4,0.35,2,2),
('great_snow_wolf',16037,82,2379093816,3611,1733,369,146,241,100,189,180,40,187,278,333,15590,132,16,54510,10,4,0.35,2,2),
('great_snow_wolf',16037,83,2831502296,3716,1796,383,150,250,103,194,185,40,187,278,333,16188,138,16,54510,10,4,0.35,2,2),
('great_snow_wolf',16037,84,3340379889,3821,1861,398,154,259,106,199,190,40,187,278,333,16809,144,17,54510,10,4,0.35,2,2),
('great_snow_wolf',16037,85,3905839397,3929,1927,413,158,268,109,204,195,40,187,278,333,17454,150,17,54510,10,4,0.35,2,2),
('great_snow_wolf',16037,86,4567019890,4040,1995,428,162,277,112,209,200,40,187,278,333,18123,156,17,54510,10,4,0.35,2,2);
 
INSERT INTO `pets_stats` VALUES
('fenrir',16041,70,266966617,5098,775,656,233,467,439,108,103,44,187,278,333,22237,77,12,54510,9,3,0.35,2,2),
('fenrir',16041,71,311043873,5198,793,681,240,487,450,110,105,44,187,278,333,23127,82,12,54510,9,3,0.35,2,2),
('fenrir',16041,72,366944678,5297,812,705,244,508,459,112,107,44,187,278,333,24039,86,13,54510,9,3,0.35,2,2),
('fenrir',16041,73,436722878,5394,830,730,251,530,468,114,109,44,187,278,333,24927,90,13,54510,9,3,0.35,2,2),
('fenrir',16041,74,522505733,5489,849,755,255,552,479,116,111,44,187,278,333,25784,94,14,54510,9,3,0.35,2,2),
('fenrir',16041,75,626774887,5582,868,781,260,573,489,118,113,44,187,278,333,26604,98,14,54510,9,3,0.35,2,2),
('fenrir',16041,76,772136519,5672,887,805,265,596,498,120,115,44,187,278,333,27378,102,14,54510,9,3,0.35,2,2),
('fenrir',16041,77,944761536,5760,906,830,272,618,509,122,117,44,187,278,333,27812,107,15,54510,9,3,0.35,2,2),
('fenrir',16041,78,1148089335,5845,925,855,277,640,519,126,121,44,187,278,333,28230,112,15,54510,9,3,0.35,2,2),
('fenrir',16041,79,1386786292,5928,945,880,282,662,528,128,123,44,187,278,333,28624,117,15,54510,9,3,0.35,2,2),
('fenrir',16041,80,1664975622,6007,964,906,287,685,538,130,126,44,187,278,333,28987,122,15,54510,9,3,0.35,2,2),
('fenrir',16041,81,1998969732,6083,965,930,292,709,548,133,128,44,187,278,333,29587,127,16,54510,10,4,0.35,2,2),
('fenrir',16041,82,2379093816,6156,966,954,297,730,558,135,130,44,187,278,333,30154,132,16,54510,10,4,0.35,2,2),
('fenrir',16041,83,2831502296,6225,968,978,302,755,568,137,132,44,187,278,333,30764,138,16,54510,10,4,0.35,2,2),
('fenrir',16041,84,3340379889,6291,969,1002,307,777,577,139,135,44,187,278,333,31428,144,17,54510,10,4,0.35,2,2),
('fenrir',16041,85,3905839397,6354,970,1025,313,798,587,141,137,44,187,278,333,32158,150,17,54510,10,4,0.35,2,2),
('fenrir',16041,86,4567019890,6412,1083,1047,318,821,598,144,139,44,187,278,333,33000,156,17,54510,10,4,0.35,2,2),
('snow_fenrir',16042,70,266966617,2461,1099,225,103,148,69,138,131,40,187,278,333,9234,77,12,54510,9,3,0.35,2,2),
('snow_fenrir',16042,71,311043873,2550,1145,235,106,154,70,142,135,40,187,278,333,9776,82,12,54510,9,3,0.35,2,2),
('snow_fenrir',16042,72,366944678,2640,1191,247,109,162,72,146,139,40,187,278,333,10290,86,13,54510,9,3,0.35,2,2),
('snow_fenrir',16042,73,436722878,2733,1239,258,112,170,75,150,143,40,187,278,333,10779,90,13,54510,9,3,0.35,2,2),
('snow_fenrir',16042,74,522505733,2827,1287,269,115,177,78,154,147,40,187,278,333,11269,94,14,54510,9,3,0.35,2,2),
('snow_fenrir',16042,75,626774887,2921,1339,280,118,185,81,158,151,40,187,278,333,11839,98,14,54510,9,3,0.35,2,2),
('snow_fenrir',16042,76,772136519,3018,1390,292,123,192,84,162,155,40,187,278,333,12329,102,14,54510,9,3,0.35,2,2),
('snow_fenrir',16042,77,944761536,3115,1443,304,126,201,85,166,159,40,187,278,333,12827,107,15,54510,9,3,0.35,2,2),
('snow_fenrir',16042,78,1148089335,3212,1498,316,130,209,88,170,163,40,187,278,333,13345,112,15,54510,9,3,0.35,2,2),
('snow_fenrir',16042,79,1386786292,3309,1554,329,134,217,91,174,167,40,187,278,333,13884,117,15,54510,9,3,0.35,2,2),
('snow_fenrir',16042,80,1664975622,3409,1612,342,138,225,94,179,171,40,187,278,333,14431,122,15,54510,9,3,0.35,2,2),
('snow_fenrir',16042,81,1998969732,3509,1672,355,142,233,97,184,175,40,187,278,333,14999,127,16,54510,10,4,0.35,2,2),
('snow_fenrir',16042,82,2379093816,3611,1733,369,146,241,100,189,180,40,187,278,333,15590,132,16,54510,10,4,0.35,2,2),
('snow_fenrir',16042,83,2831502296,3716,1796,383,150,250,103,194,185,40,187,278,333,16188,138,16,54510,10,4,0.35,2,2),
('snow_fenrir',16042,84,3340379889,3821,1861,398,154,259,106,199,190,40,187,278,333,16809,144,17,54510,10,4,0.35,2,2),
('snow_fenrir',16042,85,3905839397,3929,1927,413,158,268,109,204,195,40,187,278,333,17454,150,17,54510,10,4,0.35,2,2),
('snow_fenrir',16042,86,4567019890,4040,1995,428,162,277,112,209,200,40,187,278,333,18123,156,17,54510,10,4,0.35,2,2);

INSERT INTO `pets_stats` VALUES
('hatchling_of_wind',12311,1,0,31,51,2,44,0,32,38,33,40,154,282,333,696,5,2,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,2,7,37,60,2,46,0,33,39,34,40,154,282,333,676,5,2,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,3,42,45,69,2,47,0,35,40,35,40,154,282,333,892,7,2,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,4,140,53,79,2,49,0,36,41,36,40,154,282,333,1112,9,2,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,5,357,63,89,3,51,0,37,42,37,40,154,282,333,1428,11,2,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,6,769,73,98,3,53,0,39,43,38,40,154,282,333,1740,14,2,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,7,1481,85,108,3,55,0,40,44,39,40,154,282,333,1944,16,3,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,8,2629,98,118,4,57,1,42,45,40,40,154,282,333,2228,18,3,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,9,4388,113,128,4,59,1,43,46,41,40,154,282,333,2392,19,3,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,10,6980,128,138,4,61,1,45,47,42,40,154,282,333,2584,21,4,54510,2,1,0.10,1,1),
('hatchling_of_wind',12311,11,10682,146,148,5,64,1,46,48,43,40,154,282,333,2840,23,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,12,15295,157,159,5,66,1,48,49,44,40,154,282,333,2824,23,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,13,21417,169,169,6,68,1,50,50,45,40,154,282,333,2788,23,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,14,29393,182,180,6,71,1,52,51,46,40,154,282,333,2772,23,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,15,39618,195,190,7,73,1,53,52,47,40,154,282,333,2760,23,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,16,51729,208,201,8,76,2,55,53,48,40,154,282,333,2716,22,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,17,67878,223,212,8,78,2,57,54,49,40,154,282,333,2700,22,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,18,87835,238,223,9,81,2,59,55,50,40,154,282,333,2664,22,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,19,112262,254,234,10,84,2,61,56,51,40,154,282,333,2636,21,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,20,141904,270,245,11,86,2,63,57,52,40,154,282,333,2620,21,4,54510,3,1,0.10,1,1),
('hatchling_of_wind',12311,21,177595,287,262,11,89,3,65,58,53,40,154,282,333,3040,25,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,22,212623,305,279,12,92,3,67,59,54,40,154,282,333,3112,25,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,23,409075,324,296,13,95,3,69,60,55,40,154,282,333,3004,25,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,24,501816,343,314,15,98,3,72,61,56,40,154,282,333,3208,26,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,25,605973,364,331,16,101,4,74,62,57,40,154,282,333,3256,27,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,26,722379,385,349,17,105,4,76,63,58,40,154,282,333,3312,27,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,27,851883,406,367,18,108,4,79,64,59,40,154,282,333,3344,27,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,28,995357,429,385,20,111,5,81,65,60,40,154,282,333,3396,28,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,29,1153690,453,403,21,115,5,84,66,61,40,154,282,333,3432,28,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,30,1327790,477,421,23,118,6,86,67,62,40,154,282,333,3472,28,5,54510,4,2,0.10,1,1),
('hatchling_of_wind',12311,31,1518582,502,440,24,121,6,89,68,63,40,154,282,333,3992,33,6,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,32,1727007,528,458,26,125,6,91,69,64,40,154,282,333,4100,34,6,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,33,1954023,554,477,28,129,7,94,70,65,40,154,282,333,4224,35,7,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,34,2200605,582,496,30,132,7,97,71,66,40,154,282,333,4324,36,7,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,35,2467742,610,515,32,136,8,100,72,67,40,154,282,333,4436,36,7,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,36,2756437,639,534,34,140,9,102,73,68,40,154,282,333,4548,37,7,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,37,3067709,669,553,36,144,9,105,74,69,40,154,282,333,4652,38,7,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,38,3402590,700,573,39,148,10,108,75,70,40,154,282,333,4752,39,7,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,39,3762126,731,593,41,152,10,111,76,71,40,154,282,333,4860,40,8,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,40,4147374,763,612,44,156,11,114,77,72,40,154,282,333,4952,41,8,54510,5,2,0.10,1,1),
('hatchling_of_wind',12311,41,4559407,796,646,46,160,12,117,78,73,40,154,282,333,5584,46,9,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,42,4999307,830,679,49,164,12,120,79,74,40,154,282,333,5700,47,9,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,43,5468169,864,713,52,169,13,123,80,75,40,154,282,333,5828,48,9,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,44,5967101,899,747,55,173,14,126,81,76,40,154,282,333,5944,49,9,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,45,6497220,935,781,58,177,15,130,82,77,40,154,282,333,6068,50,10,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,46,7059654,971,816,62,182,16,133,83,78,40,154,282,333,6184,51,10,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,47,7655543,1008,851,65,186,17,136,84,79,40,154,282,333,6292,52,10,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,48,8286036,1045,886,68,191,18,139,85,80,40,154,282,333,6408,53,10,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,49,8952291,1084,921,72,195,19,143,86,81,40,154,282,333,6520,54,10,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,50,9655478,1122,957,76,200,19,146,87,82,40,154,282,333,6636,55,11,54510,6,2,0.10,1,1),
('hatchling_of_wind',12311,51,10767423,1161,993,80,204,21,149,88,83,40,154,282,333,7380,61,12,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,52,11938312,1201,1029,84,209,22,153,89,84,40,154,282,333,7512,62,12,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,53,13169940,1240,1065,88,214,23,156,90,85,40,154,282,333,7648,63,12,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,54,14464112,1281,1102,92,218,24,160,91,86,40,154,282,333,7788,64,12,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,55,15822648,1321,1138,97,223,25,163,92,87,40,154,282,333,7920,66,13,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,56,17722290,1362,1176,101,228,26,167,93,88,40,154,282,333,8056,67,13,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,57,19712649,1403,1213,106,233,27,170,94,89,40,154,282,333,8196,68,13,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,58,21796197,1444,1251,110,237,28,174,95,90,40,154,282,333,8328,69,13,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,59,23975421,1485,1288,115,242,30,177,96,91,40,154,282,333,8464,70,14,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,60,26252824,1527,1327,120,247,31,181,97,92,40,154,282,333,8600,71,14,54510,7,2,0.10,1,1),
('hatchling_of_wind',12311,61,29819969,1568,1365,125,252,32,184,98,93,40,154,282,333,9468,78,15,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,62,33541949,1609,1404,130,257,34,188,99,94,40,154,282,333,9632,80,16,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,63,37422578,1651,1443,135,262,35,191,100,95,40,154,282,333,9796,81,16,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,64,41465690,1692,1482,140,267,36,195,101,96,40,154,282,333,9964,83,16,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,65,45675137,1732,1521,145,271,38,198,102,97,40,154,282,333,10136,84,16,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,66,51514675,1773,1561,150,276,39,202,103,98,40,154,282,333,10308,85,17,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,67,57586339,1813,1601,156,281,40,206,104,99,40,154,282,333,10480,87,17,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,68,63895339,1853,1641,161,286,42,209,105,100,40,154,282,333,10656,88,17,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,69,70446906,1892,1681,166,291,43,213,106,101,40,154,282,333,10832,90,18,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,70,77246293,1931,1722,172,295,45,216,107,102,40,154,282,333,11024,91,18,54510,8,3,0.10,1,1),
('hatchling_of_wind',12311,71,84298776,1969,1763,177,300,46,220,108,103,40,154,282,333,10864,90,18,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,72,93437370,2006,1804,182,305,47,223,109,104,40,154,282,333,11048,92,18,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,73,104799246,2043,1846,188,310,49,226,110,105,40,154,282,333,11240,93,18,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,74,118525598,2079,1888,193,314,50,230,111,106,40,154,282,333,11428,95,19,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,75,134761662,2114,1929,198,319,52,233,112,107,40,154,282,333,11628,96,19,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,76,153656733,2148,1972,203,323,53,236,113,108,40,154,282,333,11824,98,19,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,77,179705679,2182,2014,208,328,54,240,114,109,40,154,282,333,12028,100,20,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,78,208869769,2214,2057,213,332,56,243,115,110,40,154,282,333,12236,101,20,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,79,241313302,2245,2100,218,337,57,246,116,111,40,154,282,333,12448,103,20,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,80,277204713,2275,2143,223,341,58,249,117,112,40,154,282,333,12664,105,21,54510,9,3,0.10,1,1),
('hatchling_of_wind',12311,81,316716590,2304,2187,228,345,59,252,118,113,40,154,282,333,12664,105,21,54510,10,4,0.10,1,1),
('hatchling_of_wind',12311,82,325507841,2347,2228,233,350,60,255,119,114,40,154,282,333,12943,107,21,54510,10,4,0.10,1,1),
('hatchling_of_wind',12311,83,352041558,2381,2271,238,354,62,258,120,115,40,154,282,333,13123,109,22,54510,10,4,0.10,1,1),
('hatchling_of_wind',12311,84,378575276,2415,2313,243,359,63,262,121,116,40,154,282,333,13304,110,22,54510,10,4,0.10,1,1),
('hatchling_of_wind',12311,85,405108993,2449,2356,248,363,64,265,122,117,40,154,282,333,13484,112,23,54510,10,4,0.10,1,1),
('hatchling_of_wind',12311,86,431642710,2483,2399,253,367,65,268,123,118,40,154,282,333,13665,113,23,54510,10,4,0.10,1,1),
('hatchling_of_star',12312,1,0,31,51,1,44,2,32,38,33,40,154,282,333,508,5,2,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,2,7,37,60,1,46,3,33,39,34,40,154,282,333,492,5,2,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,3,42,45,69,1,47,3,35,40,35,40,154,282,333,608,7,2,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,4,140,53,79,1,49,3,36,41,36,40,154,282,333,756,9,2,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,5,357,63,89,1,51,4,37,42,37,40,154,282,333,932,11,2,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,6,769,73,98,1,53,4,39,43,38,40,154,282,333,1124,14,2,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,7,1481,85,108,1,55,4,40,44,39,40,154,282,333,1200,16,3,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,8,2629,98,118,1,57,5,42,45,40,40,154,282,333,1336,18,3,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,9,4388,113,128,1,59,5,43,46,41,40,154,282,333,1432,19,3,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,10,6980,128,138,1,61,6,45,47,42,40,154,282,333,1492,21,4,54510,2,1,0.10,1,1),
('hatchling_of_star',12312,11,10682,146,148,1,64,6,46,48,43,40,154,282,333,1784,23,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,12,15295,157,159,1,66,7,48,49,44,40,154,282,333,1796,23,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,13,21417,169,169,1,68,8,50,50,45,40,154,282,333,1724,23,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,14,29393,182,180,1,71,8,52,51,46,40,154,282,333,1664,23,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,15,39618,195,190,1,73,9,53,52,47,40,154,282,333,1608,23,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,16,51729,208,201,1,76,10,55,53,48,40,154,282,333,1548,22,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,17,67878,223,212,1,78,11,57,54,49,40,154,282,333,1512,22,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,18,87835,238,223,1,81,12,59,55,50,40,154,282,333,1464,22,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,19,112262,254,234,1,84,13,61,56,51,40,154,282,333,1456,21,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,20,141904,270,245,1,86,14,63,57,52,40,154,282,333,1460,21,4,54510,3,1,0.10,1,1),
('hatchling_of_star',12312,21,177595,287,262,1,89,15,65,58,53,40,154,282,333,1908,25,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,22,212623,305,279,1,92,16,67,59,54,40,154,282,333,1912,25,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,23,350264,324,296,1,95,18,69,60,55,40,154,282,333,1804,25,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,24,466190,343,314,1,98,19,72,61,56,40,154,282,333,1900,26,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,25,596387,364,331,1,101,21,74,62,57,40,154,282,333,1896,27,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,26,741894,385,349,1,105,22,76,63,58,40,154,282,333,1896,27,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,27,903774,406,367,1,108,24,79,64,59,40,154,282,333,1844,27,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,28,1083117,429,385,1,111,26,81,65,60,40,154,282,333,1856,28,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,29,1281033,453,403,1,115,28,84,66,61,40,154,282,333,1848,28,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,30,1498658,477,421,1,118,30,86,67,62,40,154,282,333,1880,28,5,54510,4,2,0.10,1,1),
('hatchling_of_star',12312,31,1737148,502,440,1,121,32,89,68,63,40,154,282,333,2384,33,6,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,32,1997679,528,458,1,125,34,91,69,64,40,154,282,333,2376,34,6,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,33,2281450,554,477,2,129,37,94,70,65,40,154,282,333,2416,35,7,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,34,2589677,582,496,2,132,39,97,71,66,40,154,282,333,2452,36,7,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,35,2923598,610,515,3,136,42,100,72,67,40,154,282,333,2488,36,7,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,36,3284467,639,534,3,140,45,102,73,68,40,154,282,333,2524,37,7,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,37,3673557,669,553,4,144,48,105,74,69,40,154,282,333,2516,38,7,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,38,4092158,700,573,5,148,51,108,75,70,40,154,282,333,2548,39,7,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,39,4541577,731,593,5,152,54,111,76,71,40,154,282,333,2584,40,8,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,40,5023138,763,612,6,156,57,114,77,72,40,154,282,333,2576,41,8,54510,5,2,0.10,1,1),
('hatchling_of_star',12312,41,5538179,796,646,7,160,61,117,78,73,40,154,282,333,3156,46,9,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,42,6088054,830,679,8,164,64,120,79,74,40,154,282,333,3200,47,9,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,43,6674132,864,713,8,169,68,123,80,75,40,154,282,333,3244,48,9,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,44,7297797,899,747,9,173,72,126,81,76,40,154,282,333,3244,49,9,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,45,7960445,935,781,10,177,76,130,82,77,40,154,282,333,3292,50,10,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,46,8663488,971,816,11,182,81,133,83,78,40,154,282,333,3332,51,10,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,47,9408349,1008,851,12,186,85,136,84,79,40,154,282,333,3328,52,10,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,48,10196465,1045,886,13,191,90,139,85,80,40,154,282,333,3368,53,10,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,49,11029284,1084,921,14,195,95,143,86,81,40,154,282,333,3376,54,10,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,50,11908268,1122,957,15,200,99,146,87,82,40,154,282,333,3416,55,11,54510,6,2,0.10,1,1),
('hatchling_of_star',12312,51,13298199,1161,993,16,204,105,149,88,83,40,154,282,333,4084,61,12,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,52,14761810,1201,1029,17,209,110,153,89,84,40,154,282,333,4132,62,12,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,53,16301345,1240,1065,19,214,113,156,90,85,40,154,282,333,4148,63,12,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,54,17919061,1281,1102,20,218,116,160,91,86,40,154,282,333,4200,64,12,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,55,19617231,1321,1138,21,223,119,163,92,87,40,154,282,333,4208,66,13,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,56,21991783,1362,1176,22,228,121,167,93,88,40,154,282,333,4264,67,13,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,57,24479731,1403,1213,24,233,124,170,94,89,40,154,282,333,4316,68,13,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,58,27084166,1444,1251,25,237,130,174,95,90,40,154,282,333,4328,69,13,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,59,29808197,1485,1288,26,242,136,177,96,91,40,154,282,333,4384,70,14,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,60,32654950,1527,1327,28,247,141,181,97,92,40,154,282,333,4392,71,14,54510,7,2,0.10,1,1),
('hatchling_of_star',12312,61,37113882,1568,1365,29,252,147,184,98,93,40,154,282,333,5164,78,15,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,62,41766357,1609,1404,30,257,153,188,99,94,40,154,282,333,5232,80,16,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,63,46617143,1651,1443,32,262,159,191,100,95,40,154,282,333,5300,81,16,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,64,51671033,1692,1482,33,267,165,195,101,96,40,154,282,333,5328,83,16,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,65,56932842,1732,1521,35,271,171,198,102,97,40,154,282,333,5400,84,16,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,66,64232264,1773,1561,36,276,177,202,103,98,40,154,282,333,5472,85,17,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,67,71821844,1813,1601,38,281,184,206,104,99,40,154,282,333,5544,87,17,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,68,79708094,1853,1641,39,286,190,209,105,100,40,154,282,333,5576,88,17,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,69,87897553,1892,1681,41,291,196,213,106,101,40,154,282,333,5648,90,18,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,70,96396787,1931,1722,42,295,202,216,107,102,40,154,282,333,5728,91,18,54510,8,3,0.10,1,1),
('hatchling_of_star',12312,71,105212391,1969,1763,44,300,209,220,108,103,40,154,282,333,5948,90,18,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,72,116635633,2006,1804,45,305,215,223,109,104,40,154,282,333,6028,92,18,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,73,130837978,2043,1846,47,310,221,226,110,105,40,154,282,333,6116,93,18,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,74,147995918,2079,1888,48,314,227,230,111,106,40,154,282,333,6200,95,19,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,75,168290997,2114,1929,50,319,234,233,112,107,40,154,282,333,6288,96,19,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,76,191909837,2148,1972,51,323,240,236,113,108,40,154,282,333,6376,98,19,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,77,224471019,2182,2014,53,328,246,240,114,109,40,154,282,333,6468,100,20,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,78,260926132,2214,2057,54,332,252,243,115,110,40,154,282,333,6556,101,20,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,79,301480548,2245,2100,56,337,257,246,116,111,40,154,282,333,6656,103,20,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,80,346344812,2275,2143,57,341,263,249,117,112,40,154,282,333,6748,105,21,54510,9,3,0.10,1,1),
('hatchling_of_star',12312,81,395734658,2304,2187,59,345,268,252,118,113,40,154,282,333,6748,105,21,54510,10,4,0.10,1,1),
('hatchling_of_star',12312,82,414801785,2340,2229,60,350,275,255,119,114,40,154,282,333,6883,107,21,54510,10,4,0.10,1,1),
('hatchling_of_star',12312,83,450392350,2372,2271,62,354,280,259,120,115,40,154,282,333,6968,109,22,54510,10,4,0.10,1,1),
('hatchling_of_star',12312,84,485982916,2404,2314,63,359,286,262,121,116,40,154,282,333,7052,111,22,54510,10,4,0.10,1,1),
('hatchling_of_star',12312,85,521573481,2436,2357,65,363,292,265,122,117,40,154,282,333,7136,112,22,54510,10,4,0.10,1,1),
('hatchling_of_star',12312,86,557164047,2469,2400,66,368,298,268,123,118,40,154,282,333,7220,114,23,54510,10,4,0.10,1,1),
('hatchling_of_twilight',12313,1,0,31,51,0,0,0,8,38,33,40,154,282,333,12,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,2,7,37,60,0,0,0,8,39,34,40,154,282,333,8,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,3,42,45,69,0,0,0,8,40,35,40,154,282,333,12,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,4,140,53,79,0,0,0,9,41,36,40,154,282,333,20,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,5,357,63,89,0,0,0,9,42,37,40,154,282,333,24,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,6,769,73,98,0,0,0,9,43,38,40,154,282,333,32,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,7,1481,85,108,0,0,0,10,44,39,40,154,282,333,36,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,8,2629,98,118,0,0,0,10,45,40,40,154,282,333,44,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,9,4388,113,128,0,0,0,10,46,41,40,154,282,333,48,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,10,6980,128,138,0,0,1,11,47,42,40,154,282,333,56,1,1,54510,2,1,0.10,1,1),
('hatchling_of_twilight',12313,11,10682,146,148,0,0,1,11,48,43,40,154,282,333,60,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,12,15295,157,159,0,0,1,12,49,44,40,154,282,333,64,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,13,21417,169,169,0,0,1,12,50,45,40,154,282,333,64,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,14,29393,182,180,0,0,1,13,51,46,40,154,282,333,64,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,15,39618,195,190,0,1,1,13,52,47,40,154,282,333,64,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,16,51729,208,201,0,1,1,13,53,48,40,154,282,333,64,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,17,67878,223,212,0,1,1,14,54,49,40,154,282,333,64,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,18,87835,238,223,0,2,2,14,55,50,40,154,282,333,68,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,19,112262,254,234,0,2,2,15,56,51,40,154,282,333,68,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,20,141904,270,245,0,2,2,15,57,52,40,154,282,333,68,1,1,54510,3,1,0.10,1,1),
('hatchling_of_twilight',12313,21,177595,287,262,0,3,2,16,58,53,40,154,282,333,76,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,22,212623,305,279,0,3,2,16,59,54,40,154,282,333,80,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,23,254072,324,296,0,3,3,17,60,55,40,154,282,333,76,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,24,302838,343,314,0,4,3,18,61,56,40,154,282,333,84,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,25,359907,364,331,0,4,3,18,62,57,40,154,282,333,88,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,26,426364,385,349,0,5,3,19,63,58,40,154,282,333,92,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,27,503400,406,367,0,5,4,19,64,59,40,154,282,333,92,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,28,592316,429,385,0,5,4,20,65,60,40,154,282,333,96,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,29,694532,453,403,0,6,4,21,66,61,40,154,282,333,100,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,30,811593,477,421,0,6,5,21,67,62,40,154,282,333,104,1,1,54510,4,2,0.10,1,1),
('hatchling_of_twilight',12313,31,945176,502,440,0,7,5,22,68,63,40,154,282,333,112,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,32,1074521,528,458,0,7,5,22,69,64,40,154,282,333,116,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,33,1220860,554,477,1,8,6,23,70,65,40,154,282,333,124,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,34,1385938,582,496,1,8,6,24,71,66,40,154,282,333,128,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,35,1571632,610,515,1,9,6,25,72,67,40,154,282,333,136,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,36,1625762,639,534,1,9,7,25,73,68,40,154,282,333,144,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,37,1684126,669,553,2,10,7,26,74,69,40,154,282,333,148,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,38,1746916,700,573,2,10,8,27,75,70,40,154,282,333,156,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,39,1814329,731,593,2,11,8,27,76,71,40,154,282,333,164,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,40,1886563,763,612,3,11,9,28,77,72,40,154,282,333,172,1,1,54510,5,2,0.10,1,1),
('hatchling_of_twilight',12313,41,1963819,796,646,3,12,10,29,78,73,40,154,282,333,180,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,42,2046300,830,679,4,12,10,30,79,74,40,154,282,333,188,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,43,2134212,864,713,4,13,11,30,80,75,40,154,282,333,196,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,44,2227762,899,747,4,13,12,31,81,76,40,154,282,333,204,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,45,2327159,935,781,5,14,12,32,82,77,40,154,282,333,212,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,46,2432616,971,816,5,14,13,33,83,78,40,154,282,333,220,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,47,2544345,1008,851,6,15,14,34,84,79,40,154,282,333,228,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,48,2662562,1045,886,6,15,14,34,85,80,40,154,282,333,236,1,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,49,2787485,1084,921,7,16,15,35,86,81,40,154,282,333,248,2,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,50,2919333,1122,957,7,17,16,36,87,82,40,154,282,333,256,2,1,54510,6,2,0.10,1,1),
('hatchling_of_twilight',12313,51,3127822,1161,993,8,17,17,37,88,83,40,154,282,333,264,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,52,3347364,1201,1029,8,18,18,38,89,84,40,154,282,333,276,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,53,3578294,1240,1065,9,18,19,39,90,85,40,154,282,333,284,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,54,3820951,1281,1102,10,19,20,40,91,86,40,154,282,333,296,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,55,4075677,1321,1138,10,19,20,40,92,87,40,154,282,333,308,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,56,4431860,1362,1176,11,20,21,41,93,88,40,154,282,333,316,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,57,4805052,1403,1213,12,21,22,42,94,89,40,154,282,333,328,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,58,5195717,1444,1251,12,21,23,43,95,90,40,154,282,333,340,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,59,5604322,1485,1288,13,22,24,44,96,91,40,154,282,333,352,2,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,60,6031335,1527,1327,14,22,26,45,97,92,40,154,282,333,364,3,1,54510,7,2,0.10,1,1),
('hatchling_of_twilight',12313,61,6700175,1568,1365,14,23,27,46,98,93,40,154,282,333,372,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,62,7398046,1609,1404,15,24,28,47,99,94,40,154,282,333,388,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,63,8125664,1651,1443,16,24,29,47,100,95,40,154,282,333,400,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,64,8883747,1692,1482,16,25,30,48,101,96,40,154,282,333,412,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,65,9673019,1732,1521,17,25,31,49,102,97,40,154,282,333,424,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,66,10767932,1773,1561,18,26,32,50,103,98,40,154,282,333,440,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,67,11906369,1813,1601,19,27,33,51,104,99,40,154,282,333,452,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,68,13089306,1853,1641,19,27,34,52,105,100,40,154,282,333,468,3,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,69,14317725,1892,1681,20,28,36,53,106,101,40,154,282,333,480,4,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,70,15592610,1931,1722,21,28,37,54,107,102,40,154,282,333,496,4,1,54510,8,3,0.10,1,1),
('hatchling_of_twilight',12313,71,16914951,1969,1763,22,29,38,55,108,103,40,154,282,333,456,3,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,72,18628437,2006,1804,22,30,39,55,109,104,40,154,282,333,468,3,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,73,20758789,2043,1846,23,30,40,56,110,105,40,154,282,333,484,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,74,23332480,2079,1888,24,31,41,57,111,106,40,154,282,333,496,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,75,26376742,2114,1929,25,31,42,58,112,107,40,154,282,333,512,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,76,29919568,2148,1972,25,32,44,59,113,108,40,154,282,333,524,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,77,34803745,2182,2014,26,33,45,60,114,109,40,154,282,333,540,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,78,40272012,2214,2057,27,33,46,60,115,110,40,154,282,333,552,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,79,46355175,2245,2100,28,34,47,61,116,111,40,154,282,333,568,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,80,53084814,2275,2143,28,34,48,62,117,112,40,154,282,333,584,4,1,54510,9,3,0.10,1,1),
('hatchling_of_twilight',12313,81,60493291,2304,2187,29,35,49,63,118,113,40,154,282,333,584,4,1,54510,10,4,0.10,1,1),
('hatchling_of_twilight',12313,82,65534266,2337,2229,30,35,50,64,119,114,40,154,282,333,603,4,1,54510,10,4,0.10,1,1),
('hatchling_of_twilight',12313,83,71642694,2368,2272,31,36,51,64,120,115,40,154,282,333,616,4,1,54510,10,4,0.10,1,1),
('hatchling_of_twilight',12313,84,77751122,2399,2315,31,36,52,65,121,116,40,154,282,333,629,4,1,54510,10,4,0.10,1,1),
('hatchling_of_twilight',12313,85,83859550,2430,2358,32,37,53,66,122,117,40,154,282,333,642,4,1,54510,10,4,0.10,1,1),
('hatchling_of_twilight',12313,86,89967979,2462,2401,33,38,54,67,123,118,40,154,282,333,655,4,1,54510,10,4,0.10,1,1);

INSERT INTO `pets_stats` VALUES
('strider_of_wind',12526,1,0,31,51,2,44,0,32,38,33,40,187,278,333,696,5,2,54510,2,1,0.10,2,2),
('strider_of_wind',12526,2,7,37,60,2,46,0,33,39,34,40,187,278,333,676,5,2,54510,2,1,0.10,2,2),
('strider_of_wind',12526,3,42,45,69,2,47,0,35,40,35,40,187,278,333,892,7,2,54510,2,1,0.10,2,2),
('strider_of_wind',12526,4,140,53,79,2,49,0,36,41,36,40,187,278,333,1112,9,2,54510,2,1,0.10,2,2),
('strider_of_wind',12526,5,357,63,89,3,51,0,37,42,37,40,187,278,333,1428,11,2,54510,2,1,0.10,2,2),
('strider_of_wind',12526,6,769,73,98,3,53,0,39,43,38,40,187,278,333,1740,14,2,54510,2,1,0.10,2,2),
('strider_of_wind',12526,7,1481,85,108,3,55,0,40,44,39,40,187,278,333,1944,16,3,54510,2,1,0.10,2,2),
('strider_of_wind',12526,8,2629,98,118,4,57,1,42,45,40,40,187,278,333,2228,18,3,54510,2,1,0.10,2,2),
('strider_of_wind',12526,9,4388,113,128,4,59,1,43,46,41,40,187,278,333,2392,19,3,54510,2,1,0.10,2,2),
('strider_of_wind',12526,10,6980,128,138,4,61,1,45,47,42,40,187,278,333,2584,21,4,54510,2,1,0.10,2,2),
('strider_of_wind',12526,11,10682,146,148,5,64,1,46,48,43,40,187,278,333,2840,23,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,12,15295,157,159,5,66,1,48,49,44,40,187,278,333,2824,23,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,13,21417,169,169,6,68,1,50,50,45,40,187,278,333,2788,23,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,14,29393,182,180,6,71,1,52,51,46,40,187,278,333,2772,23,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,15,39618,195,190,7,73,1,53,52,47,40,187,278,333,2760,23,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,16,51729,208,201,8,76,2,55,53,48,40,187,278,333,2716,22,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,17,67878,223,212,8,78,2,57,54,49,40,187,278,333,2700,22,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,18,87835,238,223,9,81,2,59,55,50,40,187,278,333,2664,22,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,19,112262,254,234,10,84,2,61,56,51,40,187,278,333,2636,21,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,20,141904,270,245,11,86,2,63,57,52,40,187,278,333,2620,21,4,54510,3,1,0.10,2,2),
('strider_of_wind',12526,21,177595,287,262,11,89,3,65,58,53,40,187,278,333,3040,25,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,22,212623,305,279,12,92,3,67,59,54,40,187,278,333,3112,25,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,23,409075,324,296,13,95,3,69,60,55,40,187,278,333,3004,25,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,24,501816,343,314,15,98,3,72,61,56,40,187,278,333,3208,26,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,25,605973,364,331,16,101,4,74,62,57,40,187,278,333,3256,27,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,26,722379,385,349,17,105,4,76,63,58,40,187,278,333,3312,27,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,27,851883,406,367,18,108,4,79,64,59,40,187,278,333,3344,27,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,28,995357,429,385,20,111,5,81,65,60,40,187,278,333,3396,28,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,29,1153690,453,403,21,115,5,84,66,61,40,187,278,333,3432,28,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,30,1327790,477,421,23,118,6,86,67,62,40,187,278,333,3472,28,5,54510,4,2,0.10,2,2),
('strider_of_wind',12526,31,1518582,502,440,24,121,6,89,68,63,40,187,278,333,3992,33,6,54510,5,2,0.10,2,2),
('strider_of_wind',12526,32,1727007,528,458,26,125,6,91,69,64,40,187,278,333,4100,34,6,54510,5,2,0.10,2,2),
('strider_of_wind',12526,33,1954023,554,477,28,129,7,94,70,65,40,187,278,333,4224,35,7,54510,5,2,0.10,2,2),
('strider_of_wind',12526,34,2200605,582,496,30,132,7,97,71,66,40,187,278,333,4324,36,7,54510,5,2,0.10,2,2),
('strider_of_wind',12526,35,2467742,610,515,32,136,8,100,72,67,40,187,278,333,4436,36,7,54510,5,2,0.10,2,2),
('strider_of_wind',12526,36,2756437,639,534,34,140,9,102,73,68,40,187,278,333,4548,37,7,54510,5,2,0.10,2,2),
('strider_of_wind',12526,37,3067709,669,553,36,144,9,105,74,69,40,187,278,333,4652,38,7,54510,5,2,0.10,2,2),
('strider_of_wind',12526,38,3402590,700,573,39,148,10,108,75,70,40,187,278,333,4752,39,7,54510,5,2,0.10,2,2),
('strider_of_wind',12526,39,3762126,731,593,41,152,10,111,76,71,40,187,278,333,4860,40,8,54510,5,2,0.10,2,2),
('strider_of_wind',12526,40,4147374,763,612,44,156,11,114,77,72,40,187,278,333,4952,41,8,54510,5,2,0.10,2,2),
('strider_of_wind',12526,41,4559407,796,646,46,160,12,117,78,73,40,187,278,333,5584,46,9,54510,6,2,0.10,2,2),
('strider_of_wind',12526,42,4999307,830,679,49,164,12,120,79,74,40,187,278,333,5700,47,9,54510,6,2,0.10,2,2),
('strider_of_wind',12526,43,5468169,864,713,52,169,13,123,80,75,40,187,278,333,5828,48,9,54510,6,2,0.10,2,2),
('strider_of_wind',12526,44,5967101,899,747,55,173,14,126,81,76,40,187,278,333,5944,49,9,54510,6,2,0.10,2,2),
('strider_of_wind',12526,45,6497220,935,781,58,177,15,130,82,77,40,187,278,333,6068,50,10,54510,6,2,0.10,2,2),
('strider_of_wind',12526,46,7059654,971,816,62,182,16,133,83,78,40,187,278,333,6184,51,10,54510,6,2,0.10,2,2),
('strider_of_wind',12526,47,7655543,1008,851,65,186,17,136,84,79,40,187,278,333,6292,52,10,54510,6,2,0.10,2,2),
('strider_of_wind',12526,48,8286036,1045,886,68,191,18,139,85,80,40,187,278,333,6408,53,10,54510,6,2,0.10,2,2),
('strider_of_wind',12526,49,8952291,1084,921,72,195,19,143,86,81,40,187,278,333,6520,54,10,54510,6,2,0.10,2,2),
('strider_of_wind',12526,50,9655478,1122,957,76,200,19,146,87,82,40,187,278,333,6636,55,11,54510,6,2,0.10,2,2),
('strider_of_wind',12526,51,10767423,1161,993,80,204,21,149,88,83,40,187,278,333,7380,61,12,54510,7,2,0.10,2,2),
('strider_of_wind',12526,52,11938312,1201,1029,84,209,22,153,89,84,40,187,278,333,7512,62,12,54510,7,2,0.10,2,2),
('strider_of_wind',12526,53,13169940,1240,1065,88,214,23,156,90,85,40,187,278,333,7648,63,12,54510,7,2,0.10,2,2),
('strider_of_wind',12526,54,14464112,1281,1102,92,218,24,160,91,86,40,187,278,333,7788,64,12,54510,7,2,0.10,2,2),
('strider_of_wind',12526,55,15822648,1321,1138,97,223,25,163,92,87,40,187,278,333,7920,66,13,54510,7,2,0.10,2,2),
('strider_of_wind',12526,56,17722290,1362,1176,101,228,26,167,93,88,40,187,278,333,8056,67,13,54510,7,2,0.10,2,2),
('strider_of_wind',12526,57,19712649,1403,1213,106,233,27,170,94,89,40,187,278,333,8196,68,13,54510,7,2,0.10,2,2),
('strider_of_wind',12526,58,21796197,1444,1251,110,237,28,174,95,90,40,187,278,333,8328,69,13,54510,7,2,0.10,2,2),
('strider_of_wind',12526,59,23975421,1485,1288,115,242,30,177,96,91,40,187,278,333,8464,70,14,54510,7,2,0.10,2,2),
('strider_of_wind',12526,60,26252824,1527,1327,120,247,31,181,97,92,40,187,278,333,8600,71,14,54510,7,2,0.10,2,2),
('strider_of_wind',12526,61,29819969,1568,1365,125,252,32,184,98,93,40,187,278,333,9468,78,15,54510,8,3,0.10,2,2),
('strider_of_wind',12526,62,33541949,1609,1404,130,257,34,188,99,94,40,187,278,333,9632,80,16,54510,8,3,0.10,2,2),
('strider_of_wind',12526,63,37422578,1651,1443,135,262,35,191,100,95,40,187,278,333,9796,81,16,54510,8,3,0.10,2,2),
('strider_of_wind',12526,64,41465690,1692,1482,140,267,36,195,101,96,40,187,278,333,9964,83,16,54510,8,3,0.10,2,2),
('strider_of_wind',12526,65,45675137,1732,1521,145,271,38,198,102,97,40,187,278,333,10136,84,16,54510,8,3,0.10,2,2),
('strider_of_wind',12526,66,51514675,1773,1561,150,276,39,202,103,98,40,187,278,333,10308,85,17,54510,8,3,0.10,2,2),
('strider_of_wind',12526,67,57586339,1813,1601,156,281,40,206,104,99,40,187,278,333,10480,87,17,54510,8,3,0.10,2,2),
('strider_of_wind',12526,68,63895339,1853,1641,161,286,42,209,105,100,40,187,278,333,10656,88,17,54510,8,3,0.10,2,2),
('strider_of_wind',12526,69,70446906,1892,1681,166,291,43,213,106,101,40,187,278,333,10832,90,18,54510,8,3,0.10,2,2),
('strider_of_wind',12526,70,77246293,1931,1722,172,295,45,216,107,102,40,187,278,333,11024,91,18,54510,8,3,0.10,2,2),
('strider_of_wind',12526,71,84298776,1969,1763,177,300,46,220,108,103,40,187,278,333,10864,90,18,54510,9,3,0.10,2,2),
('strider_of_wind',12526,72,93437370,2006,1804,182,305,47,223,109,104,40,187,278,333,11048,92,18,54510,9,3,0.10,2,2),
('strider_of_wind',12526,73,104799246,2043,1846,188,310,49,226,110,105,40,187,278,333,11240,93,18,54510,9,3,0.10,2,2),
('strider_of_wind',12526,74,118525598,2079,1888,193,314,50,230,111,106,40,187,278,333,11428,95,19,54510,9,3,0.10,2,2),
('strider_of_wind',12526,75,134761662,2114,1929,198,319,52,233,112,107,40,187,278,333,11628,96,19,54510,9,3,0.10,2,2),
('strider_of_wind',12526,76,153656733,2148,1972,203,323,53,236,113,108,40,187,278,333,11824,98,19,54510,9,3,0.10,2,2),
('strider_of_wind',12526,77,179705679,2182,2014,208,328,54,240,114,109,40,187,278,333,12028,100,20,54510,9,3,0.10,2,2),
('strider_of_wind',12526,78,208869769,2214,2057,213,332,56,243,115,110,40,187,278,333,12236,101,20,54510,9,3,0.10,2,2),
('strider_of_wind',12526,79,241313302,2245,2100,218,337,57,246,116,111,40,187,278,333,12448,103,20,54510,9,3,0.10,2,2),
('strider_of_wind',12526,80,277204713,2275,2143,223,341,58,249,117,112,40,187,278,333,12664,105,21,54510,9,3,0.10,2,2),
('strider_of_wind',12526,81,316716590,2304,2187,228,345,59,252,118,113,40,187,278,333,12664,105,21,54510,10,4,0.10,2,2),
('strider_of_wind',12526,82,338113831,2338,2229,233,350,60,255,119,114,40,187,278,333,12957,107,21,54510,10,4,0.10,2,2),
('strider_of_wind',12526,83,368634130,2370,2272,238,354,62,259,120,115,40,187,278,333,13143,109,22,54510,10,4,0.10,2,2),
('strider_of_wind',12526,84,399154428,2402,2315,243,359,63,262,121,116,40,187,278,333,13329,111,22,54510,10,4,0.10,2,2),
('strider_of_wind',12526,85,429674727,2433,2358,248,363,64,265,122,117,40,187,278,333,13515,112,23,54510,10,4,0.10,2,2),
('strider_of_wind',12526,86,460195026,2465,2401,253,367,65,268,123,118,40,187,278,333,13701,114,23,54510,10,4,0.10,2,2),
('strider_of_star',12527,1,0,31,51,1,44,2,32,38,33,40,187,278,333,508,5,2,54510,2,1,0.10,2,2),
('strider_of_star',12527,2,7,37,60,1,46,3,33,39,34,40,187,278,333,492,5,2,54510,2,1,0.10,2,2),
('strider_of_star',12527,3,42,45,69,1,47,3,35,40,35,40,187,278,333,608,7,2,54510,2,1,0.10,2,2),
('strider_of_star',12527,4,140,53,79,1,49,3,36,41,36,40,187,278,333,756,9,2,54510,2,1,0.10,2,2),
('strider_of_star',12527,5,357,63,89,1,51,4,37,42,37,40,187,278,333,932,11,2,54510,2,1,0.10,2,2),
('strider_of_star',12527,6,769,73,98,1,53,4,39,43,38,40,187,278,333,1124,14,2,54510,2,1,0.10,2,2),
('strider_of_star',12527,7,1481,85,108,1,55,4,40,44,39,40,187,278,333,1200,16,3,54510,2,1,0.10,2,2),
('strider_of_star',12527,8,2629,98,118,1,57,5,42,45,40,40,187,278,333,1336,18,3,54510,2,1,0.10,2,2),
('strider_of_star',12527,9,4388,113,128,1,59,5,43,46,41,40,187,278,333,1432,19,3,54510,2,1,0.10,2,2),
('strider_of_star',12527,10,6980,128,138,1,61,6,45,47,42,40,187,278,333,1492,21,4,54510,2,1,0.10,2,2),
('strider_of_star',12527,11,10682,146,148,1,64,6,46,48,43,40,187,278,333,1784,23,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,12,15295,157,159,1,66,7,48,49,44,40,187,278,333,1796,23,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,13,21417,169,169,1,68,8,50,50,45,40,187,278,333,1724,23,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,14,29393,182,180,1,71,8,52,51,46,40,187,278,333,1664,23,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,15,39618,195,190,1,73,9,53,52,47,40,187,278,333,1608,23,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,16,51729,208,201,1,76,10,55,53,48,40,187,278,333,1548,22,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,17,67878,223,212,1,78,11,57,54,49,40,187,278,333,1512,22,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,18,87835,238,223,1,81,12,59,55,50,40,187,278,333,1464,22,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,19,112262,254,234,1,84,13,61,56,51,40,187,278,333,1456,21,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,20,141904,270,245,1,86,14,63,57,52,40,187,278,333,1460,21,4,54510,3,1,0.10,2,2),
('strider_of_star',12527,21,177595,287,262,1,89,15,65,58,53,40,187,278,333,1908,25,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,22,212623,305,279,1,92,16,67,59,54,40,187,278,333,1912,25,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,23,350264,324,296,1,95,18,69,60,55,40,187,278,333,1804,25,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,24,466190,343,314,1,98,19,72,61,56,40,187,278,333,1900,26,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,25,596387,364,331,1,101,21,74,62,57,40,187,278,333,1896,27,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,26,741894,385,349,1,105,22,76,63,58,40,187,278,333,1896,27,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,27,903774,406,367,1,108,24,79,64,59,40,187,278,333,1844,27,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,28,1083117,429,385,1,111,26,81,65,60,40,187,278,333,1856,28,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,29,1281033,453,403,1,115,28,84,66,61,40,187,278,333,1848,28,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,30,1498658,477,421,1,118,30,86,67,62,40,187,278,333,1880,28,5,54510,4,2,0.10,2,2),
('strider_of_star',12527,31,1737148,502,440,1,121,32,89,68,63,40,187,278,333,2384,33,6,54510,5,2,0.10,2,2),
('strider_of_star',12527,32,1997679,528,458,1,125,34,91,69,64,40,187,278,333,2376,34,6,54510,5,2,0.10,2,2),
('strider_of_star',12527,33,2281450,554,477,2,129,37,94,70,65,40,187,278,333,2416,35,7,54510,5,2,0.10,2,2),
('strider_of_star',12527,34,2589677,582,496,2,132,39,97,71,66,40,187,278,333,2452,36,7,54510,5,2,0.10,2,2),
('strider_of_star',12527,35,2923598,610,515,3,136,42,100,72,67,40,187,278,333,2488,36,7,54510,5,2,0.10,2,2),
('strider_of_star',12527,36,3284467,639,534,3,140,45,102,73,68,40,187,278,333,2524,37,7,54510,5,2,0.10,2,2),
('strider_of_star',12527,37,3673557,669,553,4,144,48,105,74,69,40,187,278,333,2516,38,7,54510,5,2,0.10,2,2),
('strider_of_star',12527,38,4092158,700,573,5,148,51,108,75,70,40,187,278,333,2548,39,7,54510,5,2,0.10,2,2),
('strider_of_star',12527,39,4541577,731,593,5,152,54,111,76,71,40,187,278,333,2584,40,8,54510,5,2,0.10,2,2),
('strider_of_star',12527,40,5023138,763,612,6,156,57,114,77,72,40,187,278,333,2576,41,8,54510,5,2,0.10,2,2),
('strider_of_star',12527,41,5538179,796,646,7,160,61,117,78,73,40,187,278,333,3156,46,9,54510,6,2,0.10,2,2),
('strider_of_star',12527,42,6088054,830,679,8,164,64,120,79,74,40,187,278,333,3200,47,9,54510,6,2,0.10,2,2),
('strider_of_star',12527,43,6674132,864,713,8,169,68,123,80,75,40,187,278,333,3244,48,9,54510,6,2,0.10,2,2),
('strider_of_star',12527,44,7297797,899,747,9,173,72,126,81,76,40,187,278,333,3244,49,9,54510,6,2,0.10,2,2),
('strider_of_star',12527,45,7960445,935,781,10,177,76,130,82,77,40,187,278,333,3292,50,10,54510,6,2,0.10,2,2),
('strider_of_star',12527,46,8663488,971,816,11,182,81,133,83,78,40,187,278,333,3332,51,10,54510,6,2,0.10,2,2),
('strider_of_star',12527,47,9408349,1008,851,12,186,85,136,84,79,40,187,278,333,3328,52,10,54510,6,2,0.10,2,2),
('strider_of_star',12527,48,10196465,1045,886,13,191,90,139,85,80,40,187,278,333,3368,53,10,54510,6,2,0.10,2,2),
('strider_of_star',12527,49,11029284,1084,921,14,195,95,143,86,81,40,187,278,333,3376,54,10,54510,6,2,0.10,2,2),
('strider_of_star',12527,50,11908268,1122,957,15,200,99,146,87,82,40,187,278,333,3416,55,11,54510,6,2,0.10,2,2),
('strider_of_star',12527,51,13298199,1161,993,16,204,105,149,88,83,40,187,278,333,4084,61,12,54510,7,2,0.10,2,2),
('strider_of_star',12527,52,14761810,1201,1029,17,209,110,153,89,84,40,187,278,333,4132,62,12,54510,7,2,0.10,2,2),
('strider_of_star',12527,53,16301345,1240,1065,19,214,113,156,90,85,40,187,278,333,4148,63,12,54510,7,2,0.10,2,2),
('strider_of_star',12527,54,17919061,1281,1102,20,218,116,160,91,86,40,187,278,333,4200,64,12,54510,7,2,0.10,2,2),
('strider_of_star',12527,55,19617231,1321,1138,21,223,119,163,92,87,40,187,278,333,4208,66,13,54510,7,2,0.10,2,2),
('strider_of_star',12527,56,21991783,1362,1176,22,228,121,167,93,88,40,187,278,333,4264,67,13,54510,7,2,0.10,2,2),
('strider_of_star',12527,57,24479731,1403,1213,24,233,124,170,94,89,40,187,278,333,4316,68,13,54510,7,2,0.10,2,2),
('strider_of_star',12527,58,27084166,1444,1251,25,237,130,174,95,90,40,187,278,333,4328,69,13,54510,7,2,0.10,2,2),
('strider_of_star',12527,59,29808197,1485,1288,26,242,136,177,96,91,40,187,278,333,4384,70,14,54510,7,2,0.10,2,2),
('strider_of_star',12527,60,32654950,1527,1327,28,247,141,181,97,92,40,187,278,333,4392,71,14,54510,7,2,0.10,2,2),
('strider_of_star',12527,61,37113882,1568,1365,29,252,147,184,98,93,40,187,278,333,5164,78,15,54510,8,3,0.10,2,2),
('strider_of_star',12527,62,41766357,1609,1404,30,257,153,188,99,94,40,187,278,333,5232,80,16,54510,8,3,0.10,2,2),
('strider_of_star',12527,63,46617143,1651,1443,32,262,159,191,100,95,40,187,278,333,5300,81,16,54510,8,3,0.10,2,2),
('strider_of_star',12527,64,51671033,1692,1482,33,267,165,195,101,96,40,187,278,333,5328,83,16,54510,8,3,0.10,2,2),
('strider_of_star',12527,65,56932842,1732,1521,35,271,171,198,102,97,40,187,278,333,5400,84,16,54510,8,3,0.10,2,2),
('strider_of_star',12527,66,64232264,1773,1561,36,276,177,202,103,98,40,187,278,333,5472,85,17,54510,8,3,0.10,2,2),
('strider_of_star',12527,67,71821844,1813,1601,38,281,184,206,104,99,40,187,278,333,5544,87,17,54510,8,3,0.10,2,2),
('strider_of_star',12527,68,79708094,1853,1641,39,286,190,209,105,100,40,187,278,333,5576,88,17,54510,8,3,0.10,2,2),
('strider_of_star',12527,69,87897553,1892,1681,41,291,196,213,106,101,40,187,278,333,5648,90,18,54510,8,3,0.10,2,2),
('strider_of_star',12527,70,96396787,1931,1722,42,295,202,216,107,102,40,187,278,333,5728,91,18,54510,8,3,0.10,2,2),
('strider_of_star',12527,71,105212391,1969,1763,44,300,209,220,108,103,40,187,278,333,5948,90,18,54510,9,3,0.10,2,2),
('strider_of_star',12527,72,116635633,2006,1804,45,305,215,223,109,104,40,187,278,333,6028,92,18,54510,9,3,0.10,2,2),
('strider_of_star',12527,73,130837978,2043,1846,47,310,221,226,110,105,40,187,278,333,6116,93,18,54510,9,3,0.10,2,2),
('strider_of_star',12527,74,147995918,2079,1888,48,314,227,230,111,106,40,187,278,333,6200,95,19,54510,9,3,0.10,2,2),
('strider_of_star',12527,75,168290997,2114,1929,50,319,234,233,112,107,40,187,278,333,6288,96,19,54510,9,3,0.10,2,2),
('strider_of_star',12527,76,191909837,2148,1972,51,323,240,236,113,108,40,187,278,333,6376,98,19,54510,9,3,0.10,2,2),
('strider_of_star',12527,77,224471019,2182,2014,53,328,246,240,114,109,40,187,278,333,6468,100,20,54510,9,3,0.10,2,2),
('strider_of_star',12527,78,260926132,2214,2057,54,332,252,243,115,110,40,187,278,333,6556,101,20,54510,9,3,0.10,2,2),
('strider_of_star',12527,79,301480548,2245,2100,56,337,257,246,116,111,40,187,278,333,6656,103,20,54510,9,3,0.10,2,2),
('strider_of_star',12527,80,346344812,2275,2143,57,341,263,249,117,112,40,187,278,333,6748,105,21,54510,9,3,0.10,2,2),
('strider_of_star',12527,81,395734658,2304,2187,59,345,268,252,118,113,40,187,278,333,6748,105,21,54510,10,4,0.10,2,2),
('strider_of_star',12527,82,429341158,2337,2229,60,350,274,255,119,114,40,187,278,333,6872,107,21,54510,10,4,0.10,2,2),
('strider_of_star',12527,83,470064012,2368,2272,62,354,280,258,120,115,40,187,278,333,6952,109,22,54510,10,4,0.10,2,2),
('strider_of_star',12527,84,510786866,2399,2315,63,359,285,262,121,116,40,187,278,333,7032,110,22,54510,10,4,0.10,2,2),
('strider_of_star',12527,85,551509721,2430,2358,65,363,291,265,122,117,40,187,278,333,7112,112,23,54510,10,4,0.10,2,2),
('strider_of_star',12527,86,592232575,2462,2401,67,367,296,268,123,118,40,187,278,333,7192,113,23,54510,10,4,0.10,2,2),
('strider_of_twilight',12528,1,0,31,51,0,0,0,8,38,33,40,187,278,333,12,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,2,7,37,60,0,0,0,8,39,34,40,187,278,333,8,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,3,42,45,69,0,0,0,8,40,35,40,187,278,333,12,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,4,140,53,79,0,0,0,9,41,36,40,187,278,333,20,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,5,357,63,89,0,0,0,9,42,37,40,187,278,333,24,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,6,769,73,98,0,0,0,9,43,38,40,187,278,333,32,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,7,1481,85,108,0,0,0,10,44,39,40,187,278,333,36,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,8,2629,98,118,0,0,0,10,45,40,40,187,278,333,44,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,9,4388,113,128,0,0,0,10,46,41,40,187,278,333,48,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,10,6980,128,138,0,0,1,11,47,42,40,187,278,333,56,1,1,54510,2,1,0.10,2,2),
('strider_of_twilight',12528,11,10682,146,148,0,0,1,11,48,43,40,187,278,333,60,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,12,15295,157,159,0,0,1,12,49,44,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,13,21417,169,169,0,0,1,12,50,45,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,14,29393,182,180,0,0,1,13,51,46,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,15,39618,195,190,0,1,1,13,52,47,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,16,51729,208,201,0,1,1,13,53,48,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,17,67878,223,212,0,1,1,14,54,49,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,18,87835,238,223,0,2,2,14,55,50,40,187,278,333,68,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,19,112262,254,234,0,2,2,15,56,51,40,187,278,333,68,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,20,141904,270,245,0,2,2,15,57,52,40,187,278,333,68,1,1,54510,3,1,0.10,2,2),
('strider_of_twilight',12528,21,177595,287,262,0,3,2,16,58,53,40,187,278,333,76,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,22,212623,305,279,0,3,2,16,59,54,40,187,278,333,80,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,23,254072,324,296,0,3,3,17,60,55,40,187,278,333,76,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,24,302838,343,314,0,4,3,18,61,56,40,187,278,333,84,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,25,359907,364,331,0,4,3,18,62,57,40,187,278,333,88,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,26,426364,385,349,0,5,3,19,63,58,40,187,278,333,92,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,27,503400,406,367,0,5,4,19,64,59,40,187,278,333,92,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,28,592316,429,385,0,5,4,20,65,60,40,187,278,333,96,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,29,694532,453,403,0,6,4,21,66,61,40,187,278,333,100,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,30,811593,477,421,0,6,5,21,67,62,40,187,278,333,104,1,1,54510,4,2,0.10,2,2),
('strider_of_twilight',12528,31,945176,502,440,0,7,5,22,68,63,40,187,278,333,112,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,32,1074521,528,458,0,7,5,22,69,64,40,187,278,333,116,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,33,1220860,554,477,1,8,6,23,70,65,40,187,278,333,124,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,34,1385938,582,496,1,8,6,24,71,66,40,187,278,333,128,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,35,1571632,610,515,1,9,6,25,72,67,40,187,278,333,136,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,36,1625762,639,534,1,9,7,25,73,68,40,187,278,333,144,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,37,1684126,669,553,2,10,7,26,74,69,40,187,278,333,148,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,38,1746916,700,573,2,10,8,27,75,70,40,187,278,333,156,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,39,1814329,731,593,2,11,8,27,76,71,40,187,278,333,164,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,40,1886563,763,612,3,11,9,28,77,72,40,187,278,333,172,1,1,54510,5,2,0.10,2,2),
('strider_of_twilight',12528,41,1963819,796,646,3,12,10,29,78,73,40,187,278,333,180,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,42,2046300,830,679,4,12,10,30,79,74,40,187,278,333,188,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,43,2134212,864,713,4,13,11,30,80,75,40,187,278,333,196,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,44,2227762,899,747,4,13,12,31,81,76,40,187,278,333,204,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,45,2327159,935,781,5,14,12,32,82,77,40,187,278,333,212,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,46,2432616,971,816,5,14,13,33,83,78,40,187,278,333,220,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,47,2544345,1008,851,6,15,14,34,84,79,40,187,278,333,228,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,48,2662562,1045,886,6,15,14,34,85,80,40,187,278,333,236,1,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,49,2787485,1084,921,7,16,15,35,86,81,40,187,278,333,248,2,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,50,2919333,1122,957,7,17,16,36,87,82,40,187,278,333,256,2,1,54510,6,2,0.10,2,2),
('strider_of_twilight',12528,51,3127822,1161,993,8,17,17,37,88,83,40,187,278,333,264,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,52,3347364,1201,1029,8,18,18,38,89,84,40,187,278,333,276,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,53,3578294,1240,1065,9,18,19,39,90,85,40,187,278,333,284,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,54,3820951,1281,1102,10,19,20,40,91,86,40,187,278,333,296,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,55,4075677,1321,1138,10,19,20,40,92,87,40,187,278,333,308,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,56,4431860,1362,1176,11,20,21,41,93,88,40,187,278,333,316,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,57,4805052,1403,1213,12,21,22,42,94,89,40,187,278,333,328,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,58,5195717,1444,1251,12,21,23,43,95,90,40,187,278,333,340,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,59,5604322,1485,1288,13,22,24,44,96,91,40,187,278,333,352,2,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,60,6031335,1527,1327,14,22,26,45,97,92,40,187,278,333,364,3,1,54510,7,2,0.10,2,2),
('strider_of_twilight',12528,61,6700175,1568,1365,14,23,27,46,98,93,40,187,278,333,372,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,62,7398046,1609,1404,15,24,28,47,99,94,40,187,278,333,388,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,63,8125664,1651,1443,16,24,29,47,100,95,40,187,278,333,400,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,64,8883747,1692,1482,16,25,30,48,101,96,40,187,278,333,412,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,65,9673019,1732,1521,17,25,31,49,102,97,40,187,278,333,424,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,66,10767932,1773,1561,18,26,32,50,103,98,40,187,278,333,440,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,67,11906369,1813,1601,19,27,33,51,104,99,40,187,278,333,452,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,68,13089306,1853,1641,19,27,34,52,105,100,40,187,278,333,468,3,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,69,14317725,1892,1681,20,28,36,53,106,101,40,187,278,333,480,4,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,70,15592610,1931,1722,21,28,37,54,107,102,40,187,278,333,496,4,1,54510,8,3,0.10,2,2),
('strider_of_twilight',12528,71,16914951,1969,1763,22,29,38,55,108,103,40,187,278,333,456,3,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,72,18628437,2006,1804,22,30,39,55,109,104,40,187,278,333,468,3,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,73,20758789,2043,1846,23,30,40,56,110,105,40,187,278,333,484,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,74,23332480,2079,1888,24,31,41,57,111,106,40,187,278,333,496,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,75,26376742,2114,1929,25,31,42,58,112,107,40,187,278,333,512,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,76,29919568,2148,1972,25,32,44,59,113,108,40,187,278,333,524,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,77,34803745,2182,2014,26,33,45,60,114,109,40,187,278,333,540,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,78,40272012,2214,2057,27,33,46,60,115,110,40,187,278,333,552,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,79,46355175,2245,2100,28,34,47,61,116,111,40,187,278,333,568,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,80,53084814,2275,2143,28,34,48,62,117,112,40,187,278,333,584,4,1,54510,9,3,0.10,2,2),
('strider_of_twilight',12528,81,60493291,2304,2187,29,35,49,63,118,113,40,187,278,333,584,4,1,54510,10,4,0.10,2,2),
('strider_of_twilight',12528,82,65534266,2337,2229,30,35,50,64,119,114,40,187,278,333,603,4,1,54510,10,4,0.10,2,2),
('strider_of_twilight',12528,83,71642694,2368,2272,31,36,51,64,120,115,40,187,278,333,616,4,1,54510,10,4,0.10,2,2),
('strider_of_twilight',12528,84,77751122,2399,2315,31,36,52,65,121,116,40,187,278,333,629,4,1,54510,10,4,0.10,2,2),
('strider_of_twilight',12528,85,83859550,2430,2358,32,37,53,66,122,117,40,187,278,333,642,4,1,54510,10,4,0.10,2,2),
('strider_of_twilight',12528,86,89967979,2462,2401,33,38,54,67,123,118,40,187,278,333,655,4,1,54510,10,4,0.10,2,2);

INSERT INTO `pets_stats` VALUES
('red_strider_of_wind',16038,1,0,31,51,2,44,0,32,38,33,40,187,278,333,696,5,2,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,2,7,37,60,2,46,0,33,39,34,40,187,278,333,676,5,2,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,3,42,45,69,2,47,0,35,40,35,40,187,278,333,892,7,2,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,4,140,53,79,2,49,0,36,41,36,40,187,278,333,1112,9,2,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,5,357,63,89,3,51,0,37,42,37,40,187,278,333,1428,11,2,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,6,769,73,98,3,53,0,39,43,38,40,187,278,333,1740,14,2,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,7,1481,85,108,3,55,0,40,44,39,40,187,278,333,1944,16,3,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,8,2629,98,118,4,57,1,42,45,40,40,187,278,333,2228,18,3,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,9,4388,113,128,4,59,1,43,46,41,40,187,278,333,2392,19,3,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,10,6980,128,138,4,61,1,45,47,42,40,187,278,333,2584,21,4,54510,2,1,0.10,2,2),
('red_strider_of_wind',16038,11,10682,146,148,5,64,1,46,48,43,40,187,278,333,2840,23,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,12,15295,157,159,5,66,1,48,49,44,40,187,278,333,2824,23,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,13,21417,169,169,6,68,1,50,50,45,40,187,278,333,2788,23,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,14,29393,182,180,6,71,1,52,51,46,40,187,278,333,2772,23,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,15,39618,195,190,7,73,1,53,52,47,40,187,278,333,2760,23,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,16,51729,208,201,8,76,2,55,53,48,40,187,278,333,2716,22,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,17,67878,223,212,8,78,2,57,54,49,40,187,278,333,2700,22,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,18,87835,238,223,9,81,2,59,55,50,40,187,278,333,2664,22,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,19,112262,254,234,10,84,2,61,56,51,40,187,278,333,2636,21,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,20,141904,270,245,11,86,2,63,57,52,40,187,278,333,2620,21,4,54510,3,1,0.10,2,2),
('red_strider_of_wind',16038,21,177595,287,262,11,89,3,65,58,53,40,187,278,333,3040,25,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,22,212623,305,279,12,92,3,67,59,54,40,187,278,333,3112,25,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,23,409075,324,296,13,95,3,69,60,55,40,187,278,333,3004,25,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,24,501816,343,314,15,98,3,72,61,56,40,187,278,333,3208,26,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,25,605973,364,331,16,101,4,74,62,57,40,187,278,333,3256,27,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,26,722379,385,349,17,105,4,76,63,58,40,187,278,333,3312,27,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,27,851883,406,367,18,108,4,79,64,59,40,187,278,333,3344,27,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,28,995357,429,385,20,111,5,81,65,60,40,187,278,333,3396,28,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,29,1153690,453,403,21,115,5,84,66,61,40,187,278,333,3432,28,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,30,1327790,477,421,23,118,6,86,67,62,40,187,278,333,3472,28,5,54510,4,2,0.10,2,2),
('red_strider_of_wind',16038,31,1518582,502,440,24,121,6,89,68,63,40,187,278,333,3992,33,6,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,32,1727007,528,458,26,125,6,91,69,64,40,187,278,333,4100,34,6,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,33,1954023,554,477,28,129,7,94,70,65,40,187,278,333,4224,35,7,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,34,2200605,582,496,30,132,7,97,71,66,40,187,278,333,4324,36,7,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,35,2467742,610,515,32,136,8,100,72,67,40,187,278,333,4436,36,7,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,36,2756437,639,534,34,140,9,102,73,68,40,187,278,333,4548,37,7,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,37,3067709,669,553,36,144,9,105,74,69,40,187,278,333,4652,38,7,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,38,3402590,700,573,39,148,10,108,75,70,40,187,278,333,4752,39,7,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,39,3762126,731,593,41,152,10,111,76,71,40,187,278,333,4860,40,8,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,40,4147374,763,612,44,156,11,114,77,72,40,187,278,333,4952,41,8,54510,5,2,0.10,2,2),
('red_strider_of_wind',16038,41,4559407,796,646,46,160,12,117,78,73,40,187,278,333,5584,46,9,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,42,4999307,830,679,49,164,12,120,79,74,40,187,278,333,5700,47,9,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,43,5468169,864,713,52,169,13,123,80,75,40,187,278,333,5828,48,9,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,44,5967101,899,747,55,173,14,126,81,76,40,187,278,333,5944,49,9,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,45,6497220,935,781,58,177,15,130,82,77,40,187,278,333,6068,50,10,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,46,7059654,971,816,62,182,16,133,83,78,40,187,278,333,6184,51,10,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,47,7655543,1008,851,65,186,17,136,84,79,40,187,278,333,6292,52,10,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,48,8286036,1045,886,68,191,18,139,85,80,40,187,278,333,6408,53,10,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,49,8952291,1084,921,72,195,19,143,86,81,40,187,278,333,6520,54,10,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,50,9655478,1122,957,76,200,19,146,87,82,40,187,278,333,6636,55,11,54510,6,2,0.10,2,2),
('red_strider_of_wind',16038,51,10767423,1161,993,80,204,21,149,88,83,40,187,278,333,7380,61,12,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,52,11938312,1201,1029,84,209,22,153,89,84,40,187,278,333,7512,62,12,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,53,13169940,1240,1065,88,214,23,156,90,85,40,187,278,333,7648,63,12,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,54,14464112,1281,1102,92,218,24,160,91,86,40,187,278,333,7788,64,12,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,55,15822648,1321,1138,97,223,25,163,92,87,40,187,278,333,7920,66,13,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,56,17722290,1362,1176,101,228,26,167,93,88,40,187,278,333,8056,67,13,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,57,19712649,1403,1213,106,233,27,170,94,89,40,187,278,333,8196,68,13,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,58,21796197,1444,1251,110,237,28,174,95,90,40,187,278,333,8328,69,13,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,59,23975421,1485,1288,115,242,30,177,96,91,40,187,278,333,8464,70,14,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,60,26252824,1527,1327,120,247,31,181,97,92,40,187,278,333,8600,71,14,54510,7,2,0.10,2,2),
('red_strider_of_wind',16038,61,29819969,1568,1365,125,252,32,184,98,93,40,187,278,333,9468,78,15,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,62,33541949,1609,1404,130,257,34,188,99,94,40,187,278,333,9632,80,16,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,63,37422578,1651,1443,135,262,35,191,100,95,40,187,278,333,9796,81,16,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,64,41465690,1692,1482,140,267,36,195,101,96,40,187,278,333,9964,83,16,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,65,45675137,1732,1521,145,271,38,198,102,97,40,187,278,333,10136,84,16,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,66,51514675,1773,1561,150,276,39,202,103,98,40,187,278,333,10308,85,17,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,67,57586339,1813,1601,156,281,40,206,104,99,40,187,278,333,10480,87,17,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,68,63895339,1853,1641,161,286,42,209,105,100,40,187,278,333,10656,88,17,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,69,70446906,1892,1681,166,291,43,213,106,101,40,187,278,333,10832,90,18,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,70,77246293,1931,1722,172,295,45,216,107,102,40,187,278,333,11024,91,18,54510,8,3,0.10,2,2),
('red_strider_of_wind',16038,71,84298776,1969,1763,177,300,46,220,108,103,40,187,278,333,10864,90,18,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,72,93437370,2006,1804,182,305,47,223,109,104,40,187,278,333,11048,92,18,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,73,104799246,2043,1846,188,310,49,226,110,105,40,187,278,333,11240,93,18,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,74,118525598,2079,1888,193,314,50,230,111,106,40,187,278,333,11428,95,19,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,75,134761662,2114,1929,198,319,52,233,112,107,40,187,278,333,11628,96,19,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,76,153656733,2148,1972,203,323,53,236,113,108,40,187,278,333,11824,98,19,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,77,179705679,2182,2014,208,328,54,240,114,109,40,187,278,333,12028,100,20,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,78,208869769,2214,2057,213,332,56,243,115,110,40,187,278,333,12236,101,20,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,79,241313302,2245,2100,218,337,57,246,116,111,40,187,278,333,12448,103,20,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,80,277204713,2275,2143,223,341,58,249,117,112,40,187,278,333,12664,105,21,54510,9,3,0.10,2,2),
('red_strider_of_wind',16038,81,316716590,2304,2187,228,345,59,252,118,113,40,187,278,333,12664,105,21,54510,10,4,0.10,2,2),
('red_strider_of_wind',16038,82,338113831,2338,2229,233,350,60,255,119,114,40,187,278,333,12957,107,21,54510,10,4,0.10,2,2),
('red_strider_of_wind',16038,83,368634130,2370,2272,238,354,62,259,120,115,40,187,278,333,13143,109,22,54510,10,4,0.10,2,2),
('red_strider_of_wind',16038,84,399154428,2402,2315,243,359,63,262,121,116,40,187,278,333,13329,111,22,54510,10,4,0.10,2,2),
('red_strider_of_wind',16038,85,429674727,2433,2358,248,363,64,265,122,117,40,187,278,333,13515,112,23,54510,10,4,0.10,2,2),
('red_strider_of_wind',16038,86,460195026,2465,2401,253,367,65,268,123,118,40,187,278,333,13701,114,23,54510,10,4,0.10,2,2),
('red_strider_of_star',16039,1,0,31,51,1,44,2,32,38,33,40,187,278,333,508,5,2,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,2,7,37,60,1,46,3,33,39,34,40,187,278,333,492,5,2,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,3,42,45,69,1,47,3,35,40,35,40,187,278,333,608,7,2,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,4,140,53,79,1,49,3,36,41,36,40,187,278,333,756,9,2,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,5,357,63,89,1,51,4,37,42,37,40,187,278,333,932,11,2,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,6,769,73,98,1,53,4,39,43,38,40,187,278,333,1124,14,2,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,7,1481,85,108,1,55,4,40,44,39,40,187,278,333,1200,16,3,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,8,2629,98,118,1,57,5,42,45,40,40,187,278,333,1336,18,3,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,9,4388,113,128,1,59,5,43,46,41,40,187,278,333,1432,19,3,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,10,6980,128,138,1,61,6,45,47,42,40,187,278,333,1492,21,4,54510,2,1,0.10,2,2),
('red_strider_of_star',16039,11,10682,146,148,1,64,6,46,48,43,40,187,278,333,1784,23,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,12,15295,157,159,1,66,7,48,49,44,40,187,278,333,1796,23,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,13,21417,169,169,1,68,8,50,50,45,40,187,278,333,1724,23,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,14,29393,182,180,1,71,8,52,51,46,40,187,278,333,1664,23,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,15,39618,195,190,1,73,9,53,52,47,40,187,278,333,1608,23,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,16,51729,208,201,1,76,10,55,53,48,40,187,278,333,1548,22,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,17,67878,223,212,1,78,11,57,54,49,40,187,278,333,1512,22,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,18,87835,238,223,1,81,12,59,55,50,40,187,278,333,1464,22,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,19,112262,254,234,1,84,13,61,56,51,40,187,278,333,1456,21,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,20,141904,270,245,1,86,14,63,57,52,40,187,278,333,1460,21,4,54510,3,1,0.10,2,2),
('red_strider_of_star',16039,21,177595,287,262,1,89,15,65,58,53,40,187,278,333,1908,25,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,22,212623,305,279,1,92,16,67,59,54,40,187,278,333,1912,25,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,23,350264,324,296,1,95,18,69,60,55,40,187,278,333,1804,25,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,24,466190,343,314,1,98,19,72,61,56,40,187,278,333,1900,26,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,25,596387,364,331,1,101,21,74,62,57,40,187,278,333,1896,27,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,26,741894,385,349,1,105,22,76,63,58,40,187,278,333,1896,27,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,27,903774,406,367,1,108,24,79,64,59,40,187,278,333,1844,27,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,28,1083117,429,385,1,111,26,81,65,60,40,187,278,333,1856,28,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,29,1281033,453,403,1,115,28,84,66,61,40,187,278,333,1848,28,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,30,1498658,477,421,1,118,30,86,67,62,40,187,278,333,1880,28,5,54510,4,2,0.10,2,2),
('red_strider_of_star',16039,31,1737148,502,440,1,121,32,89,68,63,40,187,278,333,2384,33,6,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,32,1997679,528,458,1,125,34,91,69,64,40,187,278,333,2376,34,6,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,33,2281450,554,477,2,129,37,94,70,65,40,187,278,333,2416,35,7,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,34,2589677,582,496,2,132,39,97,71,66,40,187,278,333,2452,36,7,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,35,2923598,610,515,3,136,42,100,72,67,40,187,278,333,2488,36,7,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,36,3284467,639,534,3,140,45,102,73,68,40,187,278,333,2524,37,7,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,37,3673557,669,553,4,144,48,105,74,69,40,187,278,333,2516,38,7,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,38,4092158,700,573,5,148,51,108,75,70,40,187,278,333,2548,39,7,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,39,4541577,731,593,5,152,54,111,76,71,40,187,278,333,2584,40,8,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,40,5023138,763,612,6,156,57,114,77,72,40,187,278,333,2576,41,8,54510,5,2,0.10,2,2),
('red_strider_of_star',16039,41,5538179,796,646,7,160,61,117,78,73,40,187,278,333,3156,46,9,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,42,6088054,830,679,8,164,64,120,79,74,40,187,278,333,3200,47,9,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,43,6674132,864,713,8,169,68,123,80,75,40,187,278,333,3244,48,9,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,44,7297797,899,747,9,173,72,126,81,76,40,187,278,333,3244,49,9,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,45,7960445,935,781,10,177,76,130,82,77,40,187,278,333,3292,50,10,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,46,8663488,971,816,11,182,81,133,83,78,40,187,278,333,3332,51,10,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,47,9408349,1008,851,12,186,85,136,84,79,40,187,278,333,3328,52,10,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,48,10196465,1045,886,13,191,90,139,85,80,40,187,278,333,3368,53,10,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,49,11029284,1084,921,14,195,95,143,86,81,40,187,278,333,3376,54,10,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,50,11908268,1122,957,15,200,99,146,87,82,40,187,278,333,3416,55,11,54510,6,2,0.10,2,2),
('red_strider_of_star',16039,51,13298199,1161,993,16,204,105,149,88,83,40,187,278,333,4084,61,12,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,52,14761810,1201,1029,17,209,110,153,89,84,40,187,278,333,4132,62,12,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,53,16301345,1240,1065,19,214,113,156,90,85,40,187,278,333,4148,63,12,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,54,17919061,1281,1102,20,218,116,160,91,86,40,187,278,333,4200,64,12,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,55,19617231,1321,1138,21,223,119,163,92,87,40,187,278,333,4208,66,13,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,56,21991783,1362,1176,22,228,121,167,93,88,40,187,278,333,4264,67,13,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,57,24479731,1403,1213,24,233,124,170,94,89,40,187,278,333,4316,68,13,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,58,27084166,1444,1251,25,237,130,174,95,90,40,187,278,333,4328,69,13,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,59,29808197,1485,1288,26,242,136,177,96,91,40,187,278,333,4384,70,14,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,60,32654950,1527,1327,28,247,141,181,97,92,40,187,278,333,4392,71,14,54510,7,2,0.10,2,2),
('red_strider_of_star',16039,61,37113882,1568,1365,29,252,147,184,98,93,40,187,278,333,5164,78,15,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,62,41766357,1609,1404,30,257,153,188,99,94,40,187,278,333,5232,80,16,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,63,46617143,1651,1443,32,262,159,191,100,95,40,187,278,333,5300,81,16,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,64,51671033,1692,1482,33,267,165,195,101,96,40,187,278,333,5328,83,16,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,65,56932842,1732,1521,35,271,171,198,102,97,40,187,278,333,5400,84,16,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,66,64232264,1773,1561,36,276,177,202,103,98,40,187,278,333,5472,85,17,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,67,71821844,1813,1601,38,281,184,206,104,99,40,187,278,333,5544,87,17,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,68,79708094,1853,1641,39,286,190,209,105,100,40,187,278,333,5576,88,17,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,69,87897553,1892,1681,41,291,196,213,106,101,40,187,278,333,5648,90,18,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,70,96396787,1931,1722,42,295,202,216,107,102,40,187,278,333,5728,91,18,54510,8,3,0.10,2,2),
('red_strider_of_star',16039,71,105212391,1969,1763,44,300,209,220,108,103,40,187,278,333,5948,90,18,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,72,116635633,2006,1804,45,305,215,223,109,104,40,187,278,333,6028,92,18,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,73,130837978,2043,1846,47,310,221,226,110,105,40,187,278,333,6116,93,18,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,74,147995918,2079,1888,48,314,227,230,111,106,40,187,278,333,6200,95,19,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,75,168290997,2114,1929,50,319,234,233,112,107,40,187,278,333,6288,96,19,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,76,191909837,2148,1972,51,323,240,236,113,108,40,187,278,333,6376,98,19,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,77,224471019,2182,2014,53,328,246,240,114,109,40,187,278,333,6468,100,20,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,78,260926132,2214,2057,54,332,252,243,115,110,40,187,278,333,6556,101,20,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,79,301480548,2245,2100,56,337,257,246,116,111,40,187,278,333,6656,103,20,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,80,346344812,2275,2143,57,341,263,249,117,112,40,187,278,333,6748,105,21,54510,9,3,0.10,2,2),
('red_strider_of_star',16039,81,395734658,2304,2187,59,345,268,252,118,113,40,187,278,333,6748,105,21,54510,10,4,0.10,2,2),
('red_strider_of_star',16039,82,429341158,2337,2229,60,350,274,255,119,114,40,187,278,333,6872,107,21,54510,10,4,0.10,2,2),
('red_strider_of_star',16039,83,470064012,2368,2272,62,354,280,258,120,115,40,187,278,333,6952,109,22,54510,10,4,0.10,2,2),
('red_strider_of_star',16039,84,510786866,2399,2315,63,359,285,262,121,116,40,187,278,333,7032,110,22,54510,10,4,0.10,2,2),
('red_strider_of_star',16039,85,551509721,2430,2358,65,363,291,265,122,117,40,187,278,333,7112,112,23,54510,10,4,0.10,2,2),
('red_strider_of_star',16039,86,592232575,2462,2401,67,367,296,268,123,118,40,187,278,333,7192,113,23,54510,10,4,0.10,2,2),
('red_strider_of_twilight',16040,1,0,31,51,0,0,0,8,38,33,40,187,278,333,12,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,2,7,37,60,0,0,0,8,39,34,40,187,278,333,8,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,3,42,45,69,0,0,0,8,40,35,40,187,278,333,12,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,4,140,53,79,0,0,0,9,41,36,40,187,278,333,20,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,5,357,63,89,0,0,0,9,42,37,40,187,278,333,24,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,6,769,73,98,0,0,0,9,43,38,40,187,278,333,32,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,7,1481,85,108,0,0,0,10,44,39,40,187,278,333,36,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,8,2629,98,118,0,0,0,10,45,40,40,187,278,333,44,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,9,4388,113,128,0,0,0,10,46,41,40,187,278,333,48,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,10,6980,128,138,0,0,1,11,47,42,40,187,278,333,56,1,1,54510,2,1,0.10,2,2),
('red_strider_of_twilight',16040,11,10682,146,148,0,0,1,11,48,43,40,187,278,333,60,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,12,15295,157,159,0,0,1,12,49,44,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,13,21417,169,169,0,0,1,12,50,45,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,14,29393,182,180,0,0,1,13,51,46,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,15,39618,195,190,0,1,1,13,52,47,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,16,51729,208,201,0,1,1,13,53,48,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,17,67878,223,212,0,1,1,14,54,49,40,187,278,333,64,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,18,87835,238,223,0,2,2,14,55,50,40,187,278,333,68,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,19,112262,254,234,0,2,2,15,56,51,40,187,278,333,68,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,20,141904,270,245,0,2,2,15,57,52,40,187,278,333,68,1,1,54510,3,1,0.10,2,2),
('red_strider_of_twilight',16040,21,177595,287,262,0,3,2,16,58,53,40,187,278,333,76,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,22,212623,305,279,0,3,2,16,59,54,40,187,278,333,80,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,23,254072,324,296,0,3,3,17,60,55,40,187,278,333,76,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,24,302838,343,314,0,4,3,18,61,56,40,187,278,333,84,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,25,359907,364,331,0,4,3,18,62,57,40,187,278,333,88,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,26,426364,385,349,0,5,3,19,63,58,40,187,278,333,92,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,27,503400,406,367,0,5,4,19,64,59,40,187,278,333,92,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,28,592316,429,385,0,5,4,20,65,60,40,187,278,333,96,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,29,694532,453,403,0,6,4,21,66,61,40,187,278,333,100,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,30,811593,477,421,0,6,5,21,67,62,40,187,278,333,104,1,1,54510,4,2,0.10,2,2),
('red_strider_of_twilight',16040,31,945176,502,440,0,7,5,22,68,63,40,187,278,333,112,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,32,1074521,528,458,0,7,5,22,69,64,40,187,278,333,116,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,33,1220860,554,477,1,8,6,23,70,65,40,187,278,333,124,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,34,1385938,582,496,1,8,6,24,71,66,40,187,278,333,128,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,35,1571632,610,515,1,9,6,25,72,67,40,187,278,333,136,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,36,1625762,639,534,1,9,7,25,73,68,40,187,278,333,144,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,37,1684126,669,553,2,10,7,26,74,69,40,187,278,333,148,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,38,1746916,700,573,2,10,8,27,75,70,40,187,278,333,156,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,39,1814329,731,593,2,11,8,27,76,71,40,187,278,333,164,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,40,1886563,763,612,3,11,9,28,77,72,40,187,278,333,172,1,1,54510,5,2,0.10,2,2),
('red_strider_of_twilight',16040,41,1963819,796,646,3,12,10,29,78,73,40,187,278,333,180,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,42,2046300,830,679,4,12,10,30,79,74,40,187,278,333,188,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,43,2134212,864,713,4,13,11,30,80,75,40,187,278,333,196,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,44,2227762,899,747,4,13,12,31,81,76,40,187,278,333,204,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,45,2327159,935,781,5,14,12,32,82,77,40,187,278,333,212,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,46,2432616,971,816,5,14,13,33,83,78,40,187,278,333,220,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,47,2544345,1008,851,6,15,14,34,84,79,40,187,278,333,228,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,48,2662562,1045,886,6,15,14,34,85,80,40,187,278,333,236,1,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,49,2787485,1084,921,7,16,15,35,86,81,40,187,278,333,248,2,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,50,2919333,1122,957,7,17,16,36,87,82,40,187,278,333,256,2,1,54510,6,2,0.10,2,2),
('red_strider_of_twilight',16040,51,3127822,1161,993,8,17,17,37,88,83,40,187,278,333,264,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,52,3347364,1201,1029,8,18,18,38,89,84,40,187,278,333,276,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,53,3578294,1240,1065,9,18,19,39,90,85,40,187,278,333,284,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,54,3820951,1281,1102,10,19,20,40,91,86,40,187,278,333,296,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,55,4075677,1321,1138,10,19,20,40,92,87,40,187,278,333,308,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,56,4431860,1362,1176,11,20,21,41,93,88,40,187,278,333,316,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,57,4805052,1403,1213,12,21,22,42,94,89,40,187,278,333,328,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,58,5195717,1444,1251,12,21,23,43,95,90,40,187,278,333,340,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,59,5604322,1485,1288,13,22,24,44,96,91,40,187,278,333,352,2,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,60,6031335,1527,1327,14,22,26,45,97,92,40,187,278,333,364,3,1,54510,7,2,0.10,2,2),
('red_strider_of_twilight',16040,61,6700175,1568,1365,14,23,27,46,98,93,40,187,278,333,372,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,62,7398046,1609,1404,15,24,28,47,99,94,40,187,278,333,388,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,63,8125664,1651,1443,16,24,29,47,100,95,40,187,278,333,400,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,64,8883747,1692,1482,16,25,30,48,101,96,40,187,278,333,412,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,65,9673019,1732,1521,17,25,31,49,102,97,40,187,278,333,424,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,66,10767932,1773,1561,18,26,32,50,103,98,40,187,278,333,440,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,67,11906369,1813,1601,19,27,33,51,104,99,40,187,278,333,452,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,68,13089306,1853,1641,19,27,34,52,105,100,40,187,278,333,468,3,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,69,14317725,1892,1681,20,28,36,53,106,101,40,187,278,333,480,4,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,70,15592610,1931,1722,21,28,37,54,107,102,40,187,278,333,496,4,1,54510,8,3,0.10,2,2),
('red_strider_of_twilight',16040,71,16914951,1969,1763,22,29,38,55,108,103,40,187,278,333,456,3,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,72,18628437,2006,1804,22,30,39,55,109,104,40,187,278,333,468,3,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,73,20758789,2043,1846,23,30,40,56,110,105,40,187,278,333,484,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,74,23332480,2079,1888,24,31,41,57,111,106,40,187,278,333,496,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,75,26376742,2114,1929,25,31,42,58,112,107,40,187,278,333,512,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,76,29919568,2148,1972,25,32,44,59,113,108,40,187,278,333,524,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,77,34803745,2182,2014,26,33,45,60,114,109,40,187,278,333,540,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,78,40272012,2214,2057,27,33,46,60,115,110,40,187,278,333,552,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,79,46355175,2245,2100,28,34,47,61,116,111,40,187,278,333,568,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,80,53084814,2275,2143,28,34,48,62,117,112,40,187,278,333,584,4,1,54510,9,3,0.10,2,2),
('red_strider_of_twilight',16040,81,60493291,2304,2187,29,35,49,63,118,113,40,187,278,333,584,4,1,54510,10,4,0.10,2,2),
('red_strider_of_twilight',16040,82,65534266,2337,2229,30,35,50,64,119,114,40,187,278,333,603,4,1,54510,10,4,0.10,2,2),
('red_strider_of_twilight',16040,83,71642694,2368,2272,31,36,51,64,120,115,40,187,278,333,616,4,1,54510,10,4,0.10,2,2),
('red_strider_of_twilight',16040,84,77751122,2399,2315,31,36,52,65,121,116,40,187,278,333,629,4,1,54510,10,4,0.10,2,2),
('red_strider_of_twilight',16040,85,83859550,2430,2358,32,37,53,66,122,117,40,187,278,333,642,4,1,54510,10,4,0.10,2,2),
('red_strider_of_twilight',16040,86,89967979,2462,2401,33,38,54,67,123,118,40,187,278,333,655,4,1,54510,10,4,0.10,2,2);

INSERT INTO `pets_stats` VALUES
('baby_buffalo',12780,1,1,21,17,1,1,1,9,38,33,40,132,282,333,12,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,2,125001,25,20,1,1,1,9,39,34,40,132,282,333,8,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,3,250001,30,23,1,1,1,9,40,35,40,132,282,333,12,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,4,375001,36,26,1,1,1,11,41,36,40,132,282,333,20,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,5,500001,42,29,1,1,1,11,42,37,40,132,282,333,24,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,6,625001,49,33,1,1,1,11,43,38,40,132,282,333,32,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,7,750001,57,36,1,1,1,12,44,39,40,132,282,333,36,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,8,875001,65,39,1,1,1,12,45,40,40,132,282,333,44,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,9,1000001,75,42,1,1,1,13,46,41,40,132,282,333,48,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,10,1125001,85,46,1,1,1,14,47,42,40,132,282,333,56,1,1,54510,6,3,0.30,1,1),
('baby_buffalo',12780,11,1250001,97,49,1,1,1,14,48,43,40,132,282,333,60,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,12,1375001,104,53,1,1,1,16,49,44,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,13,1500001,112,56,1,1,1,16,50,45,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,14,1625001,120,60,1,1,1,17,51,46,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,15,1750001,129,63,1,1,1,17,52,47,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,16,1875001,138,67,1,1,1,17,53,48,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,17,2000001,147,70,1,1,1,19,54,49,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,18,2125001,157,74,1,2,2,19,55,50,40,132,282,333,68,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,19,2250001,168,77,1,2,2,21,56,51,40,132,282,333,68,1,1,54510,8,4,0.30,1,1),
('baby_buffalo',12780,20,2375001,179,81,1,2,2,21,57,52,40,132,282,333,68,1,1,54510,8,4,0.10,1,1),
('baby_buffalo',12780,21,2500001,190,87,1,3,2,23,58,53,40,132,282,333,76,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,22,2625001,202,92,1,3,2,23,59,54,40,132,282,333,80,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,23,2750001,214,98,1,3,2,24,60,55,40,132,282,333,76,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,24,2875001,227,104,1,5,3,26,61,56,40,132,282,333,84,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,25,3000001,240,109,1,5,3,26,62,57,40,132,282,333,88,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,26,3125001,254,115,1,6,3,28,63,58,40,132,282,333,92,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,27,3250001,269,121,1,6,4,28,64,59,40,132,282,333,92,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,28,3375001,284,127,1,6,4,30,65,60,40,132,282,333,96,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,29,3500001,299,133,1,7,4,32,66,61,40,132,282,333,100,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,30,3625001,315,139,1,7,5,32,67,62,40,132,282,333,104,1,1,54510,11,5,0.10,1,1),
('baby_buffalo',12780,31,3750001,331,145,1,8,5,34,68,63,40,132,282,333,112,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,32,3875001,349,151,1,8,5,34,69,64,40,132,282,333,116,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,33,4000001,366,158,1,10,6,36,70,65,40,132,282,333,124,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,34,4125001,384,164,1,10,6,38,71,66,40,132,282,333,128,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,35,4250001,403,170,1,11,6,40,72,67,40,132,282,333,136,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,36,4375001,422,176,2,11,7,40,73,68,40,132,282,333,144,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,37,4500001,442,183,3,13,7,42,74,69,40,132,282,333,148,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,38,4625001,462,189,3,13,8,44,75,70,40,132,282,333,156,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,39,4750001,483,196,3,14,9,44,76,71,40,132,282,333,164,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,40,4875001,504,202,5,14,10,46,77,72,40,132,282,333,172,1,1,54510,14,5,0.10,1,1),
('baby_buffalo',12780,41,5000001,526,213,5,16,11,48,78,73,40,132,282,333,180,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,42,5125001,548,224,6,16,11,50,79,74,40,132,282,333,188,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,43,5250001,571,235,6,17,13,51,80,75,40,132,282,333,196,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,44,5375001,594,247,6,17,14,53,81,76,40,132,282,333,204,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,45,5500001,617,258,8,19,14,55,82,77,40,132,282,333,212,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,46,5625001,641,269,8,19,16,57,83,78,40,132,282,333,220,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,47,5750001,666,281,10,20,17,59,84,79,40,132,282,333,228,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,48,5875001,690,292,10,21,17,60,85,80,40,132,282,333,236,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,49,6000001,715,304,12,22,19,62,86,81,40,132,282,333,248,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,50,6125001,741,316,12,24,20,64,87,82,40,132,282,333,256,1,1,54510,17,6,0.10,1,1),
('baby_buffalo',12780,51,6250001,767,328,13,24,22,66,88,83,40,132,282,333,264,1,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,52,6375001,793,340,14,25,23,69,89,84,40,132,282,333,276,1,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,53,6500001,819,352,15,26,25,71,90,85,40,132,282,333,284,1,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,54,6625001,846,364,17,27,27,73,91,86,40,132,282,333,296,1,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,55,6750001,872,376,17,27,27,74,92,87,40,132,282,333,308,2,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,56,6875001,899,388,19,29,29,76,93,88,40,132,282,333,316,2,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,57,7000001,926,400,21,31,31,78,94,89,40,132,282,333,328,2,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,58,7125001,954,413,21,31,33,81,95,90,40,132,282,333,340,2,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,59,7250001,981,425,23,33,34,83,96,91,40,132,282,333,352,2,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,60,7375001,1008,438,25,33,38,86,97,92,40,132,282,333,364,2,1,54510,20,7,0.10,1,1),
('baby_buffalo',12780,61,7500001,1035,451,25,35,40,88,98,93,40,132,282,333,372,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,62,7625001,1063,463,27,36,42,91,99,94,40,132,282,333,388,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,63,7750001,1090,476,29,36,44,91,100,95,40,132,282,333,400,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,64,7875001,1117,489,29,38,46,94,101,96,40,132,282,333,412,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,65,8000001,1144,502,31,39,48,97,102,97,40,132,282,333,424,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,66,8125001,1170,515,33,40,50,99,103,98,40,132,282,333,440,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,67,8250001,1197,528,36,42,53,102,104,99,40,132,282,333,452,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,68,8375001,1223,542,36,42,55,104,105,100,40,132,282,333,468,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,69,8500001,1249,555,38,44,59,107,106,101,40,132,282,333,480,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,70,8625001,1275,568,40,45,61,110,107,102,40,132,282,333,496,2,1,54510,23,8,0.10,1,1),
('baby_buffalo',12780,71,8750001,1300,582,42,46,64,113,108,103,40,132,282,333,456,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,72,8875001,1325,596,43,48,66,113,109,104,40,132,282,333,468,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,73,9000001,1349,609,45,49,69,116,110,105,40,132,282,333,484,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,74,9125001,1372,623,47,51,71,119,111,106,40,132,282,333,496,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,75,9250001,1396,637,49,51,74,122,112,107,40,132,282,333,512,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,76,9375001,1418,651,50,53,79,125,113,108,40,132,282,333,524,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,77,9500001,1440,665,52,55,81,127,114,109,40,132,282,333,540,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,78,9625001,1462,679,54,55,84,128,115,110,40,132,282,333,552,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,79,9750001,1482,693,56,57,87,131,116,111,40,132,282,333,568,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,80,9875001,1502,707,57,57,90,134,117,112,40,132,282,333,584,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,81,10000001,1521,722,59,60,93,137,118,113,40,132,282,333,584,2,1,54510,26,9,0.10,1,1),
('baby_buffalo',12780,82,10125001,1543,736,61,60,96,139,119,114,40,132,282,333,603,2,1,54510,29,10,0.10,1,1),
('baby_buffalo',12780,83,10250001,1564,750,63,62,99,141,120,115,40,132,282,333,616,2,1,54510,29,10,0.10,1,1),
('baby_buffalo',12780,84,10375001,1584,764,64,63,101,144,121,116,40,132,282,333,629,2,1,54510,29,10,0.10,1,1),
('baby_buffalo',12780,85,10500001,1605,778,66,64,104,146,122,117,40,132,282,333,642,2,1,54510,29,10,0.10,1,1),
('baby_buffalo',12780,86,10625001,1625,792,68,65,107,148,123,118,40,132,282,333,655,2,1,54510,29,10,0.10,1,1),
('baby_kookaburra',12781,1,1,21,17,1,1,1,9,38,33,40,132,282,333,12,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,2,125001,25,20,1,1,1,9,39,34,40,132,282,333,8,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,3,250001,30,23,1,1,1,9,40,35,40,132,282,333,12,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,4,375001,36,26,1,1,1,11,41,36,40,132,282,333,20,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,5,500001,42,29,1,1,1,11,42,37,40,132,282,333,24,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,6,625001,49,33,1,1,1,11,43,38,40,132,282,333,32,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,7,750001,57,36,1,1,1,12,44,39,40,132,282,333,36,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,8,875001,65,39,1,1,1,12,45,40,40,132,282,333,44,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,9,1000001,75,42,1,1,1,13,46,41,40,132,282,333,48,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,10,1125001,85,46,1,1,1,14,47,42,40,132,282,333,56,1,1,54510,6,3,0.30,1,1),
('baby_kookaburra',12781,11,1250001,97,49,1,1,1,14,48,43,40,132,282,333,60,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,12,1375001,104,53,1,1,1,16,49,44,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,13,1500001,112,56,1,1,1,16,50,45,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,14,1625001,120,60,1,1,1,17,51,46,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,15,1750001,129,63,1,1,1,17,52,47,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,16,1875001,138,67,1,1,1,17,53,48,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,17,2000001,147,70,1,1,1,19,54,49,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,18,2125001,157,74,1,2,2,19,55,50,40,132,282,333,68,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,19,2250001,168,77,1,2,2,21,56,51,40,132,282,333,68,1,1,54510,8,4,0.30,1,1),
('baby_kookaburra',12781,20,2375001,179,81,1,2,2,21,57,52,40,132,282,333,68,1,1,54510,8,4,0.10,1,1),
('baby_kookaburra',12781,21,2500001,190,87,1,3,2,23,58,53,40,132,282,333,76,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,22,2625001,202,92,1,3,2,23,59,54,40,132,282,333,80,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,23,2750001,214,98,1,3,2,24,60,55,40,132,282,333,76,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,24,2875001,227,104,1,5,3,26,61,56,40,132,282,333,84,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,25,3000001,240,109,1,5,3,26,62,57,40,132,282,333,88,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,26,3125001,254,115,1,6,3,28,63,58,40,132,282,333,92,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,27,3250001,269,121,1,6,4,28,64,59,40,132,282,333,92,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,28,3375001,284,127,1,6,4,30,65,60,40,132,282,333,96,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,29,3500001,299,133,1,7,4,32,66,61,40,132,282,333,100,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,30,3625001,315,139,1,7,5,32,67,62,40,132,282,333,104,1,1,54510,11,5,0.10,1,1),
('baby_kookaburra',12781,31,3750001,331,145,1,8,5,34,68,63,40,132,282,333,112,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,32,3875001,349,151,1,8,5,34,69,64,40,132,282,333,116,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,33,4000001,366,158,1,10,6,36,70,65,40,132,282,333,124,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,34,4125001,384,164,1,10,6,38,71,66,40,132,282,333,128,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,35,4250001,403,170,1,11,6,40,72,67,40,132,282,333,136,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,36,4375001,422,176,2,11,7,40,73,68,40,132,282,333,144,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,37,4500001,442,183,3,13,7,42,74,69,40,132,282,333,148,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,38,4625001,462,189,3,13,8,44,75,70,40,132,282,333,156,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,39,4750001,483,196,3,14,9,44,76,71,40,132,282,333,164,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,40,4875001,504,202,5,14,10,46,77,72,40,132,282,333,172,1,1,54510,14,5,0.10,1,1),
('baby_kookaburra',12781,41,5000001,526,213,5,16,11,48,78,73,40,132,282,333,180,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,42,5125001,548,224,6,16,11,50,79,74,40,132,282,333,188,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,43,5250001,571,235,6,17,13,51,80,75,40,132,282,333,196,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,44,5375001,594,247,6,17,14,53,81,76,40,132,282,333,204,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,45,5500001,617,258,8,19,14,55,82,77,40,132,282,333,212,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,46,5625001,641,269,8,19,16,57,83,78,40,132,282,333,220,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,47,5750001,666,281,10,20,17,59,84,79,40,132,282,333,228,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,48,5875001,690,292,10,21,17,60,85,80,40,132,282,333,236,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,49,6000001,715,304,12,22,19,62,86,81,40,132,282,333,248,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,50,6125001,741,316,12,24,20,64,87,82,40,132,282,333,256,1,1,54510,17,6,0.10,1,1),
('baby_kookaburra',12781,51,6250001,767,328,13,24,22,66,88,83,40,132,282,333,264,1,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,52,6375001,793,340,14,25,23,69,89,84,40,132,282,333,276,1,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,53,6500001,819,352,15,26,25,71,90,85,40,132,282,333,284,1,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,54,6625001,846,364,17,27,27,73,91,86,40,132,282,333,296,1,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,55,6750001,872,376,17,27,27,74,92,87,40,132,282,333,308,2,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,56,6875001,899,388,19,29,29,76,93,88,40,132,282,333,316,2,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,57,7000001,926,400,21,31,31,78,94,89,40,132,282,333,328,2,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,58,7125001,954,413,21,31,33,81,95,90,40,132,282,333,340,2,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,59,7250001,981,425,23,33,34,83,96,91,40,132,282,333,352,2,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,60,7375001,1008,438,25,33,38,86,97,92,40,132,282,333,364,2,1,54510,20,7,0.10,1,1),
('baby_kookaburra',12781,61,7500001,1035,451,25,35,40,88,98,93,40,132,282,333,372,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,62,7625001,1063,463,27,36,42,91,99,94,40,132,282,333,388,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,63,7750001,1090,476,29,36,44,91,100,95,40,132,282,333,400,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,64,7875001,1117,489,29,38,46,94,101,96,40,132,282,333,412,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,65,8000001,1144,502,31,39,48,97,102,97,40,132,282,333,424,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,66,8125001,1170,515,33,40,50,99,103,98,40,132,282,333,440,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,67,8250001,1197,528,36,42,53,102,104,99,40,132,282,333,452,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,68,8375001,1223,542,36,42,55,104,105,100,40,132,282,333,468,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,69,8500001,1249,555,38,44,59,107,106,101,40,132,282,333,480,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,70,8625001,1275,568,40,45,61,110,107,102,40,132,282,333,496,2,1,54510,23,8,0.10,1,1),
('baby_kookaburra',12781,71,8750001,1300,582,42,46,64,113,108,103,40,132,282,333,456,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,72,8875001,1325,596,43,48,66,113,109,104,40,132,282,333,468,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,73,9000001,1349,609,45,49,69,116,110,105,40,132,282,333,484,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,74,9125001,1372,623,47,51,71,119,111,106,40,132,282,333,496,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,75,9250001,1396,637,49,51,74,122,112,107,40,132,282,333,512,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,76,9375001,1418,651,50,53,79,125,113,108,40,132,282,333,524,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,77,9500001,1440,665,52,55,81,127,114,109,40,132,282,333,540,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,78,9625001,1462,679,54,55,84,128,115,110,40,132,282,333,552,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,79,9750001,1482,693,56,57,87,131,116,111,40,132,282,333,568,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,80,9875001,1502,707,57,57,90,134,117,112,40,132,282,333,584,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,81,10000001,1521,722,59,60,93,137,118,113,40,132,282,333,584,2,1,54510,26,9,0.10,1,1),
('baby_kookaburra',12781,82,10125001,1543,736,61,60,96,139,119,114,40,132,282,333,603,2,1,54510,29,10,0.10,1,1),
('baby_kookaburra',12781,83,10250001,1564,750,63,62,99,141,120,115,40,132,282,333,616,2,1,54510,29,10,0.10,1,1),
('baby_kookaburra',12781,84,10375001,1584,764,64,63,101,144,121,116,40,132,282,333,629,2,1,54510,29,10,0.10,1,1),
('baby_kookaburra',12781,85,10500001,1605,778,66,64,104,146,122,117,40,132,282,333,642,2,1,54510,29,10,0.10,1,1),
('baby_kookaburra',12781,86,10625001,1625,792,68,65,107,148,123,118,40,132,282,333,655,2,1,54510,29,10,0.10,1,1),
('baby_cougar',12782,1,1,21,17,1,1,1,9,38,33,40,132,282,333,12,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,2,125001,25,20,1,1,1,9,39,34,40,132,282,333,8,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,3,250001,30,23,1,1,1,9,40,35,40,132,282,333,12,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,4,375001,36,26,1,1,1,11,41,36,40,132,282,333,20,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,5,500001,42,29,1,1,1,11,42,37,40,132,282,333,24,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,6,625001,49,33,1,1,1,11,43,38,40,132,282,333,32,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,7,750001,57,36,1,1,1,12,44,39,40,132,282,333,36,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,8,875001,65,39,1,1,1,12,45,40,40,132,282,333,44,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,9,1000001,75,42,1,1,1,13,46,41,40,132,282,333,48,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,10,1125001,85,46,1,1,1,14,47,42,40,132,282,333,56,1,1,54510,6,3,0.30,1,1),
('baby_cougar',12782,11,1250001,97,49,1,1,1,14,48,43,40,132,282,333,60,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,12,1375001,104,53,1,1,1,16,49,44,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,13,1500001,112,56,1,1,1,16,50,45,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,14,1625001,120,60,1,1,1,17,51,46,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,15,1750001,129,63,1,1,1,17,52,47,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,16,1875001,138,67,1,1,1,17,53,48,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,17,2000001,147,70,1,1,1,19,54,49,40,132,282,333,64,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,18,2125001,157,74,1,2,2,19,55,50,40,132,282,333,68,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,19,2250001,168,77,1,2,2,21,56,51,40,132,282,333,68,1,1,54510,8,4,0.30,1,1),
('baby_cougar',12782,20,2375001,179,81,1,2,2,21,57,52,40,132,282,333,68,1,1,54510,8,4,0.10,1,1),
('baby_cougar',12782,21,2500001,190,87,1,3,2,23,58,53,40,132,282,333,76,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,22,2625001,202,92,1,3,2,23,59,54,40,132,282,333,80,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,23,2750001,214,98,1,3,2,24,60,55,40,132,282,333,76,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,24,2875001,227,104,1,5,3,26,61,56,40,132,282,333,84,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,25,3000001,240,109,1,5,3,26,62,57,40,132,282,333,88,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,26,3125001,254,115,1,6,3,28,63,58,40,132,282,333,92,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,27,3250001,269,121,1,6,4,28,64,59,40,132,282,333,92,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,28,3375001,284,127,1,6,4,30,65,60,40,132,282,333,96,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,29,3500001,299,133,1,7,4,32,66,61,40,132,282,333,100,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,30,3625001,315,139,1,7,5,32,67,62,40,132,282,333,104,1,1,54510,11,5,0.10,1,1),
('baby_cougar',12782,31,3750001,331,145,1,8,5,34,68,63,40,132,282,333,112,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,32,3875001,349,151,1,8,5,34,69,64,40,132,282,333,116,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,33,4000001,366,158,1,10,6,36,70,65,40,132,282,333,124,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,34,4125001,384,164,1,10,6,38,71,66,40,132,282,333,128,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,35,4250001,403,170,1,11,6,40,72,67,40,132,282,333,136,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,36,4375001,422,176,2,11,7,40,73,68,40,132,282,333,144,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,37,4500001,442,183,3,13,7,42,74,69,40,132,282,333,148,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,38,4625001,462,189,3,13,8,44,75,70,40,132,282,333,156,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,39,4750001,483,196,3,14,9,44,76,71,40,132,282,333,164,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,40,4875001,504,202,5,14,10,46,77,72,40,132,282,333,172,1,1,54510,14,5,0.10,1,1),
('baby_cougar',12782,41,5000001,526,213,5,16,11,48,78,73,40,132,282,333,180,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,42,5125001,548,224,6,16,11,50,79,74,40,132,282,333,188,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,43,5250001,571,235,6,17,13,51,80,75,40,132,282,333,196,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,44,5375001,594,247,6,17,14,53,81,76,40,132,282,333,204,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,45,5500001,617,258,8,19,14,55,82,77,40,132,282,333,212,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,46,5625001,641,269,8,19,16,57,83,78,40,132,282,333,220,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,47,5750001,666,281,10,20,17,59,84,79,40,132,282,333,228,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,48,5875001,690,292,10,21,17,60,85,80,40,132,282,333,236,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,49,6000001,715,304,12,22,19,62,86,81,40,132,282,333,248,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,50,6125001,741,316,12,24,20,64,87,82,40,132,282,333,256,1,1,54510,17,6,0.10,1,1),
('baby_cougar',12782,51,6250001,767,328,13,24,22,66,88,83,40,132,282,333,264,1,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,52,6375001,793,340,14,25,23,69,89,84,40,132,282,333,276,1,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,53,6500001,819,352,15,26,25,71,90,85,40,132,282,333,284,1,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,54,6625001,846,364,17,27,27,73,91,86,40,132,282,333,296,1,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,55,6750001,872,376,17,27,27,74,92,87,40,132,282,333,308,2,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,56,6875001,899,388,19,29,29,76,93,88,40,132,282,333,316,2,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,57,7000001,926,400,21,31,31,78,94,89,40,132,282,333,328,2,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,58,7125001,954,413,21,31,33,81,95,90,40,132,282,333,340,2,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,59,7250001,981,425,23,33,34,83,96,91,40,132,282,333,352,2,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,60,7375001,1008,438,25,33,38,86,97,92,40,132,282,333,364,2,1,54510,20,7,0.10,1,1),
('baby_cougar',12782,61,7500001,1035,451,25,35,40,88,98,93,40,132,282,333,372,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,62,7625001,1063,463,27,36,42,91,99,94,40,132,282,333,388,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,63,7750001,1090,476,29,36,44,91,100,95,40,132,282,333,400,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,64,7875001,1117,489,29,38,46,94,101,96,40,132,282,333,412,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,65,8000001,1144,502,31,39,48,97,102,97,40,132,282,333,424,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,66,8125001,1170,515,33,40,50,99,103,98,40,132,282,333,440,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,67,8250001,1197,528,36,42,53,102,104,99,40,132,282,333,452,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,68,8375001,1223,542,36,42,55,104,105,100,40,132,282,333,468,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,69,8500001,1249,555,38,44,59,107,106,101,40,132,282,333,480,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,70,8625001,1275,568,40,45,61,110,107,102,40,132,282,333,496,2,1,54510,23,8,0.10,1,1),
('baby_cougar',12782,71,8750001,1300,582,42,46,64,113,108,103,40,132,282,333,456,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,72,8875001,1325,596,43,48,66,113,109,104,40,132,282,333,468,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,73,9000001,1349,609,45,49,69,116,110,105,40,132,282,333,484,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,74,9125001,1372,623,47,51,71,119,111,106,40,132,282,333,496,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,75,9250001,1396,637,49,51,74,122,112,107,40,132,282,333,512,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,76,9375001,1418,651,50,53,79,125,113,108,40,132,282,333,524,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,77,9500001,1440,665,52,55,81,127,114,109,40,132,282,333,540,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,78,9625001,1462,679,54,55,84,128,115,110,40,132,282,333,552,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,79,9750001,1482,693,56,57,87,131,116,111,40,132,282,333,568,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,80,9875001,1502,707,57,57,90,134,117,112,40,132,282,333,584,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,81,10000001,1521,722,59,60,93,137,118,113,40,132,282,333,584,2,1,54510,26,9,0.10,1,1),
('baby_cougar',12782,82,10125001,1543,736,61,60,96,139,119,114,40,132,282,333,603,2,1,54510,29,10,0.10,1,1),
('baby_cougar',12782,83,10250001,1564,750,63,62,99,141,120,115,40,132,282,333,616,2,1,54510,29,10,0.10,1,1),
('baby_cougar',12782,84,10375001,1584,764,64,63,101,144,121,116,40,132,282,333,629,2,1,54510,29,10,0.10,1,1),
('baby_cougar',12782,85,10500001,1605,778,66,64,104,146,122,117,40,132,282,333,642,2,1,54510,29,10,0.10,1,1),
('baby_cougar',12782,86,10625001,1625,792,68,65,107,148,123,118,40,132,282,333,655,2,1,54510,29,10,0.10,1,1);

INSERT INTO `pets_stats` VALUES
('improved_baby_buffalo',16034,55,10000001,1521,722,59,60,93,137,118,113,40,137,278,333,584,2,1,54510,20,7,0.35,1,1),
('improved_baby_buffalo',16034,56,10180001,1567,744,65,64,99,141,119,114,40,137,278,333,606,2,1,54510,20,7,0.35,1,1),
('improved_baby_buffalo',16034,57,10363241,1614,769,65,64,105,146,120,115,40,137,278,333,628,2,1,54510,20,7,0.35,1,1),
('improved_baby_buffalo',16034,58,10549779,1659,791,71,68,108,150,121,116,40,137,278,333,650,2,1,54510,20,7,0.35,1,1),
('improved_baby_buffalo',16034,59,10729125,1705,816,77,68,121,155,122,117,40,137,278,333,672,2,1,54510,20,7,0.35,1,1),
('improved_baby_buffalo',16034,60,10911520,1751,840,77,72,127,159,123,118,40,137,278,333,687,2,1,54510,20,7,0.35,1,1),
('improved_baby_buffalo',16034,61,11097016,1798,863,83,74,133,164,124,119,40,137,278,333,717,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,62,11274568,1843,887,89,74,139,164,125,120,40,137,278,333,739,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,63,11454961,1889,911,89,78,145,169,126,121,40,137,278,333,761,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,64,11638240,1934,936,95,80,151,174,127,122,40,137,278,333,783,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,65,11824452,1978,960,101,82,157,178,128,123,40,137,278,333,813,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,66,12001819,2023,984,110,86,166,183,129,124,40,137,278,333,835,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,67,12181846,2068,1011,110,86,172,187,130,125,40,137,278,333,864,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,68,12364574,2111,1035,116,90,185,192,131,126,40,137,278,333,886,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,69,12550043,2155,1059,122,92,191,197,132,127,40,137,278,333,915,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,70,12725744,2198,1085,128,94,200,202,133,128,40,137,278,333,841,2,1,54510,23,8,0.35,1,1),
('improved_baby_buffalo',16034,71,12903904,2240,1111,131,98,206,202,134,129,40,137,278,333,863,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,72,13084559,2280,1135,137,100,215,207,135,130,40,137,278,333,892,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,73,13267743,2319,1161,143,104,221,212,136,131,40,137,278,333,914,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,74,13453491,2358,1187,149,104,230,217,137,132,40,137,278,333,943,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,75,13641840,2396,1213,152,108,246,222,138,133,40,137,278,333,965,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,76,13819184,2434,1240,158,112,252,226,139,134,40,137,278,333,995,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,77,13998833,2471,1266,164,112,261,228,140,135,40,137,278,333,1017,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,78,14180818,2506,1293,170,116,270,233,141,136,40,137,278,333,1046,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,79,14365169,2539,1320,173,116,279,238,142,137,40,137,278,333,1075,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,80,14551916,2572,1348,179,122,288,243,143,138,40,137,278,333,1105,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,81,14741091,2603,1376,185,122,298,248,144,139,40,137,278,333,1136,2,1,54510,26,9,0.35,1,1),
('improved_baby_buffalo',16034,82,14932725,2634,1405,191,126,308,253,145,140,40,137,278,333,1167,2,1,54510,29,10,0.35,1,1),
('improved_baby_buffalo',16034,83,15126850,2663,1433,198,131,318,259,146,141,40,137,278,333,1199,2,1,54510,29,10,0.35,1,1),
('improved_baby_buffalo',16034,84,15323499,2692,1462,205,136,328,265,147,142,40,137,278,333,1230,2,1,54510,29,10,0.35,1,1),
('improved_baby_buffalo',16034,85,15522704,2722,1491,212,141,339,271,148,143,40,137,278,333,1261,2,1,54510,29,10,0.35,1,1),
('improved_baby_buffalo',16034,86,15724499,2752,1521,219,146,350,277,149,144,40,137,278,333,1293,2,1,54510,29,10,0.35,1,1),
('improved_baby_kookaburra',16035,55,10000001,1521,722,59,60,93,137,118,113,40,137,278,333,584,2,1,54510,20,7,0.35,1,1),
('improved_baby_kookaburra',16035,56,10180001,1567,744,65,64,99,141,119,114,40,137,278,333,606,2,1,54510,20,7,0.35,1,1),
('improved_baby_kookaburra',16035,57,10363241,1614,769,65,64,105,146,120,115,40,137,278,333,628,2,1,54510,20,7,0.35,1,1),
('improved_baby_kookaburra',16035,58,10549779,1659,791,71,68,108,150,121,116,40,137,278,333,650,2,1,54510,20,7,0.35,1,1),
('improved_baby_kookaburra',16035,59,10729125,1705,816,77,68,121,155,122,117,40,137,278,333,672,2,1,54510,20,7,0.35,1,1),
('improved_baby_kookaburra',16035,60,10911520,1751,840,77,72,127,159,123,118,40,137,278,333,687,2,1,54510,20,7,0.35,1,1),
('improved_baby_kookaburra',16035,61,11097016,1798,863,83,74,133,164,124,119,40,137,278,333,717,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,62,11274568,1843,887,89,74,139,164,125,120,40,137,278,333,739,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,63,11454961,1889,911,89,78,145,169,126,121,40,137,278,333,761,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,64,11638240,1934,936,95,80,151,174,127,122,40,137,278,333,783,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,65,11824452,1978,960,101,82,157,178,128,123,40,137,278,333,813,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,66,12001819,2023,984,110,86,166,183,129,124,40,137,278,333,835,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,67,12181846,2068,1011,110,86,172,187,130,125,40,137,278,333,864,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,68,12364574,2111,1035,116,90,185,192,131,126,40,137,278,333,886,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,69,12550043,2155,1059,122,92,191,197,132,127,40,137,278,333,915,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,70,12725744,2198,1085,128,94,200,202,133,128,40,137,278,333,841,2,1,54510,23,8,0.35,1,1),
('improved_baby_kookaburra',16035,71,12903904,2240,1111,131,98,206,202,134,129,40,137,278,333,863,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,72,13084559,2280,1135,137,100,215,207,135,130,40,137,278,333,892,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,73,13267743,2319,1161,143,104,221,212,136,131,40,137,278,333,914,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,74,13453491,2358,1187,149,104,230,217,137,132,40,137,278,333,943,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,75,13641840,2396,1213,152,108,246,222,138,133,40,137,278,333,965,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,76,13819184,2434,1240,158,112,252,226,139,134,40,137,278,333,995,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,77,13998833,2471,1266,164,112,261,228,140,135,40,137,278,333,1017,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,78,14180818,2506,1293,170,116,270,233,141,136,40,137,278,333,1046,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,79,14365169,2539,1320,173,116,279,238,142,137,40,137,278,333,1075,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,80,14551916,2572,1348,179,122,288,243,143,138,40,137,278,333,1105,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,81,14741091,2603,1376,185,122,298,248,144,139,40,137,278,333,1136,2,1,54510,26,9,0.35,1,1),
('improved_baby_kookaburra',16035,82,14932725,2634,1405,191,126,308,253,145,140,40,137,278,333,1167,2,1,54510,29,10,0.35,1,1),
('improved_baby_kookaburra',16035,83,15126850,2663,1433,198,131,318,259,146,141,40,137,278,333,1199,2,1,54510,29,10,0.35,1,1),
('improved_baby_kookaburra',16035,84,15323499,2692,1462,205,136,328,265,147,142,40,137,278,333,1230,2,1,54510,29,10,0.35,1,1),
('improved_baby_kookaburra',16035,85,15522704,2722,1491,212,141,339,271,148,143,40,137,278,333,1261,2,1,54510,29,10,0.35,1,1),
('improved_baby_kookaburra',16035,86,15724499,2752,1521,219,146,350,277,149,144,40,137,278,333,1293,2,1,54510,29,10,0.35,1,1),
('improved_baby_cougar',16036,55,10000001,1521,722,59,60,93,137,118,113,40,137,278,333,584,2,1,54510,20,7,0.35,1,1),
('improved_baby_cougar',16036,56,10180001,1567,744,65,64,99,141,119,114,40,137,278,333,606,2,1,54510,20,7,0.35,1,1),
('improved_baby_cougar',16036,57,10363241,1614,769,65,64,105,146,120,115,40,137,278,333,628,2,1,54510,20,7,0.35,1,1),
('improved_baby_cougar',16036,58,10549779,1659,791,71,68,108,150,121,116,40,137,278,333,650,2,1,54510,20,7,0.35,1,1),
('improved_baby_cougar',16036,59,10729125,1705,816,77,68,121,155,122,117,40,137,278,333,672,2,1,54510,20,7,0.35,1,1),
('improved_baby_cougar',16036,60,10911520,1751,840,77,72,127,159,123,118,40,137,278,333,687,2,1,54510,20,7,0.35,1,1),
('improved_baby_cougar',16036,61,11097016,1798,863,83,74,133,164,124,119,40,137,278,333,717,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,62,11274568,1843,887,89,74,139,164,125,120,40,137,278,333,739,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,63,11454961,1889,911,89,78,145,169,126,121,40,137,278,333,761,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,64,11638240,1934,936,95,80,151,174,127,122,40,137,278,333,783,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,65,11824452,1978,960,101,82,157,178,128,123,40,137,278,333,813,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,66,12001819,2023,984,110,86,166,183,129,124,40,137,278,333,835,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,67,12181846,2068,1011,110,86,172,187,130,125,40,137,278,333,864,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,68,12364574,2111,1035,116,90,185,192,131,126,40,137,278,333,886,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,69,12550043,2155,1059,122,92,191,197,132,127,40,137,278,333,915,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,70,12725744,2198,1085,128,94,200,202,133,128,40,137,278,333,841,2,1,54510,23,8,0.35,1,1),
('improved_baby_cougar',16036,71,12903904,2240,1111,131,98,206,202,134,129,40,137,278,333,863,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,72,13084559,2280,1135,137,100,215,207,135,130,40,137,278,333,892,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,73,13267743,2319,1161,143,104,221,212,136,131,40,137,278,333,914,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,74,13453491,2358,1187,149,104,230,217,137,132,40,137,278,333,943,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,75,13641840,2396,1213,152,108,246,222,138,133,40,137,278,333,965,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,76,13819184,2434,1240,158,112,252,226,139,134,40,137,278,333,995,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,77,13998833,2471,1266,164,112,261,228,140,135,40,137,278,333,1017,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,78,14180818,2506,1293,170,116,270,233,141,136,40,137,278,333,1046,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,79,14365169,2539,1320,173,116,279,238,142,137,40,137,278,333,1075,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,80,14551916,2572,1348,179,122,288,243,143,138,40,137,278,333,1105,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,81,14741091,2603,1376,185,122,298,248,144,139,40,137,278,333,1136,2,1,54510,26,9,0.35,1,1),
('improved_baby_cougar',16036,82,14932725,2634,1405,191,126,308,253,145,140,40,137,278,333,1167,2,1,54510,29,10,0.35,1,1),
('improved_baby_cougar',16036,83,15126850,2663,1433,198,131,318,259,146,141,40,137,278,333,1199,2,1,54510,29,10,0.35,1,1),
('improved_baby_cougar',16036,84,15323499,2692,1462,205,136,328,265,147,142,40,137,278,333,1230,2,1,54510,29,10,0.35,1,1),
('improved_baby_cougar',16036,85,15522704,2722,1491,212,141,339,271,148,143,40,137,278,333,1261,2,1,54510,29,10,0.35,1,1),
('improved_baby_cougar',16036,86,15724499,2752,1521,219,146,350,277,149,144,40,137,278,333,1293,2,1,54510,29,10,0.35,1,1);

INSERT INTO `pets_stats` VALUES
('sin_eater',12564,1,55101,31,26,1,11,1,8,38,33,40,137,282,333,124,2,2,54510,2,1,1.00,2,2),
('sin_eater',12564,2,112582,38,30,1,11,1,8,39,34,40,137,282,333,122,2,2,54510,2,1,1.00,2,2),
('sin_eater',12564,3,172475,45,35,1,11,1,8,40,35,40,137,282,333,160,2,2,54510,2,1,1.00,2,2),
('sin_eater',12564,4,234758,54,40,1,12,1,9,41,36,40,137,282,333,200,3,2,54510,2,1,1.00,2,2),
('sin_eater',12564,5,299344,63,45,1,12,1,9,42,37,40,137,282,333,256,4,2,54510,2,1,1.00,2,2),
('sin_eater',12564,6,367190,74,49,1,13,1,9,43,38,40,137,282,333,312,5,2,54510,2,1,1.00,2,2),
('sin_eater',12564,7,438670,86,54,1,13,1,10,44,39,40,137,282,333,352,5,2,54510,2,1,1.00,2,2),
('sin_eater',12564,8,514414,99,59,1,14,1,10,45,40,40,137,282,333,404,6,2,54510,2,1,1.00,2,2),
('sin_eater',12564,9,595594,113,64,1,14,1,10,46,41,40,137,282,333,436,7,2,54510,2,1,1.00,2,2),
('sin_eater',12564,10,684022,129,69,1,15,1,11,47,42,40,137,282,333,474,7,2,54510,2,1,1.00,2,2),
('sin_eater',12564,11,776403,146,74,1,16,1,11,48,43,40,137,282,333,580,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,12,872662,158,80,1,16,1,12,49,44,40,137,282,333,584,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,13,972580,170,85,1,17,1,12,50,45,40,137,282,333,580,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,14,1075898,182,90,1,17,1,13,51,46,40,137,282,333,580,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,15,1182444,195,95,1,27,1,13,52,47,40,137,282,333,580,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,16,1291812,209,101,1,28,1,13,53,48,40,137,282,333,574,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,17,1403587,223,106,1,28,1,14,54,49,40,137,282,333,570,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,18,1518206,238,112,1,29,2,14,55,50,40,137,282,333,566,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,19,1634822,254,117,1,30,2,15,56,51,40,137,282,333,562,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,20,1792908,271,123,1,30,2,15,57,52,40,137,282,333,558,9,2,54510,3,1,1.00,2,2),
('sin_eater',12564,21,1957805,288,131,1,31,2,16,58,53,40,137,282,333,740,12,2,54510,4,2,1.00,2,2),
('sin_eater',12564,22,2129070,306,140,1,32,2,16,59,54,40,137,282,333,756,12,2,54510,4,2,1.00,2,2),
('sin_eater',12564,23,2306244,324,148,1,32,2,17,60,55,40,137,282,333,734,12,2,54510,4,2,1.00,2,2),
('sin_eater',12564,24,2488860,344,157,1,33,3,18,61,56,40,137,282,333,776,12,2,54510,4,2,1.00,2,2),
('sin_eater',12564,25,2677911,364,166,1,34,3,18,62,57,40,137,282,333,786,13,2,54510,4,2,1.00,2,2),
('sin_eater',12564,26,2871525,385,175,1,35,3,19,63,58,40,137,282,333,802,13,2,54510,4,2,1.00,2,2),
('sin_eater',12564,27,3070830,407,184,1,36,4,19,64,59,40,137,282,333,808,13,2,54510,4,2,1.00,2,2),
('sin_eater',12564,28,3275486,430,193,1,36,4,20,65,60,40,137,282,333,822,13,2,54510,4,2,1.00,2,2),
('sin_eater',12564,29,3485156,453,202,1,37,4,21,66,61,40,137,282,333,832,13,2,54510,4,2,1.00,2,2),
('sin_eater',12564,30,3751539,477,211,1,38,5,21,67,62,40,137,282,333,842,14,2,54510,4,2,1.00,2,2),
('sin_eater',12564,31,4028340,502,220,1,39,5,22,68,63,40,137,282,333,1058,17,3,54510,5,2,1.00,2,2),
('sin_eater',12564,32,4315501,528,229,1,40,5,22,69,64,40,137,282,333,1086,18,3,54510,5,2,1.00,2,2),
('sin_eater',12564,33,4612963,555,239,1,41,6,23,70,65,40,137,282,333,1118,18,3,54510,5,2,1.00,2,2),
('sin_eater',12564,34,4920669,582,248,1,42,6,24,71,66,40,137,282,333,1144,19,3,54510,5,2,1.00,2,2),
('sin_eater',12564,35,5238565,610,258,1,43,6,25,72,67,40,137,282,333,1174,19,3,54510,5,2,1.00,2,2),
('sin_eater',12564,36,5566601,640,267,2,44,7,25,73,68,40,137,282,333,1204,20,4,54510,5,2,1.00,2,2),
('sin_eater',12564,37,5904731,669,277,3,45,7,26,74,69,40,137,282,333,1232,20,4,54510,5,2,1.00,2,2),
('sin_eater',12564,38,6252914,700,287,3,46,8,27,75,70,40,137,282,333,1260,21,4,54510,5,2,1.00,2,2),
('sin_eater',12564,39,6611116,731,297,3,47,9,27,76,71,40,137,282,333,1290,21,4,54510,5,2,1.00,2,2),
('sin_eater',12564,40,7043983,764,306,5,48,10,28,77,72,40,137,282,333,1318,21,4,54510,5,2,1.00,2,2),
('sin_eater',12564,41,7488914,797,323,5,49,11,29,78,73,40,137,282,333,1584,26,5,54510,6,2,1.00,2,2),
('sin_eater',12564,42,7945899,830,340,6,50,11,30,79,74,40,137,282,333,1618,26,5,54510,6,2,1.00,2,2),
('sin_eater',12564,43,8414937,864,357,6,51,13,30,80,75,40,137,282,333,1654,27,5,54510,6,2,1.00,2,2),
('sin_eater',12564,44,8896036,900,374,6,52,14,31,81,76,40,137,282,333,1690,28,5,54510,6,2,1.00,2,2),
('sin_eater',12564,45,9389214,935,391,8,53,14,32,82,77,40,137,282,333,1726,28,5,54510,6,2,1.00,2,2),
('sin_eater',12564,46,9894501,972,408,8,54,16,33,83,78,40,137,282,333,1762,29,5,54510,6,2,1.00,2,2),
('sin_eater',12564,47,10411936,1008,426,10,55,17,34,84,79,40,137,282,333,1796,29,5,54510,6,2,1.00,2,2),
('sin_eater',12564,48,10941572,1046,443,10,56,17,34,85,80,40,137,282,333,1834,30,6,54510,6,2,1.00,2,2),
('sin_eater',12564,49,11483472,1084,461,12,57,19,35,86,81,40,137,282,333,1870,31,6,54510,6,2,1.00,2,2),
('sin_eater',12564,50,12118290,1123,479,12,59,20,36,87,82,40,137,282,333,1798,29,5,54510,6,2,1.00,2,2),
('sin_eater',12564,51,12767663,1162,497,13,60,22,37,88,83,40,137,282,333,2122,35,7,54510,7,2,1.00,2,2),
('sin_eater',12564,52,13431709,1201,515,14,61,23,38,89,84,40,137,282,333,2182,36,7,54510,7,2,1.00,2,2),
('sin_eater',12564,53,14110562,1241,533,15,62,25,39,90,85,40,137,282,333,2242,37,7,54510,7,2,1.00,2,2),
('sin_eater',12564,54,14804375,1281,551,17,63,27,40,91,86,40,137,282,333,2300,38,7,54510,7,2,1.00,2,2),
('sin_eater',12564,55,15513314,1322,569,17,64,27,40,92,87,40,137,282,333,2266,37,7,54510,7,2,1.00,2,2),
('sin_eater',12564,56,16237563,1362,588,19,66,29,41,93,88,40,137,282,333,2336,38,7,54510,7,2,1.00,2,2),
('sin_eater',12564,57,16977324,1403,607,21,67,31,42,94,89,40,137,282,333,2402,40,8,54510,7,2,1.00,2,2),
('sin_eater',12564,58,17732818,1445,626,21,68,33,43,95,90,40,137,282,333,2466,41,8,54510,7,2,1.00,2,2),
('sin_eater',12564,59,18504282,1486,644,23,69,34,44,96,91,40,137,282,333,2530,42,8,54510,7,2,1.00,2,2),
('sin_eater',12564,60,19389330,1527,664,25,70,38,45,97,92,40,137,282,333,2464,41,8,54510,7,2,1.00,2,2),
('sin_eater',12564,61,20293188,1569,683,25,72,40,46,98,93,40,137,282,333,2858,47,9,54510,8,3,1.00,2,2),
('sin_eater',12564,62,21216188,1610,702,27,73,42,47,99,94,40,137,282,333,2946,49,9,54510,8,3,1.00,2,2),
('sin_eater',12564,63,22158686,1651,722,29,74,44,47,100,95,40,137,282,333,3032,50,10,54510,8,3,1.00,2,2),
('sin_eater',12564,64,23121062,1692,741,29,75,46,48,101,96,40,137,282,333,3114,51,10,54510,8,3,1.00,2,2),
('sin_eater',12564,65,24103719,1733,761,31,76,48,49,102,97,40,137,282,333,3088,51,10,54510,8,3,1.00,2,2),
('sin_eater',12564,66,25107088,1773,781,33,78,50,50,103,98,40,137,282,333,3184,53,10,54510,8,3,1.00,2,2),
('sin_eater',12564,67,26131623,1813,801,36,79,53,51,104,99,40,137,282,333,3278,54,10,54510,8,3,1.00,2,2),
('sin_eater',12564,68,27177809,1853,821,36,80,55,52,105,100,40,137,282,333,3370,56,11,54510,8,3,1.00,2,2),
('sin_eater',12564,69,28246157,1892,841,38,81,59,53,106,101,40,137,282,333,3462,57,11,54510,8,3,1.00,2,2),
('sin_eater',12564,70,29453717,1931,861,40,82,61,54,107,102,40,137,282,333,3554,59,11,54510,8,3,1.00,2,2),
('sin_eater',12564,71,30687219,1969,882,42,84,64,55,108,103,40,137,282,333,3694,61,12,54510,8,3,1.00,2,2),
('sin_eater',12564,72,31947320,2007,902,43,85,66,55,109,104,40,137,282,333,3844,64,12,54510,8,3,1.00,2,2),
('sin_eater',12564,73,33234715,2043,923,45,86,69,56,110,105,40,137,282,333,3978,66,13,54510,8,3,1.00,2,2),
('sin_eater',12564,74,34550133,2079,944,47,87,71,57,111,106,40,137,282,333,4098,68,13,54510,8,3,1.00,2,2),
('sin_eater',12564,75,35894342,2115,965,49,88,74,58,112,107,40,137,282,333,4214,70,14,54510,8,3,1.00,2,2),
('sin_eater',12564,76,37268148,2149,986,50,89,79,59,113,108,40,137,282,333,4352,72,14,54510,8,3,1.00,2,2),
('sin_eater',12564,77,38672397,2182,1007,52,91,81,60,114,109,40,137,282,333,4458,74,14,54510,8,3,1.00,2,2),
('sin_eater',12564,78,40107979,2214,1029,54,92,84,60,115,110,40,137,282,333,4562,76,15,54510,8,3,1.00,2,2),
('sin_eater',12564,79,41575826,2245,1050,56,93,87,61,116,111,40,137,282,333,4670,77,15,54510,8,3,1.00,2,2),
('sin_eater',12564,80,43076915,2275,1072,57,94,90,62,117,112,40,137,282,333,4776,79,15,54510,8,3,1.00,2,2),
('sin_eater',12564,81,44612271,2304,1073,59,95,93,63,118,113,40,137,282,333,4776,79,15,54510,9,4,1.00,2,2),
('sin_eater',12564,82,46025791,2337,1101,61,96,96,64,119,114,40,137,282,333,4917,81,15,54510,9,4,1.00,2,2),
('sin_eater',12564,83,47494420,2368,1120,63,97,99,64,120,115,40,137,282,333,5008,83,16,54510,9,4,1.00,2,2),
('sin_eater',12564,84,48963049,2399,1138,64,99,101,65,121,116,40,137,282,333,5099,84,16,54510,9,4,1.00,2,2),
('sin_eater',12564,85,50431678,2430,1157,66,100,104,66,122,117,40,137,282,333,5190,86,16,54510,9,4,1.00,2,2),
('sin_eater',12564,86,51900307,2461,1176,68,101,107,67,123,118,40,137,282,333,5281,87,16,54510,9,4,1.00,2,2),
('wyvern',12621,1,0,28,25,9,20,6,64,38,33,40,220,278,333,508,4,2,54510,2,1,0.10,2,2),
('wyvern',12621,2,1,34,30,9,20,6,67,39,34,40,220,278,333,492,4,2,54510,2,1,0.10,2,2),
('wyvern',12621,3,2,40,34,9,21,7,70,40,35,40,220,278,333,608,5,2,54510,2,1,0.10,2,2),
('wyvern',12621,4,3,48,39,10,21,7,74,41,36,40,220,278,333,756,6,2,54510,2,1,0.10,2,2),
('wyvern',12621,5,4,57,44,10,22,8,78,42,37,40,220,278,333,932,7,2,54510,2,1,0.10,2,2),
('wyvern',12621,6,5,66,49,10,22,8,81,43,38,40,220,278,333,1124,9,2,54510,2,1,0.10,2,2),
('wyvern',12621,7,6,77,54,10,23,9,85,44,39,40,220,278,333,1200,10,2,54510,2,1,0.10,2,2),
('wyvern',12621,8,7,88,59,10,23,10,89,45,40,40,220,278,333,1336,11,2,54510,2,1,0.10,2,2),
('wyvern',12621,9,8,101,64,10,24,10,94,46,41,40,220,278,333,1432,11,2,54510,2,1,0.10,2,2),
('wyvern',12621,10,9,116,69,11,24,11,98,47,42,40,220,278,333,1492,12,2,54510,2,1,0.10,2,2),
('wyvern',12621,11,10,131,74,11,25,12,103,48,43,40,220,278,333,1784,14,2,54510,3,1,0.10,2,2),
('wyvern',12621,12,11,141,79,11,25,13,107,49,44,40,220,278,333,1796,14,2,54510,3,1,0.10,2,2),
('wyvern',12621,13,12,152,84,11,26,14,112,50,45,40,220,278,333,1724,14,2,54510,3,1,0.10,2,2),
('wyvern',12621,14,13,163,90,12,26,15,117,51,46,40,220,278,333,1664,13,2,54510,3,1,0.10,2,2),
('wyvern',12621,15,14,175,95,12,27,16,123,52,47,40,220,278,333,1608,13,2,54510,3,1,0.10,2,2),
('wyvern',12621,16,15,187,100,12,28,17,128,53,48,40,220,278,333,1548,12,2,54510,3,1,0.10,2,2),
('wyvern',12621,17,16,200,106,12,28,18,134,54,49,40,220,278,333,1512,12,2,54510,3,1,0.10,2,2),
('wyvern',12621,18,17,214,111,13,29,19,140,55,50,40,220,278,333,1464,12,2,54510,3,1,0.10,2,2),
('wyvern',12621,19,9411,228,117,13,30,20,146,56,51,40,220,278,333,1456,12,2,54510,3,1,0.10,2,2),
('wyvern',12621,20,78112,243,122,14,30,22,152,57,52,40,220,278,333,1460,12,2,54510,3,1,0.10,2,2),
('wyvern',12621,21,157197,259,131,14,31,23,158,58,53,40,220,278,333,1908,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,22,247595,275,139,15,32,24,165,59,54,40,220,278,333,1912,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,23,350264,292,148,15,33,26,172,60,55,40,220,278,333,1804,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,24,466190,309,157,16,33,27,179,61,56,40,220,278,333,1900,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,25,596387,327,165,16,34,29,186,62,57,40,220,278,333,1896,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,26,741894,346,174,17,35,31,194,63,58,40,220,278,333,1896,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,27,903774,366,183,18,36,33,202,64,59,40,220,278,333,1844,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,28,1083117,386,192,18,37,34,210,65,60,40,220,278,333,1856,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,29,1281033,407,201,19,37,36,218,66,61,40,220,278,333,1848,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,30,1498658,429,210,20,38,38,226,67,62,40,220,278,333,1880,15,3,54510,4,2,0.10,2,2),
('wyvern',12621,31,1737148,452,220,21,39,40,235,68,63,40,220,278,333,2384,19,3,54510,5,2,0.10,2,2),
('wyvern',12621,32,1997679,475,229,21,40,43,244,69,64,40,220,278,333,2376,19,3,54510,5,2,0.10,2,2),
('wyvern',12621,33,2281450,499,238,22,41,45,253,70,65,40,220,278,333,2416,20,4,54510,5,2,0.10,2,2),
('wyvern',12621,34,2589677,523,248,23,42,47,263,71,66,40,220,278,333,2452,20,4,54510,5,2,0.10,2,2),
('wyvern',12621,35,2923598,549,257,24,43,49,272,72,67,40,220,278,333,2488,20,4,54510,5,2,0.10,2,2),
('wyvern',12621,36,3284467,575,267,26,44,52,282,73,68,40,220,278,333,2524,21,4,54510,5,2,0.10,2,2),
('wyvern',12621,37,3673557,602,276,28,46,54,293,74,69,40,220,278,333,2516,20,4,54510,5,2,0.10,2,2),
('wyvern',12621,38,4092158,630,286,30,47,57,303,75,70,40,220,278,333,2548,21,4,54510,5,2,0.10,2,2),
('wyvern',12621,39,4541577,658,296,32,49,60,314,76,71,40,220,278,333,2584,21,4,54510,5,2,0.10,2,2),
('wyvern',12621,40,5023138,687,306,34,50,62,325,77,72,40,220,278,333,2576,21,4,54510,5,2,0.10,2,2),
('wyvern',12621,41,5538179,716,323,37,52,65,336,78,73,40,220,278,333,3156,26,5,54510,6,2,0.10,2,2),
('wyvern',12621,42,6088054,747,339,39,53,68,347,79,74,40,220,278,333,3200,26,5,54510,6,2,0.10,2,2),
('wyvern',12621,43,6674132,778,356,42,55,71,359,80,75,40,220,278,333,3244,27,5,54510,6,2,0.10,2,2),
('wyvern',12621,44,7297797,809,373,44,57,74,371,81,76,40,220,278,333,3244,27,5,54510,6,2,0.10,2,2),
('wyvern',12621,45,7960445,841,390,47,58,77,383,82,77,40,220,278,333,3292,27,5,54510,6,2,0.10,2,2),
('wyvern',12621,46,8663488,874,408,50,60,80,395,83,78,40,220,278,333,3332,27,5,54510,6,2,0.10,2,2),
('wyvern',12621,47,9408349,907,425,53,62,84,408,84,79,40,220,278,333,3328,27,5,54510,6,2,0.10,2,2),
('wyvern',12621,48,10196465,941,443,56,63,87,421,85,80,40,220,278,333,3368,28,5,54510,6,2,0.10,2,2),
('wyvern',12621,49,11029284,975,460,59,65,90,434,86,81,40,220,278,333,3376,28,5,54510,6,2,0.10,2,2),
('wyvern',12621,50,11908268,1010,478,62,67,93,448,87,82,40,220,278,333,3416,28,5,54510,6,2,0.10,2,2),
('wyvern',12621,51,13298199,1045,496,65,68,97,461,88,83,40,220,278,333,4084,34,6,54510,7,2,0.10,2,2),
('wyvern',12621,52,14761810,1080,514,69,70,100,475,89,84,40,220,278,333,4132,34,6,54510,7,2,0.10,2,2),
('wyvern',12621,53,16301345,1116,532,72,72,104,489,90,85,40,220,278,333,4148,34,6,54510,7,2,0.10,2,2),
('wyvern',12621,54,17919061,1153,551,76,74,107,503,91,86,40,220,278,333,4200,35,7,54510,7,2,0.10,2,2),
('wyvern',12621,55,19617231,1189,569,80,75,111,518,92,87,40,220,278,333,4208,35,7,54510,7,2,0.10,2,2),
('wyvern',12621,56,21991783,1226,588,84,77,114,533,93,88,40,220,278,333,4264,35,7,54510,7,2,0.10,2,2),
('wyvern',12621,57,24479731,1263,606,88,79,118,548,94,89,40,220,278,333,4316,35,7,54510,7,2,0.10,2,2),
('wyvern',12621,58,27084166,1300,625,92,81,121,563,95,90,40,220,278,333,4328,36,7,54510,7,2,0.10,2,2),
('wyvern',12621,59,29808197,1337,644,96,83,125,578,96,91,40,220,278,333,4384,36,7,54510,7,2,0.10,2,2),
('wyvern',12621,60,32654950,1374,663,100,84,128,594,97,92,40,220,278,333,4392,36,7,54510,7,2,0.10,2,2),
('wyvern',12621,61,37113882,1411,682,104,86,132,609,98,93,40,220,278,333,5164,43,8,54510,8,3,0.10,2,2),
('wyvern',12621,62,41766357,1448,702,108,88,135,625,99,94,40,220,278,333,5232,43,8,54510,8,3,0.10,2,2),
('wyvern',12621,63,46617143,1485,721,113,90,139,641,100,95,40,220,278,333,5300,44,8,54510,8,3,0.10,2,2),
('wyvern',12621,64,51671033,1522,741,117,92,142,657,101,96,40,220,278,333,5328,44,8,54510,8,3,0.10,2,2),
('wyvern',12621,65,56932842,1559,760,122,94,145,674,102,97,40,220,278,333,5400,45,9,54510,8,3,0.10,2,2),
('wyvern',12621,66,64232264,1595,780,126,95,149,690,103,98,40,220,278,333,5472,45,9,54510,8,3,0.10,2,2),
('wyvern',12621,67,71821844,1632,800,131,97,152,707,104,99,40,220,278,333,5544,46,9,54510,8,3,0.10,2,2),
('wyvern',12621,68,79708094,1667,820,135,99,155,723,105,100,40,220,278,333,5576,46,9,54510,8,3,0.10,2,2),
('wyvern',12621,69,87897553,1703,840,140,101,158,740,106,101,40,220,278,333,5648,47,9,54510,8,3,0.10,2,2),
('wyvern',12621,70,96396787,1738,861,144,103,161,757,107,102,40,220,278,333,5728,47,9,54510,8,3,0.10,2,2),
('wyvern',12621,71,105212391,1772,881,149,104,164,774,108,103,40,220,278,333,5948,49,9,54510,9,3,0.10,2,2),
('wyvern',12621,72,116635633,1806,902,154,106,167,791,109,104,40,220,278,333,6028,50,10,54510,9,3,0.10,2,2),
('wyvern',12621,73,130837978,1839,923,158,108,170,808,110,105,40,220,278,333,6116,50,10,54510,9,3,0.10,2,2),
('wyvern',12621,74,147995918,1871,944,163,110,172,825,111,106,40,220,278,333,6200,51,10,54510,9,3,0.10,2,2),
('wyvern',12621,75,168290997,1903,964,167,111,175,842,112,107,40,220,278,333,6288,52,10,54510,9,3,0.10,2,2),
('wyvern',12621,76,191909837,1933,986,172,113,177,860,113,108,40,220,278,333,6376,53,10,54510,9,3,0.10,2,2),
('wyvern',12621,77,224471019,1963,1007,176,115,180,877,114,109,40,220,278,333,6468,53,10,54510,9,3,0.10,2,2),
('wyvern',12621,78,260926132,1992,1028,180,116,182,894,115,110,40,220,278,333,6556,54,10,54510,9,3,0.10,2,2),
('wyvern',12621,79,301480548,2020,1050,184,118,184,911,116,111,40,220,278,333,6656,55,11,54510,9,3,0.10,2,2),
('wyvern',12621,80,346344812,2047,1071,189,120,186,928,117,112,40,220,278,333,6748,56,11,54510,9,3,0.10,2,2),
('wyvern',12621,81,395734658,2049,1073,190,121,187,945,118,113,40,220,278,333,6748,56,11,54510,10,4,0.10,2,2),
('wyvern',12621,82,455734658,2049,1073,190,121,187,945,118,113,40,220,278,333,6748,56,11,54510,10,4,0.10,2,2),
('wyvern',12621,83,505734658,2049,1073,190,121,187,945,118,113,40,220,278,333,6748,56,11,54510,10,4,0.10,2,2),
('wyvern',12621,84,555734658,2049,1073,190,121,187,945,118,113,40,220,278,333,6748,56,11,54510,10,4,0.10,2,2),
('wyvern',12621,85,605734658,2049,1073,190,121,187,945,118,113,40,220,278,333,6748,56,11,54510,10,4,0.10,2,2),
('wyvern',12621,86,656701989,2049,1073,190,121,187,945,118,113,40,220,278,333,6748,56,11,54510,10,4,0.10,2,2);

INSERT INTO `pets_stats` VALUES
('Fox Shaman',16043,55,15513314,2379,810,359,382,379,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Fox Shaman',16043,56,16237563,2451,837,401,394,407,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Fox Shaman',16043,57,16977324,2525,864,443,400,435,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Fox Shaman',16043,58,17732818,2601,891,443,406,464,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Fox Shaman',16043,59,18504282,2675,917,486,412,478,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Fox Shaman',16043,60,19389330,2748,945,528,418,534,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Fox Shaman',16043,61,20293188,2824,972,528,430,562,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,62,21216188,2898,999,570,436,590,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,63,22158686,2972,1028,612,442,618,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,64,23121062,3045,1055,612,448,646,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,65,24103719,3119,1083,654,454,674,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,66,25107088,3191,1112,697,465,702,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,67,26131623,3263,1140,760,471,745,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,68,27177809,3335,1169,760,477,773,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,69,28246157,3405,1197,802,483,829,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,70,29453717,3476,1226,844,489,857,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,71,30687219,3544,1256,887,501,899,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,72,31947320,3612,1284,908,507,927,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,73,33234715,3677,1314,950,513,969,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,74,34550133,3742,1344,992,519,997,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,75,35894342,3807,1374,1034,525,1040,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,76,37268148,3868,1404,1056,531,1110,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,77,38672397,3927,1434,1098,543,1138,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,78,40107979,3985,1465,1140,549,1180,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,79,41575826,4041,1495,1182,555,1222,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,80,43076915,4095,1526,1203,561,1264,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Fox Shaman',16043,81,44612271,4147,1528,1246,567,1306,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Fox Shaman',16043,82,46025791,4206,1568,1288,573,1349,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Fox Shaman',16043,83,47494420,4262,1595,1330,579,1391,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Fox Shaman',16043,84,48963049,4318,1620,1351,591,1419,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Fox Shaman',16043,85,50431678,4374,1647,1393,597,1461,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Fox Shaman',16043,86,51900307,4430,1674,1436,603,1503,523,135,130,44,187,278,333,5281,0,0,54510,9,4,0.10,1,1),
('Wild Beast Fighter',16044,55,15513314,3490,486,564,382,189,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Wild Beast Fighter',16044,56,16237563,3596,502,630,394,203,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Wild Beast Fighter',16044,57,16977324,3704,519,696,400,217,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Wild Beast Fighter',16044,58,17732818,3815,535,696,406,231,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Wild Beast Fighter',16044,59,18504282,3923,550,763,412,238,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Wild Beast Fighter',16044,60,19389330,4031,567,829,418,266,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Wild Beast Fighter',16044,61,20293188,4142,583,829,430,280,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,62,21216188,4250,600,895,436,295,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,63,22158686,4359,617,962,442,309,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,64,23121062,4467,633,962,448,323,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,65,24103719,4575,650,1028,454,337,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,66,25107088,4681,667,1095,465,351,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,67,26131623,4786,684,1194,471,372,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,68,27177809,4892,701,1194,477,386,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,69,28246157,4995,718,1260,483,414,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,70,29453717,5098,735,1327,489,428,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,71,30687219,5198,753,1393,501,449,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,72,31947320,5299,771,1426,507,463,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,73,33234715,5394,788,1493,513,484,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,74,34550133,5489,806,1559,519,498,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,75,35894342,5584,824,1625,525,519,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,76,37268148,5673,842,1658,531,554,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,77,38672397,5761,860,1725,543,568,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,78,40107979,5845,879,1791,549,589,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,79,41575826,5927,897,1857,555,610,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,80,43076915,6006,916,1891,561,631,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Wild Beast Fighter',16044,81,44612271,6083,917,1957,567,652,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Wild Beast Fighter',16044,82,46025791,6170,941,2023,573,673,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Wild Beast Fighter',16044,83,47494420,6252,957,2090,579,694,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Wild Beast Fighter',16044,84,48963049,6333,972,2123,591,708,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Wild Beast Fighter',16044,85,50431678,6415,988,2189,597,729,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Wild Beast Fighter',16044,86,51900307,6497,1005,2255,603,750,523,135,130,44,187,278,333,5281,0,0,54510,9,4,0.10,1,1),
('White Weasel',16045,55,15513314,2909,1026,461,382,284,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('White Weasel',16045,56,16237563,2997,1061,515,394,305,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('White Weasel',16045,57,16977324,3087,1095,569,400,326,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('White Weasel',16045,58,17732818,3179,1129,569,406,347,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('White Weasel',16045,59,18504282,3269,1162,624,412,357,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('White Weasel',16045,60,19389330,3360,1198,678,418,399,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('White Weasel',16045,61,20293188,3452,1232,678,430,420,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,62,21216188,3542,1266,732,436,442,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,63,22158686,3632,1302,786,442,463,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,64,23121062,3723,1337,786,448,484,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,65,24103719,3813,1373,840,454,505,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,66,25107088,3901,1409,895,465,526,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,67,26131623,3989,1445,976,471,557,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,68,27177809,4077,1481,976,477,578,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,69,28246157,4163,1517,1030,483,620,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,70,29453717,4248,1553,1084,489,641,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,71,30687219,4332,1591,1139,501,673,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,72,31947320,4416,1627,1166,507,694,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,73,33234715,4495,1665,1220,513,725,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,74,34550133,4574,1703,1274,519,746,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,75,35894342,4653,1741,1328,525,778,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,76,37268148,4728,1778,1356,531,830,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,77,38672397,4801,1816,1410,543,851,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,78,40107979,4871,1856,1464,549,883,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,79,41575826,4939,1894,1518,555,915,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,80,43076915,5005,1934,1545,561,946,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('White Weasel',16045,81,44612271,5069,1935,1600,567,978,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('White Weasel',16045,82,46025791,5142,1986,1654,573,1009,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('White Weasel',16045,83,47494420,5210,2020,1708,579,1041,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('White Weasel',16045,84,48963049,5278,2053,1735,591,1062,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('White Weasel',16045,85,50431678,5346,2087,1789,597,1093,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('White Weasel',16045,86,51900307,5414,2121,1844,603,1125,523,135,130,44,187,278,333,5281,0,0,54510,9,4,0.10,1,1),
('Fairy Princess',16046,55,15513314,2618,1080,359,382,316,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Fairy Princess',16046,56,16237563,2697,1117,401,394,339,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Fairy Princess',16046,57,16977324,2778,1153,443,400,362,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Fairy Princess',16046,58,17732818,2861,1189,443,406,386,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Fairy Princess',16046,59,18504282,2942,1223,486,412,397,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Fairy Princess',16046,60,19389330,3024,1261,528,418,444,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Fairy Princess',16046,61,20293188,3107,1297,528,430,468,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,62,21216188,3188,1333,570,436,491,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,63,22158686,3269,1371,612,442,514,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,64,23121062,3350,1407,612,448,538,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,65,24103719,3432,1445,654,454,561,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,66,25107088,3511,1483,697,465,585,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,67,26131623,3590,1521,760,471,620,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,68,27177809,3669,1559,760,477,643,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,69,28246157,3746,1597,802,483,690,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,70,29453717,3824,1635,844,489,713,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,71,30687219,3899,1675,887,501,748,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,72,31947320,3974,1713,908,507,772,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,73,33234715,4045,1753,950,513,807,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,74,34550133,4117,1793,992,519,830,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,75,35894342,4188,1832,1034,525,865,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,76,37268148,4255,1872,1056,531,924,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,77,38672397,4321,1912,1098,543,947,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,78,40107979,4384,1954,1140,549,982,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,79,41575826,4445,1994,1182,555,1017,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,80,43076915,4505,2036,1203,561,1052,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Fairy Princess',16046,81,44612271,4562,2038,1246,567,1087,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Fairy Princess',16046,82,46025791,4628,2091,1288,573,1122,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Fairy Princess',16046,83,47494420,4689,2127,1330,579,1157,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Fairy Princess',16046,84,48963049,4750,2161,1351,591,1181,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Fairy Princess',16046,85,50431678,4812,2197,1393,597,1216,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Fairy Princess',16046,86,51900307,4873,2233,1436,603,1251,523,135,130,44,187,278,333,5281,0,0,54510,9,4,0.10,1,1),
('Owl Monk',16050,55,15513314,2379,810,359,382,379,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Owl Monk',16050,56,16237563,2451,837,401,394,407,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Owl Monk',16050,57,16977324,2525,864,443,400,435,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Owl Monk',16050,58,17732818,2601,891,443,406,464,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Owl Monk',16050,59,18504282,2675,917,486,412,478,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Owl Monk',16050,60,19389330,2748,945,528,418,534,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Owl Monk',16050,61,20293188,2824,972,528,430,562,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,62,21216188,2898,999,570,436,590,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,63,22158686,2972,1028,612,442,618,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,64,23121062,3045,1055,612,448,646,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,65,24103719,3119,1083,654,454,674,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,66,25107088,3191,1112,697,465,702,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,67,26131623,3263,1140,760,471,745,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,68,27177809,3335,1169,760,477,773,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,69,28246157,3405,1197,802,483,829,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,70,29453717,3476,1226,844,489,857,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,71,30687219,3544,1256,887,501,899,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,72,31947320,3612,1284,908,507,927,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,73,33234715,3677,1314,950,513,969,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,74,34550133,3742,1344,992,519,997,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,75,35894342,3807,1374,1034,525,1040,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,76,37268148,3868,1404,1056,531,1110,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,77,38672397,3927,1434,1098,543,1138,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,78,40107979,3985,1465,1140,549,1180,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,79,41575826,4041,1495,1182,555,1222,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,80,43076915,4095,1526,1203,561,1264,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Owl Monk',16050,81,44612271,4147,1528,1246,567,1306,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Owl Monk',16050,82,46025791,4206,1568,1288,573,1349,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Owl Monk',16050,83,47494420,4262,1595,1330,579,1391,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Owl Monk',16050,84,48963049,4318,1620,1351,591,1419,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Owl Monk',16050,85,50431678,4374,1647,1393,597,1461,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Owl Monk',16050,86,51900307,4384,1670,1421,602,1499,520,135,130,44,187,278,333,5290,0,0,54510,9,4,0.10,1,1),
('Spirit Shaman',16051,55,15513314,2379,810,359,382,379,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Spirit Shaman',16051,56,16237563,2451,837,401,394,407,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Spirit Shaman',16051,57,16977324,2525,864,443,400,435,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Spirit Shaman',16051,58,17732818,2601,891,443,406,464,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Spirit Shaman',16051,59,18504282,2675,917,486,412,478,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Spirit Shaman',16051,60,19389330,2748,945,528,418,534,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Spirit Shaman',16051,61,20293188,2824,972,528,430,562,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,62,21216188,2898,999,570,436,590,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,63,22158686,2972,1028,612,442,618,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,64,23121062,3045,1055,612,448,646,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,65,24103719,3119,1083,654,454,674,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,66,25107088,3191,1112,697,465,702,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,67,26131623,3263,1140,760,471,745,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,68,27177809,3335,1169,760,477,773,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,69,28246157,3405,1197,802,483,829,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,70,29453717,3476,1226,844,489,857,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,71,30687219,3544,1256,887,501,899,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,72,31947320,3612,1284,908,507,927,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,73,33234715,3677,1314,950,513,969,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,74,34550133,3742,1344,992,519,997,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,75,35894342,3807,1374,1034,525,1040,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,76,37268148,3868,1404,1056,531,1110,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,77,38672397,3927,1434,1098,543,1138,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,78,40107979,3985,1465,1140,549,1180,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,79,41575826,4041,1495,1182,555,1222,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,80,43076915,4095,1526,1203,561,1264,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Spirit Shaman',16051,81,44612271,4147,1528,1246,567,1306,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Spirit Shaman',16051,82,46025791,4206,1568,1288,573,1349,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Spirit Shaman',16051,83,47494420,4262,1595,1330,579,1391,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Spirit Shaman',16051,84,48963049,4318,1620,1351,591,1419,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Spirit Shaman',16051,85,50431678,4374,1647,1393,597,1461,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Spirit Shaman',16051,86,51900307,4384,1670,1421,602,1499,520,135,130,44,187,278,333,5290,0,0,54510,9,4,0.10,1,1),
('Toy Knight',16052,55,15513314,2379,810,359,382,379,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Toy Knight',16052,56,16237563,2451,837,401,394,407,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Toy Knight',16052,57,16977324,2525,864,443,400,435,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Toy Knight',16052,58,17732818,2601,891,443,406,464,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Toy Knight',16052,59,18504282,2675,917,486,412,478,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Toy Knight',16052,60,19389330,2748,945,528,418,534,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Toy Knight',16052,61,20293188,2824,972,528,430,562,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,62,21216188,2898,999,570,436,590,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,63,22158686,2972,1028,612,442,618,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,64,23121062,3045,1055,612,448,646,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,65,24103719,3119,1083,654,454,674,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,66,25107088,3191,1112,697,465,702,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,67,26131623,3263,1140,760,471,745,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,68,27177809,3335,1169,760,477,773,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,69,28246157,3405,1197,802,483,829,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,70,29453717,3476,1226,844,489,857,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,71,30687219,3544,1256,887,501,899,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,72,31947320,3612,1284,908,507,927,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,73,33234715,3677,1314,950,513,969,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,74,34550133,3742,1344,992,519,997,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,75,35894342,3807,1374,1034,525,1040,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,76,37268148,3868,1404,1056,531,1110,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,77,38672397,3927,1434,1098,543,1138,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,78,40107979,3985,1465,1140,549,1180,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,79,41575826,4041,1495,1182,555,1222,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,80,43076915,4095,1526,1203,561,1264,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Toy Knight',16052,81,44612271,4147,1528,1246,567,1306,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Toy Knight',16052,82,46025791,4206,1568,1288,573,1349,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Toy Knight',16052,83,47494420,4262,1595,1330,579,1391,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Toy Knight',16052,84,48963049,4318,1620,1351,591,1419,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Toy Knight',16052,85,50431678,4374,1647,1393,597,1461,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Toy Knight',16052,86,51900307,4384,1670,1421,602,1499,520,135,130,44,187,278,333,5290,0,0,54510,9,4,0.10,1,1),
('Turtle Ascetic',16053,55,15513314,2379,810,359,382,379,312,101,96,44,187,278,333,2266,0,0,54510,7,2,0.10,1,1),
('Turtle Ascetic',16053,56,16237563,2451,837,401,394,407,320,102,97,44,187,278,333,2336,0,0,54510,7,2,0.10,1,1),
('Turtle Ascetic',16053,57,16977324,2525,864,443,400,435,328,103,98,44,187,278,333,2402,0,0,54510,7,2,0.10,1,1),
('Turtle Ascetic',16053,58,17732818,2601,891,443,406,464,335,104,99,44,187,278,333,2466,0,0,54510,7,2,0.10,1,1),
('Turtle Ascetic',16053,59,18504282,2675,917,486,412,478,343,105,100,44,187,278,333,2530,0,0,54510,7,2,0.10,1,1),
('Turtle Ascetic',16053,60,19389330,2748,945,528,418,534,351,106,101,44,187,278,333,2464,0,0,54510,7,2,0.10,1,1),
('Turtle Ascetic',16053,61,20293188,2824,972,528,430,562,359,107,102,44,187,278,333,2858,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,62,21216188,2898,999,570,436,590,367,108,103,44,187,278,333,2946,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,63,22158686,2972,1028,612,442,618,367,110,105,44,187,278,333,3032,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,64,23121062,3045,1055,612,448,646,374,111,106,44,187,278,333,3114,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,65,24103719,3119,1083,654,454,674,382,112,107,44,187,278,333,3088,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,66,25107088,3191,1112,697,465,702,390,113,108,44,187,278,333,3184,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,67,26131623,3263,1140,760,471,745,398,114,109,44,187,278,333,3278,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,68,27177809,3335,1169,760,477,773,406,115,110,44,187,278,333,3370,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,69,28246157,3405,1197,802,483,829,413,116,111,44,187,278,333,3462,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,70,29453717,3476,1226,844,489,857,421,117,112,44,187,278,333,3554,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,71,30687219,3544,1256,887,501,899,429,118,113,44,187,278,333,3694,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,72,31947320,3612,1284,908,507,927,429,119,114,44,187,278,333,3844,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,73,33234715,3677,1314,950,513,969,437,121,116,44,187,278,333,3978,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,74,34550133,3742,1344,992,519,997,445,122,117,44,187,278,333,4098,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,75,35894342,3807,1374,1034,525,1040,452,123,118,44,187,278,333,4214,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,76,37268148,3868,1404,1056,531,1110,460,124,119,44,187,278,333,4352,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,77,38672397,3927,1434,1098,543,1138,468,125,120,44,187,278,333,4458,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,78,40107979,3985,1465,1140,549,1180,468,126,121,44,187,278,333,4562,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,79,41575826,4041,1495,1182,555,1222,476,127,122,44,187,278,333,4670,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,80,43076915,4095,1526,1203,561,1264,484,128,123,44,187,278,333,4776,0,0,54510,8,3,0.10,1,1),
('Turtle Ascetic',16053,81,44612271,4147,1528,1246,567,1306,491,129,124,44,187,278,333,4776,0,0,54510,9,4,0.10,1,1),
('Turtle Ascetic',16053,82,46025791,4206,1568,1288,573,1349,499,130,125,44,187,278,333,4917,0,0,54510,9,4,0.10,1,1),
('Turtle Ascetic',16053,83,47494420,4262,1595,1330,579,1391,499,131,127,44,187,278,333,5008,0,0,54510,9,4,0.10,1,1),
('Turtle Ascetic',16053,84,48963049,4318,1620,1351,591,1419,507,133,128,44,187,278,333,5099,0,0,54510,9,4,0.10,1,1),
('Turtle Ascetic',16053,85,50431678,4374,1647,1393,597,1461,515,134,129,44,187,278,333,5190,0,0,54510,9,4,0.10,1,1),
('Turtle Ascetic',16053,86,51900307,4384,1670,1421,602,1499,520,135,130,44,187,278,333,5290,0,0,54510,9,4,0.10,1,1);

-- Incomplete Stats, just for summoning purpose
INSERT INTO `pets_stats` VALUES
('Deinonychus',16067,55,26502939,1321,542,174,92,89,70,96,87,11,176,278,333,4532,37,7,54510,2,2,0.10,1,1),
('Deinonychus',16067,56,29922294,1321,542,174,92,89,70,96,87,11,176,278,333,4532,37,7,54510,2,2,0.10,1,1);

-- Wind Strider stats for now
INSERT INTO `pets_stats` VALUES
('guardian_strider',16068,55,15822648,1321,1138,97,223,25,163,92,87,40,187,278,333,7920,66,13,54510,7,2,0.10,2,2),
('guardian_strider',16068,56,17722290,1362,1176,101,228,26,167,93,88,40,187,278,333,8056,67,13,54510,7,2,0.10,2,2),
('guardian_strider',16068,57,19712649,1403,1213,106,233,27,170,94,89,40,187,278,333,8196,68,13,54510,7,2,0.10,2,2),
('guardian_strider',16068,58,21796197,1444,1251,110,237,28,174,95,90,40,187,278,333,8328,69,13,54510,7,2,0.10,2,2),
('guardian_strider',16068,59,23975421,1485,1288,115,242,30,177,96,91,40,187,278,333,8464,70,14,54510,7,2,0.10,2,2),
('guardian_strider',16068,60,26252824,1527,1327,120,247,31,181,97,92,40,187,278,333,8600,71,14,54510,7,2,0.10,2,2),
('guardian_strider',16068,61,29819969,1568,1365,125,252,32,184,98,93,40,187,278,333,9468,78,15,54510,8,3,0.10,2,2),
('guardian_strider',16068,62,33541949,1609,1404,130,257,34,188,99,94,40,187,278,333,9632,80,16,54510,8,3,0.10,2,2),
('guardian_strider',16068,63,37422578,1651,1443,135,262,35,191,100,95,40,187,278,333,9796,81,16,54510,8,3,0.10,2,2),
('guardian_strider',16068,64,41465690,1692,1482,140,267,36,195,101,96,40,187,278,333,9964,83,16,54510,8,3,0.10,2,2),
('guardian_strider',16068,65,45675137,1732,1521,145,271,38,198,102,97,40,187,278,333,10136,84,16,54510,8,3,0.10,2,2),
('guardian_strider',16068,66,51514675,1773,1561,150,276,39,202,103,98,40,187,278,333,10308,85,17,54510,8,3,0.10,2,2),
('guardian_strider',16068,67,57586339,1813,1601,156,281,40,206,104,99,40,187,278,333,10480,87,17,54510,8,3,0.10,2,2),
('guardian_strider',16068,68,63895339,1853,1641,161,286,42,209,105,100,40,187,278,333,10656,88,17,54510,8,3,0.10,2,2),
('guardian_strider',16068,69,70446906,1892,1681,166,291,43,213,106,101,40,187,278,333,10832,90,18,54510,8,3,0.10,2,2),
('guardian_strider',16068,70,77246293,1931,1722,172,295,45,216,107,102,40,187,278,333,11024,91,18,54510,8,3,0.10,2,2),
('guardian_strider',16068,71,84298776,1969,1763,177,300,46,220,108,103,40,187,278,333,10864,90,18,54510,9,3,0.10,2,2),
('guardian_strider',16068,72,93437370,2006,1804,182,305,47,223,109,104,40,187,278,333,11048,92,18,54510,9,3,0.10,2,2),
('guardian_strider',16068,73,104799246,2043,1846,188,310,49,226,110,105,40,187,278,333,11240,93,18,54510,9,3,0.10,2,2),
('guardian_strider',16068,74,118525598,2079,1888,193,314,50,230,111,106,40,187,278,333,11428,95,19,54510,9,3,0.10,2,2),
('guardian_strider',16068,75,134761662,2114,1929,198,319,52,233,112,107,40,187,278,333,11628,96,19,54510,9,3,0.10,2,2),
('guardian_strider',16068,76,153656733,2148,1972,203,323,53,236,113,108,40,187,278,333,11824,98,19,54510,9,3,0.10,2,2),
('guardian_strider',16068,77,179705679,2182,2014,208,328,54,240,114,109,40,187,278,333,12028,100,20,54510,9,3,0.10,2,2),
('guardian_strider',16068,78,208869769,2214,2057,213,332,56,243,115,110,40,187,278,333,12236,101,20,54510,9,3,0.10,2,2),
('guardian_strider',16068,79,241313302,2245,2100,218,337,57,246,116,111,40,187,278,333,12448,103,20,54510,9,3,0.10,2,2),
('guardian_strider',16068,80,277204713,2275,2143,223,341,58,249,117,112,40,187,278,333,12664,105,21,54510,9,3,0.10,2,2),
('guardian_strider',16068,81,316716590,2304,2187,228,345,59,252,118,113,40,187,278,333,12664,105,21,54510,10,4,0.10,2,2),
('guardian_strider',16068,82,338113831,2338,2229,233,350,60,255,119,114,40,187,278,333,12957,107,21,54510,10,4,0.10,2,2),
('guardian_strider',16068,83,368634130,2370,2272,238,354,62,259,120,115,40,187,278,333,13143,109,22,54510,10,4,0.10,2,2),
('guardian_strider',16068,84,399154428,2402,2315,243,359,63,262,121,116,40,187,278,333,13329,111,22,54510,10,4,0.10,2,2),
('guardian_strider',16068,85,429674727,2433,2358,248,363,64,265,122,117,40,187,278,333,13515,112,23,54510,10,4,0.10,2,2),
('guardian_strider',16068,86,460195026,2465,2401,253,367,65,268,123,118,40,187,278,333,13701,114,23,54510,10,4,0.10,2,2);

-- Incomplete Stats, just for summoning purpose
INSERT INTO `pets_stats` VALUES
('Deseloph',1562,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Deseloph',1562,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Hyum',1563,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Hyum',1563,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Rekang',1564,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Rekang',1564,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Lilias',1565,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Lilias',1565,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Lapham',1566,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Lapham',1566,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Mafum',1567,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Mafum',1567,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Deseloph',1568,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Deseloph',1568,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Hyum',1569,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Hyum',1569,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Rekang',1570,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Rekang',1570,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Lilias',1571,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Lilias',1571,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Lapham',1572,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Lapham',1572,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Mafum',1573,70,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1),
('Improved_Mafum',1573,71,0,57,1305,11,39,3,33,38,33,44,180,278,333,10800,0,0,45540,2,1,0.00,1,1);