DROP TABLE IF EXISTS `walker_routes`;
CREATE TABLE `walker_routes` (
  `route_id` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `npc_id` smallint(5) unsigned NOT NULL DEFAULT '0',
  `move_point` tinyint(2) unsigned NOT NULL,
  `chatText` varchar(255) DEFAULT NULL,
  `move_x` mediumint(6) NOT NULL DEFAULT '0',
  `move_y` mediumint(6) NOT NULL DEFAULT '0',
  `move_z` mediumint(6) NOT NULL DEFAULT '0',
  `delay` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `running` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`route_id`,`npc_id`,`move_point`)
);

INSERT INTO `walker_routes` VALUES
(1,31361,1,NULL,22418,10249,-3648,61,1),
(1,31361,2,NULL,23423,11165,-3720,0,1),
(1,31361,3,NULL,20182,11101,-3720,0,1),
(1,31361,4,NULL,17327,13603,-3728,1,1),
(1,31361,5,'数日後には闇の礼拝が始まります。警備の手を緩めないでくださいね！',17410,13038,-3736,10,1),
(1,31361,6,NULL,20176,12902,-3712,0,1),
(1,31361,7,NULL,21669,13378,-3616,0,1),
(1,31361,8,NULL,20675,10401,-3712,0,1),
(2,31360,1,NULL,10820,14770,-4240,62,0),
(2,31360,2,NULL,10947,14642,-4240,0,0),
(2,31360,3,NULL,11301,15844,-4584,0,0),
(2,31360,4,NULL,12107,16431,-4584,0,0),
(2,31360,5,'お疲れ様です、ライラ様！',15097,15662,-4376,6,0),
(2,31360,6,NULL,15269,16281,-4376,7,0),
(2,31360,7,NULL,12336,16921,-4584,0,0),
(2,31360,8,NULL,11786,17663,-4564,0,0),
(2,31360,9,NULL,11246,17650,-4568,0,0),
(2,31360,10,NULL,10649,17284,-4584,0,0),
(2,31360,11,'お疲れ様です！',7692,18041,-4376,6,0),
(2,31360,12,NULL,10549,16780,-4584,0,0),
(2,31360,13,NULL,10722,16538,-4584,0,0),
(2,31360,14,NULL,11008,15927,-4584,0,0),
(3,31362,1,'リードさん！マーフリンさん！エアリーさん！お元気ですか。',114847,-180066,-877,30,0),
(3,31362,2,NULL,114834,-179685,-877,2,0),
(3,31362,3,NULL,116122,-179457,-1068,1,0),
(3,31362,4,NULL,116798,-180391,-1200,2,0),
(3,31362,5,NULL,116324,-181564,-1384,2,0),
(3,31362,6,NULL,115797,-181563,-1336,0,0),
(3,31362,7,'さあ、それじゃあひと回りしてみようか。',116054,-181575,-1352,0,0),
(3,31362,8,NULL,116506,-181478,-1384,2,0),
(3,31362,9,NULL,116634,-180029,-1160,1,0),
(3,31362,10,NULL,115347,-178623,-928,1,0),
(3,31362,11,NULL,115763,-177591,-888,2,0),
(3,31362,12,'ガリタさん！ミオンさん！良い一日を！',115801,-177342,-880,1,0),
(3,31362,13,NULL,115869,-177340,-880,15,0),
(3,31362,14,NULL,115788,-177482,-880,3,0),
(3,31362,15,NULL,115124,-179821,-885,1,0),
(3,31362,16,NULL,115103,-180065,-877,1,0),
(4,31363,1,'すばしっこい奴め！どこに隠れたんだ？',116731,-182477,-1512,10,1),
(4,31363,2,NULL,115870,-183280,-1472,0,1),
(4,31363,3,NULL,115746,-183428,-1472,1,1),
(4,31363,4,NULL,115870,-183280,-1472,1,1),
(4,31363,5,NULL,115999,-183246,-1480,0,1),
(4,31363,6,NULL,116094,-183113,-1480,1,1),
(4,31363,7,'今日、トロッコを見かけませんでしたか。',116584,-184294,-1568,11,1),
(4,31363,8,NULL,116392,-184100,-1560,1,1),
(4,31363,9,NULL,117093,-182524,-1528,1,1),
(4,31363,10,'もしかして、トロッコを見かけませんでしたか。',117789,-182540,-1528,11,1),
(5,31359,1,NULL,45744,50561,-3065,61,0),
(5,31359,2,NULL,46444,49742,-3065,2,0),
(5,31359,3,'世界樹を元気にする方法はないかな？',46103,48798,-3065,5,0),
(5,31359,4,'世界樹がだんだん枯れていく．．．',45403,48436,-3065,5,0),
(5,31359,5,NULL,44444,49078,-3065,0,0),
(5,31359,6,NULL,44414,50025,-3065,0,0),
(5,31359,7,NULL,44957,50568,-3065,0,0),
(5,31359,8,NULL,44414,50025,-3065,0,0),
(5,31359,9,NULL,44444,49078,-3065,0,0),
(5,31359,10,'世界樹がだんだん枯れていく．．．',45403,48436,-3065,5,0),
(5,31359,11,'世界樹を元気にする方法はないかな？',46103,48798,-3065,5,0),
(5,31359,12,NULL,46444,49742,-3065,2,0),
(6,31358,1,'ミンティエル様！汝に湖畔の平和のあらんことを！',47015,51278,-2992,65,0),
(6,31358,2,NULL,47437,50441,-2992,0,0),
(6,31358,3,NULL,47509,49038,-2992,0,0),
(6,31358,4,NULL,46725,47755,-2992,0,0),
(6,31358,5,'いつ見ても世界樹は美しい．．．',45319,47339,-2992,5,0),
(6,31358,6,NULL,43998,47672,-2992,0,0),
(6,31358,7,NULL,43037,49310,-2992,0,0),
(6,31358,8,NULL,43310,50382,-2992,0,0),
(6,31358,9,NULL,43896,51060,-2992,0,0),
(6,31358,10,NULL,43312,50362,-2992,0,0),
(6,31358,11,NULL,43040,49311,-2992,0,0),
(6,31358,12,NULL,44018,47645,-2992,0,0),
(6,31358,13,'いつ見ても世界樹は美しい．．．',45301,47340,-2992,5,0),
(6,31358,14,NULL,46693,47752,-2992,0,0),
(6,31358,15,NULL,47489,48976,-2992,0,0),
(6,31358,16,NULL,47441,50455,-2992,0,0),
(7,31357,1,'一体どこに行ったんだろう？',-86328,241120,-3734,60,0),
(7,31357,2,NULL,-86505,240727,-3704,0,0),
(7,31357,3,NULL,-86081,240402,-3712,0,0),
(7,31357,4,'あの、ウィンダウッド様を見かけませんでしたか。',-86078,240853,-3720,15,0),
(7,31357,5,NULL,-85957,241389,-3728,0,0),
(7,31357,6,'一体どこに行ったんだろう？',-83993,242766,-3728,10,0),
(7,31357,7,NULL,-82952,244461,-3728,0,0),
(7,31357,8,NULL,-82370,244919,-3720,0,0),
(7,31357,9,NULL,-82129,245020,-3720,0,0),
(7,31357,10,NULL,-82198,245350,-3712,0,0),
(7,31357,11,NULL,-82554,245137,-3716,1,0),
(7,31357,12,NULL,-82198,245350,-3712,0,0),
(7,31357,13,NULL,-82129,245020,-3720,0,0),
(7,31357,14,NULL,-82370,244919,-3720,0,0),
(7,31357,15,NULL,-82952,244461,-3728,0,0),
(7,31357,16,'一体どこに行ったんだろう？',-83993,242766,-3728,10,0),
(7,31357,17,NULL,-85957,241389,-3728,0,0),
(7,31357,18,'あの、ウィンダウッド様を見かけませんでしたか。',-86078,240853,-3720,15,0),
(7,31357,19,NULL,-86081,240402,-3712,0,0),
(7,31357,20,NULL,-86505,240727,-3704,0,0),
(8,31356,1,'レクターさんにお届けですね？はい、かしこまりました～',-81681,243384,-3712,61,1),
(8,31356,2,NULL,-81915,243870,-3712,1,1),
(8,31356,3,NULL,-82084,243659,-3712,0,1),
(8,31356,4,NULL,-83148,243731,-3728,0,1),
(8,31356,5,'ふう、ちょっと休もうっと～',-84497,243241,-3728,6,1),
(8,31356,6,NULL,-85212,243184,-3728,0,1),
(8,31356,7,NULL,-86161,242898,-3728,0,1),
(8,31356,8,NULL,-86281,242963,-3720,0,1),
(8,31356,9,'こんにちは、レクターさん！ジャクソンさんもご無沙汰してます！',-86356,243201,-3720,7,1),
(8,31356,10,NULL,-86491,242781,-3720,0,1),
(8,31356,11,NULL,-86497,242585,-3728,0,1),
(8,31356,12,NULL,-86114,241587,-3728,0,1),
(8,31356,13,NULL,-85184,240679,-3728,0,1),
(8,31356,14,'ルンルン～',-84075,241282,-3728,3,1),
(8,31356,15,'ルンルン～',-84075,241282,-3728,3,1),
(8,31356,16,'ルンルン～',-83709,241238,-3728,0,1),
(8,31356,17,NULL,-83182,241141,-3728,1,1),
(8,31356,18,NULL,-82383,242926,-3720,1,1),
(9,31364,1,NULL,-46506,-109402,-238,10,0),
(9,31364,2,NULL,-45752,-111652,-240,0,0),
(9,31364,3,NULL,-44028,-112688,-240,0,0),
(9,31364,4,NULL,-44049,-114536,-240,0,0),
(9,31364,5,NULL,-45540,-115415,-240,0,0),
(9,31364,6,NULL,-46526,-117731,-240,0,0),
(9,31364,7,NULL,-45540,-115415,-240,0,0),
(9,31364,8,NULL,-44049,-114536,-240,0,0),
(9,31364,9,NULL,-44028,-112688,-240,0,0),
(9,31364,10,NULL,-45752,-111652,-240,0,0),
(10,31365,1,NULL,-48807,-113489,-241,61,0),
(10,31365,2,NULL,-48821,-113746,-232,1,0),
(10,31365,3,NULL,-48823,-113505,-232,61,0),
(10,31365,4,NULL,-47339,-113581,-232,1,0),
(10,31365,5,NULL,-45740,-113562,-240,0,0),
(10,31365,6,NULL,-44851,-112965,-240,0,0),
(10,31365,7,NULL,-44308,-113207,-240,0,0),
(10,31365,8,NULL,-44204,-113743,-240,0,0),
(10,31365,9,NULL,-44659,-114171,-240,0,0),
(10,31365,10,NULL,-45167,-114034,-224,0,0),
(10,31365,11,NULL,-45658,-113633,-240,0,0),
(10,31365,12,NULL,-47363,-113621,-224,0,0),
(10,31365,13,NULL,-48829,-113746,-232,0,0),
(10,31365,14,NULL,-47363,-113621,-224,0,0),
(10,31365,15,NULL,-45658,-113633,-240,0,0),
(10,31365,16,NULL,-45167,-114034,-224,0,0),
(10,31365,17,NULL,-44659,-114171,-240,0,0),
(10,31365,18,NULL,-44204,-113743,-240,0,0),
(10,31365,19,NULL,-44308,-113207,-240,0,0),
(10,31365,20,NULL,-44851,-112965,-240,0,0),
(10,31365,21,NULL,-45740,-113562,-240,1,0),
(11,32072,1,NULL,84429,-144065,-1542,10,0),
(11,32072,2,NULL,84465,-142493,-1536,0,0),
(11,32072,3,NULL,85234,-140963,-1536,0,0),
(11,32072,4,NULL,87351,-140059,-1536,5,0),
(11,32072,5,NULL,89343,-140746,-1536,0,0),
(11,32072,6,NULL,90605,-143167,-1536,0,0),
(11,32072,7,NULL,90271,-143869,-1536,10,0),
(11,32072,8,NULL,90605,-143167,-1536,0,0),
(11,32072,9,NULL,89343,-140746,-1536,0,0),
(11,32072,10,NULL,87351,-140059,-1536,5,0),
(11,32072,11,NULL,85234,-140963,-1536,0,0),
(11,32072,12,NULL,84465,-142493,-1536,0,0),
(12,32070,1,NULL,90271,-143869,-1547,10,1),
(12,32070,2,NULL,90605,-143167,-1536,1,1),
(12,32070,3,NULL,89343,-140746,-1536,1,1),
(12,32070,4,NULL,87351,-140059,-1536,5,1),
(12,32070,5,NULL,85234,-140963,-1536,1,1),
(12,32070,6,NULL,84465,-142493,-1536,1,1),
(12,32070,7,NULL,84434,-144061,-1528,10,1),
(12,32070,8,NULL,84465,-142493,-1536,1,1),
(12,32070,9,NULL,85234,-140963,-1536,1,1),
(12,32070,10,NULL,87351,-140059,-1536,5,1),
(12,32070,11,NULL,89343,-140746,-1536,1,1),
(12,32070,12,NULL,90605,-143167,-1536,1,1);

INSERT INTO `walker_routes` VALUES
(13,29095,1,NULL,141569,-45908,-2387,10,0),
(13,29095,2,NULL,142494,-45456,-2397,0,0),
(13,29095,3,NULL,142922,-44561,-2395,0,0),
(13,29095,4,NULL,143672,-44130,-2398,0,0),
(13,29095,5,NULL,144557,-43378,-2325,0,0),
(13,29095,6,NULL,145839,-43267,-2301,0,0),
(13,29095,7,NULL,147044,-43601,-2307,0,0),
(13,29095,8,NULL,148140,-43206,-2303,0,0),
(13,29095,9,NULL,148815,-43434,-2328,5,0),
(13,29095,10,NULL,149862,-44151,-2558,0,0),
(13,29095,11,NULL,151037,-44197,-2708,5,0),
(13,29095,12,NULL,152555,-42756,-2836,0,0),
(13,29095,13,NULL,154808,-39546,-3236,0,0),
(13,29095,14,NULL,155333,-39962,-3272,0,0),
(13,29095,15,NULL,156531,-41240,-3470,0,0),
(13,29095,16,NULL,156863,-43232,-3707,0,0),
(13,29095,17,NULL,156783,-44198,-3764,0,0),
(13,29095,18,NULL,158169,-45163,-3541,0,0),
(13,29095,19,NULL,158952,-45479,-3473,0,0),
(13,29095,20,NULL,160039,-46514,-3634,0,0),
(13,29095,21,NULL,160244,-47429,-3656,3,0),
(13,29095,22,NULL,159155,-48109,-3665,0,0),
(13,29095,23,NULL,159558,-51027,-3523,0,0),
(13,29095,24,NULL,159396,-53362,-3244,3,0),
(13,29095,25,NULL,160872,-56556,-2789,0,0),
(13,29095,26,NULL,160857,-59072,-2613,5,0),
(13,29095,27,NULL,160410,-59888,-2647,0,0),
(13,29095,28,NULL,158770,-60173,-2673,0,0),
(13,29095,29,NULL,156368,-59557,-2638,3,0),
(13,29095,30,NULL,155188,-59868,-2642,0,0),
(13,29095,31,NULL,154118,-60591,-2731,0,0),
(13,29095,32,NULL,153571,-61567,-2821,0,0),
(13,29095,33,NULL,153457,-62819,-2886,3,0),
(13,29095,34,NULL,152939,-63778,-3003,0,0),
(13,29095,35,NULL,151816,-64209,-3120,0,0),
(13,29095,36,NULL,147655,-64826,-3433,0,0),
(13,29095,37,NULL,145422,-64576,-3369,0,0),
(13,29095,38,NULL,144097,-64320,-3404,0,0),
(13,29095,39,NULL,140780,-61618,-3096,0,0),
(13,29095,40,NULL,139688,-61450,-3062,0,0),
(13,29095,41,NULL,138267,-61743,-3056,3,0),
(13,29095,42,NULL,138613,-58491,-3465,0,0),
(13,29095,43,NULL,138139,-57252,-3517,5,0),
(13,29095,44,NULL,139555,-56044,-3310,0,0),
(13,29095,45,NULL,139107,-54537,-3240,0,0),
(13,29095,46,NULL,139279,-53781,-3091,0,0),
(13,29095,47,NULL,139810,-52687,-2866,0,0),
(13,29095,48,NULL,139657,-52041,-2793,0,0),
(13,29095,49,NULL,139215,-51355,-2698,0,0),
(13,29095,50,NULL,139334,-50514,-2594,0,0),
(13,29095,51,NULL,139817,-49715,-2449,0,0),
(13,29095,52,NULL,139824,-48976,-2263,0,0),
(13,29095,53,NULL,140130,-47578,-2213,0,0),
(13,29095,54,NULL,140483,-46339,-2382,5,0),
(13,29095,55,NULL,141569,-45908,-2387,0,0);

-- Suspicious Merchant - Shanty Fortress
INSERT INTO `walker_routes` VALUES
(101,35659,1,NULL,-58672,154703,-2688,30,0),
(101,35659,2,NULL,-57522,156523,-2576,15,0),
(101,35659,3,NULL,-55226,157117,-2064,0,0),
(101,35659,4,NULL,-57528,156515,-2576,0,0),
(101,35659,5,NULL,-58660,154706,-2688,0,0),
(101,35659,6,NULL,-60174,156182,-2832,0,0),
(101,35659,7,NULL,-61834,157703,-3264,0,0),
(101,35659,8,NULL,-62761,159101,-3584,0,0),
(101,35659,9,NULL,-63472,159672,-3680,0,0),
(101,35659,10,NULL,-64072,160631,-3760,0,0),
(101,35659,11,NULL,-64387,161877,-3792,0,0),
(101,35659,12,NULL,-63842,163092,-3840,15,0),
(101,35659,13,NULL,-64397,161831,-3792,0,0),
(101,35659,14,NULL,-64055,160587,-3760,0,0),
(101,35659,15,NULL,-63461,159656,-3680,0,0),
(101,35659,16,NULL,-62744,159095,-3584,0,0),
(101,35659,17,NULL,-61831,157693,-3256,0,0),
(101,35659,18,NULL,-60152,156167,-2824,0,0),
(101,35659,19,NULL,-58652,154707,-2688,0,0),
(101,35659,20,NULL,-58672,154703,-2688,0,0);

-- Suspicious Merchant - Southern Fortress
INSERT INTO `walker_routes` VALUES
(102,35690,1,NULL,-28169,216864,-3544,30,0),
(102,35690,2,NULL,-29028,215089,-3672,0,0),
(102,35690,3,NULL,-30888,213455,-3656,0,0),
(102,35690,4,NULL,-31937,211656,-3656,0,0),
(102,35690,5,NULL,-30880,211006,-3552,0,0),
(102,35690,6,NULL,-27690,210004,-3272,0,0),
(102,35690,7,NULL,-25784,210108,-3272,0,0),
(102,35690,8,NULL,-21682,211459,-3272,0,0),
(102,35690,9,NULL,-18430,212927,-3704,0,0),
(102,35690,10,NULL,-16247,212795,-3664,0,0),
(102,35690,11,NULL,-16868,214267,-3648,0,0),
(102,35690,12,NULL,-17263,215887,-3552,0,0),
(102,35690,13,NULL,-18352,216841,-3504,60,0),
(102,35690,14,NULL,-17263,215887,-3552,0,0),
(102,35690,15,NULL,-16868,214267,-3648,0,0),
(102,35690,16,NULL,-16247,212795,-3664,0,0),
(102,35690,17,NULL,-18430,212927,-3704,0,0),
(102,35690,18,NULL,-21682,211459,-3272,0,0),
(102,35690,19,NULL,-25784,210108,-3272,0,0),
(102,35690,20,NULL,-27690,210004,-3272,0,0),
(102,35690,21,NULL,-30880,211006,-3552,0,0),
(102,35690,22,NULL,-31937,211656,-3656,0,0),
(102,35690,23,NULL,-30888,213455,-3656,0,0),
(102,35690,24,NULL,-29028,215089,-3672,0,0),
(102,35690,25,NULL,-28169,216864,-3544,30,0);

-- Suspicious Merchant - Hive Fortress
INSERT INTO `walker_routes` VALUES
(103,35728,1,NULL,19408,189422,-3136,30,0),
(103,35728,2,NULL,20039,187700,-3416,0,0),
(103,35728,3,NULL,19016,185813,-3552,30,0),
(103,35728,4,NULL,17959,181955,-3680,0,0),
(103,35728,5,NULL,16440,181635,-3616,30,0),
(103,35728,6,NULL,15679,182540,-3608,0,0),
(103,35728,7,NULL,15310,182791,-3568,0,0),
(103,35728,8,NULL,15242,184507,-3112,30,0),
(103,35728,9,NULL,15310,182791,-3568,0,0),
(103,35728,10,NULL,15679,182540,-3608,0,0),
(103,35728,11,NULL,16440,181635,-3616,30,0),
(103,35728,12,NULL,17959,181955,-3680,0,0),
(103,35728,13,NULL,19016,185813,-3552,30,0),
(103,35728,14,NULL,20039,187700,-3416,0,0),
(103,35728,15,NULL,19408,189422,-3136,30,0);

-- Suspicious Merchant - Valley Fortress
INSERT INTO `walker_routes` VALUES
(104,35759,1,NULL,123383,121093,-2864,30,0),
(104,35759,2,NULL,122670,120890,-3088,0,0),
(104,35759,3,NULL,124617,119069,-3088,0,0),
(104,35759,4,NULL,126177,118273,-3080,0,0),
(104,35759,5,NULL,125979,119528,-2728,60,0),
(104,35759,6,NULL,126177,118273,-3080,0,0),
(104,35759,7,NULL,124617,119069,-3088,0,0),
(104,35759,8,NULL,122670,120890,-3088,0,0),
(104,35759,9,NULL,123383,121093,-2864,30,0);

-- Suspicious Merchant - Ivory Tower Fortress
INSERT INTO `walker_routes` VALUES
(105,35797,1,NULL,74725,1671,-3128,30,0),
(105,35797,2,NULL,76651,1505,-3552,0,0),
(105,35797,3,NULL,79421,4977,-3080,0,0),
(105,35797,4,NULL,77357,7197,-3208,30,0),
(105,35797,5,NULL,76287,9164,-3568,0,0),
(105,35797,6,NULL,72447,8196,-3264,0,0),
(105,35797,7,NULL,71780,7467,-3160,0,0),
(105,35797,8,NULL,72447,8196,-3264,0,0),
(105,35797,9,NULL,76287,9164,-3568,0,0),
(105,35797,10,NULL,77357,7197,-3208,0,0),
(105,35797,11,NULL,79421,4977,-3080,60,0),
(105,35797,12,NULL,76651,1505,-3552,0,0),
(105,35797,13,NULL,74725,1671,-3128,0,0);

-- Suspicious Merchant - Narsell Fortress
INSERT INTO `walker_routes` VALUES
(106,35828,1,NULL,159377,52403,-3312,30,0),
(106,35828,2,NULL,161177,54083,-3560,0,0),
(106,35828,3,NULL,162152,54365,-3632,0,0),
(106,35828,4,NULL,162703,55840,-3696,0,0),
(106,35828,5,NULL,162370,58534,-3504,0,0),
(106,35828,6,NULL,160099,60034,-3224,0,0),
(106,35828,7,NULL,158048,62696,-3464,0,0),
(106,35828,8,NULL,157220,63450,-3520,0,0),
(106,35828,9,NULL,155076,63731,-3544,0,0),
(106,35828,10,NULL,153893,64441,-3656,0,0),
(106,35828,11,NULL,153085,62948,-3680,0,0),
(106,35828,12,NULL,150866,58737,-3432,60,0),
(106,35828,13,NULL,153085,62948,-3680,0,0),
(106,35828,14,NULL,153893,64441,-3656,0,0),
(106,35828,15,NULL,155076,63731,-3544,0,0),
(106,35828,16,NULL,157220,63450,-3520,0,0),
(106,35828,17,NULL,158048,62696,-3464,0,0),
(106,35828,18,NULL,160099,60034,-3224,0,0),
(106,35828,19,NULL,162370,58534,-3504,0,0),
(106,35828,20,NULL,162703,55840,-3696,0,0),
(106,35828,21,NULL,162152,54365,-3632,0,0),
(106,35828,22,NULL,161177,54083,-3560,0,0),
(106,35828,23,NULL,159377,52403,-3312,30,0);

-- Suspicious Merchant - Bayou Fortress
INSERT INTO `walker_routes` VALUES
(107,35859,1,NULL,190423,43540,-3656,30,0),
(107,35859,2,NULL,189579,45949,-4240,0,0),
(107,35859,3,NULL,187058,43551,-4808,0,0),
(107,35859,4,NULL,185916,41869,-4512,30,0),
(107,35859,5,NULL,185292,39403,-4200,0,0),
(107,35859,6,NULL,185167,38401,-4200,0,0),
(107,35859,7,NULL,184984,36863,-4152,0,0),
(107,35859,8,NULL,184377,36425,-4080,0,0),
(107,35859,9,NULL,185314,35866,-3936,0,0),
(107,35859,10,NULL,185781,35955,-3832,0,0),
(107,35859,11,NULL,186686,35667,-3752,60,0),
(107,35859,12,NULL,185781,35955,-3832,0,0),
(107,35859,13,NULL,185314,35866,-3936,0,0),
(107,35859,14,NULL,184377,36425,-4080,0,0),
(107,35859,15,NULL,184984,36863,-4152,0,0),
(107,35859,16,NULL,185167,38401,-4200,0,0),
(107,35859,17,NULL,185292,39403,-4200,0,0),
(107,35859,18,NULL,185916,41869,-4512,30,0),
(107,35859,19,NULL,187058,43551,-4808,0,0),
(107,35859,20,NULL,189579,45949,-4240,0,0),
(107,35859,21,NULL,190423,43540,-3656,30,0);

-- Suspicious Merchant - White Sands Fortress
INSERT INTO `walker_routes` VALUES
(108,35897,1,NULL,114436,202528,-3408,30,0),
(108,35897,2,NULL,113809,200514,-3720,0,0),
(108,35897,3,NULL,116035,199822,-3664,0,0),
(108,35897,4,NULL,117017,199876,-3632,0,0),
(108,35897,5,NULL,119959,201032,-3608,0,0),
(108,35897,6,NULL,121849,200614,-3384,0,0),
(108,35897,7,NULL,122868,200874,-3168,0,0),
(108,35897,8,NULL,123130,202427,-3128,30,0),
(108,35897,9,NULL,122427,204162,-3488,0,0),
(108,35897,10,NULL,122661,204842,-3576,0,0),
(108,35897,11,NULL,124051,205402,-3576,0,0),
(108,35897,12,NULL,124211,206023,-3504,0,0),
(108,35897,13,NULL,124948,206778,-3400,0,0),
(108,35897,14,NULL,124483,207777,-3200,60,0),
(108,35897,15,NULL,124948,206778,-3400,0,0),
(108,35897,16,NULL,124211,206023,-3504,0,0),
(108,35897,17,NULL,124051,205402,-3576,0,0),
(108,35897,18,NULL,122661,204842,-3576,0,0),
(108,35897,19,NULL,122427,204162,-3488,0,0),
(108,35897,20,NULL,123130,202427,-3128,30,0),
(108,35897,21,NULL,122868,200874,-3168,0,0),
(108,35897,22,NULL,121849,200614,-3384,0,0),
(108,35897,23,NULL,119959,201032,-3608,0,0),
(108,35897,24,NULL,117017,199876,-3632,0,0),
(108,35897,25,NULL,116035,199822,-3664,0,0),
(108,35897,26,NULL,113809,200514,-3720,0,0),
(108,35897,27,NULL,114436,202528,-3408,30,0);

-- Suspicious Merchant - Borderland Fortress
INSERT INTO `walker_routes` VALUES
(109,35928,1,NULL,161876,-73407,-2984,30,0),
(109,35928,2,NULL,161795,-75288,-3088,0,0),
(109,35928,3,NULL,159678,-77671,-3584,0,0),
(109,35928,4,NULL,158917,-78117,-3760,0,0),
(109,35928,5,NULL,158989,-77130,-3720,0,0),
(109,35928,6,NULL,158757,-75951,-3720,0,0),
(109,35928,7,NULL,158157,-74161,-3592,30,0),
(109,35928,8,NULL,157547,-73326,-3400,0,0),
(109,35928,9,NULL,153815,-71497,-3392,0,0),
(109,35928,10,NULL,153086,-70701,-3488,0,0),
(109,35928,11,NULL,152262,-70352,-3568,0,0),
(109,35928,12,NULL,155193,-69617,-3008,60,0),
(109,35928,13,NULL,152262,-70352,-3568,0,0),
(109,35928,14,NULL,153086,-70701,-3488,0,0),
(109,35928,15,NULL,153815,-71497,-3392,0,0),
(109,35928,16,NULL,157547,-73326,-3400,0,0),
(109,35928,17,NULL,158157,-74161,-3592,30,0),
(109,35928,18,NULL,158757,-75951,-3720,0,0),
(109,35928,19,NULL,158989,-77130,-3720,0,0),
(109,35928,20,NULL,158917,-78117,-3760,0,0),
(109,35928,21,NULL,159678,-77671,-3584,0,0),
(109,35928,22,NULL,161795,-75288,-3088,0,0),
(109,35928,23,NULL,161876,-73407,-2984,30,0);

-- Suspicious Merchant - Swamp Fortress
INSERT INTO `walker_routes` VALUES
(110,35966,1,NULL,71436,-58182,-2904,30,0),
(110,35966,2,NULL,71731,-56949,-3080,0,0),
(110,35966,3,NULL,72715,-56729,-3104,0,0),
(110,35966,4,NULL,73277,-56055,-3104,30,0),
(110,35966,5,NULL,73369,-55636,-3104,0,0),
(110,35966,6,NULL,74136,-54646,-3104,0,0),
(110,35966,7,NULL,73408,-54422,-3104,0,0),
(110,35966,8,NULL,72998,-53404,-3136,0,0),
(110,35966,9,NULL,71661,-52937,-3104,0,0),
(110,35966,10,NULL,71127,-52304,-3104,0,0),
(110,35966,11,NULL,70225,-52304,-3064,0,0),
(110,35966,12,NULL,69668,-52780,-3064,0,0),
(110,35966,13,NULL,68422,-52407,-3240,0,0),
(110,35966,14,NULL,67702,-52940,-3208,0,0),
(110,35966,15,NULL,67798,-52940,-3232,0,0),
(110,35966,16,NULL,66667,-55841,-2840,60,0),
(110,35966,17,NULL,67798,-52940,-3232,0,0),
(110,35966,18,NULL,67702,-52940,-3208,0,0),
(110,35966,19,NULL,68422,-52407,-3240,0,0),
(110,35966,20,NULL,69668,-52780,-3064,0,0),
(110,35966,21,NULL,70225,-52304,-3064,0,0),
(110,35966,22,NULL,71127,-52304,-3104,0,0),
(110,35966,23,NULL,71661,-52937,-3104,0,0),
(110,35966,24,NULL,72998,-53404,-3136,0,0),
(110,35966,25,NULL,73408,-54422,-3104,0,0),
(110,35966,26,NULL,74136,-54646,-3104,0,0),
(110,35966,27,NULL,73369,-55636,-3104,0,0),
(110,35966,28,NULL,73277,-56055,-3104,30,0),
(110,35966,29,NULL,72715,-56729,-3104,0,0),
(110,35966,30,NULL,71731,-56949,-3080,0,0),
(110,35966,31,NULL,71436,-58182,-2904,30,0);

-- Suspicious Merchant - Archaic Fortress
INSERT INTO `walker_routes` VALUES
(111,36004,1,NULL,105447,-139845,-3120,30,0),
(111,36004,2,NULL,104918,-140382,-3256,0,0),
(111,36004,3,NULL,105507,-142515,-3648,0,0),
(111,36004,4,NULL,106533,-143107,-3656,0,0),
(111,36004,5,NULL,106714,-143825,-3656,0,0),
(111,36004,6,NULL,107510,-144024,-3656,0,0),
(111,36004,7,NULL,108092,-144888,-3656,30,0),
(111,36004,8,NULL,109499,-145168,-3664,0,0),
(111,36004,9,NULL,110064,-146169,-3456,0,0),
(111,36004,10,NULL,110186,-147427,-3096,0,0),
(111,36004,11,NULL,112389,-147779,-3256,60,0),
(111,36004,12,NULL,110186,-147427,-3096,0,0),
(111,36004,13,NULL,110064,-146169,-3456,0,0),
(111,36004,14,NULL,109499,-145168,-3664,0,0),
(111,36004,15,NULL,108092,-144888,-3656,30,0),
(111,36004,16,NULL,107510,-144024,-3656,0,0),
(111,36004,17,NULL,106714,-143825,-3656,0,0),
(111,36004,18,NULL,106533,-143107,-3656,0,0),
(111,36004,19,NULL,105507,-142515,-3648,0,0),
(111,36004,20,NULL,104918,-140382,-3256,0,0),
(111,36004,21,NULL,105447,-139845,-3120,30,0);

-- Suspicious Merchant - Floran Fortress
INSERT INTO `walker_routes` VALUES
(112,36035,1,NULL,14186,149947,-3352,20,0),
(112,36035,2,NULL,16180,150387,-3216,0,0),
(112,36035,3,NULL,18387,151874,-3317,0,0),
(112,36035,4,NULL,18405,154770,-3616,30,0),
(112,36035,5,NULL,17655,156863,-3664,0,0),
(112,36035,6,NULL,12303,153937,-2680,0,0),
(112,36035,7,NULL,17655,156863,-3664,0,0),
(112,36035,8,NULL,18405,154770,-3616,30,0),
(112,36035,9,NULL,18387,151874,-3317,0,0),
(112,36035,10,NULL,16180,150387,-3216,0,0),
(112,36035,11,NULL,14186,149947,-3352,20,0);

-- Suspicious Merchant - Cloud Mountain
INSERT INTO `walker_routes` VALUES
(113,36073,1,NULL,-56032,86017,-3259,30,0),
(113,36073,2,NULL,-57329,86006,-3640,0,0),
(113,36073,3,NULL,-57470,85306,-3664,0,0),
(113,36073,4,NULL,-58892,85159,-3768,30,0),
(113,36073,5,NULL,-59030,80150,-3632,0,0),
(113,36073,6,NULL,-57642,77591,-3512,20,0),
(113,36073,7,NULL,-53971,77664,-3224,40,0),
(113,36073,8,NULL,-53271,85126,-3552,60,0),
(113,36073,9,NULL,-53971,77664,-3224,40,0),
(113,36073,10,NULL,-57642,77591,-3512,20,0),
(113,36073,11,NULL,-59030,80150,-3632,0,0),
(113,36073,12,NULL,-58892,85159,-3768,30,0),
(113,36073,13,NULL,-57470,85306,-3664,0,0),
(113,36073,14,NULL,-57329,86006,-3640,0,0),
(113,36073,15,NULL,-56032,86017,-3259,30,0);

-- Suspicious Merchant - Tanor Fortress
INSERT INTO `walker_routes` VALUES
(114,36111,1,NULL,58314,136319,-2000,30,0),
(114,36111,2,NULL,57078,137124,-2216,0,0),
(114,36111,3,NULL,54644,137366,-2600,0,0),
(114,36111,4,NULL,58696,134202,-3096,30,0),
(114,36111,5,NULL,60967,134154,-3416,0,0),
(114,36111,6,NULL,62813,134744,-3592,0,0),
(114,36111,7,NULL,65158,135007,-3728,0,0),
(114,36111,8,NULL,64278,139384,-3176,30,0),
(114,36111,9,NULL,63711,140599,-2720,0,0),
(114,36111,10,NULL,63187,141192,-2440,0,0),
(114,36111,11,NULL,62811,142466,-2064,60,0),
(114,36111,12,NULL,63187,141192,-2440,0,0),
(114,36111,13,NULL,63711,140599,-2720,0,0),
(114,36111,14,NULL,64278,139384,-3176,30,0),
(114,36111,15,NULL,65158,135007,-3728,0,0),
(114,36111,16,NULL,62813,134744,-3592,0,0),
(114,36111,17,NULL,60967,134154,-3416,0,0),
(114,36111,18,NULL,58696,134202,-3096,30,0),
(114,36111,19,NULL,54644,137366,-2600,0,0),
(114,36111,20,NULL,57078,137124,-2216,0,0),
(114,36111,21,NULL,58314,136319,-2000,30,0);

-- Suspicious Merchant - Dragonspine Fortress
INSERT INTO `walker_routes` VALUES
(115,36142,1,NULL,9318,92253,-3536,30,0),
(115,36142,2,NULL,9117,91645,-3656,0,0),
(115,36142,3,NULL,9240,90149,-3592,0,0),
(115,36142,4,NULL,11509,90093,-3720,20,0),
(115,36142,5,NULL,13269,90004,-3840,20,0),
(115,36142,6,NULL,14812,89578,-3832,20,0),
(115,36142,7,NULL,14450,90636,-3680,0,0),
(115,36142,8,NULL,14236,91690,-3656,0,0),
(115,36142,9,NULL,13636,92359,-3480,60,0),
(115,36142,10,NULL,14236,91690,-3656,0,0),
(115,36142,11,NULL,14450,90636,-3680,0,0),
(115,36142,12,NULL,14812,89578,-3832,20,0),
(115,36142,13,NULL,13269,90004,-3840,20,0),
(115,36142,14,NULL,11509,90093,-3720,20,0),
(115,36142,15,NULL,9240,90149,-3592,0,0),
(115,36142,16,NULL,9117,91645,-3656,0,0),
(115,36142,17,NULL,9318,92253,-3536,30,0);

-- Suspicious Merchant - Antharas Fortress
INSERT INTO `walker_routes` VALUES
(116,36173,1,NULL,74810,90814,-3344,30,0),
(116,36173,2,NULL,75094,92951,-3104,0,0),
(116,36173,3,NULL,75486,92906,-3072,0,0),
(116,36173,4,NULL,75765,91794,-2912,0,0),
(116,36173,5,NULL,77116,90455,-2896,0,0),
(116,36173,6,NULL,77743,89119,-2896,15,0),
(116,36173,7,NULL,77118,90457,-2896,0,0),
(116,36173,8,NULL,75750,91811,-2912,0,0),
(116,36173,9,NULL,75479,92904,-3072,0,0),
(116,36173,10,NULL,75094,92943,-3104,0,0),
(116,36173,11,NULL,74809,90794,-3344,0,0),
(116,36173,12,NULL,76932,88297,-3296,0,0),
(116,36173,13,NULL,77882,87441,-3408,0,0),
(116,36173,14,NULL,78257,85859,-3632,0,0),
(116,36173,15,NULL,80994,85866,-3472,0,0),
(116,36173,16,NULL,82676,87519,-3360,0,0),
(116,36173,17,NULL,83778,88414,-3376,0,0),
(116,36173,18,NULL,83504,90378,-3120,0,0),
(116,36173,19,NULL,84431,90379,-3264,0,0),
(116,36173,20,NULL,85453,90117,-3312,0,0),
(116,36173,21,NULL,85605,89708,-3296,0,0),
(116,36173,22,NULL,84894,88975,-3344,0,0),
(116,36173,23,NULL,83735,88382,-3376,0,0),
(116,36173,24,NULL,82616,87485,-3360,0,0),
(116,36173,25,NULL,80971,85855,-3472,0,0),
(116,36173,26,NULL,78247,85853,-3632,0,0),
(116,36173,27,NULL,77868,87463,-3408,0,0),
(116,36173,28,NULL,76916,88304,-3280,0,0),
(116,36173,29,NULL,75494,89865,-3200,0,0),
(116,36173,30,NULL,74810,90814,-3344,30,0);

-- Suspicious Merchant - Western Fortress
INSERT INTO `walker_routes` VALUES
(117,36211,1,NULL,114221,-18762,-1768,30,0),
(117,36211,2,NULL,115920,-19177,-2120,0,0),
(117,36211,3,NULL,117105,-19759,-2400,0,0),
(117,36211,4,NULL,118417,-20135,-2632,30,0),
(117,36211,5,NULL,118881,-20011,-2712,0,0),
(117,36211,6,NULL,117210,-18329,-1816,60,0),
(117,36211,7,NULL,118881,-20011,-2712,0,0),
(117,36211,8,NULL,118417,-20135,-2632,30,0),
(117,36211,9,NULL,117105,-19759,-2400,0,0),
(117,36211,10,NULL,115920,-19177,-2120,0,0),
(117,36211,11,NULL,114221,-18762,-1768,30,0);

-- Suspicious Merchant - Hunters Fortress
INSERT INTO `walker_routes` VALUES
(118,36249,1,NULL,121072,93215,-2736,30,0),
(118,36249,2,NULL,122718,92355,-2320,0,0),
(118,36249,3,NULL,126171,91910,-2216,0,0),
(118,36249,4,NULL,126353,90422,-2296,0,0),
(118,36249,5,NULL,125796,87720,-2432,0,0),
(118,36249,6,NULL,124803,85970,-2464,0,0),
(118,36249,7,NULL,125036,83836,-2376,30,0),
(118,36249,8,NULL,128886,83331,-1416,0,0),
(118,36249,9,NULL,129697,84969,-1256,0,0),
(118,36249,10,NULL,126291,86712,-2240,0,0),
(118,36249,11,NULL,126599,88950,-2325,0,0),
(118,36249,12,NULL,126847,90713,-2264,0,0),
(118,36249,13,NULL,126599,88950,-2325,0,0),
(118,36249,14,NULL,126291,86712,-2240,0,0),
(118,36249,15,NULL,129697,84969,-1256,0,0),
(118,36249,16,NULL,128886,83331,-1416,0,0),
(118,36249,17,NULL,125036,83836,-2376,30,0),
(118,36249,18,NULL,124803,85970,-2464,0,0),
(118,36249,19,NULL,125796,87720,-2432,0,0),
(118,36249,20,NULL,126353,90422,-2296,0,0),
(118,36249,21,NULL,126171,91910,-2216,0,0),
(118,36249,22,NULL,122718,92355,-2320,0,0),
(118,36249,23,NULL,121072,93215,-2736,30,0);

-- Suspicious Merchant - Aaru Fortress
INSERT INTO `walker_routes` VALUES
(119,36287,1,NULL,71692,188004,-2616,30,0),
(119,36287,2,NULL,69326,187042,-3008,0,0),
(119,36287,3,NULL,68627,185540,-2984,0,0),
(119,36287,4,NULL,69077,184566,-2976,30,0),
(119,36287,5,NULL,70642,182573,-2992,0,0),
(119,36287,6,NULL,73647,181706,-3160,0,0),
(119,36287,7,NULL,74283,181756,-3152,0,0),
(119,36287,8,NULL,73655,182960,-2736,60,0),
(119,36287,9,NULL,74283,181756,-3152,0,0),
(119,36287,10,NULL,73647,181706,-3160,0,0),
(119,36287,11,NULL,70642,182573,-2992,0,0),
(119,36287,12,NULL,69077,184566,-2976,30,0),
(119,36287,13,NULL,68627,185540,-2984,0,0),
(119,36287,14,NULL,69326,187042,-3008,0,0),
(119,36287,15,NULL,71692,188004,-2616,30,0);

-- Suspicious Merchant - Demon Fortress
INSERT INTO `walker_routes` VALUES
(120,36318,1,NULL,104150,-57163,-848,30,0),
(120,36318,2,NULL,106218,-59401,-1344,0,0),
(120,36318,3,NULL,106898,-59553,-1664,30,0),
(120,36318,4,NULL,107352,-60168,-2000,0,0),
(120,36318,5,NULL,107651,-61177,-2400,0,0),
(120,36318,6,NULL,109094,-62678,-3248,0,0),
(120,36318,7,NULL,108266,-62657,-3104,0,0),
(120,36318,8,NULL,105169,-61226,-2616,0,0),
(120,36318,9,NULL,102968,-59982,-2384,0,0),
(120,36318,10,NULL,100070,-60173,-2792,0,0),
(120,36318,11,NULL,98764,-61095,-2768,0,0),
(120,36318,12,NULL,94946,-60039,-2432,0,0),
(120,36318,13,NULL,96103,-59078,-1992,0,0),
(120,36318,14,NULL,96884,-59043,-1656,0,0),
(120,36318,15,NULL,97064,-57884,-1256,30,0),
(120,36318,16,NULL,96884,-59043,-1656,0,0),
(120,36318,17,NULL,96103,-59078,-1992,0,0),
(120,36318,18,NULL,94946,-60039,-2432,0,0),
(120,36318,19,NULL,98764,-61095,-2768,0,0),
(120,36318,20,NULL,100070,-60173,-2792,0,0),
(120,36318,21,NULL,102968,-59982,-2384,0,0),
(120,36318,22,NULL,105169,-61226,-2616,0,0),
(120,36318,23,NULL,108266,-62657,-3104,0,0),
(120,36318,24,NULL,109094,-62678,-3248,0,0),
(120,36318,25,NULL,107651,-61177,-2400,0,0),
(120,36318,26,NULL,107352,-60168,-2000,0,0),
(120,36318,27,NULL,106898,-59553,-1664,30,0),
(120,36318,28,NULL,106218,-59401,-1344,0,0),
(120,36318,29,NULL,104150,-57163,-848,30,0);

-- Suspicious Merchant - Monastic Fortress
INSERT INTO `walker_routes` VALUES
(121,36356,1,NULL,69553,-91746,-1488,30,0),
(121,36356,2,NULL,70941,-89751,-2256,0,0),
(121,36356,3,NULL,71104,-89094,-2368,0,0),
(121,36356,4,NULL,73471,-91462,-2024,30,0),
(121,36356,5,NULL,74532,-92202,-1776,0,0),
(121,36356,6,NULL,74908,-93152,-1536,60,0),
(121,36356,7,NULL,74532,-92202,-1776,0,0),
(121,36356,8,NULL,73471,-91462,-2024,30,0),
(121,36356,9,NULL,71104,-89094,-2368,0,0),
(121,36356,10,NULL,70941,-89751,-2256,0,0),
(121,36356,11,NULL,69553,-91746,-1488,30,0);