/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.BB;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.communitybbs.BB.Topic;
import com.l2jserver.gameserver.communitybbs.Manager.PostBBSManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class Post {
    private static Logger _log = Logger.getLogger(Post.class.getName());
    private List<CPost> _post = new FastList();

    public Post(String _PostOwner, int _PostOwnerID, long date, int tid, int _PostForumID, String txt) {
        CPost cp = new CPost();
        cp.postId = 0;
        cp.postOwner = _PostOwner;
        cp.postOwnerId = _PostOwnerID;
        cp.postDate = date;
        cp.postTopicId = tid;
        cp.postForumId = _PostForumID;
        cp.postTxt = txt;
        this._post.add(cp);
        this.insertindb(cp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertindb(CPost cp) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("INSERT INTO posts (post_id,post_owner_name,post_ownerid,post_date,post_topic_id,post_forum_id,post_txt) values (?,?,?,?,?,?,?)");
            statement.setInt(1, cp.postId);
            statement.setString(2, cp.postOwner);
            statement.setInt(3, cp.postOwnerId);
            statement.setLong(4, cp.postDate);
            statement.setInt(5, cp.postTopicId);
            statement.setInt(6, cp.postForumId);
            statement.setString(7, cp.postTxt);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while saving new Post to db " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public Post(Topic t) {
        this.load(t);
    }

    public CPost getCPost(int id) {
        int i = 0;
        for (CPost cp : this._post) {
            if (i++ != id) continue;
            return cp;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteme(Topic t) {
        PostBBSManager.getInstance().delPostByTopic(t);
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("DELETE FROM posts WHERE post_forum_id=? AND post_topic_id=?");
            statement.setInt(1, t.getForumID());
            statement.setInt(2, t.getID());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while deleting post: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(Topic t) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM posts WHERE post_forum_id=? AND post_topic_id=? ORDER BY post_id ASC");
            statement.setInt(1, t.getForumID());
            statement.setInt(2, t.getID());
            ResultSet result = statement.executeQuery();
            while (result.next()) {
                CPost cp = new CPost();
                cp.postId = result.getInt("post_id");
                cp.postOwner = result.getString("post_owner_name");
                cp.postOwnerId = result.getInt("post_ownerid");
                cp.postDate = result.getLong("post_date");
                cp.postTopicId = result.getInt("post_topic_id");
                cp.postForumId = result.getInt("post_forum_id");
                cp.postTxt = result.getString("post_txt");
                this._post.add(cp);
            }
            result.close();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Data error on Post " + t.getForumID() + "/" + t.getID() + " : " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatetxt(int i) {
        Connection con = null;
        try {
            CPost cp = this.getCPost(i);
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("UPDATE posts SET post_txt=? WHERE post_id=? AND post_topic_id=? AND post_forum_id=?");
            statement.setString(1, cp.postTxt);
            statement.setInt(2, cp.postId);
            statement.setInt(3, cp.postTopicId);
            statement.setInt(4, cp.postForumId);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            try {
                _log.log(Level.WARNING, "Error while saving new Post to db " + e.getMessage(), e);
            }
            catch (Throwable throwable) {
                L2DatabaseFactory.close(con);
                throw throwable;
            }
            L2DatabaseFactory.close(con);
        }
        L2DatabaseFactory.close(con);
    }

    public static class CPost {
        public int postId;
        public String postOwner;
        public int postOwnerId;
        public long postDate;
        public int postTopicId;
        public int postForumId;
        public String postTxt;
    }
}

