/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.handler;

import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.templates.item.L2EtcItem;
import gnu.trove.TIntObjectHashMap;

public class ItemHandler {
    private TIntObjectHashMap<IItemHandler> _datatable = new TIntObjectHashMap();

    public static ItemHandler getInstance() {
        return SingletonHolder._instance;
    }

    public int size() {
        return this._datatable.size();
    }

    private ItemHandler() {
    }

    public void registerItemHandler(IItemHandler handler) {
        this._datatable.put(handler.getClass().getSimpleName().intern().hashCode(), (Object)handler);
    }

    public IItemHandler getItemHandler(L2EtcItem item) {
        if (item == null || item.getHandlerName() == null) {
            return null;
        }
        return (IItemHandler)this._datatable.get(item.getHandlerName().hashCode());
    }

    private static class SingletonHolder {
        protected static final ItemHandler _instance = new ItemHandler();

        private SingletonHolder() {
        }
    }
}

