/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;
import javolution.util.FastList;

public final class L2BabyPetInstance
extends L2PetInstance {
    private static final int BUFF_CONTROL = 5771;
    private static final int AWAKENING = 5753;
    private FastList<SkillHolder> _buffs = null;
    private SkillHolder _majorHeal = null;
    private SkillHolder _minorHeal = null;
    private SkillHolder _recharge = null;
    private Future<?> _castTask;
    private boolean _bufferMode = true;

    public L2BabyPetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control) {
        super(objectId, template, owner, control);
        this.setInstanceType(L2Object.InstanceType.L2BabyPetInstance);
    }

    public L2BabyPetInstance(int objectId, L2NpcTemplate template, L2PcInstance owner, L2ItemInstance control, byte level) {
        super(objectId, template, owner, control, level);
        this.setInstanceType(L2Object.InstanceType.L2BabyPetInstance);
    }

    @Override
    public void onSpawn() {
        super.onSpawn();
        for (L2PetData.L2PetSkillLearn psl : PetDataTable.getInstance().getPetData(this.getNpcId()).getAvailableSkills()) {
            L2Skill skill;
            int id = psl.getId();
            double healPower = 0.0;
            int lvl = PetDataTable.getInstance().getPetData(this.getNpcId()).getAvailableLevel(id, this.getLevel());
            if (lvl == 0 || (skill = SkillTable.getInstance().getInfo(id, lvl)) == null || skill.getId() == 5771 || skill.getId() == 5753) continue;
            switch (skill.getSkillType()) {
                case HEAL: {
                    if (healPower == 0.0) {
                        this._minorHeal = this._majorHeal = new SkillHolder(skill);
                        healPower = skill.getPower();
                        break;
                    }
                    if (skill.getPower() > healPower) {
                        this._majorHeal = new SkillHolder(skill);
                        break;
                    }
                    this._minorHeal = new SkillHolder(skill);
                    break;
                }
                case BUFF: {
                    if (this._buffs == null) {
                        this._buffs = new FastList();
                    }
                    this._buffs.add((Object)new SkillHolder(skill));
                    break;
                }
                case MANAHEAL: 
                case MANARECHARGE: {
                    this._recharge = new SkillHolder(skill);
                }
            }
        }
        this.startCastTask();
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        this.stopCastTask();
        this.abortCast();
        return true;
    }

    @Override
    public synchronized void unSummon(L2PcInstance owner) {
        this.stopCastTask();
        this.abortCast();
        super.unSummon(owner);
    }

    @Override
    public void doRevive() {
        super.doRevive();
        this.startCastTask();
    }

    @Override
    public void onDecay() {
        super.onDecay();
        if (this._buffs != null) {
            this._buffs.clear();
        }
    }

    private final void startCastTask() {
        if (!(this._majorHeal == null && this._buffs == null && this._recharge == null || this._castTask != null || this.isDead())) {
            this._castTask = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new CastTask(this), 3000L, 1000L);
        }
    }

    public void switchMode() {
        this._bufferMode = !this._bufferMode;
    }

    private final void stopCastTask() {
        if (this._castTask != null) {
            this._castTask.cancel(false);
            this._castTask = null;
        }
    }

    protected void castSkill(L2Skill skill) {
        boolean previousFollowStatus = this.getFollowStatus();
        if (!previousFollowStatus && !this.isInsideRadius(this.getOwner(), skill.getCastRange(), true, true)) {
            return;
        }
        this.setTarget(this.getOwner());
        this.useMagic(skill, false, false);
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.PET_USES_S1);
        msg.addSkillName(skill);
        this.getOwner().sendPacket(msg);
        if (previousFollowStatus != this.getFollowStatus()) {
            this.setFollowStatus(previousFollowStatus);
        }
    }

    private class CastTask
    implements Runnable {
        private final L2BabyPetInstance _baby;
        private List<L2Skill> _currentBuffs = new FastList();

        public CastTask(L2BabyPetInstance baby) {
            this._baby = baby;
        }

        @Override
        public void run() {
            L2PcInstance owner = this._baby.getOwner();
            if (!(owner == null || owner.isDead() || owner.isInvul() || this._baby.isCastingNow() || this._baby.isBetrayed() || this._baby.isMuted() || this._baby.isOutOfControl() || !L2BabyPetInstance.this._bufferMode || this._baby.getAI().getIntention() == CtrlIntention.AI_INTENTION_CAST)) {
                L2Skill skill = null;
                if (L2BabyPetInstance.this._majorHeal != null) {
                    double hpPercent = owner.getCurrentHp() / (double)owner.getMaxHp();
                    if (hpPercent < 0.15 && !this._baby.isSkillDisabled(skill = L2BabyPetInstance.this._majorHeal.getSkill()) && Rnd.get(100) <= 75 && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                        L2BabyPetInstance.this.castSkill(skill);
                        return;
                    }
                    if (hpPercent < 0.8 && !this._baby.isSkillDisabled(skill = L2BabyPetInstance.this._minorHeal.getSkill()) && Rnd.get(100) <= 25 && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                        L2BabyPetInstance.this.castSkill(skill);
                        return;
                    }
                }
                if (this._baby.getFirstEffect(5771) == null) {
                    if (L2BabyPetInstance.this._buffs != null && !L2BabyPetInstance.this._buffs.isEmpty()) {
                        for (SkillHolder i : L2BabyPetInstance.this._buffs) {
                            skill = i.getSkill();
                            if (this._baby.isSkillDisabled(skill) || !(this._baby.getCurrentMp() >= (double)skill.getMpConsume())) continue;
                            this._currentBuffs.add(skill);
                        }
                    }
                    if (!this._currentBuffs.isEmpty()) {
                        L2Effect[] effects;
                        for (L2Effect e : effects = owner.getAllEffects()) {
                            L2Skill currentSkill;
                            if (e == null || (currentSkill = e.getSkill()).isDebuff() || currentSkill.isPassive() || currentSkill.isToggle()) continue;
                            Iterator<L2Skill> iter = this._currentBuffs.iterator();
                            while (iter.hasNext()) {
                                skill = iter.next();
                                if (currentSkill.getId() == skill.getId() && currentSkill.getLevel() >= skill.getLevel()) {
                                    iter.remove();
                                    continue;
                                }
                                if (!skill.hasEffects() || "none".equals(skill.getEffectTemplates()[0].stackType) || !e.getStackType().equals(skill.getEffectTemplates()[0].stackType) || !(e.getStackOrder() >= skill.getEffectTemplates()[0].stackOrder)) continue;
                                iter.remove();
                            }
                            if (this._currentBuffs.isEmpty()) break;
                        }
                        if (!this._currentBuffs.isEmpty()) {
                            L2BabyPetInstance.this.castSkill(this._currentBuffs.get(Rnd.get(this._currentBuffs.size())));
                            this._currentBuffs.clear();
                            return;
                        }
                    }
                }
                if (L2BabyPetInstance.this._recharge != null && owner.isInCombat() && owner.getCurrentMp() / (double)owner.getMaxMp() < 0.7 && Rnd.get(100) <= 60 && !this._baby.isSkillDisabled(skill = L2BabyPetInstance.this._recharge.getSkill()) && this._baby.getCurrentMp() >= (double)skill.getMpConsume()) {
                    L2BabyPetInstance.this.castSkill(skill);
                    return;
                }
            }
        }
    }
}

