/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.L2CharPosition;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import javolution.util.FastList;

public class L2FortCommanderInstance
extends L2DefenderInstance {
    private boolean _canTalk;

    public L2FortCommanderInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(L2Object.InstanceType.L2FortCommanderInstance);
        this._canTalk = true;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker == null || !(attacker instanceof L2PcInstance)) {
            return false;
        }
        boolean isFort = this.getFort() != null && this.getFort().getFortId() > 0 && this.getFort().getSiege().getIsInProgress() && !this.getFort().getSiege().checkIsDefender(((L2PcInstance)attacker).getClan());
        return isFort;
    }

    @Override
    public void addDamageHate(L2Character attacker, int damage, int aggro) {
        if (attacker == null) {
            return;
        }
        if (!(attacker instanceof L2FortCommanderInstance)) {
            super.addDamageHate(attacker, damage, aggro);
        }
    }

    @Override
    public boolean doDie(L2Character killer) {
        if (!super.doDie(killer)) {
            return false;
        }
        if (this.getFort().getSiege().getIsInProgress()) {
            this.getFort().getSiege().killedCommander(this);
        }
        return true;
    }

    @Override
    public void returnHome() {
        if (!this.isInsideRadius(this.getSpawn().getLocx(), this.getSpawn().getLocy(), 200, false)) {
            if (Config.DEBUG) {
                _log.info(this.getObjectId() + ": moving home");
            }
            this.setisReturningToSpawnPoint(true);
            this.clearAggroList();
            if (this.hasAI()) {
                this.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new L2CharPosition(this.getSpawn().getLocx(), this.getSpawn().getLocy(), this.getSpawn().getLocz(), 0));
            }
        }
    }

    @Override
    public final void addDamage(L2Character attacker, int damage, L2Skill skill) {
        L2Spawn spawn = this.getSpawn();
        if (spawn != null && this.canTalk()) {
            FastList<FortSiegeManager.SiegeSpawn> commanders = FortSiegeManager.getInstance().getCommanderSpawnList(this.getFort().getFortId());
            for (FortSiegeManager.SiegeSpawn spawn2 : commanders) {
                if (spawn2.getNpcId() != spawn.getNpcid()) continue;
                NpcSay cs = null;
                switch (spawn2.getId()) {
                    case 1: {
                        cs = new NpcSay(this.getObjectId(), 1, this.getNpcId(), 1300013);
                        break;
                    }
                    case 2: {
                        if (attacker instanceof L2Summon) {
                            attacker = ((L2Summon)attacker).getOwner();
                        }
                        cs = new NpcSay(this.getObjectId(), 1, this.getNpcId(), 1300012).addString(attacker.getName());
                        break;
                    }
                    case 3: {
                        cs = new NpcSay(this.getObjectId(), 1, this.getNpcId(), 1300014);
                    }
                }
                if (cs == null) continue;
                this.broadcastPacket(cs);
                this.setCanTalk(false);
                ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleTalkTask(), 10000L);
            }
        }
        super.addDamage(attacker, damage, skill);
    }

    void setCanTalk(boolean val) {
        this._canTalk = val;
    }

    private boolean canTalk() {
        return this._canTalk;
    }

    @Override
    public boolean hasRandomAnimation() {
        return false;
    }

    private class ScheduleTalkTask
    implements Runnable {
        @Override
        public void run() {
            L2FortCommanderInstance.this.setCanTalk(true);
        }
    }
}

