/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.knownlist;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.AttackableKnownList;
import java.util.logging.Logger;

public class GuardKnownList
extends AttackableKnownList {
    private static final Logger _log = Logger.getLogger(GuardKnownList.class.getName());

    public GuardKnownList(L2GuardInstance activeChar) {
        super(activeChar);
    }

    @Override
    public boolean addKnownObject(L2Object object) {
        if (!super.addKnownObject(object)) {
            return false;
        }
        if (object instanceof L2PcInstance) {
            if (((L2PcInstance)object).getKarma() > 0) {
                if (Config.DEBUG) {
                    _log.fine(this.getActiveChar().getObjectId() + ": PK " + object.getObjectId() + " entered scan range");
                }
                if (this.getActiveChar().getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                    this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
                }
            }
        } else if (Config.GUARD_ATTACK_AGGRO_MOB && this.getActiveChar().isInActiveRegion() && object instanceof L2MonsterInstance && ((L2MonsterInstance)object).isAggressive()) {
            if (Config.DEBUG) {
                _log.fine(this.getActiveChar().getObjectId() + ": Aggressive mob " + object.getObjectId() + " entered scan range");
            }
            if (this.getActiveChar().getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE) {
                this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        }
        return true;
    }

    @Override
    protected boolean removeKnownObject(L2Object object, boolean forget) {
        if (!super.removeKnownObject(object, forget)) {
            return false;
        }
        if (this.getActiveChar().noTarget() && this.getActiveChar().hasAI()) {
            this.getActiveChar().getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE, null);
        }
        return true;
    }

    @Override
    public final L2GuardInstance getActiveChar() {
        return (L2GuardInstance)super.getActiveChar();
    }
}

