/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.Race;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.ShowCalculator;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.gameserver.templates.item.L2WeaponType;
import java.util.logging.Logger;

public final class UseItem
extends L2GameClientPacket {
    private static Logger _log = Logger.getLogger(UseItem.class.getName());
    private static final String _C__14_USEITEM = "[C] 14 UseItem";
    private int _objectId;
    private boolean _ctrlPressed;
    private int _itemId;

    @Override
    protected void readImpl() {
        this._objectId = this.readD();
        this._ctrlPressed = this.readD() != 0;
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (!((L2GameClient)this.getClient()).getFloodProtectors().getUseItem().tryPerformAction("use item")) {
            return;
        }
        if (activeChar.getPrivateStoreType() != 0) {
            activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_TRADE_DISCARD_DROP_ITEM_WHILE_IN_SHOPMODE));
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (activeChar.getActiveTradeList() != null) {
            activeChar.cancelActiveTrade();
        }
        if (activeChar.isAfraid()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        L2ItemInstance item = activeChar.getInventory().getItemByObjectId(this._objectId);
        if (item == null) {
            return;
        }
        if (item.getItem().getType2() == 3) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CANNOT_USE_QUEST_ITEMS);
            activeChar.sendPacket(sm);
            sm = null;
            return;
        }
        this._itemId = item.getItemId();
        if (!Config.ALT_GAME_KARMA_PLAYER_CAN_TELEPORT && activeChar.getKarma() > 0) {
            switch (this._itemId) {
                case 736: 
                case 1538: 
                case 1829: 
                case 1830: 
                case 3958: 
                case 5858: 
                case 5859: 
                case 6663: 
                case 6664: 
                case 7554: 
                case 7555: 
                case 7556: 
                case 7557: 
                case 7558: 
                case 7559: 
                case 7618: 
                case 7619: 
                case 10129: 
                case 10130: {
                    return;
                }
            }
            if (this._itemId >= 7117 && this._itemId <= 7135) {
                return;
            }
        }
        if (activeChar.getInstanceId() == 0 && (13032 <= this._itemId && this._itemId <= 13059 || this._itemId == 13129)) {
            return;
        }
        if (activeChar.isFishing() && (this._itemId < 6535 || this._itemId > 6540)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.CANNOT_DO_WHILE_FISHING_3);
            ((L2GameClient)this.getClient()).getActiveChar().sendPacket(sm);
            sm = null;
            return;
        }
        if (activeChar.isDead()) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addItemName(item);
            ((L2GameClient)this.getClient()).getActiveChar().sendPacket(sm);
            sm = null;
            return;
        }
        if (activeChar.isStunned() || activeChar.isSleeping() || activeChar.isParalyzed() || activeChar.isAlikeDead() || activeChar.isAfraid() || activeChar.isCastingNow()) {
            return;
        }
        if (!activeChar.getInventory().canManipulateWithItemId(item.getItemId())) {
            activeChar.sendMessage("Cannot use this item.");
            return;
        }
        if (Config.DEBUG) {
            _log.finest(activeChar.getObjectId() + ": use item " + this._objectId);
        }
        if (!item.isEquipped() && !item.getItem().checkCondition(activeChar, activeChar, true)) {
            return;
        }
        if (item.isEquipable()) {
            if (activeChar.isInOlympiadMode() && (item.isHeroItem() || item.isOlyRestrictedItem())) {
                activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.THIS_ITEM_CANT_BE_EQUIPPED_FOR_THE_OLYMPIAD_EVENT));
                return;
            }
            switch (item.getItem().getBodyPart()) {
                case 128: 
                case 256: 
                case 16384: {
                    if (activeChar.getActiveWeaponItem() != null && activeChar.getActiveWeaponItem().getItemId() == 9819) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                        return;
                    }
                    if (activeChar.isCastingNow() || activeChar.isCastingSimultaneouslyNow()) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_USE_ITEM_WHILE_USING_MAGIC));
                        return;
                    }
                    if (activeChar.isMounted()) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                        return;
                    }
                    if (activeChar.isDisarmed()) {
                        activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                        return;
                    }
                    if (activeChar.isCursedWeaponEquipped()) {
                        return;
                    }
                    if (item.isEquipped() || !(item.getItem() instanceof L2Weapon) || activeChar.isGM()) break;
                    L2Weapon wpn = (L2Weapon)item.getItem();
                    switch (activeChar.getRace()) {
                        case Kamael: {
                            switch (wpn.getItemType()) {
                                case NONE: {
                                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                                    return;
                                }
                            }
                            break;
                        }
                        case Human: 
                        case Dwarf: 
                        case Elf: 
                        case DarkElf: 
                        case Orc: {
                            switch (wpn.getItemType()) {
                                case RAPIER: 
                                case CROSSBOW: 
                                case ANCIENTSWORD: {
                                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                                    return;
                                }
                            }
                        }
                    }
                    break;
                }
                case 64: 
                case 512: 
                case 1024: 
                case 2048: 
                case 4096: 
                case 8192: 
                case 32768: {
                    if (activeChar.getRace() != Race.Kamael || item.getItem().getItemType() != L2ArmorType.HEAVY && item.getItem().getItemType() != L2ArmorType.MAGIC) break;
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    return;
                }
                case 0x400000: {
                    if (item.isEquipped() || activeChar.getInventory().getMaxTalismanCount() != 0) break;
                    activeChar.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION));
                    return;
                }
            }
            if (activeChar.isCursedWeaponEquipped() && this._itemId == 6408) {
                return;
            }
            if (activeChar.isAttackingNow()) {
                ThreadPoolManager.getInstance().scheduleGeneral(new WeaponEquipTask(item, activeChar), (activeChar.getAttackEndTime() - GameTimeController.getGameTicks()) * 100);
                return;
            }
            if (FortSiegeManager.getInstance().isCombat(item.getItemId())) {
                return;
            }
            if (activeChar.isCombatFlagEquipped()) {
                return;
            }
            activeChar.useEquippableItem(item, true);
        } else {
            L2Weapon weaponItem = activeChar.getActiveWeaponItem();
            int itemid = item.getItemId();
            if (itemid == 4393) {
                activeChar.sendPacket(new ShowCalculator(4393));
            } else {
                if (weaponItem != null && weaponItem.getItemType() == L2WeaponType.FISHINGROD && (itemid >= 6519 && itemid <= 6527 || itemid >= 7610 && itemid <= 7613 || itemid >= 7807 && itemid <= 7809 || itemid >= 8484 && itemid <= 8486 || itemid >= 8505 && itemid <= 8513)) {
                    activeChar.getInventory().setPaperdollItem(7, item);
                    activeChar.broadcastUserInfo();
                    ItemList il = new ItemList(activeChar, false);
                    this.sendPacket(il);
                    return;
                }
                IItemHandler handler = ItemHandler.getInstance().getItemHandler(item.getEtcItem());
                if (handler == null) {
                    if (Config.DEBUG) {
                        _log.warning("No item handler registered for item ID " + item.getItemId() + ".");
                    }
                } else {
                    handler.useItem(activeChar, item, this._ctrlPressed);
                }
            }
        }
    }

    @Override
    public String getType() {
        return _C__14_USEITEM;
    }

    @Override
    protected boolean triggersOnActionRequest() {
        return !Config.SPAWN_PROTECTION_ALLOWED_ITEMS.contains(this._itemId);
    }

    public static class WeaponEquipTask
    implements Runnable {
        L2ItemInstance item;
        L2PcInstance activeChar;

        public WeaponEquipTask(L2ItemInstance it, L2PcInstance character) {
            this.item = it;
            this.activeChar = character;
        }

        @Override
        public void run() {
            if (this.activeChar.isAttackingNow()) {
                return;
            }
            this.activeChar.useEquippableItem(this.item, false);
        }
    }
}

