/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.scripting;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Formatter;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Native2Ascii {
    public static void run(File scriptsDirectory, String encoding) {
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                String fileName = file.getName();
                char c0 = fileName.charAt(0);
                if (c0 == '.' || c0 == '#') {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                return fileName.endsWith(".java") || fileName.endsWith(".py");
            }
        };
        Native2Ascii.run(scriptsDirectory, fileFilter, encoding);
    }

    private static void run(File scriptsDirectory, FileFilter fileFilter, String encoding) {
        File[] files = scriptsDirectory.listFiles(fileFilter);
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                Native2Ascii.run(file, fileFilter, encoding);
                continue;
            }
            if (!file.isFile()) continue;
            String encoding1 = encoding;
            try {
                FileInputStream fis = new FileInputStream(file);
                byte[] byteBuffer = new byte[fis.available()];
                fis.read(byteBuffer);
                fis.close();
                if (byteBuffer.length >= 3 && byteBuffer[0] == -17 && byteBuffer[1] == -69 && byteBuffer[2] == -65) {
                    if (file.getPath().endsWith(".java")) {
                        byteBuffer[2] = 8;
                        byteBuffer[1] = 8;
                        byteBuffer[0] = 8;
                    }
                    encoding1 = "UTF8";
                } else {
                    String temp = new String(byteBuffer, "ISO8859_1");
                    Matcher m = Pattern.compile("coding[=:]\\s*([-\\w.]+)").matcher(temp);
                    if (m.find()) {
                        encoding1 = m.group(1);
                    }
                }
                char[] unicodeBuffer = new String(byteBuffer, encoding1).toCharArray();
                StringBuilder asciiBuffer = new StringBuilder(unicodeBuffer.length * 2);
                Formatter fm = new Formatter(asciiBuffer);
                boolean modify = false;
                for (char unicode : unicodeBuffer) {
                    if (unicode == '\b') {
                        modify = true;
                        continue;
                    }
                    if (unicode >= '\u0080') {
                        fm.format("\\u%04x", unicode);
                        modify = true;
                        continue;
                    }
                    asciiBuffer.append(unicode);
                }
                if (!modify) continue;
                long mtime = file.lastModified();
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(file));
                osw.write(asciiBuffer.toString());
                osw.close();
                file.setLastModified(mtime);
            }
            catch (IOException e) {
                Logger.getLogger("Native2Ascii").warning(file.getAbsoluteFile() + " [" + encoding1 + "] - " + e.toString());
                e.printStackTrace();
            }
        }
    }
}

