/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.skills.effects;

import com.l2jserver.gameserver.model.L2Effect;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.templates.effects.EffectTemplate;
import com.l2jserver.gameserver.templates.skills.L2EffectType;
import com.l2jserver.gameserver.templates.skills.L2SkillType;

public class EffectSilentMove
extends L2Effect {
    public EffectSilentMove(Env env, EffectTemplate template) {
        super(env, template);
    }

    public EffectSilentMove(Env env, L2Effect effect) {
        super(env, effect);
    }

    @Override
    public boolean onStart() {
        super.onStart();
        return true;
    }

    @Override
    public void onExit() {
        super.onExit();
    }

    @Override
    public L2EffectType getEffectType() {
        return L2EffectType.SILENT_MOVE;
    }

    @Override
    public boolean onActionTime() {
        if (this.getSkill().getSkillType() != L2SkillType.CONT) {
            return false;
        }
        if (this.getEffected().isDead()) {
            return false;
        }
        double manaDam = this.calc();
        if (manaDam > this.getEffected().getCurrentMp()) {
            this.getEffected().sendPacket(SystemMessage.getSystemMessage(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP));
            return false;
        }
        this.getEffected().reduceCurrentMp(manaDam);
        return true;
    }

    @Override
    public int getEffectFlags() {
        return 16;
    }
}

