/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.taskmanager;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class DecayTaskManager {
    protected static final Logger _log = Logger.getLogger(DecayTaskManager.class.getName());
    protected Map<L2Character, Long> _decayTasks = new FastMap().shared();
    public static final int RAID_BOSS_DECAY_TIME = 30000;
    public static final int ATTACKABLE_DECAY_TIME = 8500;
    private static final boolean GRAND_BOSS_DECAY_TIME_L2J_JP = true;

    private DecayTaskManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new DecayScheduler(), 10000L, 5000L);
    }

    public static DecayTaskManager getInstance() {
        return SingletonHolder._instance;
    }

    public void addDecayTask(L2Character actor) {
        this._decayTasks.put(actor, System.currentTimeMillis());
    }

    public void addDecayTask(L2Character actor, int interval) {
        this._decayTasks.put(actor, System.currentTimeMillis() + (long)interval);
    }

    public void cancelDecayTask(L2Character actor) {
        try {
            this._decayTasks.remove(actor);
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(256).append("============= DecayTask Manager Report ============\r\nTasks count: ").append(this._decayTasks.size()).append("\r\nTasks dump:\r\n");
        Long current = System.currentTimeMillis();
        for (L2Character actor : this._decayTasks.keySet()) {
            ret.append("Class/Name: ").append(actor.getClass().getSimpleName()).append('/').append(actor.getName()).append(" decay timer: ").append(current - this._decayTasks.get(actor)).append("\r\n");
        }
        return ret.toString();
    }

    public Map<L2Character, Long> getTasks() {
        return this._decayTasks;
    }

    private static class SingletonHolder {
        protected static final DecayTaskManager _instance = new DecayTaskManager();

        private SingletonHolder() {
        }
    }

    private class DecayScheduler
    implements Runnable {
        protected DecayScheduler() {
        }

        @Override
        public void run() {
            long current = System.currentTimeMillis();
            try {
                Iterator<Map.Entry<L2Character, Long>> it = DecayTaskManager.this._decayTasks.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<L2Character, Long> e = it.next();
                    L2Character actor = e.getKey();
                    Long next = e.getValue();
                    if (next == null) continue;
                    int delay = actor.isRaid() && !actor.isRaidMinion() ? 30000 : (actor instanceof L2Attackable && (((L2Attackable)actor).isSpoil() || ((L2Attackable)actor).isSeeded()) ? 17000 : 8500);
                    if (actor instanceof L2Npc) {
                        L2Npc npc = (L2Npc)actor;
                        switch (npc.getNpcId()) {
                            case 29014: {
                                delay = 150000;
                                break;
                            }
                            case 29001: {
                                delay = 150000;
                            }
                        }
                    }
                    if (current - next <= (long)delay) continue;
                    actor.onDecay();
                    it.remove();
                }
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Error in DecayScheduler: " + e.getMessage(), e);
            }
        }
    }
}

