/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.gameserver.model.L2ItemInstance;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.skills.Env;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.skills.funcs.Func;
import com.l2jserver.gameserver.skills.funcs.FuncTemplate;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2ArmorType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.util.StringUtil;
import java.util.ArrayList;

public final class L2Armor
extends L2Item {
    private final int _avoidModifier;
    private SkillHolder _enchant4Skill = null;
    private SkillHolder[] _skillHolder;
    private L2ArmorType _type;

    public L2Armor(StatsSet set) {
        super(set);
        String[] info;
        this._type = L2ArmorType.valueOf(set.getString("armor_type", "none").toUpperCase());
        int _bodyPart = this.getBodyPart();
        if (_bodyPart == 8 || _bodyPart == 65536 || _bodyPart == 262144 || _bodyPart == 524288 || (_bodyPart & 4) != 0 || (_bodyPart & 0x20) != 0 || (_bodyPart & 0x100000) != 0 || (_bodyPart & 0x200000) != 0 || (_bodyPart & 0x2000) != 0) {
            this._type1 = 0;
            this._type2 = 2;
        } else {
            if (this._type == L2ArmorType.NONE && this.getBodyPart() == 256) {
                this._type = L2ArmorType.SHIELD;
            }
            this._type1 = 1;
            this._type2 = 1;
        }
        this._avoidModifier = set.getInteger("avoid_modify", 0);
        String skill = set.getString("enchant4_skill", null);
        if (skill != null && (info = skill.split("-")) != null && info.length == 2) {
            int id = 0;
            int level = 0;
            try {
                id = Integer.parseInt(info[0]);
                level = Integer.parseInt(info[1]);
            }
            catch (Exception nfe) {
                _log.info(StringUtil.concat("> Couldnt parse ", skill, " in armor enchant skills! item ", this.toString()));
            }
            if (id > 0 && level > 0) {
                this._enchant4Skill = new SkillHolder(id, level);
            }
        }
        if ((skill = set.getString("item_skill", null)) != null) {
            String[] skills = skill.split(";");
            this._skillHolder = new SkillHolder[skills.length];
            int iterator = 0;
            for (String st : skills) {
                String[] info2 = st.split("-");
                if (info2 == null || info2.length != 2) continue;
                int id = 0;
                int level = 0;
                try {
                    id = Integer.parseInt(info2[0]);
                    level = Integer.parseInt(info2[1]);
                }
                catch (Exception nfe) {
                    _log.info(StringUtil.concat("> Couldnt parse ", st, " in armor skills! item ", this.toString()));
                    continue;
                }
                if (id <= 0 || level <= 0) continue;
                this._skillHolder[iterator] = new SkillHolder(id, level);
                iterator = (byte)(iterator + 1);
            }
        }
    }

    @Override
    public L2ArmorType getItemType() {
        return this._type;
    }

    @Override
    public final int getItemMask() {
        return this.getItemType().mask();
    }

    public final int getAvoidModifier() {
        return this._avoidModifier;
    }

    public L2Skill getEnchant4Skill() {
        if (this._enchant4Skill == null) {
            return null;
        }
        return this._enchant4Skill.getSkill();
    }

    @Override
    public SkillHolder[] getSkills() {
        return this._skillHolder;
    }

    @Override
    public Func[] getStatFuncs(L2ItemInstance instance, L2Character player) {
        if (this._funcTemplates == null || this._funcTemplates.length == 0) {
            return _emptyFunctionSet;
        }
        ArrayList<Func> funcs = new ArrayList<Func>(this._funcTemplates.length);
        Env env = new Env();
        env.player = player;
        env.item = instance;
        for (FuncTemplate t : this._funcTemplates) {
            Func f = t.getFunc(env, instance);
            if (f == null) continue;
            funcs.add(f);
        }
        return funcs.toArray(new Func[funcs.size()]);
    }
}

