/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.templates.item;

import com.l2jserver.gameserver.model.L2ExtractableProduct;
import com.l2jserver.gameserver.skills.SkillHolder;
import com.l2jserver.gameserver.templates.StatsSet;
import com.l2jserver.gameserver.templates.item.L2EtcItemType;
import com.l2jserver.gameserver.templates.item.L2Item;
import com.l2jserver.util.StringUtil;
import java.util.ArrayList;
import java.util.List;

public final class L2EtcItem
extends L2Item {
    private String _handler;
    private SkillHolder[] _skillHolder;
    private int _sharedReuseGroup;
    private L2EtcItemType _type;
    private final boolean _isBlessed;
    private final List<L2ExtractableProduct> _extractableItems;

    public L2EtcItem(StatsSet set) {
        super(set);
        this._type = L2EtcItemType.valueOf(set.getString("etcitem_type", "none").toUpperCase());
        switch (this.getDefaultAction()) {
            case soulshot: 
            case summon_soulshot: 
            case summon_spiritshot: 
            case spiritshot: {
                this._type = L2EtcItemType.SHOT;
            }
        }
        if (this.is_ex_immediate_effect()) {
            this._type = L2EtcItemType.HERB;
        }
        this._type1 = 4;
        this._type2 = 5;
        if (this.isQuestItem()) {
            this._type2 = 3;
        } else if (this.getItemId() == 57 || this.getItemId() == 5575) {
            this._type2 = 4;
        }
        String skill = set.getString("item_skill", null);
        if (skill != null) {
            String[] skills = skill.split(";");
            this._skillHolder = new SkillHolder[skills.length];
            int iterator = 0;
            for (String st : skills) {
                String[] info = st.split("-");
                if (info == null || info.length != 2) continue;
                int id = 0;
                int level = 0;
                try {
                    id = Integer.parseInt(info[0]);
                    level = Integer.parseInt(info[1]);
                }
                catch (Exception nfe) {
                    _log.info(StringUtil.concat("> Couldnt parse ", st, " in etcitem skills! item ", this.toString()));
                    continue;
                }
                if (id <= 0 || level <= 0) continue;
                this._skillHolder[iterator] = new SkillHolder(id, level);
                iterator = (byte)(iterator + 1);
            }
        }
        this._handler = set.getString("handler", null);
        if (this._handler != null) {
            this._handler = this._handler.intern();
        }
        this._sharedReuseGroup = set.getInteger("shared_reuse_group", -1);
        this._isBlessed = set.getBool("blessed", false);
        String capsuled_items = set.getString("capsuled_items", null);
        if (capsuled_items != null) {
            String[] split = capsuled_items.split(";");
            this._extractableItems = new ArrayList<L2ExtractableProduct>(split.length);
            for (String part : split) {
                if (part.trim().isEmpty()) continue;
                String[] data = part.split(",");
                if (data.length != 4) {
                    _log.info(StringUtil.concat("> Couldnt parse ", part, " in capsuled_items! item ", this.toString()));
                    continue;
                }
                int itemId = Integer.parseInt(data[0]);
                int min = Integer.parseInt(data[1]);
                int max = Integer.parseInt(data[2]);
                double chance = Double.parseDouble(data[3]);
                if (max < min) {
                    _log.info(StringUtil.concat("> Max amount < Min amount in ", part, ", item ", this.toString()));
                    continue;
                }
                L2ExtractableProduct product = new L2ExtractableProduct(itemId, min, max, chance);
                this._extractableItems.add(product);
            }
            ((ArrayList)this._extractableItems).trimToSize();
            if (this._handler == null) {
                this._handler = "ExtractableItems";
            }
        } else {
            this._extractableItems = null;
        }
    }

    @Override
    public L2EtcItemType getItemType() {
        return this._type;
    }

    @Override
    public final boolean isConsumable() {
        return this.getItemType() == L2EtcItemType.SHOT || this.getItemType() == L2EtcItemType.POTION;
    }

    @Override
    public int getItemMask() {
        return this.getItemType().mask();
    }

    @Override
    public SkillHolder[] getSkills() {
        return this._skillHolder;
    }

    public String getHandlerName() {
        return this._handler;
    }

    public int getSharedReuseGroup() {
        return this._sharedReuseGroup;
    }

    public final boolean isBlessed() {
        return this._isBlessed;
    }

    public List<L2ExtractableProduct> getExtractableItems() {
        return this._extractableItems;
    }
}

