/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.util;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.util.Util;
import java.util.List;

public class EventNpcAligner {
    public static L2Npc align(L2Npc manager) {
        int mX = manager.getX();
        int mY = manager.getY();
        int mZ = manager.getZ();
        int mH = manager.getHeading();
        L2Object guide = null;
        List<L2Object> knownObjects = L2World.getInstance().getVisibleObjects(manager, 300);
        block0: while (true) {
            for (L2Object o : knownObjects) {
                if (!(o instanceof L2Npc)) continue;
                L2Npc obj = (L2Npc)o;
                double collisionRadius = Math.max(30, manager.getTemplate().collisionRadius * 2 + obj.getTemplate().collisionRadius);
                boolean isMove = false;
                while (Util.calculateDistance(mX, mY, obj.getX(), obj.getY()) < collisionRadius) {
                    if (guide == null && (guide = EventNpcAligner.findGuide(manager, knownObjects)) == null) {
                        return manager;
                    }
                    double gx = guide.getX();
                    double gy = guide.getY();
                    double dx = (double)mX - gx;
                    double dy = (double)mY - gy;
                    double angle = Math.atan2(dy, dx);
                    double radius = Math.sqrt(dx * dx + dy * dy) + (double)(manager.getTemplate().collisionRadius * 2);
                    mX = (int)Math.round(Math.cos(angle) * radius + gx);
                    mY = (int)Math.round(Math.sin(angle) * radius + gy);
                    mH = ((L2Character)guide).getHeading();
                    isMove = true;
                }
                if (!isMove) continue;
                continue block0;
            }
            break;
        }
        if (mX != manager.getX() || mY != manager.getY() || mH != manager.getHeading()) {
            manager.setXYZ(mX, mY, mZ);
            manager.setHeading(mH);
            manager.broadcastPacket(new ValidateLocation(manager));
            L2Spawn spawn = manager.getSpawn();
            spawn.setXYZ(mY, mY, mZ);
            spawn.setHeading(mH);
        }
        return manager;
    }

    private static L2Npc findGuide(L2Npc npc, List<L2Object> knownObjects) {
        L2Npc nearestGuide = null;
        double distance = Double.MAX_VALUE;
        for (L2Object o : knownObjects) {
            if (!(o instanceof L2Npc)) continue;
            L2Npc obj = (L2Npc)o;
            switch (obj.getNpcId()) {
                case 30598: 
                case 30599: 
                case 30600: 
                case 30601: 
                case 30602: 
                case 31076: 
                case 31077: 
                case 32135: 
                case 32327: {
                    double d = Util.calculateDistance(npc, obj, true);
                    if (!(distance > d)) break;
                    distance = d;
                    nearestGuide = obj;
                }
            }
        }
        return nearestGuide;
    }
}

