/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package events.SquashEvent;

import static com.l2jserver.gameserver.util.Util.contains;

import java.util.Arrays;
import java.util.Comparator;

import javolution.util.FastMap;

import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Skill;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2ChronoMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.network.clientpackets.Say2;
import com.l2jserver.gameserver.network.serverpackets.NpcSay;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.templates.item.L2Weapon;
import com.l2jserver.util.Rnd;

/**
 * @author Gnacik
 * @version 1.0
 * @see Warning! Mostly that event is custom!
 * Java   By JOJO@L2J-SFJP 29-07-2010
 * Update By pmq@L2J-TW    04-09-2010
 * Update By JOJO@L2J-SFJP 04-12-2010
 */
public class SquashEvent extends Quest
{
	private static final String qn = "SquashEvent";
/**
 * Cxgis t@X U Lbg Npc ID (31860)
 */
	private static final int MANAGER = 31860;
/**
 * lN^[ Skill ID (2005)
 */
	private static final int NECTAR_SKILL = 2005;

	private static final long DESPAWN_FIRST = 180000;
	private static final long DESPAWN_NEXT = 90000;

	private static final int DAMAGE_MAX = 12;
	private static final int DAMAGE_DEFAULT = 5;
/**
 * C1LOy Nm L^   Item ID (4202) * C2LOy Nm ^o Item ID (5133)
 * C3LOy Nm Jpi Item ID (5817) * C4LOy Nm _ubJ Item ID (7058)
 * C5LOy Nm }JX Item ID (8350)
 */
	private static final int[] CHRONO_LIST =
	{
		4202,5133,5817,7058,8350
	};
/**
 * c|i       Mob ID (12774) * ǎȃ|i         Mob ID (12775) * sǂȃ|i       Mob ID (12776)
 * c傫ȃ|i Mob ID (12777) * ǎȑ傫ȃ|i   Mob ID (12778) * sǂȑ傫ȃ|i Mob ID (12779)
 * ǎȃ|i   Mob ID (13016) * ǎȑ傫ȃ|i Mob ID (13017)
 */
	private static final int[] SQUASH_LIST =
	{
		12774,12775,12776,
		12777,12778,12779,
		13016,13017
	};

	// ŗc`҂Ƃ̋
	private static final int[] SPAWN_TEXT =
	{
		99700,	//A^V̂ƌĂ񂾁H
		99701,	//ɂ́AA^VA|iI낵肢܁`I
		99702,	//ӂӂAA^V̂ƌĂ񂾁H
		99703,	//݂Ȃ҂܂I|iAIꂩǂǂႤ񂾂I
		99704,	//HAi^ɉ̂͏߂ĂHA^VA|iI낵ˁI
		99705,	//A^VAAi^̂Ƃ悤ɂ΂邩AςĂˁI
		99706,	//pHGbIȃA^VɈẮH
		99707,	//ӁBA^V̎pAȂɌ`H
		99708,	//Ai^ɌĂ΂Ăɗ̂I傤`I
		99709,	//ɂ́AA^VA|iIɗ̂͏߂ĂȁH낵ˁI
	};
	// lN^[ŐƂ̋
	private static final int[] GROWUP_TEXT =
	{
		99710,	//҂Ił́Aϐg̎ԂI
		99711,	//ǂHA^VALCɂȂHHLCɂȂČāI
		99712,	//nIAǂł[I
		99713,	//DDDM̂Sg삯́I
		99714,	//A^V̂ƁA؂ɂĂȂ̂ˁDDDnYႦI
		99715,	//Ai^Ƀ|i_̏j悤ɋF肵ĂI瑁I
		99716,	//тHCHƂAAE^EVHւցAxĂ݂񂾁B
		99717,	//1疜Afi邩狖ĂIĂÂH
		99718,	//A^V̒ɔ߂ꂽ̌Ă݂H
		99719,	//A^V̍~̂킩H킩ĂłHA̈~́I
	};
	// lN^[܂Ƃ̋
	private static final int[] POISON_TEXT =
	{
		99720,	//˂AlN^[ĂIA^Vւ̈ĂȂ̂ȂłH
		99721,	//ACCBC悢I傤I
		99722,	//Ai^̈Ŗ銴DDDƗ~́I
		99723,	//I܂ƂɂłȂ́HڂĂ邶ȂIvv
		99724,	//``ςIAA^Vւ̈ĂȂ̂I
		99725,	//ADDDƂ傤I
		99726,	//CbIȂ́Iw^N\IAɂȂႤI
		99727,	//E@[ÎȂ`DDD˂A̖{ɃlN^[́H
		99728,	//˂A肵ĂILCɈĂȂAlN^[LCɂ̂؂I
		99729,	//ɖlN^[~́I
	};
	// lN^[^ȂŕuƂ̋
	private static final int[] HUNGRY_TEXT =
	{
	/*	99730,	//AbIA^VA@ꂽ`͖Ȃ̂I肢炾͂߂āI		*/
	/*	99731,	//A^V߂ȂŁ`߂ĂI@ȂłIA^V́AAi^̈~́`	*/
		99732,	//Ai^̈Ȃ́IꂶAA^VނႤI
		99733,	//A^VƂ̈ĂC͂Ȃ́HA^V́AAi^̈̂lN^[~́I
		99734,	//܂́Iɂ̂͂Ȃ́IlN^[~́I
		99735,	//̂܂܂ႵꂿႤ́IA^VǂȂĂ悢ẮH
		99736,	//A^VꂽAȂɂcȂHȂɃA^V̂ƌȂ́HƂAi^̈͏IĂ܂́H
		99737,	//Aʂ̂ƍlĂłHȂ񂶂AAi^̈̓A^Vɓ`ĂȂ́IƈāI
		99738,	//lFAA^VĂ`lN^[x߂ɂȂāAm炸Ďʂ̂ƈꏏI
		99739,	//̂܂܂ƃA^VA܂ĂӖȂA邵Ȃ̂ˁB߂DDD
	};
	// Ԑ؂̂Ƃ̋
	private static final int[] TIMEUP_TEXT =
	{
		99745,	//A^VˁAAi^̖̂ƂzẮBˁÃA^V̓Ai^ɂςẮB܂܂ŌCłĂ˂IƂI
		99746,	//ĉȂ̂킩HAi^ɂꂪłAxƎv́B܂܂傤ˁI
		99747,	//܂ȂIA^VAAIȂ񂶂Ã|iɂ񂾂IȂȂ`I
		99748,	//Aʂ̎ԂȂ́BɈ܂łɁAA^Vւ̈łĂˁI
		99749,	//IȈāA΂ĂĂDDDAă_Ǝv́B܂łĂꂽ񂾂ǁAsˁB{ɃSˁB
	};
	// 傫ȃ|iNmōUƂ̋
	private static final int[] CHRONO_TEXT =
	{
		99750,	//AFˁI
		99751,	//˂A˂Aȉ̂ĂH
		99752,	//Ă΂炵́IFł`̂Ȃ̂˂I
		99753,	//CɂȂĂ`ĂI
		99754,	//A^V̂߂ɒeẮHꂵI
		99755,	//ƁIςȂHA^Vւ̈ĂȂ̂Ȃ́H
		99756,	//|IXSꂵI
		99757,	//``AĝYYĂIȂ𕷂ƒĂǁAA^V̏ꍇ|HȊˁH
		99758,	//A̘aIōIƕĂȂ́I
		99759,	//AĨTEh́IAi^A~[WVɂȂI
	};
	// 傫ȃ|iwO̕ōUƂ̋
	private static final int[] NOCHRONO_TEXT =
	{
		99760,	//Ȃ񂶂_I@Ă͈炽ȂI
		99761,	//ɂ̂IA^V͉ýI܂߂ɂĂI
		99762,	//TEhȂAA^V̐SƐĝɂ͋Ȃ́I
		99763,	//ꂶȂ́IAINm̊yIł́I
		99764,	//ŉyȂ́HA^VAAĂHDDD́H{ɋAႤH
		99765,	//̂́AȈo镨łĂI
		99766,	//A^V́AyȂ_Ȃ̂`Œ@ӖȂ́I
		99767,	//yłĂIȕCIył́I
		99768,	//Ai^̃A^bNăXSĈˁ`łAʖʂȂ̂`Ȃ܂܂Ȃă_I
		99769,	//nŋĂʂIA^V~͉̂Ȃ́I
	};
	// ̋
	private static final int[] KILL_TEXT =
	{
		99770,	//|iƂāAAi^ɈĂ悩B܂܂ĂĂ|iłȁBAi^ƂxDDD
		99771,	//ނނFInYႦILnn
		99772,	//A^VƂ̎voA؂ɂĂˁ`
		99773,	//ꂪAi^ƃA^V̈̌I
		99774,	//Ai^̑zA󂯎́BATiˁDDD
		99775,	//ڂŃAi^̊炪Ȃ́DDDłˁAAi^͖̎YȂB܂ˁH
		99776,	//`A悩́IȂ́`Ał܂]邱Ƃł邩ȁHƂĂꂠˁB
		99777,	//Ai^̈Aς󂯂Ƃ́BłAʂꂾˁBAi^̂ƁAYȂI܂ˁI
		99778,	//|iAꂿ́Ȉo`HoȂƂĂAx˂ˁI
		99779,	//IꂿIA^V̒̈````
	};
	// ʏ|iUƂ̋
	private static final int[] ATTACK_TEXT =
	{
		99780,	//߂ĂȂ́IDĂˁI
		99781,	//AꂢȁH
		99782,	//ƁIƈ~́I
		99783,	//A^V̓Ai^̈ň̂I
		99784,	//ł߂ς̈Ȃ́HȂ񂶂A^V߂Ȃ́I
		99785,	//̒xŖƂłvẮH
		99786,	//ˁBA^VA̍DB
		99787,	//AI[AEI͂ӂ
		99788,	//ƂAAi^̈Ă̒x̂̂Ȃ́H
		99789,	//A^V̂ƂlāÎƂlȂă_Ȃ́Iƒ@āI
	};
	// lN^[Ƃ̋
	private static final int[] NECTAR_TEXT =
	{
		99790,	//lN^[~́IǂĂlN^[~́I
		99791,	//A^VˁAlN^[Ƒ傫Ȃ̂I
		99792,	//AAi^̈ςՁI肭΃A^VALCɈI
		99793,	//˂ÂlN^[傤IA^V̐SƂ͂yRyRI
		99794,	//AlN^[ςāI
		99795,	//lN^[DDDăA^Vւ̈̕\Ȃ́BA^V͂đ傫Ȃ́I
		99796,	//ȖnȂɒẮHĆB傫ȂĂA^VI
		99797,	//Ai^ɑ̂ĺBāIAi^ɈĂ悩`A^V̈󂯎~߂Ă邩`A^V_ɂȂĂ`Ō܂ňꏏɈĂ悤DDDǂH_ȁH
		99798,	//ƃAi^ɂƂƎvIA^V́AǂȂƂĂAi^̈΂񂺂񕽋C`MĂ邩ˁI
		99799,	//˂AA^VMălN^[ĂIA^Vn炫ƂKI
	};
	// hbv Xg y ID X^[ , NO m , ID ACe, NO  z
	private static final int[][] DROPLIST =
	{
		/**
		 * <DEL>must be sorted by npcId !</DEL>
		 * npcId, chance, itemId,qty [,itemId,qty...]
		 *
		 * Young Squash
		 * c|i
		 */
		{ 12774,100,  6391,2 },		// Nectar
		/**
		 * Low Quality Squash
		 * sǂȃ|i
		 */
		{ 12776,100,  6391,50 },	// Nectar
		/**
		 * High Quality Squash
		 * ǎȃ|i
		 */
		{ 12775,100,  6391,100 },	// Nectar
		/**
		 * King Squash
		 * ǎȃ|i
		 */
		{ 13016,100,  6391,150 },	// Nectar
		/**
		 * Large Young Squash
		 * c傫ȃ|i
		 */
		{ 12777,100, 14701,2,		//͏uԑ̗͉񕜍
					 14700,2 },		//̗͉͑񕜍
		/**
		 * Low Quality Large
		 * sǂȑ傫ȃ|i
		 */
		{ 12779, 50,   729,4,		//틭XN[FAO[h
					   730,4,		//hXN[FAO[h
					  6569,2,		//jꂽ틭XN[FAO[h
					  6570,2 },		//jꂽhXN[FAO[h
		{ 12779, 30,  6622,1 },		//l̔`
		{ 12779, 10,  8750,1 },		//㋉ ̐΁Fx67
		{ 12779, 10,  8751,1 },		//㋉ ̐΁Fx70
		{ 12779, 99, 14701,4,		//͏uԑ̗͉񕜍
					 14700,4 },		//̗͉͑񕜍
		{ 12779, 50,  1461,4 },		//NX^FAO[h
		{ 12779, 30,  1462,3 },		//NX^FSO[h
		{ 12779, 50,  2133,4 },		//WFXg[FAO[h
		{ 12779, 30,  2134,3 },		//WFXg[FSO[h
		/**
		 * High Quality Large
		 * ǎȑ傫ȃ|i
		 */
		{ 12778,  7,  9570,1,		//bh \E Xg[FXebv14
					  9571,1,		//u[ \E Xg[FXebv14
					  9572,1,		//O[ \E Xg[FXebv14
					 10480,1,		//bh \E Xg[FXebv15
					 10481,1,		//u[ \E Xg[FXebv15
					 10482,1,		//O[ \E Xg[FXebv15
					 13071,1,		//bh \E Xg[FXebv16
					 13072,1,		//u[ \E Xg[FXebv16
					 13073,1 },		//O[ \E Xg[FXebv16
		{ 12778, 35,   729,4,		//틭XN[FAO[h
					   730,4,		//hXN[FAO[h
					   959,3,		//틭XN[FSO[h
					   960,3,		//hXN[FSO[h
					  6569,2,		//jꂽ틭XN[FAO[h
					  6570,2,		//jꂽhXN[FAO[h
					  6577,1,		//jꂽ틭XN[FSO[h
					  6578,1 },		//jꂽhXN[FSO[h
		{ 12778, 28,  6622,3,		//l̔`
					  9625,2,		//l̔`FYp
					  9626,2,		//l̔`FC
					  9627,2 },		//l̔`Fn
		{ 12778, 14,  8750,10 },	//㋉ ̐΁Fx67
		{ 12778, 14,  8751,8 },		//㋉ ̐΁Fx70
		{ 12778, 14,  8752,6 },		//㋉ ̐΁Fx76
		{ 12778, 14,  9575,4 },		//㋉ ̐΁Fx80
		{ 12778, 14, 10485,2 },		//㋉ ̐΁Fx82
		{ 12778, 14, 14168,1 },		//㋉̐΁Fx84
		{ 12778, 21,  8760,1,		//ŏ㋉̐΁Fx67
					  8761,1,		//ŏ㋉̐΁Fx70
					  8762,1,		//ŏ㋉̐΁Fx76
					  9576,1,		//ŏ㋉̐΁Fx80
					 10486,1,		//ŏ㋉̐΁Fx82
					 14169,1 },		//ŏ㋉̐΁Fx84
		{ 12778, 21, 14683,1,		//͐̔FcO[h
					 14684,1,		//͐̔FCO[h
					 14685,1,		//͐̔FBO[h
					 14686,1,		//͐̔FAO[h
					 14687,1,		//͐̔FSO[h
					 14689,1,		//͐_̔FcO[h
					 14690,1,		//͐_̔FCO[h
					 14691,1,		//͐_̔FBO[h
					 14692,1,		//͐_̔FAO[h
					 14693,1,		//͐_̔FSO[h
					 14695,1,		//͓u̔FcO[h
					 14696,1,		//͓u̔FCO[h
					 14697,1,		//͓u̔FBO[h
					 14698,1,		//͓u̔FAO[h
					 14699,1 },		//͓u̔FSO[h
		{ 12778, 99, 14701,9,		//͏uԑ̗͉񕜍
					 14700,9 },		//̗͉͑񕜍
		{ 12778, 63,  1461,8 },		//NX^FAO[h
		{ 12778, 49,  1462,5 },		//NX^FSO[h
		{ 12778, 63,  2133,6 },		//WFXg[FAO[h
		{ 12778, 49,  2134,4 },		//WFXg[FSO[h
		/**
		 * Emperor
		 * ǎȑ傫ȃ|i
		 */
		{ 13017, 10,  9570,1,		//bh \E Xg[FXebv14
					  9571,1,		//u[ \E Xg[FXebv14
					  9572,1,		//O[ \E Xg[FXebv14
					 10480,1,		//bh \E Xg[FXebv15
					 10481,1,		//u[ \E Xg[FXebv15
					 10482,1,		//O[ \E Xg[FXebv15
					 13071,1,		//bh \E Xg[FXebv16
					 13072,1,		//u[ \E Xg[FXebv16
					 13073,1 },		//O[ \E Xg[FXebv16
		{ 13017, 50,   729,4,		//틭XN[FAO[h
					   730,4,		//hXN[FAO[h
					   959,3,		//틭XN[FSO[h
					   960,3,		//hXN[FSO[h
					  6569,2,		//jꂽ틭XN[FAO[h
					  6570,2,		//jꂽhXN[FAO[h
					  6577,1,		//jꂽ틭XN[FSO[h
					  6578,1 },		//jꂽhXN[FSO[h
		{ 13017, 40,  6622,3,		//l̔`
					  9625,2,		//l̔`FYp
					  9626,2,		//l̔`FC
					  9627,2 },		//l̔`Fn
		{ 13017, 20,  8750,10 },	//㋉ ̐΁Fx67
		{ 13017, 20,  8751,8 },		//㋉ ̐΁Fx70
		{ 13017, 20,  8752,6 },		//㋉ ̐΁Fx76
		{ 13017, 20,  9575,4 },		//㋉ ̐΁Fx80
		{ 13017, 20, 10485,2 },		//㋉ ̐΁Fx82
		{ 13017, 20, 14168,1 },		//㋉̐΁Fx84
		{ 13017, 30,  8760,1,		//ŏ㋉̐΁Fx67
					  8761,1,		//ŏ㋉̐΁Fx70
					  8762,1,		//ŏ㋉̐΁Fx76
					  9576,1,		//ŏ㋉̐΁Fx80
					 10486,1,		//ŏ㋉̐΁Fx82
					 14169,1 },		//ŏ㋉̐΁Fx84
		{ 13017, 30, 14683,1,		//͐̔FcO[h
					 14684,1,		//͐̔FCO[h
					 14685,1,		//͐̔FBO[h
					 14686,1,		//͐̔FAO[h
					 14687,1,		//͐̔FSO[h
					 14689,1,		//͐_̔FcO[h
					 14690,1,		//͐_̔FCO[h
					 14691,1,		//͐_̔FBO[h
					 14692,1,		//͐_̔FAO[h
					 14693,1,		//͐_̔FSO[h
					 14695,1,		//͓u̔FcO[h
					 14696,1,		//͓u̔FCO[h
					 14697,1,		//͓u̔FBO[h
					 14698,1,		//͓u̔FAO[h
					 14699,1 },		//͓u̔FSO[h
		{ 13017, 99, 14701,12,		//͏uԑ̗͉񕜍
					 14700,12 },	//̗͉͑񕜍
		{ 13017, 90,  1461,8 },		//NX^FAO[h
		{ 13017, 70,  1462,5 },		//NX^FSO[h
		{ 13017, 90,  2133,6 },		//WFXg[FAO[h
		{ 13017, 70,  2134,4 },		//WFXg[FSO[h
	};

	class TheInstance
	{
		int nectar;
		int success;
		long despawnTime;
	}
	private FastMap<L2ChronoMonsterInstance, TheInstance> _monsterInstances = new FastMap<L2ChronoMonsterInstance, TheInstance>().shared();
	private TheInstance create(L2ChronoMonsterInstance mob)
	{
		TheInstance mons = new TheInstance();
		_monsterInstances.put(mob, mons);
		return mons;
	}
	private TheInstance get(L2ChronoMonsterInstance mob)
	{
		return _monsterInstances.get(mob);
	}
	private void remove(L2ChronoMonsterInstance mob)
	{
		cancelQuestTimer("countdown", mob, null);
		cancelQuestTimer("despawn", mob, null);
		_monsterInstances.remove(mob);
	}

	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "countdown")
		{
			final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
			final TheInstance self = get(mob);
			int timeLeft = (int)((self.despawnTime - System.currentTimeMillis() + 500) / 1000);

			switch (timeLeft)
			{
			case 120:
				if (self.nectar == 0)
					autoChat(mob, 99743);	//lN^[ȂȂA2ɋAႤI
				break;
			case 60:
				if (self.nectar == 0)
					autoChat(mob, 99744);	//lN^[ȂȂA1ɃTiȂ񂾂I
				break;
			case 30:
				if (self.nectar == 0)
					autoChat(mob, 99740);	//炵߂Ȃ́I񂾂OẮI30bȓɂȂȂAAႤI
				break;
			case 20:
				autoChat(mob, 99741);	//20bIA^Vւ̈ĂȂ񂾂́H
				break;
			case 10:
				autoChat(mob, 99742);	//Ac10bI9DDD8DDD7DDD
				break;
			case 0:
				autoChat(mob, TIMEUP_TEXT);
				break;
			default:
				if ((timeLeft % 20) == 0)
					if (self.nectar == 0)
						autoChat(mob, HUNGRY_TEXT);
				break;
			}
		}
		else if (event == "despawn")
		{
			remove((L2ChronoMonsterInstance)npc);
			npc.deleteMe();
		}
		else if (event == "sound")
		{
			((L2ChronoMonsterInstance)npc).broadcastPacket(new PlaySound(0, "ItemSound3.sys_sow_success", 0, 0, 0, 0, 0));
		}
		else
			return super.onAdvEvent(event, npc, player);
		return null;
	}

	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isPet)
	{
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		L2Weapon weapon;
		final boolean isChronoAttack
			= !isPet
			&& (weapon = attacker.getActiveWeaponItem()) != null && contains(CHRONO_LIST, weapon.getItemId());
		switch (mob.getNpcId())
		{
			case 12774:
			case 12775:
			case 12776:
			case 13016:
				if (Rnd.get(100) < 20)
					autoChat(mob, ATTACK_TEXT);
				break;
			case 12777:
			case 12778:
			case 12779:
			case 13017:
				if (isChronoAttack)
				{
					mob.setIsInvul(false);
					if (damage == 0)
						mob.getStatus().reduceHp(DAMAGE_DEFAULT, attacker);
					else if (damage > DAMAGE_MAX)
						mob.getStatus().setCurrentHp(mob.getStatus().getCurrentHp() + damage - DAMAGE_MAX);
					if (Rnd.get(100) < 20)
						autoChat(mob, CHRONO_TEXT);
				}
				else
				{
					mob.setIsInvul(true);
					mob.setCurrentHp(mob.getMaxHp());
					if (Rnd.get(100) < 20)
						autoChat(mob, NOCHRONO_TEXT);
				}
				break;
			default:
				throw new RuntimeException();
		}
		mob.getStatus().stopHpMpRegeneration();
		return super.onAttack(npc, attacker, damage, isPet);
	}

	@Override
	public String onSkillSee(L2Npc npc, L2PcInstance caster, L2Skill skill, L2Object[] targets, boolean isPet)
	{
		if (skill.getId() == NECTAR_SKILL && targets[0] == npc)
		{
			final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
			switch (mob.getNpcId())
			{
				case 12774:
					randomSpawnYoung(12776, 12775, 13016, mob);
					break;
				case 12777:
					randomSpawnYoung(12779, 12778, 13017, mob);
					break;
				case 12775:
					randomSpawnHigh(13016, mob);
					break;
				case 12778:
					randomSpawnHigh(13017, mob);
					break;
				case 12776:
				case 12779:
					autoChat(mob, 99771);	//ނނFInYႦILnn
					break;
			}
		}
		return null;
	//	return super.onSkillSee(npc,caster,skill,targets,isPet);
	}

	@Override
	public String onKill(L2Npc npc, L2PcInstance killer, boolean isPet)
	{
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		remove(mob);
		autoChat(mob, KILL_TEXT);
		dropItem(mob, killer);
		return super.onKill(npc, killer, isPet);
	}

	@Override
	public String onSpawn(L2Npc npc)
	{
		assert npc instanceof L2ChronoMonsterInstance;
		
		final L2ChronoMonsterInstance mob = (L2ChronoMonsterInstance)npc;
		mob.setOnKillDelay(1500);	//Default 5000ms.
		final TheInstance self = create(mob);
		switch(mob.getNpcId())
		{
			case 12774:
			case 12777:
				startQuestTimer("countdown", 10000, mob, null, true);
				startQuestTimer("despawn", DESPAWN_FIRST + 3333, mob, null);
				self.nectar = 0;
				self.despawnTime = System.currentTimeMillis() + DESPAWN_FIRST;
				autoChat(mob, SPAWN_TEXT);
				break;
			case 12775:
			case 12776:
			case 12778:
			case 12779:
			case 13016:
			case 13017:
				startQuestTimer("countdown", 10000, mob, null, true);
				startQuestTimer("despawn", DESPAWN_NEXT + 3333, mob, null);
				self.nectar = 5;
				self.despawnTime = System.currentTimeMillis() + DESPAWN_NEXT;
				autoChat(mob, GROWUP_TEXT);
				startQuestTimer("sound",3000, mob, null);
				break;
			default:
				throw new RuntimeException();
		}
		return null;
	}

	static {
		Arrays.sort(DROPLIST, new Comparator<int[]>() {
			public int compare(int[] a, int[] b) { return a[0] - b[0]; }
		});
	}
	private static final void dropItem(L2ChronoMonsterInstance mob, L2PcInstance player)
	{
		final int npcId = mob.getNpcId();
		for (int[] drop : DROPLIST)
		{
			/**
			 * npcId   = drop[0]
			 * chance  = drop[1]
			 * itemId  = drop[2,4,6,8...]
			 * itemQty = drop[3,5,7,9...]
			 */
			if (npcId == drop[0])
			{
				final int chance = Rnd.get(100);
				if (chance < drop[1])
				{
					int i = 2 + 2 * Rnd.get((drop.length - 2) / 2);
					int itemId = drop[i + 0];
					int itemQty = drop[i + 1];
					if (itemQty > 1) itemQty = Rnd.get(1, itemQty);
					mob.dropItem(mob.getOwner(), itemId, itemQty);
					continue;
				}
			}
			if (npcId < drop[0])
				return; // not found
		}
	}

	private void randomSpawnYoung(int bad, int good, int king, L2ChronoMonsterInstance mob)
	{
		final TheInstance self = get(mob);
		++self.nectar;
		final int[] npcString;
		
		if (Rnd.get(100) < 50)
		{
			++self.success;
			mob.doCast(SkillTable.getInstance().getInfo(4513, 1));
			npcString = NECTAR_TEXT;
		}
		else
		{
			mob.doCast(SkillTable.getInstance().getInfo(4514, 1));
			npcString = POISON_TEXT;
		}
		
		if (self.nectar == 5)
		{
			if (self.success >= 5) 
				spawnNext(king, mob);	// [5..5] 1/6=16.6%: cǎ
			else if (self.success >= 3) 
				spawnNext(good, mob);	// [3..4] 2/6=33.3%: cǎ
			else 
				spawnNext(bad, mob);	// [0..2] 3/6=49.9%: csǂ
		}
		else /*if (self.nectar < 5)*/
		{
			autoChat(mob, npcString);
		}
	}

	private void randomSpawnHigh(int king, L2ChronoMonsterInstance mob)
	{
		final TheInstance self = get(mob);
		if (++self.nectar > 5 && self.nectar <= 15 && Rnd.get(100) < 15 - self.nectar)	// 10% ǎȁǎ
		{
		//	mob.doCast(SkillTable.getInstance().getInfo(4513, 1));
			spawnNext(king, mob);
		}
		else
		{
			mob.doCast(SkillTable.getInstance().getInfo(4514, 1));
			autoChat(mob, POISON_TEXT);
		}
	}

	private void autoChat(L2ChronoMonsterInstance mob, int npcString)
	{
		mob.broadcastPacket(new NpcSay(mob.getObjectId(), Say2.ALL, mob.getNpcId(), npcString));
	}
	private void autoChat(L2ChronoMonsterInstance mob, int[] npcString)
	{
		autoChat(mob, npcString[Rnd.get(npcString.length)]);
	}

	private void spawnNext(int npcId, L2ChronoMonsterInstance oldMob)
	{
		remove(oldMob);
		L2ChronoMonsterInstance newMob = (L2ChronoMonsterInstance)addSpawn(npcId, oldMob.getX(), oldMob.getY(), oldMob.getZ(), oldMob.getHeading(), false, 0);
		newMob.setOwner(oldMob.getOwner());
		newMob.setTitle(oldMob.getTitle());
		oldMob.deleteMe();
	}

	private SquashEvent(int questId, String name, String descr)
	{
		super(questId, name, descr);

		for (int mob : SQUASH_LIST)
		{
			addAttackId(mob);
			addKillId(mob);
			addSpawnId(mob);
			addSkillSeeId(mob);
		}

		addStartNpc(MANAGER);
		addFirstTalkId(MANAGER);
		addTalkId(MANAGER);
	}

	@Override
	public String onFirstTalk(L2Npc npc, L2PcInstance player)
	{
//		String htmltext = "";
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			Quest q = QuestManager.getInstance().getQuest(getName());
			st = q.newQuestState(player);
		}
		switch (npc.getNpcId())
		{
			case MANAGER: return "31860.htm";
		}
		throw new RuntimeException();
	}

	@Override
	public String onEvent(String event, QuestState qs)
	{
		// 31860-1.htm
		return event;
	}

	public static void main(String[] args)
	{
		new SquashEvent(-1, qn, "events");
	}
}