DROP TABLE IF EXISTS `zone_vertices`;
CREATE TABLE `zone_vertices` (
  `id` mediumint(5) unsigned NOT NULL,
  `order` tinyint(2) unsigned NOT NULL,
  `x` mediumint(6) NOT NULL,
  `y` mediumint(6) NOT NULL,
  PRIMARY KEY (`id`,`order`)
);

-- Arena Zones
INSERT INTO `zone_vertices` VALUES
-- Monster Race Track
-- dion_monster_race1
(10000,0,11714,181568),
(10000,1,14406,181571),
(10000,2,14405,182673),
(10000,3,11714,182673),
-- dion_monster_race2
(10001,0,13309,181324),
(10001,1,14061,181324),
(10001,2,14061,181610),
(10001,3,13309,181610),
-- dion_monster_race3
(10002,0,13559,182641),
(10002,1,14073,182640),
(10002,2,14073,182919),
(10002,3,13560,182918),
-- dion_monster_race4
(10003,0,12196,182662),
(10003,1,12447,182663),
(10003,2,12447,182766),
(10003,3,12197,182766),
-- dion_monster_race5
(10004,0,11706,182774),
(10004,1,13194,182769),
(10004,2,13194,183006),
(10004,3,11701,183017),
-- dion_monster_race6
(10005,0,11701,184017),
(10005,1,13188,184011),
(10005,2,13194,184265),
(10005,3,11701,184260),
-- dion_monster_race7
(10006,0,11697,183013),
(10006,1,11945,183019),
(10006,2,11940,184015),
(10006,3,11697,184015),
-- dion_monster_race8
(10007,0,12945,183013),
(10007,1,13193,183008),
(10007,2,13193,184009),
(10007,3,12945,184009),

-- GM Consultation Service
-- gm_room
(10025,0,-115727,-251652),
(10025,1,-113365,-251655),
(10025,2,-113365,-248191),
(10025,3,-115727,-248194),
-- gm_room_solo1
(10026,0,-116299,-251426),
(10026,1,-115745,-251426),
(10026,2,-115745,-250840),
(10026,3,-116296,-250840),
-- gm_room_solo2
(10027,0,-113350,-251408),
(10027,1,-112797,-251407),
(10027,2,-112798,-250855),
(10027,3,-113353,-250857);

-- Town Zones
INSERT INTO `zone_vertices` VALUES
(11020,0,77170,147420),
(11020,1,79200,147420),
(11020,2,79200,144780),
(11020,3,80310,144780),
(11020,4,80310,143630),
(11020,5,83120,143630),
(11020,6,83120,143505),
(11020,7,83700,143505),
(11020,8,83700,141500),
(11020,9,84070,141500),
(11020,10,84070,143505),
(11020,11,85040,143505),
(11020,12,85040,145760),
(11020,13,86115,145760),
(11020,14,86115,146910),
(11020,15,88425,146910),
(11020,16,88425,147175),
(11020,17,90430,147175),
(11020,18,90430,147540),
(11020,19,88425,147540),
(11020,20,88425,150050),
(11020,21,86495,150050),
(11020,22,86495,150250),
(11020,23,85995,150250),
(11020,24,85995,152250),
(11020,25,86780,152250),
(11020,26,86780,153600),
(11020,27,84850,153600),
(11020,28,84850,152250),
(11020,29,85625,152250),
(11020,30,85265,150250),
(11020,31,85085,150250),
(11020,32,85085,149875),
(11020,33,83680,149875),
(11020,34,83680,149920),
(11020,35,83500,149920),
(11020,36,83500,151270),
(11020,37,82705,151270),
(11020,38,82705,152820),
(11020,39,79195,152820),
(11020,40,79195,149805),
(11020,41,77170,149805),
(11021,0,15704,15397),
(11021,1,15765,15878),
(11021,2,15801,16332),
(11021,3,14098,19672),
(11021,4,10278,20689),
(11021,5,8852,20421),
(11021,6,7484,18628),
(11021,7,7236,18042),
(11021,8,7141,17507),
(11021,9,7045,16819),
(11021,10,7382,14486),
(11021,11,13891,13025),
(11021,12,15542,15230),
(11022,0,-83739,245733),
(11022,1,-84049,246087),
(11022,2,-84289,246258),
(11022,3,-84556,246243),
(11022,4,-84984,245820),
(11022,5,-85336,245426),
(11022,6,-85684,245099),
(11022,7,-85969,244770),
(11022,8,-86400,244292),
(11022,9,-86664,243997),
(11022,10,-86940,243631),
(11022,11,-87517,243034),
(11022,12,-87650,242799),
(11022,13,-87613,242572),
(11022,14,-87348,242246),
(11022,15,-86956,241942),
(11022,16,-86656,241684),
(11022,17,-86343,241365),
(11022,18,-85829,240966),
(11022,19,-85544,240765),
(11022,20,-85193,240440),
(11022,21,-84865,240185),
(11022,22,-84594,239866),
(11022,23,-84284,239666),
(11022,24,-84002,239734),
(11022,25,-83822,239922),
(11022,26,-83640,240190),
(11022,27,-83295,240492),
(11022,28,-82990,240878),
(11022,29,-82635,241208),
(11022,30,-82234,241698),
(11022,31,-82027,241985),
(11022,32,-81684,242328),
(11022,33,-81421,242741),
(11022,34,-81113,243073),
(11022,35,-81011,243228),
(11022,36,-81029,243496),
(11022,37,-81340,243797),
(11022,38,-81691,244028),
(11022,39,-82292,244585),
(11022,40,-82787,244999),
(11022,41,-83726,245721),
(11023,0,45364,46535),
(11023,1,45895,46578),
(11023,2,46388,46713),
(11023,3,46861,46934),
(11023,4,47290,47232),
(11023,5,47659,47598),
(11023,6,47959,48024),
(11023,7,48182,48499),
(11023,8,48318,49006),
(11023,9,48364,49523),
(11023,10,48319,50048),
(11023,11,48186,50548),
(11023,12,47963,51022),
(11023,13,47661,51450),
(11023,14,47286,51836),
(11023,15,46864,52126),
(11023,16,46398,52345),
(11023,17,46313,52598),
(11023,18,45768,52597),
(11023,19,45735,52665),
(11023,20,45651,52791),
(11023,21,45520,52878),
(11023,22,45363,52912),
(11023,23,45210,52882),
(11023,24,45077,52794),
(11023,25,44993,52667),
(11023,26,44961,52600),
(11023,27,44422,52600),
(11023,28,44342,52347),
(11023,29,43867,52131),
(11023,30,43438,51827),
(11023,31,43075,51458),
(11023,32,42766,51019),
(11023,33,42546,50557),
(11023,34,42412,50051),
(11023,35,42367,49530),
(11023,36,42410,49012),
(11023,37,42547,48509),
(11023,38,42769,48034),
(11023,39,43065,47602),
(11023,40,43437,47232),
(11023,41,43859,46937),
(11023,42,44336,46713),
(11023,43,44843,46575),
(11023,44,45395,46530),
(11024,0,-45528,-110079),
(11024,1,-45711,-110075),
(11024,2,-45704,-110164),
(11024,3,-46633,-110080),
(11024,4,-46625,-109992),
(11024,5,-46803,-109993),
(11024,6,-47345,-109973),
(11024,7,-47388,-110012),
(11024,8,-47388,-113001),
(11024,9,-47351,-113039),
(11024,10,-47102,-113038),
(11024,11,-47107,-113382),
(11024,12,-47326,-113379),
(11024,13,-47326,-113829),
(11024,14,-47114,-113826),
(11024,15,-47102,-114171),
(11024,16,-47350,-114170),
(11024,17,-47388,-114199),
(11024,18,-47391,-117182),
(11024,19,-47339,-117239),
(11024,20,-46791,-117240),
(11024,21,-46607,-117240),
(11024,22,-46619,-117151),
(11024,23,-45701,-117000),
(11024,24,-45705,-117085),
(11024,25,-45523,-117088),
(11024,26,-44169,-116722),
(11024,27,-44147,-116804),
(11024,28,-43838,-116717),
(11024,29,-43855,-116638),
(11024,30,-43779,-116620),
(11024,31,-42581,-115424),
(11024,32,-42472,-115258),
(11024,33,-42051,-113671),
(11024,34,-42050,-113502),
(11024,35,-42474,-111925),
(11024,36,-42554,-111775),
(11024,37,-43843,-110456),
(11024,38,-44147,-110375),
(11024,39,-45529,-110078),
(11025,0,-84867,149371),
(11025,1,-82581,149364),
(11025,2,-82499,149139),
(11025,3,-81593,149177),
(11025,4,-81551,149410),
(11025,5,-79270,149392),
(11025,6,-79275,150365),
(11025,7,-79055,150368),
(11025,8,-78820,150429),
(11025,9,-78644,150595),
(11025,10,-78558,150837),
(11025,11,-78567,152410),
(11025,12,-78796,152420),
(11025,13,-78803,154319),
(11025,14,-77131,155437),
(11025,15,-78190,156459),
(11025,16,-79978,156104),
(11025,17,-84876,156106),
(11025,18,-84875,149371),
(11026,0,115499,-176771),
(11026,1,115301,-176769),
(11026,2,114877,-176811),
(11026,3,113385,-177602),
(11026,4,112934,-178507),
(11026,5,113954,-183578),
(11026,6,115493,-183698),
(11026,7,115748,-184078),
(11026,8,115936,-184197),
(11026,9,116268,-184243),
(11026,10,116716,-184246),
(11026,11,117023,-184162),
(11026,12,117211,-184022),
(11026,13,117325,-183825),
(11026,14,117490,-183411),
(11026,15,117629,-182930),
(11026,16,117762,-182686),
(11026,17,117762,-182260),
(11026,18,117734,-182090),
(11026,19,117531,-181747),
(11026,20,117452,-180534),
(11026,21,117492,-180010),
(11026,22,117466,-179559),
(11026,23,117327,-179170),
(11026,24,117328,-178966),
(11026,25,117303,-178695),
(11026,26,116860,-177230),
(11026,27,116806,-177131),
(11026,28,116650,-176975),
(11026,29,116418,-176887),
(11026,30,115929,-176804),
(11026,31,115490,-176767),
(11027,0,-14960,121148),
(11027,1,-14875,121120),
(11027,2,-14717,121106),
(11027,3,-14394,121109),
(11027,4,-14242,121104),
(11027,5,-12659,121098),
(11027,6,-12025,121767),
(11027,7,-12024,123944),
(11027,8,-12277,124668),
(11027,9,-12648,125573),
(11027,10,-12879,126199),
(11027,11,-13855,126470),
(11027,12,-14484,126463),
(11027,13,-15236,126178),
(11027,14,-16126,125356),
(11027,15,-16531,124493),
(11027,16,-16537,123850),
(11027,17,-16492,123330),
(11027,18,-16194,123160),
(11027,19,-16057,123101),
(11027,20,-15327,122741),
(11027,21,-14958,121150),
(11028,0,15264,141764),
(11028,1,15434,143574),
(11028,2,15760,144707),
(11028,3,15846,145302),
(11028,4,16134,146850),
(11028,5,16715,147153),
(11028,6,17844,147640),
(11028,7,18139,147138),
(11028,8,18541,146758),
(11028,9,18782,146598),
(11028,10,19069,146521),
(11028,11,19430,146485),
(11028,12,20363,146421),
(11028,13,20722,146319),
(11028,14,21415,146319),
(11028,15,21402,145011),
(11028,16,21381,143675),
(11028,17,20696,142841),
(11028,18,20380,142492),
(11028,19,19060,142463),
(11028,20,18821,142512),
(11028,21,17885,143046),
(11028,22,17447,143348),
(11028,23,17019,144028),
(11028,24,16780,142908),
(11028,25,17344,142847),
(11028,26,17327,142650),
(11028,27,17483,142634),
(11028,28,17396,141776),
(11028,29,17238,141792),
(11028,30,17218,141574),
(11028,31,15265,141765),
(11029,0,84014,52245),
(11029,1,84138,54683),
(11029,2,84143,55029),
(11029,3,84001,57029),
(11029,4,81773,57023),
(11029,5,81795,56237),
(11029,6,81239,56236),
(11029,7,81282,56892),
(11029,8,81187,56904),
(11029,9,81105,57179),
(11029,10,79195,57167),
(11029,11,78986,57076),
(11029,12,78844,55218),
(11029,13,78843,54882),
(11029,14,79148,54560),
(11029,15,79660,54556),
(11029,16,79662,53994),
(11029,17,79002,53990),
(11029,18,78963,53359),
(11029,19,78959,53070),
(11029,20,79027,52125),
(11029,21,79628,52070),
(11029,22,80547,52068),
(11029,23,80835,52116),
(11029,24,80733,53068),
(11029,25,81306,53070),
(11029,26,81369,52310),
(11029,27,82605,52244),
(11029,28,84010,52250),
(11030,0,115318,74260),
(11030,1,115019,74495),
(11030,2,113919,75365),
(11030,3,114386,77505),
(11030,4,114653,78197),
(11030,5,115063,80068),
(11030,6,117015,81804),
(11030,7,120527,81006),
(11030,8,121485,79049),
(11030,9,121631,74718),
(11030,10,119999,74209),
(11030,11,118499,74097),
(11030,12,117946,74068),
(11030,13,117404,73671),
(11030,14,115622,74026),
(11030,15,115328,74252),
(11031,0,143209,25727),
(11031,1,143209,26975),
(11031,2,143463,27286),
(11031,3,143473,30074),
(11031,4,144386,30947),
(11031,5,146209,30946),
(11031,6,146649,31179),
(11031,7,146830,31508),
(11031,8,148081,31511),
(11031,9,148275,31176),
(11031,10,148696,30937),
(11031,11,150367,30942),
(11031,12,151289,30008),
(11031,13,151233,25914),
(11031,14,151399,25719),
(11031,15,151403,24470),
(11031,16,151205,24271),
(11031,17,151198,21168),
(11031,18,150233,20225),
(11031,19,148287,20227),
(11031,20,148086,19992),
(11031,21,146836,19992),
(11031,22,146642,20199),
(11031,23,144429,20204),
(11031,24,143459,21124),
(11031,25,143446,25542),
(11031,26,143198,25731),
(11032,0,144345,-53353),
(11032,1,145283,-52411),
(11032,2,146840,-51665),
(11032,3,148575,-51659),
(11032,4,150128,-52405),
(11032,5,151075,-53362),
(11032,6,152091,-54735),
(11032,7,151974,-55898),
(11032,8,151852,-56567),
(11032,9,151737,-57217),
(11032,10,151608,-57387),
(11032,11,151239,-57131),
(11032,12,150447,-58201),
(11032,13,150832,-58488),
(11032,14,150551,-58851),
(11032,15,148717,-59764),
(11032,16,148590,-59759),
(11032,17,148590,-59291),
(11032,18,146839,-59291),
(11032,19,146842,-59768),
(11032,20,146700,-59766),
(11032,21,144860,-58848),
(11032,22,144589,-58489),
(11032,23,144967,-58193),
(11032,24,144179,-57141),
(11032,25,143807,-57392),
(11032,26,143685,-57210),
(11032,27,143335,-55225),
(11032,28,143679,-53917),
(11032,29,143887,-53081),
(11033,0,47150,-44815),
(11033,1,32531,-52045),
(11034,0,111391,216329),
(11034,1,106872,216579),
(11034,2,106693,217371),
(11034,3,106612,217923),
(11034,4,106612,218409),
(11034,5,106435,221617),
(11034,6,106435,222250),
(11034,7,106563,222851),
(11034,8,108183,223150),
(11034,9,108916,223150),
(11034,10,110264,222975),
(11034,11,110253,223651),
(11034,12,110185,223669),
(11034,13,110095,223756),
(11034,14,110056,223864),
(11034,15,109790,223883),
(11034,16,109703,223966),
(11034,17,109705,224197),
(11034,18,109882,224363),
(11034,19,109884,225522),
(11034,20,110764,225507),
(11034,21,110767,225985),
(11034,22,112002,225992),
(11034,23,112005,225510),
(11034,24,112891,225520),
(11034,25,112886,224389),
(11034,26,113068,224198),
(11034,27,113072,223967),
(11034,28,112983,223887),
(11034,29,112704,223864),
(11034,30,112676,223758),
(11034,31,112592,223669),
(11034,32,112520,223654),
(11034,33,112506,222975),
(11034,34,113745,223440),
(11034,35,115249,223440),
(11034,36,115249,223653),
(11034,37,115356,223653),
(11034,38,115356,223322),
(11034,39,115392,222838),
(11034,40,115393,221433),
(11034,41,115980,220372),
(11034,42,116055,219529),
(11034,43,116055,219029),
(11034,44,116220,218649),
(11034,45,116219,218388),
(11034,46,116041,218380),
(11034,47,116043,217586),
(11034,48,115310,217610),
(11034,49,114755,217086),
(11034,50,114434,217051),
(11034,51,114417,216838),
(11034,52,114182,216838),
(11034,53,114161,216957),
(11034,54,113280,216962),
(11034,55,111885,216801),
(11034,56,111808,216566),
(11034,57,111631,216386),
(11034,58,111393,216322),
(11035,0,91098,-144458),
(11035,1,91477,-143218),
(11035,2,91170,-141327),
(11035,3,90797,-140803),
(11035,4,90404,-141058),
(11035,5,90077,-140615),
(11035,6,90424,-140324),
(11035,7,89997,-139845),
(11035,8,88300,-138977),
(11035,9,87659,-138913),
(11035,10,87656,-139375),
(11035,11,87044,-139383),
(11035,12,87039,-138938),
(11035,13,86427,-138981),
(11035,14,84717,-139826),
(11035,15,84295,-140324),
(11035,16,84648,-140602),
(11035,17,84286,-141095),
(11035,18,83959,-140825),
(11035,19,83562,-141356),
(11035,20,83229,-143217),
(11035,21,83821,-145580),
(11035,22,84373,-148184),
(11035,23,89454,-148688),
(11035,24,91280,-145403),
(11035,25,91084,-144472),
(11036,0,16529,170516),
(11036,1,16645,170141),
(11036,2,16747,169833),
(11036,3,16770,169677),
(11036,4,16822,169464),
(11036,5,16858,169431),
(11036,6,17457,169398),
(11036,7,17939,169475),
(11036,8,18109,169528),
(11036,9,18435,169666),
(11036,10,18628,169781),
(11036,11,18641,169828),
(11036,12,18531,170204),
(11036,13,18473,170530),
(11036,14,18452,170686),
(11036,15,18394,170900),
(11036,16,18361,170937),
(11036,17,17771,170962),
(11036,18,17220,170888),
(11036,19,16897,170757),
(11036,20,16543,170561),
(11038,0,-121743,44424),
(11038,1,-121032,43295),
(11038,2,-120886,42480),
(11038,3,-120203,41012),
(11038,4,-118418,40332),
(11038,5,-112554,40643),
(11038,6,-111161,40894),
(11038,7,-110912,41569),
(11038,8,-110910,41908),
(11038,9,-111011,42108),
(11038,10,-111186,42197),
(11038,11,-111601,42194),
(11038,12,-111736,42102),
(11038,13,-111827,41951),
(11038,14,-113240,41951),
(11038,15,-113330,42107),
(11038,16,-113477,42193),
(11038,17,-113905,42190),
(11038,18,-114072,42096),
(11038,19,-114146,41940),
(11038,20,-114602,41944),
(11038,21,-114536,43719),
(11038,22,-114513,46154),
(11038,23,-114275,46912),
(11038,24,-114275,47297),
(11038,25,-114665,48163),
(11038,26,-115473,48310),
(11038,27,-118971,48310),
(11038,28,-119259,47970),
(11038,29,-120430,47970),
(11038,30,-120654,47199),
(11038,31,-120917,46429),
(11039,0,-88871,-77664),
(11039,1,-43060,-43491),
(11040,0,-187342,238059),
(11040,1,-181849,247548);

-- Castle Teleport Zones
INSERT INTO `zone_vertices` VALUES
(11209,0,-16287,109204),
(11209,1,-17178,109518),
(11210,0,20249,160228),
(11210,1,21132,160547),
(11211,0,116400,146030),
(11211,1,116718,146924),
(11212,0,82478,38125),
(11212,1,82794,39020),
(11213,0,146944,4097),
(11213,1,147967,5112),
(11214,0,114195,249007),
(11214,1,115081,249326),
(11215,0,147293,-46267),
(11215,1,147644,-47188),
(11216,0,9337,-49734),
(11216,1,11423,-49297),
(11216,2,11423,-49006),
(11216,3,9337,-48587),
(11217,0,77381,-150335),
(11217,1,77735,-151256);

-- Boss Zones (No Restart Zones)
INSERT INTO `zone_vertices` VALUES
-- zaken_no_restart
(12000,0,50797,213515),
(12000,1,57617,213510),
(12000,2,57669,221683),
(12000,3,50773,221632),
-- antaras_no_restart
(12001,0,173469,110431),
(12001,1,188081,110284),
(12001,2,188132,119249),
(12001,3,173386,119391),
-- baium_no_restart
(12002,0,111022,16177),
(12002,1,114510,12623),
(12002,2,118142,15790),
(12002,3,114773,19589),
-- anakimNlilith
(12003,0,183938,-13697),
(12003,1,186190,-13692),
(12003,2,186176,-8513),
(12003,3,183920,-8513),
-- Forge of the Gods/Hall of Flames
-- fire_no_restart1
(12004,0,183373,-117179),
(12004,1,184098,-116718),
(12004,2,184137,-115290),
(12004,3,183970,-115002),
(12004,4,183673,-114982),
(12004,5,182400,-115593),
(12004,6,182338,-116737),
-- fire_no_restart2
(12005,0,183432,-117590),
(12005,1,196325,-119107),
(12005,2,196377,-103657),
(12005,3,187161,-103538),
-- Imperial Tomb/4 Sepulchers
-- royal_rush_no_restart1
(12006,0,181198,-86516),
(12006,1,192394,-86521),
(12006,2,192391,-84626),
(12006,3,181193,-84622),
-- royal_rush_no_restart2
(12007,0,179511,-89903),
(12007,1,190707,-89908),
(12007,2,190704,-88013),
(12007,3,179506,-88009),
-- royal_rush_no_restart3
(12008,0,174498,-82751),
(12008,1,176622,-82751),
(12008,2,176616,-71304),
(12008,3,174489,-71303),
-- royal_rush_no_restart4
(12009,0,172183,-86660),
(12009,1,174307,-86661),
(12009,2,174301,-75214),
(12009,3,172174,-75213),
-- balakas_no_restart
(12010,0,196866,-130845),
(12010,1,229289,-130860),
(12010,2,229176,-98508),
(12010,3,196880,-98498),
-- Lair of Frintezza (Not Verified)
(12011,0,-89840,-139384),
(12011,1,-85732,-155311),
(12911,0,-89840,-151359),	-- +[JOJO] Frintezza's Concert Hall (Cuboid)<freya>
(12911,1,-85732,-155311),
-- Lair of Ant Queen (Not Verified)
(12012,0,-21490,178613),
(12012,1,-22258,178961),
(12012,2,-22890,182205),
(12012,3,-22770,183129),
(12012,4,-21594,183945),
(12012,5,-20570,183381),
(12012,6,-20310,182673),
(12012,7,-20762,179129),
-- Lair of Orfen (Not Verified)
(12013,0,43976,24664),
(12013,1,43284,18952),
(12013,2,42476,18164),
(12013,3,42480,16448),
(12013,4,43084,15944),
(12013,5,45140,15816),
(12013,6,48800,15112),
(12013,7,56556,12040),
(12013,8,59068,14288),
(12013,9,61064,18492),
(12013,10,60380,23672),
(12013,11,58724,27412),
(12013,12,55696,28496),
(12013,13,43976,24664),
-- Altar of Sacrifice (Not Verified)
(12014,0,-18176,-54972),
(12014,1,-14614,-51620),
-- Ice Queens Castle (Not Verified)
(12015,0,101744,-130016),
(12015,1,111376,-130096),
(12015,2,114416,-126128),
(12015,3,115246,-125857),
(12015,4,115209,-125669),
(12015,5,113920,-125669),
(12015,6,102400,-121920),
(12015,7,99456,-126208),
-- Lair of Sailren
(12807,0,26095,-8084),		-- +[JOJO:l2jfree boss.xml rev.4469] "Lair of Sailren" (Cuboid)
(12807,1,28987,-5295);

-- Emerald Square Zone
INSERT INTO `zone_vertices` VALUES
-- first secret room
(20105,0,144175,142396),
(20105,1,144251,142588),
-- second secret room
(20106,0,147400,143631),
(20106,1,147484,143828),
-- third secret room
(20107,0,149396,143473),
(20107,1,149559,143584);

-- Pailaka (Forgotten Temple)
INSERT INTO `zone_vertices` VALUES
(20108,0,-62840,178808),
(20108,1,-62840,184568),
(20108,2,-60792,184568),
(20108,3,-60792,188792),
(20108,4,-57976,191224),
(20108,5,-53000,190840),
(20108,6,-52360,190200),
(20108,7,-52360,178808);
-- Pailaka (Devil's Isle)
INSERT INTO `zone_vertices` VALUES
(20109,0,76650,-221310),
(20109,1,76630,-221880),
(20109,2,75490,-221480),
(20109,3,75630,-221140);

-- Pagan's Mark Zone
INSERT INTO `zone_vertices` VALUES
(30100,0,-16100,-36620),
(30100,1,-16600,-36620),
(30100,2,-16600,-36925),
(30100,3,-16100,-36925);

-- Primeval Isle Zones (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- Primeval Isle (Town Zone)
(40001,0,0,-32768),
(40001,1,32678,0);

-- Hellbound Zones (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- Hellbound (Town Zone)
(40102,0,-32768,229376),
(40102,1,32768,229376),
(40102,2,32768,262143),
(40102,3,-32768,262143);

-- SSQ Main Event
INSERT INTO `zone_vertices` VALUES
-- Oracle of Dusk
-- ssq_main_event_17_20_01
(50000,0,-79956,84556),
(50000,1,-79832,84620),
(50000,2,-79824,84772),
(50000,3,-79956,84844),
(50000,4,-80080,84772),
(50000,5,-80076,84620),
-- ssq_main_event_17_20_04
(50001,0,-76936,85164),
(50001,1,-76820,85232),
(50001,2,-76816,85380),
(50001,3,-76948,85444),
(50001,4,-77068,85376),
(50001,5,-77068,85236),
-- ssq_main_event_17_20_05
(50002,0,-74924,87012),
(50002,1,-74784,87008),
(50002,2,-74712,87132),
(50002,3,-74780,87256),
(50002,4,-74924,87260),
(50002,5,-75000,87140),
-- ssq_main_event_17_20_03
(50003,0,-77200,88820),
(50003,1,-77076,88896),
(50003,2,-77076,89040),
(50003,3,-77204,89108),
(50003,4,-77328,89044),
(50003,5,-77328,88892),
-- ssq_main_event_17_20_02
(50004,0,-80204,88220),
(50004,1,-80080,88288),
(50004,2,-80080,88428),
(50004,3,-80208,88504),
(50004,4,-80336,88428),
(50004,5,-80328,88292),
-- Oracle of Dawn
-- ssq_main_event_17_21_01
(50005,0,-78796,109452),
(50005,1,-78804,109608),
(50005,2,-78924,109672),
(50005,3,-79056,109600),
(50005,4,-79056,109456),
(50005,5,-78932,109380),
-- ssq_main_event_17_21_02
(50006,0,-75920,109992),
(50006,1,-75792,110068),
(50006,2,-75792,110220),
(50006,3,-75912,110288),
(50006,4,-76048,110212),
(50006,5,-76044,110068),
-- ssq_main_event_17_21_05
(50007,0,-73900,111844),
(50007,1,-73752,111840),
(50007,2,-73688,111976),
(50007,3,-73760,112092),
(50007,4,-73904,112092),
(50007,5,-73976,111968),
-- ssq_main_event_17_21_03
(50008,0,-76172,113656),
(50008,1,-76052,113728),
(50008,2,-76048,113872),
(50008,3,-76172,113944),
(50008,4,-76308,113876),
(50008,5,-76304,113728),
-- ssq_main_event_17_21_04
(50009,0,-79184,113040),
(50009,1,-79060,113116),
(50009,2,-79052,113268),
(50009,3,-79184,113336),
(50009,4,-79304,113260),
(50009,5,-79304,113116),
-- Oracle of Dusk (No Store Zone)
-- ssq_peace_1720_01
(50016,0,-78118,86296),
(50016,1,-75860,86294),
(50016,2,-75853,87965),
(50016,3,-78156,87967),
-- ssq_peace_1720_02
(50017,0,-81169,85693),
(50017,1,-78118,85690),
(50017,2,-78134,87364),
(50017,3,-81187,87364),
-- ssq_peace_1720_03
(50018,0,-81549,86361),
(50018,1,-80995,86367),
(50018,2,-80995,86688),
(50018,3,-81549,86688),
-- Oracle of Dawn (No Store Zone)
-- ssq_peace_1721_01
(50019,0,-77077,111140),
(50019,1,-74838,111140),
(50019,2,-74842,112806),
(50019,3,-77104,112779),
-- ssq_peace_1721_02
(50020,0,-80075,110530),
(50020,1,-77066,110552),
(50020,2,-77092,112188),
(50020,3,-80089,112184),
-- ssq_peace_1721_03
(50021,0,-80536,111192),
(50021,1,-79984,111196),
(50021,2,-79984,111517),
(50021,3,-80532,111517);

-- AirShips dock zones
INSERT INTO zone_vertices VALUES
-- Seed of Infinity
(50600,0,-212855,209819),
-- Seed of Destruction
(50601,0,-249460,249282),
-- Keucereus Base North
(50602,0,-193315,240184),
(50602,1,-188053,235278),
(50602,2,-179811,238353),
(50602,3,-178407,242454),
(50602,4,-178685,244665),
-- Keucereus Base South
(50603,0,-178685,244664),
(50603,1,-180120,246779),
(50603,2,-185598,249572),
(50603,3,-193009,245647),
(50603,4,-193315,240185);

-- Seed of Annihilation
INSERT INTO `zone_vertices` VALUES
(60002,0,-182488,186655),
(60003,0,-212755,184380),
(60004,0,-178458,188167),
(60005,0,-179430,183844),
(60006,0,-180000,183000),
(60006,1,-178300,184666),
(60006,2,-173000,184666),
(60006,3,-173000,174500),
(60006,4,-187350,174500),
(60006,5,-187350,184666),
(60006,6,-182000,184666),
(60006,7,-180500,183000),
(60007,0,-180000,182500),
(60007,1,-178800,183500),
(60007,2,-176500,183500),
(60007,3,-176500,187000),
(60007,4,-173000,187000),
(60007,5,-173000,175000),
(60007,6,-187500,175000),
(60007,7,-187500,187600),
(60007,8,-183500,187600),
(60007,9,-183500,183500),
(60007,10,-181000,183500),
(60007,11,-180500,182500),
(60008,0,-212800,182800),
(60008,1,-211000,185000),
(60008,2,-205000,185000),
(60008,3,-205000,172000),
(60008,4,-221000,172000),
(60008,5,-221000,187000),
(60008,6,-216000,187000),
(60008,7,-213500,182800);

-- Den of Evil Zones (vertices, min Z & Max Z are estimated)
INSERT INTO `zone_vertices` VALUES
-- Den of Evil 1
(70000,0,74313,-116888),
-- Den of Evil 2
(70001,0,63170,-106621),
-- Den of Evil 3
(70002,0,68030,-107150),
-- Den of Evil 4
(70003,0,62351,-117376),
-- Den of Evil 5
(70004,0,68100,-116006),
-- Den of Evil 6
(70005,0,69911,-118790),
-- Den of Evil 7
(70006,0,67520,-122211),
-- Den of Evil 8
(70007,0,74325,-121296),
-- Den of Evil 9
(70008,0,70788,-125554),
-- Den of Evil 10
(70009,0,76155,-127355),
-- Den of Evil 11
(70010,0,71543,-128820);

-- Castle NoHq Zones
-- Gludio Castle
INSERT INTO `zone_vertices` VALUES
(112000,0,-19576,106760),
(112000,1,-17288,106760),
(112000,2,-16520,107528),
(112000,3,-16520,108664),
(112000,4,-15752,108664),
(112000,5,-15752,110072),
(112000,6,-16264,110072),
(112000,7,-16264,112376),
(112000,8,-17800,113912),
(112000,9,-18824,113912),
(112000,10,-20232,112504),
(112000,11,-20232,108936),
(112000,12,-19576,108280),
(112000,13,-19576,106760);

-- Dion Castle
INSERT INTO `zone_vertices` VALUES
(112010,0,21240,162936),
(112010,1,23544,162936),
(112010,2,23544,161416),
(112010,3,24184,160776),
(112010,4,24184,157304),
(112010,6,22664,155784),
(112010,7,21752,155784),
(112010,8,20232,157304),
(112010,9,20232,159608),
(112010,10,19592,160248),
(112010,11,19592,160648),
(112010,12,20104,161160),
(112010,13,20472,161160),
(112010,14,20472,162168),
(112010,15,21240,162936);

-- Giran Castle
INSERT INTO `zone_vertices` VALUES
(112020,0,113544,142984),
(112020,1,116856,142984),
(112020,2,117496,143624),
(112020,3,119160,143624),
(112020,4,119160,145784),
(112020,5,118392,146552),
(112020,6,117240,146552),
(112020,7,117240,147448),
(112020,8,115976,147448),
(112020,9,115976,146824),
(112020,10,113672,146824),
(112020,11,112008,145672),
(112020,12,112008,144520),
(112020,13,113544,142984);

-- Oren Castle
INSERT INTO `zone_vertices` VALUES
(112030,0,79608,35080),
(112030,1,83080,35080),
(112030,2,83592,35592),
(112030,3,85240,35592),
(112030,4,85240,37896),
(112030,5,84360,38776),
(112030,6,83336,38776),
(112030,7,83336,39544),
(112030,8,81928,39544),
(112030,9,81928,39048),
(112030,10,79496,39048),
(112030,11,77960,37512),
(112030,12,77960,36728),
(112030,13,79608,35080);

-- Aden Castle
INSERT INTO `zone_vertices` VALUES
(112040,0,144200,9900),
(112040,1,144200,910),
(112040,2,150670,910),
(112040,3,150670,9900),
(112040,4,144200,9900);

-- Innadril Castle
INSERT INTO `zone_vertices` VALUES
(112050,0,115832,244488),
(112050,1,116488,244488),
(112050,2,118136,246136),
(112050,3,118136,249480),
(112050,4,117496,250120),
(112050,5,117496,251768),
(112050,6,115192,251768),
(112050,7,114424,251000),
(112050,8,114424,249848),
(112050,9,113544,249848),
(112050,10,113544,248440),
(112050,11,114184,248440),
(112050,12,114184,246136),
(112050,13,115832,244488);

-- Goddard Castle
INSERT INTO `zone_vertices` VALUES
(112060,0,151864,-48404),
(112060,1,150145,-45508),
(112060,2,147512,-44268),
(112060,3,144518,-45533),
(112060,4,143918,-49774),
(112060,5,144405,-52084),
(112060,6,147751,-52301),
(112060,7,150746,-52809),
(112060,8,151864,-48404);

-- Rune Castle
INSERT INTO `zone_vertices` VALUES
(112070,0,18808,-49656),
(112070,1,18808,-48648),
(112070,2,16904,-45832),
(112070,3,4488,-45832),
(112070,4,4488,-52742),
(112070,5,17016,-52742),
(112070,6,18808,-49656);

-- Schuttgart Castle
INSERT INTO `zone_vertices` VALUES
(112080,0,80995,-153334),
(112080,1,80808,-150137),
(112080,2,79228,-148694),
(112080,3,76451,-148399),
(112080,4,74703,-149543),
(112080,5,73718,-153342),
(112080,6,75632,-156376),
(112080,7,77635,-155680),
(112080,8,79985,-155849),
(112080,9,80995,-153334);

-- Curse Zones
INSERT INTO `zone_vertices` VALUES
-- Zaken
(12020, 0, 50797, 213515),
(12020, 1, 57617, 213510),
(12020, 2, 57669, 221683),
(12020, 3, 50773, 221632);