/*
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version.
 * 
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 * 
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */

package com.l2jserver.gameserver.scripting;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Formatter;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author JOJO
 * 
GameServer.java patch:
 	XXXXXManager.getInstance();
+	
+	_log.info("Native2Ascii Server Scripts");
+	final String scriptEncoding = "MS932";
+	com.l2jserver.gameserver.scripting.Native2Ascii.run(new File(Config.DATAPACK_ROOT.getAbsolutePath(), "data/scripts"), scriptEncoding);
 	
 	try
 	{
 		_log.info("Loading Server Scripts");
 		File scripts = new File(Config.DATAPACK_ROOT + "/data/scripts.cfg");
 		if(!Config.ALT_DEV_NO_HANDLERS || !Config.ALT_DEV_NO_QUESTS)
 			L2ScriptEngineManager.getInstance().executeScriptList(scripts);
 */
public class Native2Ascii
{
	public static void run(final File scriptsDirectory, final String encoding)
	{
		FileFilter fileFilter = new FileFilter()
		{
			public boolean accept(File file)
			{
				String fileName = file.getName();
				char c0;
				if ((c0 = fileName.charAt(0)) == '.' || c0 == '#')
					return false;
				if (file.isDirectory())
					return true;
				return fileName.endsWith(".java") || fileName.endsWith(".py");
			}
		};
		
		run(scriptsDirectory, fileFilter, encoding);
	}
	
	private static void run(final File scriptsDirectory, final FileFilter fileFilter, final String encoding)
	{
		//System.out.println("__FILE__:__LINE__: [" + scriptsDirectory.getAbsoluteFile() + "]");
		
		final File[] files = scriptsDirectory.listFiles(fileFilter);
		if (files == null)
			return;
		
		for (File file : files)
		{
			if (file.isDirectory())
			{
				run(file, fileFilter, encoding);
			}
			else if (file.isFile())
			{
				//System.out.println("__FILE__:__LINE__:   " + file.getAbsoluteFile());
				String encoding1 = encoding;
				try
				{
					// Step 1: native --> unicode
					char[] unicodeBuffer;
					{
						FileInputStream fis = new FileInputStream(file);
						byte[] byteBuffer = new byte[fis.available()];
						fis.read(byteBuffer);
						fis.close();
						
						if (byteBuffer.length >= 3
								&& byteBuffer[0] == (byte)0xEF
								&& byteBuffer[1] == (byte)0xBB
								&& byteBuffer[2] == (byte)0xBF)	//UTF8 BOM?
						{
							if (file.getPath().endsWith(".java"))
								byteBuffer[0] = byteBuffer[1] = byteBuffer[2] = '\b';
							encoding1 = "UTF8";
						}
						else
						{
							// -*- coding: XXXX -*-
							// vim:fileencoding=XXXX
							String temp = new String(byteBuffer, "ISO8859_1");
							Matcher m = Pattern.compile("coding[=:]\\s*([-\\w.]+)").matcher(temp);
							if (m.find())
								encoding1 = m.group(1);
						}
						
						unicodeBuffer = new String(byteBuffer, encoding1).toCharArray();
					}
					
					// Step 2: unicode --> ascii
					StringBuilder asciiBuffer = new StringBuilder(unicodeBuffer.length * 2);
					Formatter fm = new Formatter(asciiBuffer);
					boolean modify = false;
					for (char unicode : unicodeBuffer)
					{
						if (unicode == '\b')
						{
							modify = true;
						}
						else if (unicode >= 0x80)
						{
							fm.format("\\u%04x", (int)unicode);
						//	asciiBuffer.append(String.format("\\u%04x", (int)unicode));
							modify = true;
						}
						else
						{
							asciiBuffer.append(unicode);
						}
					}
					
					if (modify)
					{
						//System.out.println("__FILE__:__LINE__: [" + encoding1 + "] " + file.getPath());
						long mtime = file.lastModified();
						OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(file)/*, "ISO8859_1"*/);
						osw.write(asciiBuffer.toString());
						osw.close();
						file.setLastModified(mtime);
					}
				}
				catch (IOException e)
				{
					Logger.getLogger("Native2Ascii").warning(file.getAbsoluteFile() + " [" + encoding1 + "] - " + e.toString());
					e.printStackTrace();
				}
			}
		}
	}
}
