package com.l2jserver.gameserver.util;

import java.util.List;

import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;

/**
 * ̖`҃CXgN^[AS҈ēlӂ̃CxgNPCݍĂ̂
 * NPCƏdȂȂ悤ɎIɈʒu␳郍WbNB
 * `҃CXgN^[AS҈ēl_Ɉʒu␳܂B
 * 
 * @author JOJO
 */
public class EventNpcAligner
{
	static public L2Npc align(L2Npc manager)
	{
		int mX = manager.getX(), mY = manager.getY(), mZ = manager.getZ(), mH = manager.getHeading();
		L2Npc guide = null;
		
		List<L2Object> knownObjects = L2World.getInstance().getVisibleObjects(manager, 300);
		LOOP1: for (;;) {
			for (L2Object o : knownObjects)
			{
				if (o instanceof L2Npc)
				{
					L2Npc obj = (L2Npc)o;
					final double collisionRadius = Math.max(30, manager.getTemplate().collisionRadius * 2 + obj.getTemplate().collisionRadius);
					boolean isMove = false;
					while (Util.calculateDistance(mX, mY, obj.getX(), obj.getY()) < collisionRadius)
					{
						if (guide == null)
						{
							guide = findGuide(manager, knownObjects);
							if (guide == null)
							{
								//System.out.println("__BASENAME__:__LINE__: getNearestGuide(" + manager.getNpcId() + manager.getName() + ") is null");
								return manager;
							}
						}
						final double gx = guide.getX(), gy = guide.getY();
						final double dx = mX - gx, dy = mY - gy;
						final double angle = Math.atan2(dy, dx);
						final double radius = Math.sqrt(dx * dx + dy * dy) + manager.getTemplate().collisionRadius * 2;
						mX = (int)Math.round(Math.cos(angle) * radius + gx);
						mY = (int)Math.round(Math.sin(angle) * radius + gy);
						mH = guide.getHeading();
						isMove = true;
					}
					if (isMove)
						continue LOOP1; /*goto LOOP1;*/
				}
			}
			break;
		}
		
		if (mX != manager.getX() || mY != manager.getY() || mH != manager.getHeading())
		{
			//System.out.println("__BASENAME__:__LINE__: " + manager.getNpcId() + manager.getName() + ".setXYZ(" + mX + "," + mY + "," + mZ + ").setHeading(" + mH + ")");
			manager.setXYZ(mX, mY, mZ);
			manager.setHeading(mH);
			manager.broadcastPacket(new ValidateLocation(manager));
			L2Spawn spawn = manager.getSpawn();
			spawn.setXYZ(mY, mY, mZ);
			spawn.setHeading(mH);
		}
		return manager;
	}
	
	static private L2Npc findGuide(L2Npc npc, List<L2Object> knownObjects)
	{
		L2Npc nearestGuide = null;
		double distance = Double.MAX_VALUE;
		for (L2Object o : knownObjects)
		{
			if (o instanceof L2Npc)
			{
				L2Npc obj = (L2Npc)o;
				switch (obj.getNpcId())
				{
//					default:
//						if (obj.getInstanceType() != InstanceType.L2AdventurerInstance)
//							break;
					case 32327:	//` CXgN^[
					case 30598:	//S҈ēl^b铇̑
					case 30599:	//S҈ēl^Gt
					case 30600:	//S҈ēl^_[NGt
					case 30601:	//S҈ēl^h[t
					case 30602:	//S҈ēl^I[N
					case 31076:	//S҈ēl^O[fB
					case 31077:	//S҈ēl^O[fBȊ
					case 32135:	//S҈ēl^J}G
						double d = Util.calculateDistance(npc, obj, true);
						if (distance > d)
						{
							distance = d;
							nearestGuide = obj;
						}
				}
			}
		}
		return nearestGuide;
	}
}
