/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SpawnTable;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NpcWalkerRoutesTable {
    private static final Logger _log = Logger.getLogger(SpawnTable.class.getName());
    private TIntObjectHashMap<List<L2NpcWalkerNode>> _routes = new TIntObjectHashMap();

    public static NpcWalkerRoutesTable getInstance() {
        return SingletonHolder._instance;
    }

    private NpcWalkerRoutesTable() {
        if (Config.ALLOW_NPC_WALKERS) {
            _log.info("Initializing Walkers Routes Table.");
            this.load();
        }
    }

    public void load() {
        this._routes.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/WalkerRoutes.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse WalkerRoutes.xml file: " + e.getMessage(), e);
            }
            Node n = doc.getFirstChild();
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!d.getNodeName().equals("walker")) continue;
                ArrayList<L2NpcWalkerNode> list = new ArrayList<L2NpcWalkerNode>();
                int npcId = Integer.parseInt(d.getAttributes().getNamedItem("npcId").getNodeValue());
                for (Node r = d.getFirstChild(); r != null; r = r.getNextSibling()) {
                    if (!r.getNodeName().equals("route")) continue;
                    NamedNodeMap attrs = r.getAttributes();
                    int id = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                    int x = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                    int y = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                    int z = Integer.parseInt(attrs.getNamedItem("Z").getNodeValue());
                    int delay = Integer.parseInt(attrs.getNamedItem("delay").getNodeValue());
                    String chat = attrs.getNamedItem("string").getNodeValue();
                    boolean running = Boolean.parseBoolean(attrs.getNamedItem("run").getNodeValue());
                    list.add(new L2NpcWalkerNode(id, chat, x, y, z, delay, running));
                }
                this._routes.put(npcId, list);
            }
        }
        for (Object list : this._routes.getValues()) {
            ((ArrayList)list).trimToSize();
        }
        _log.info("WalkerRoutesTable: Loaded " + this._routes.size() + " Npc Walker Routes.");
    }

    public List<L2NpcWalkerNode> getRouteForNpc(int id) {
        return (List)this._routes.get(id);
    }

    public static void main(String ... arg) {
        NpcWalkerRoutesTable.getInstance().load();
    }

    private static class SingletonHolder {
        protected static final NpcWalkerRoutesTable _instance = new NpcWalkerRoutesTable();

        private SingletonHolder() {
        }
    }
}

