/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.SkillTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2Skill;
import gnu.trove.TIntObjectHashMap;
import java.io.File;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;
import javolution.util.FastList;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SubPledgeSkillTree {
    private static final Logger _log = Logger.getLogger(SubPledgeSkillTree.class.getName());
    private TIntObjectHashMap<SubUnitSkill> skilltree = new TIntObjectHashMap();

    public SubPledgeSkillTree() {
        this.load();
    }

    public static SubPledgeSkillTree getInstance() {
        return SingletonHolder._instance;
    }

    public void reload() {
        this.load();
    }

    private void load() {
        this.skilltree.clear();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(false);
        factory.setIgnoringComments(true);
        File file = new File(Config.DATAPACK_ROOT, "data/skillTrees/subpledgeskilltree.xml");
        Document doc = null;
        if (file.exists()) {
            try {
                doc = factory.newDocumentBuilder().parse(file);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not parse subpledgeskilltree.xml file: " + e.getMessage(), e);
            }
            for (Node n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"skill_tree".equalsIgnoreCase(n.getNodeName())) continue;
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if (!"skill".equalsIgnoreCase(d.getNodeName())) continue;
                    NamedNodeMap attrs = d.getAttributes();
                    Node att = attrs.getNamedItem("id");
                    if (att == null) {
                        _log.severe("[SubPledgeSkillTree] Missing id, skipping");
                        continue;
                    }
                    int skillId = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("level");
                    if (att == null) {
                        _log.severe("[SubPledgeSkillTree] Missing level, skipping");
                        continue;
                    }
                    int skillLvl = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("reputation");
                    if (att == null) {
                        _log.severe("[SubPledgeSkillTree] Missing reputation, skipping");
                        continue;
                    }
                    int reputation = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("clan_level");
                    if (att == null) {
                        _log.severe("[SubPledgeSkillTree] Missing clan_level, skipping");
                        continue;
                    }
                    int clanLvl = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("itemId");
                    if (att == null) {
                        _log.severe("[SubPledgeSkillTree] Missing itemId, skipping");
                        continue;
                    }
                    int itemId = Integer.parseInt(att.getNodeValue());
                    att = attrs.getNamedItem("count");
                    if (att == null) {
                        _log.severe("[SubPledgeSkillTree] Missing count, skipping");
                        continue;
                    }
                    int count = Integer.parseInt(att.getNodeValue());
                    L2Skill skill = SkillTable.getInstance().getInfo(skillId, skillLvl);
                    if (skill == null) {
                        _log.severe("[SubPledgeSkillTree] Skill " + skillId + " not exist, skipping");
                        continue;
                    }
                    this.skilltree.put(SkillTable.getSkillHashCode(skill), (Object)new SubUnitSkill(skill, clanLvl, reputation, itemId, count));
                }
            }
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this.skilltree.size() + " SubUnit Skills");
    }

    public SubUnitSkill getSkill(int skillhash) {
        return (SubUnitSkill)this.skilltree.get(skillhash);
    }

    public SubUnitSkill[] getAvailableSkills(L2Clan clan) {
        FastList list = FastList.newInstance();
        for (Object obj : this.skilltree.getValues()) {
            SubUnitSkill skill = (SubUnitSkill)obj;
            if (skill.getClanLvl() > clan.getLevel()) continue;
            list.add((Object)skill);
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            SubUnitSkill sus = (SubUnitSkill)it.next();
            if (clan.isLearnableSubSkill(sus.getSkill())) continue;
            it.remove();
        }
        SubUnitSkill[] result = (SubUnitSkill[])list.toArray((Object[])new SubUnitSkill[list.size()]);
        FastList.recycle((FastList)list);
        return result;
    }

    private static class SingletonHolder {
        protected static final SubPledgeSkillTree _instance = new SubPledgeSkillTree();

        private SingletonHolder() {
        }
    }

    public static class SubUnitSkill {
        private L2Skill skill;
        private int clanLvl;
        private int reputation;
        private int itemId;
        private int count;

        public SubUnitSkill(L2Skill skill, int clanLvl, int reputation, int itemId, int count) {
            this.skill = skill;
            this.clanLvl = clanLvl;
            this.reputation = reputation;
            this.itemId = itemId;
            this.count = count;
        }

        public L2Skill getSkill() {
            return this.skill;
        }

        public int getClanLvl() {
            return this.clanLvl;
        }

        public int getReputation() {
            return this.reputation;
        }

        public int getItemId() {
            return this.itemId;
        }

        public int getCount() {
            return this.count;
        }
    }
}

