/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.MercTicketManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class SiegeGuardManager {
    private static Logger _log = Logger.getLogger(SiegeGuardManager.class.getName());
    private Castle _castle;
    private List<L2Spawn> _siegeGuardSpawn = new FastList();

    public SiegeGuardManager(Castle castle) {
        this._castle = castle;
    }

    public void addSiegeGuard(L2PcInstance activeChar, int npcId) {
        if (activeChar == null) {
            return;
        }
        this.addSiegeGuard(activeChar.getX(), activeChar.getY(), activeChar.getZ(), activeChar.getHeading(), npcId);
    }

    public void addSiegeGuard(int x, int y, int z, int heading, int npcId) {
        this.saveSiegeGuard(x, y, z, heading, npcId, 0);
    }

    public void hireMerc(L2PcInstance activeChar, int npcId) {
        if (activeChar == null) {
            return;
        }
        this.hireMerc(activeChar.getX(), activeChar.getY(), activeChar.getZ(), activeChar.getHeading(), npcId);
    }

    public void hireMerc(int x, int y, int z, int heading, int npcId) {
        this.saveSiegeGuard(x, y, z, heading, npcId, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMerc(int npcId, int x, int y, int z) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Delete From castle_siege_guards Where npcId = ? And x = ? AND y = ? AND z = ? AND isHired = 1");
            statement.setInt(1, npcId);
            statement.setInt(2, x);
            statement.setInt(3, y);
            statement.setInt(4, z);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error deleting hired siege guard at " + x + ',' + y + ',' + z + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMercs() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Delete From castle_siege_guards Where castleId = ? And isHired = 1");
            statement.setInt(1, this.getCastle().getCastleId());
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error deleting hired siege guard for castle " + this.getCastle().getName() + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void spawnSiegeGuard() {
        try {
            int hiredCount = 0;
            int hiredMax = MercTicketManager.getInstance().getMaxAllowedMerc(this._castle.getCastleId());
            boolean isHired = this.getCastle().getOwnerId() > 0;
            this.loadSiegeGuard();
            for (L2Spawn spawn : this.getSiegeGuardSpawn()) {
                if (spawn == null) continue;
                spawn.init();
                if (!isHired) continue;
                spawn.stopRespawn();
                if (++hiredCount <= hiredMax) continue;
                return;
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Error spawning siege guards for castle " + this.getCastle().getName(), e);
        }
    }

    public void unspawnSiegeGuard() {
        for (L2Spawn spawn : this.getSiegeGuardSpawn()) {
            if (spawn == null) continue;
            spawn.stopRespawn();
            spawn.getLastSpawn().doDie(spawn.getLastSpawn());
        }
        this.getSiegeGuardSpawn().clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSiegeGuard() {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("SELECT * FROM castle_siege_guards Where castleId = ? And isHired = ?");
            statement.setInt(1, this.getCastle().getCastleId());
            if (this.getCastle().getOwnerId() > 0) {
                statement.setInt(2, 1);
            } else {
                statement.setInt(2, 0);
            }
            ResultSet rs = statement.executeQuery();
            while (rs.next()) {
                L2NpcTemplate template1 = NpcTable.getInstance().getTemplate(rs.getInt("npcId"));
                if (template1 != null) {
                    L2Spawn spawn1 = new L2Spawn(template1);
                    spawn1.setAmount(1);
                    spawn1.setLocx(rs.getInt("x"));
                    spawn1.setLocy(rs.getInt("y"));
                    spawn1.setLocz(rs.getInt("z"));
                    spawn1.setHeading(rs.getInt("heading"));
                    spawn1.setRespawnDelay(rs.getInt("respawnDelay"));
                    spawn1.setLocation(0);
                    this._siegeGuardSpawn.add(spawn1);
                    continue;
                }
                _log.warning("Missing npc data in npc table for id: " + rs.getInt("npcId"));
            }
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error loading siege guard for castle " + this.getCastle().getName() + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSiegeGuard(int x, int y, int z, int heading, int npcId, int isHire) {
        Connection con = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            PreparedStatement statement = con.prepareStatement("Insert Into castle_siege_guards (castleId, npcId, x, y, z, heading, respawnDelay, isHired) Values (?, ?, ?, ?, ?, ?, ?, ?)");
            statement.setInt(1, this.getCastle().getCastleId());
            statement.setInt(2, npcId);
            statement.setInt(3, x);
            statement.setInt(4, y);
            statement.setInt(5, z);
            statement.setInt(6, heading);
            if (isHire == 1) {
                statement.setInt(7, 0);
            } else {
                statement.setInt(7, 600);
            }
            statement.setInt(8, isHire);
            statement.execute();
            statement.close();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error adding siege guard for castle " + this.getCastle().getName() + ": " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public final Castle getCastle() {
        return this._castle;
    }

    public final List<L2Spawn> getSiegeGuardSpawn() {
        return this._siegeGuardSpawn;
    }
}

