/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.L2Spawn;
import com.l2jserver.gameserver.model.SpawnListener;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class AutoChatHandler
implements SpawnListener {
    protected static final Logger _log = Logger.getLogger(AutoChatHandler.class.getName());
    private static final int DEFAULT_CHAT_DELAY = 60000;
    protected Map<Integer, AutoChatInstance> _registeredChats = new FastMap();

    private AutoChatHandler() {
        this.restoreChatData();
        L2Spawn.addSpawnListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreChatData() {
        int numLoaded = 0;
        Connection con = null;
        PreparedStatement statement = null;
        PreparedStatement statement2 = null;
        ResultSet rs = null;
        ResultSet rs2 = null;
        try {
            con = L2DatabaseFactory.getInstance().getConnection();
            statement = con.prepareStatement("SELECT * FROM auto_chat ORDER BY groupId ASC");
            rs = statement.executeQuery();
            statement2 = con.prepareStatement("SELECT * FROM auto_chat_text WHERE groupId=?");
            while (rs.next()) {
                ++numLoaded;
                statement2.setInt(1, rs.getInt("groupId"));
                rs2 = statement2.executeQuery();
                statement2.clearParameters();
                rs2.last();
                String[] chatTexts = new String[rs2.getRow()];
                int i = 0;
                rs2.beforeFirst();
                while (rs2.next()) {
                    chatTexts[i++] = rs2.getString("chatText");
                }
                this.registerGlobalChat(rs.getInt("npcId"), chatTexts, rs.getLong("chatDelay"));
            }
            statement2.close();
            rs.close();
            statement.close();
            if (Config.DEBUG) {
                _log.info("AutoChatHandler: Loaded " + numLoaded + " chat group(s) from the database.");
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "AutoSpawnHandler: Could not restore chat data: " + e.getMessage(), e);
        }
        finally {
            L2DatabaseFactory.close(con);
        }
    }

    public void reload() {
        for (AutoChatInstance aci : this._registeredChats.values()) {
            if (aci == null) continue;
            if (aci._chatTask != null) {
                aci._chatTask.cancel(true);
            }
            this.removeChat(aci);
        }
        this._registeredChats = new FastMap();
        this.restoreChatData();
    }

    public static AutoChatHandler getInstance() {
        return SingletonHolder._instance;
    }

    public int size() {
        return this._registeredChats.size();
    }

    public AutoChatInstance registerGlobalChat(int npcId, String[] chatTexts, long chatDelay) {
        return this.registerChat(npcId, null, chatTexts, chatDelay);
    }

    public AutoChatInstance registerChat(L2Npc npcInst, String[] chatTexts, long chatDelay) {
        return this.registerChat(npcInst.getNpcId(), npcInst, chatTexts, chatDelay);
    }

    private final AutoChatInstance registerChat(int npcId, L2Npc npcInst, String[] chatTexts, long chatDelay) {
        AutoChatInstance chatInst = null;
        if (chatDelay < 0L) {
            chatDelay = 60000 + Rnd.nextInt(60000);
        }
        chatInst = this._registeredChats.containsKey(npcId) ? this._registeredChats.get(npcId) : new AutoChatInstance(npcId, chatTexts, chatDelay, npcInst == null);
        if (npcInst != null) {
            chatInst.addChatDefinition(npcInst);
        }
        this._registeredChats.put(npcId, chatInst);
        return chatInst;
    }

    public boolean removeChat(int npcId) {
        AutoChatInstance chatInst = this._registeredChats.get(npcId);
        return this.removeChat(chatInst);
    }

    public boolean removeChat(AutoChatInstance chatInst) {
        if (chatInst == null) {
            return false;
        }
        this._registeredChats.remove(chatInst.getNPCId());
        chatInst.setActive(false);
        if (Config.DEBUG) {
            _log.info("AutoChatHandler: Removed auto chat for NPC ID " + chatInst.getNPCId());
        }
        return true;
    }

    public AutoChatInstance getAutoChatInstance(int id, boolean byObjectId) {
        if (!byObjectId) {
            return this._registeredChats.get(id);
        }
        for (AutoChatInstance chatInst : this._registeredChats.values()) {
            if (chatInst.getChatDefinition(id) == null) continue;
            return chatInst;
        }
        return null;
    }

    public void setAutoChatActive(boolean isActive) {
        for (AutoChatInstance chatInst : this._registeredChats.values()) {
            chatInst.setActive(isActive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void npcSpawned(L2Npc npc) {
        Map<Integer, AutoChatInstance> map = this._registeredChats;
        synchronized (map) {
            AutoChatInstance chatInst;
            if (npc == null) {
                return;
            }
            int npcId = npc.getNpcId();
            if (this._registeredChats.containsKey(npcId) && (chatInst = this._registeredChats.get(npcId)) != null && chatInst.isGlobal()) {
                chatInst.addChatDefinition(npc);
            }
        }
    }

    private static class SingletonHolder {
        protected static final AutoChatHandler _instance = new AutoChatHandler();

        private SingletonHolder() {
        }
    }

    public class AutoChatInstance {
        protected int _npcId;
        private long _defaultDelay = 60000L;
        private String[] _defaultTexts;
        private boolean _defaultRandom = false;
        private boolean _globalChat = false;
        private boolean _isActive;
        private Map<Integer, AutoChatDefinition> _chatDefinitions = new FastMap();
        protected ScheduledFuture<?> _chatTask;

        protected AutoChatInstance(int npcId, String[] chatTexts, long chatDelay, boolean isGlobal) {
            this._defaultTexts = chatTexts;
            this._npcId = npcId;
            this._defaultDelay = chatDelay;
            this._globalChat = isGlobal;
            if (Config.DEBUG) {
                _log.info("AutoChatHandler: Registered auto chat for NPC ID " + this._npcId + " (Global Chat = " + this._globalChat + ").");
            }
            this.setActive(true);
        }

        protected AutoChatDefinition getChatDefinition(int objectId) {
            return this._chatDefinitions.get(objectId);
        }

        protected AutoChatDefinition[] getChatDefinitions() {
            return this._chatDefinitions.values().toArray(new AutoChatDefinition[this._chatDefinitions.values().size()]);
        }

        public int addChatDefinition(L2Npc npcInst) {
            return this.addChatDefinition(npcInst, null, 0L);
        }

        public int addChatDefinition(L2Npc npcInst, String[] chatTexts, long chatDelay) {
            int objectId = npcInst.getObjectId();
            AutoChatDefinition chatDef = new AutoChatDefinition(this, npcInst, chatTexts, chatDelay);
            if (npcInst instanceof L2DefenderInstance) {
                chatDef.setRandomChat(true);
            }
            this._chatDefinitions.put(objectId, chatDef);
            return objectId;
        }

        public boolean removeChatDefinition(int objectId) {
            if (!this._chatDefinitions.containsKey(objectId)) {
                return false;
            }
            AutoChatDefinition chatDefinition = this._chatDefinitions.get(objectId);
            chatDefinition.setActive(false);
            this._chatDefinitions.remove(objectId);
            return true;
        }

        public boolean isActive() {
            return this._isActive;
        }

        public boolean isGlobal() {
            return this._globalChat;
        }

        public boolean isDefaultRandom() {
            return this._defaultRandom;
        }

        public boolean isRandomChat(int objectId) {
            if (!this._chatDefinitions.containsKey(objectId)) {
                return false;
            }
            return this._chatDefinitions.get(objectId).isRandomChat();
        }

        public int getNPCId() {
            return this._npcId;
        }

        public int getDefinitionCount() {
            return this._chatDefinitions.size();
        }

        public L2Npc[] getNPCInstanceList() {
            FastList npcInsts = new FastList();
            for (AutoChatDefinition chatDefinition : this._chatDefinitions.values()) {
                npcInsts.add(chatDefinition._npcInstance);
            }
            return npcInsts.toArray(new L2Npc[npcInsts.size()]);
        }

        public long getDefaultDelay() {
            return this._defaultDelay;
        }

        public String[] getDefaultTexts() {
            return this._defaultTexts;
        }

        public void setDefaultChatDelay(long delayValue) {
            this._defaultDelay = delayValue;
        }

        public void setDefaultChatTexts(String[] textsValue) {
            this._defaultTexts = textsValue;
        }

        public void setDefaultRandom(boolean randValue) {
            this._defaultRandom = randValue;
        }

        public void setChatDelay(int objectId, long delayValue) {
            AutoChatDefinition chatDef = this.getChatDefinition(objectId);
            if (chatDef != null) {
                chatDef.setChatDelay(delayValue);
            }
        }

        public void setChatTexts(int objectId, String[] textsValue) {
            AutoChatDefinition chatDef = this.getChatDefinition(objectId);
            if (chatDef != null) {
                chatDef.setChatTexts(textsValue);
            }
        }

        public void setRandomChat(int objectId, boolean randValue) {
            AutoChatDefinition chatDef = this.getChatDefinition(objectId);
            if (chatDef != null) {
                chatDef.setRandomChat(randValue);
            }
        }

        public void setActive(boolean activeValue) {
            if (this._isActive == activeValue) {
                return;
            }
            this._isActive = activeValue;
            if (!this.isGlobal()) {
                for (AutoChatDefinition chatDefinition : this._chatDefinitions.values()) {
                    chatDefinition.setActive(activeValue);
                }
                return;
            }
            if (this.isActive()) {
                AutoChatRunner acr = new AutoChatRunner(this._npcId, -1);
                this._chatTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(acr, this._defaultDelay, this._defaultDelay);
            } else {
                this._chatTask.cancel(false);
            }
        }

        private class AutoChatRunner
        implements Runnable {
            private int _runnerNpcId;
            private int _objectId;

            protected AutoChatRunner(int pNpcId, int pObjectId) {
                this._runnerNpcId = pNpcId;
                this._objectId = pObjectId;
            }

            @Override
            public synchronized void run() {
                AutoChatDefinition[] chatDefinitions;
                AutoChatInstance chatInst = AutoChatHandler.this._registeredChats.get(this._runnerNpcId);
                if (chatInst.isGlobal()) {
                    chatDefinitions = chatInst.getChatDefinitions();
                } else {
                    AutoChatDefinition chatDef = chatInst.getChatDefinition(this._objectId);
                    if (chatDef == null) {
                        _log.warning("AutoChatHandler: Auto chat definition is NULL for NPC ID " + AutoChatInstance.this._npcId + ".");
                        return;
                    }
                    chatDefinitions = new AutoChatDefinition[]{chatDef};
                }
                if (Config.DEBUG) {
                    _log.info("AutoChatHandler: Running auto chat for " + chatDefinitions.length + " instances of NPC ID " + AutoChatInstance.this._npcId + "." + " (Global Chat = " + chatInst.isGlobal() + ")");
                }
                for (AutoChatDefinition chatDef : chatDefinitions) {
                    try {
                        String text;
                        L2Npc chatNpc = chatDef._npcInstance;
                        FastList nearbyPlayers = new FastList();
                        FastList nearbyGMs = new FastList();
                        for (L2Character player : chatNpc.getKnownList().getKnownCharactersInRadius(1500L)) {
                            if (!(player instanceof L2PcInstance)) continue;
                            if (((L2PcInstance)player).isGM()) {
                                nearbyGMs.add((L2PcInstance)player);
                                continue;
                            }
                            nearbyPlayers.add((L2PcInstance)player);
                        }
                        int maxIndex = chatDef.getChatTexts().length;
                        int lastIndex = Rnd.nextInt(maxIndex);
                        String creatureName = chatNpc.getName();
                        if (!chatDef.isRandomChat()) {
                            lastIndex = chatDef._chatIndex + 1;
                            if (lastIndex == maxIndex) {
                                lastIndex = 0;
                            }
                            chatDef._chatIndex = lastIndex;
                        }
                        if ((text = chatDef.getChatTexts()[lastIndex]) == null) {
                            return;
                        }
                        if (!nearbyPlayers.isEmpty()) {
                            int randomPlayerIndex = Rnd.nextInt(nearbyPlayers.size());
                            L2PcInstance randomPlayer = (L2PcInstance)nearbyPlayers.get(randomPlayerIndex);
                            int winningCabal = SevenSigns.getInstance().getCabalHighestScore();
                            int losingCabal = 0;
                            if (winningCabal == 2) {
                                losingCabal = 1;
                            } else if (winningCabal == 1) {
                                losingCabal = 2;
                            }
                            if (text.indexOf("%player_random%") > -1) {
                                text = text.replaceAll("%player_random%", randomPlayer.getName());
                            }
                            if (text.indexOf("%player_cabal_winner%") > -1) {
                                for (L2PcInstance nearbyPlayer : nearbyPlayers) {
                                    if (SevenSigns.getInstance().getPlayerCabal(nearbyPlayer.getObjectId()) != winningCabal) continue;
                                    text = text.replaceAll("%player_cabal_winner%", nearbyPlayer.getName());
                                    break;
                                }
                            }
                            if (text.indexOf("%player_cabal_loser%") > -1) {
                                for (L2PcInstance nearbyPlayer : nearbyPlayers) {
                                    if (SevenSigns.getInstance().getPlayerCabal(nearbyPlayer.getObjectId()) != losingCabal) continue;
                                    text = text.replaceAll("%player_cabal_loser%", nearbyPlayer.getName());
                                    break;
                                }
                            }
                        }
                        if (text == null) {
                            return;
                        }
                        if (!text.contains("%player_")) {
                            CreatureSay cs = new CreatureSay(chatNpc.getObjectId(), 0, creatureName, text);
                            for (L2PcInstance nearbyPlayer : nearbyPlayers) {
                                nearbyPlayer.sendPacket(cs);
                            }
                            for (L2PcInstance nearbyGM : nearbyGMs) {
                                nearbyGM.sendPacket(cs);
                            }
                        }
                        if (!Config.DEBUG) continue;
                        _log.fine("AutoChatHandler: Chat propogation for object ID " + chatNpc.getObjectId() + " (" + creatureName + ") with text '" + text + "' sent to " + nearbyPlayers.size() + " nearby players.");
                    }
                    catch (Exception e) {
                        _log.log(Level.WARNING, "Exception on AutoChatRunner.run(): " + e.getMessage(), e);
                        return;
                    }
                }
            }
        }

        private class AutoChatDefinition {
            protected int _chatIndex = 0;
            protected L2Npc _npcInstance;
            protected AutoChatInstance _chatInstance;
            private long _chatDelay = 0L;
            private String[] _chatTexts = null;
            private boolean _isActiveDefinition;
            private boolean _randomChat;

            protected AutoChatDefinition(AutoChatInstance chatInst, L2Npc npcInst, String[] chatTexts, long chatDelay) {
                this._npcInstance = npcInst;
                this._chatInstance = chatInst;
                this._randomChat = chatInst.isDefaultRandom();
                this._chatDelay = chatDelay;
                this._chatTexts = chatTexts;
                if (Config.DEBUG) {
                    _log.info("AutoChatHandler: Chat definition added for NPC ID " + this._npcInstance.getNpcId() + " (Object ID = " + this._npcInstance.getObjectId() + ").");
                }
                if (!chatInst.isGlobal()) {
                    this.setActive(true);
                }
            }

            protected String[] getChatTexts() {
                if (this._chatTexts != null) {
                    return this._chatTexts;
                }
                return this._chatInstance.getDefaultTexts();
            }

            private long getChatDelay() {
                if (this._chatDelay > 0L) {
                    return this._chatDelay;
                }
                return this._chatInstance.getDefaultDelay();
            }

            private boolean isActive() {
                return this._isActiveDefinition;
            }

            boolean isRandomChat() {
                return this._randomChat;
            }

            void setRandomChat(boolean randValue) {
                this._randomChat = randValue;
            }

            void setChatDelay(long delayValue) {
                this._chatDelay = delayValue;
            }

            void setChatTexts(String[] textsValue) {
                this._chatTexts = textsValue;
            }

            void setActive(boolean activeValue) {
                if (this.isActive() == activeValue) {
                    return;
                }
                if (activeValue) {
                    AutoChatRunner acr = new AutoChatRunner(AutoChatInstance.this._npcId, this._npcInstance.getObjectId());
                    AutoChatInstance.this._chatTask = this.getChatDelay() == 0L ? ThreadPoolManager.getInstance().scheduleGeneral(acr, 5L) : ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(acr, this.getChatDelay(), this.getChatDelay());
                } else {
                    AutoChatInstance.this._chatTask.cancel(false);
                }
                this._isActiveDefinition = activeValue;
            }
        }
    }
}

