/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.Territory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.SpawnListener;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import com.l2jserver.util.Rnd;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;

public class L2Spawn {
    protected static final Logger _log = Logger.getLogger(L2Spawn.class.getName());
    private L2NpcTemplate _template;
    private int _location;
    private int _maximumCount;
    private int _currentCount;
    protected int _scheduledCount;
    private int _locX;
    private int _locY;
    private int _locZ;
    private int _heading;
    private int _respawnDelay;
    private int _respawnMinDelay;
    private int _respawnMaxDelay;
    private int _instanceId = 0;
    private Constructor<?> _constructor;
    private boolean _doRespawn;
    private boolean _customSpawn;
    private L2Npc _lastSpawn;
    private static List<SpawnListener> _spawnListeners = new FastList();

    @Deprecated
    public boolean isRespawnable() {
        return this._doRespawn;
    }

    public L2Spawn(L2NpcTemplate mobTemplate) throws SecurityException, ClassNotFoundException, NoSuchMethodException {
        this._template = mobTemplate;
        if (this._template == null) {
            return;
        }
        String implementationName = this._template.type;
        if (mobTemplate.npcId == 30995) {
            implementationName = "L2RaceManager";
        }
        if (mobTemplate.npcId >= 31046 && mobTemplate.npcId <= 31053) {
            implementationName = "L2SymbolMaker";
        }
        Class[] parameters = new Class[]{Integer.TYPE, Class.forName("com.l2jserver.gameserver.templates.chars.L2NpcTemplate")};
        this._constructor = Class.forName("com.l2jserver.gameserver.model.actor.instance." + implementationName + "Instance").getConstructor(parameters);
    }

    public int getAmount() {
        return this._maximumCount;
    }

    public int getLocation() {
        return this._location;
    }

    public int getLocx() {
        return this._locX;
    }

    public int getLocy() {
        return this._locY;
    }

    public int getLocz() {
        return this._locZ;
    }

    public int getNpcid() {
        return this._template.npcId;
    }

    public int getHeading() {
        return this._heading;
    }

    public int getRespawnDelay() {
        return this._respawnDelay;
    }

    public int getRespawnMinDelay() {
        return this._respawnMinDelay;
    }

    public int getRespawnMaxDelay() {
        return this._respawnMaxDelay;
    }

    public void setAmount(int amount) {
        if (amount <= 0) {
            _log.log(Level.WARNING, "NPC " + this._template.npcId + this._template.name + " setAmount(" + amount + ")");
            Thread.dumpStack();
        }
        this._maximumCount = amount;
    }

    public void setLocation(int location) {
        this._location = location;
    }

    public void setRespawnMinDelay(int date) {
        this._respawnMinDelay = date;
    }

    public void setRespawnMaxDelay(int date) {
        this._respawnMaxDelay = date;
    }

    public void setLocx(int locx) {
        this._locX = locx;
    }

    public void setLocy(int locy) {
        this._locY = locy;
    }

    public void setLocz(int locz) {
        this._locZ = locz;
    }

    public void setXYZ(int locx, int locy, int locz) {
        this._locX = locx;
        this._locY = locy;
        this._locZ = locz;
    }

    public void setHeading(int heading) {
        this._heading = heading;
    }

    public void setCustom(boolean custom) {
        this._customSpawn = custom;
    }

    public boolean isCustom() {
        return this._customSpawn;
    }

    public void decreaseCount(L2Npc oldNpc) {
        if (this._currentCount <= 0) {
            return;
        }
        --this._currentCount;
        if (this._doRespawn && this._scheduledCount + this._currentCount < this._maximumCount) {
            ++this._scheduledCount;
            ThreadPoolManager.getInstance().scheduleGeneral(new SpawnTask(oldNpc), this._respawnDelay);
        }
    }

    public int init() {
        while (this._currentCount < this._maximumCount) {
            this.doSpawn();
        }
        this._doRespawn = true;
        return this._currentCount;
    }

    public L2Npc spawnOne(boolean val) {
        return this.doSpawn(val);
    }

    public boolean isRespawnEnabled() {
        return this._doRespawn;
    }

    public void stopRespawn() {
        this._doRespawn = false;
    }

    public void startRespawn() {
        this._doRespawn = true;
    }

    public L2Npc doSpawn() {
        return this.doSpawn(false);
    }

    public L2Npc doSpawn(boolean isSummonSpawn) {
        L2Npc mob = null;
        try {
            if (this._template.type.equalsIgnoreCase("L2Pet") || this._template.type.equalsIgnoreCase("L2Decoy") || this._template.type.equalsIgnoreCase("L2Trap") || this._template.type.equalsIgnoreCase("L2EffectPoint")) {
                ++this._currentCount;
                return mob;
            }
            Object[] parameters = new Object[]{IdFactory.getInstance().getNextId(), this._template};
            Object tmp = this._constructor.newInstance(parameters);
            ((L2Object)tmp).setInstanceId(this._instanceId);
            if (isSummonSpawn && tmp instanceof L2Character) {
                ((L2Character)tmp).setShowSummonAnimation(isSummonSpawn);
            }
            if (!(tmp instanceof L2Npc)) {
                return mob;
            }
            mob = (L2Npc)tmp;
            return this.initializeNpcInstance(mob);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "NPC " + this._template.npcId + " class not found", e);
            return mob;
        }
    }

    private L2Npc initializeNpcInstance(L2Npc mob) {
        int random;
        int newlocz;
        int newlocy;
        int newlocx;
        if (this.getLocx() == 0 && this.getLocy() == 0) {
            if (this.getLocation() == 0) {
                return mob;
            }
            int[] p = Territory.getInstance().getRandomPoint(this.getLocation());
            newlocx = p[0];
            newlocy = p[1];
            newlocz = GeoData.getInstance().getSpawnHeight(newlocx, newlocy, p[2], p[3], this);
        } else {
            newlocx = this.getLocx();
            newlocy = this.getLocy();
            newlocz = Config.GEODATA > 0 ? (int)GeoData.getInstance().getSpawnHeight(newlocx, newlocy, this.getLocz(), this.getLocz(), this) : this.getLocz();
        }
        mob.stopAllEffects();
        mob.setIsDead(false);
        mob.setDecayed(false);
        mob.setCurrentHpMp(mob.getMaxHp(), mob.getMaxMp());
        if (this.getHeading() == -1) {
            mob.setHeading(Rnd.nextInt(61794));
        } else {
            mob.setHeading(this.getHeading());
        }
        if (mob instanceof L2Attackable) {
            ((L2Attackable)mob).setChampion(false);
        }
        if (Config.L2JMOD_CHAMPION_ENABLE && mob instanceof L2MonsterInstance && !this.getTemplate().isQuestMonster && !mob.isRaid() && !((L2MonsterInstance)mob).isRaidMinion() && Config.L2JMOD_CHAMPION_FREQUENCY > 0 && mob.getLevel() >= Config.L2JMOD_CHAMP_MIN_LVL && mob.getLevel() <= Config.L2JMOD_CHAMP_MAX_LVL && (Config.L2JMOD_CHAMPION_ENABLE_IN_INSTANCES || this.getInstanceId() == 0) && (random = Rnd.get(100)) < Config.L2JMOD_CHAMPION_FREQUENCY) {
            ((L2Attackable)mob).setChampion(true);
        }
        mob.setSpawn(this);
        mob.spawnMe(newlocx, newlocy, newlocz);
        L2Spawn.notifyNpcSpawned(mob);
        this._lastSpawn = mob;
        if (Config.DEBUG) {
            _log.finest("spawned Mob ID: " + this._template.npcId + " ,at: " + mob.getX() + " x, " + mob.getY() + " y, " + mob.getZ() + " z");
        }
        ++this._currentCount;
        return mob;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSpawnListener(SpawnListener listener) {
        List<SpawnListener> list = _spawnListeners;
        synchronized (list) {
            _spawnListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSpawnListener(SpawnListener listener) {
        List<SpawnListener> list = _spawnListeners;
        synchronized (list) {
            _spawnListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void notifyNpcSpawned(L2Npc npc) {
        List<SpawnListener> list = _spawnListeners;
        synchronized (list) {
            for (SpawnListener listener : _spawnListeners) {
                listener.npcSpawned(npc);
            }
        }
    }

    public void setRespawnDelay(int i) {
        if (i < 0) {
            _log.warning("respawn delay is negative for spawn:" + this);
        }
        if (i < 10) {
            i = 10;
        }
        this._respawnDelay = i * 1000;
    }

    public L2Npc getLastSpawn() {
        return this._lastSpawn;
    }

    public void respawnNpc(L2Npc oldNpc) {
        if (this._doRespawn) {
            oldNpc.refreshID();
            this.initializeNpcInstance(oldNpc);
        }
    }

    public L2NpcTemplate getTemplate() {
        return this._template;
    }

    public int getInstanceId() {
        return this._instanceId;
    }

    public void setInstanceId(int instanceId) {
        this._instanceId = instanceId;
    }

    public String toString() {
        return "L2Spawn [_template=" + this.getNpcid() + ", _locX=" + this._locX + ", _locY=" + this._locY + ", _locZ=" + this._locZ + ", _heading=" + this._heading + "]";
    }

    class SpawnTask
    implements Runnable {
        private L2Npc _oldNpc;

        public SpawnTask(L2Npc pOldNpc) {
            this._oldNpc = pOldNpc;
        }

        @Override
        public void run() {
            try {
                L2Spawn.this.respawnNpc(this._oldNpc);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "", e);
            }
            --L2Spawn.this._scheduledCount;
        }
    }
}

