/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.NpcTable;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.skills.AbnormalEffect;
import com.l2jserver.gameserver.templates.chars.L2NpcTemplate;
import java.util.logging.Logger;

public class CharInfo
extends L2GameServerPacket {
    private static final Logger _log = Logger.getLogger(CharInfo.class.getName());
    private static final String _S__03_CHARINFO = "[S] 31 CharInfo";
    private L2PcInstance _activeChar;
    private Inventory _inv;
    private int _objId;
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _mAtkSpd;
    private int _pAtkSpd;
    private int _runSpd;
    private int _walkSpd;
    private float _moveMultiplier;
    private float _attackSpeedMultiplier;
    private int _vehicleId;
    private int _airShipHelm;

    public CharInfo(L2PcInstance cha) {
        this._activeChar = cha;
        this._objId = cha.getObjectId();
        this._inv = cha.getInventory();
        if (this._activeChar.getVehicle() != null && this._activeChar.getInVehiclePosition() != null) {
            this._x = this._activeChar.getInVehiclePosition().getX();
            this._y = this._activeChar.getInVehiclePosition().getY();
            this._z = this._activeChar.getInVehiclePosition().getZ();
            this._vehicleId = this._activeChar.getVehicle().getObjectId();
            this._airShipHelm = this._activeChar.isInAirShip() && this._activeChar.getAirShip().isCaptain(this._activeChar) ? this._activeChar.getAirShip().getHelmItemId() : 0;
        } else {
            this._x = this._activeChar.getX();
            this._y = this._activeChar.getY();
            this._z = this._activeChar.getZ();
            this._vehicleId = 0;
            this._airShipHelm = 0;
        }
        this._heading = this._activeChar.getHeading();
        this._mAtkSpd = this._activeChar.getMAtkSpd();
        this._pAtkSpd = this._activeChar.getPAtkSpd();
        this._moveMultiplier = this._activeChar.getMovementSpeedMultiplier();
        this._attackSpeedMultiplier = this._activeChar.getAttackSpeedMultiplier();
        this._runSpd = (int)((float)this._activeChar.getRunSpeed() / this._moveMultiplier);
        this._walkSpd = (int)((float)this._activeChar.getWalkSpeed() / this._moveMultiplier);
        this._invisible = cha.getAppearance().getInvisible();
    }

    public CharInfo(L2Decoy decoy) {
        this(decoy.getActingPlayer());
        this._vehicleId = 0;
        this._airShipHelm = 0;
        this._objId = decoy.getObjectId();
        this._x = decoy.getX();
        this._y = decoy.getY();
        this._z = decoy.getZ();
        this._heading = decoy.getHeading();
    }

    @Override
    protected final void writeImpl() {
        L2PcInstance tmp;
        boolean gmSeeInvis = false;
        if (this._invisible && (tmp = ((L2GameClient)this.getClient()).getActiveChar()) != null && tmp.isGM()) {
            gmSeeInvis = true;
        }
        if (this._activeChar.getPoly().isMorphed()) {
            L2NpcTemplate template = NpcTable.getInstance().getTemplate(this._activeChar.getPoly().getPolyId());
            if (template != null) {
                this.writeC(12);
                this.writeD(this._objId);
                this.writeD(this._activeChar.getPoly().getPolyId() + 1000000);
                this.writeD(this._activeChar.getKarma() > 0 ? 1 : 0);
                this.writeD(this._x);
                this.writeD(this._y);
                this.writeD(this._z);
                this.writeD(this._heading);
                this.writeD(0);
                this.writeD(this._mAtkSpd);
                this.writeD(this._pAtkSpd);
                this.writeD(this._runSpd);
                this.writeD(this._walkSpd);
                this.writeD(this._runSpd);
                this.writeD(this._walkSpd);
                this.writeD(this._runSpd);
                this.writeD(this._walkSpd);
                this.writeD(this._runSpd);
                this.writeD(this._walkSpd);
                this.writeF(this._moveMultiplier);
                this.writeF(this._attackSpeedMultiplier);
                this.writeF(template.fCollisionRadius);
                this.writeF(template.fCollisionHeight);
                this.writeD(this._inv.getPaperdollItemId(5));
                this.writeD(0);
                this.writeD(this._inv.getPaperdollItemId(7));
                this.writeC(1);
                this.writeC(this._activeChar.isRunning() ? 1 : 0);
                this.writeC(this._activeChar.isInCombat() ? 1 : 0);
                this.writeC(this._activeChar.isAlikeDead() ? 1 : 0);
                if (gmSeeInvis) {
                    this.writeC(0);
                } else {
                    this.writeC(this._invisible ? 1 : 0);
                }
                this.writeS(this._activeChar.getAppearance().getVisibleName());
                if (gmSeeInvis) {
                    this.writeS("Invisible");
                } else {
                    this.writeS(this._activeChar.getAppearance().getVisibleTitle());
                }
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
                if (gmSeeInvis) {
                    this.writeD(this._activeChar.getAbnormalEffect() | AbnormalEffect.STEALTH.getMask());
                } else {
                    this.writeD(this._activeChar.getAbnormalEffect());
                }
                this.writeD(this._activeChar.getClanId());
                this.writeD(this._activeChar.getClanCrestId());
                this.writeD(0);
                this.writeD(0);
                this.writeC(0);
                this.writeC(0);
                this.writeF(template.fCollisionRadius);
                this.writeF(template.fCollisionHeight);
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
                this.writeC(1);
                this.writeC(1);
                this.writeD(0);
            } else {
                _log.warning("Character " + this._activeChar.getName() + " (" + this._activeChar.getObjectId() + ") morphed in a Npc (" + this._activeChar.getPoly().getPolyId() + ") w/o template.");
            }
        } else {
            this.writeC(49);
            this.writeD(this._x);
            this.writeD(this._y);
            this.writeD(this._z);
            this.writeD(this._vehicleId);
            this.writeD(this._objId);
            this.writeS(this._activeChar.getAppearance().getVisibleName());
            this.writeD(this._activeChar.getRace().ordinal());
            this.writeD(this._activeChar.getAppearance().getSex() ? 1 : 0);
            if (this._activeChar.getClassIndex() == 0) {
                this.writeD(this._activeChar.getClassId().getId());
            } else {
                this.writeD(this._activeChar.getBaseClass());
            }
            this.writeD(this._inv.getPaperdollItemId(0));
            this.writeD(this._inv.getPaperdollItemId(1));
            if (this._airShipHelm == 0) {
                this.writeD(this._inv.getPaperdollItemId(5));
                this.writeD(this._inv.getPaperdollItemId(7));
            } else {
                this.writeD(this._airShipHelm);
                this.writeD(0);
            }
            this.writeD(this._inv.getPaperdollItemId(10));
            this.writeD(this._inv.getPaperdollItemId(6));
            this.writeD(this._inv.getPaperdollItemId(11));
            this.writeD(this._inv.getPaperdollItemId(12));
            this.writeD(this._inv.getPaperdollItemId(23));
            this.writeD(this._inv.getPaperdollItemId(5));
            this.writeD(this._inv.getPaperdollItemId(2));
            this.writeD(this._inv.getPaperdollItemId(3));
            this.writeD(this._inv.getPaperdollItemId(16));
            this.writeD(this._inv.getPaperdollItemId(15));
            this.writeD(this._inv.getPaperdollItemId(17));
            this.writeD(this._inv.getPaperdollItemId(18));
            this.writeD(this._inv.getPaperdollItemId(19));
            this.writeD(this._inv.getPaperdollItemId(20));
            this.writeD(this._inv.getPaperdollItemId(21));
            this.writeD(this._inv.getPaperdollItemId(22));
            this.writeD(this._inv.getPaperdollItemId(24));
            this.writeD(this._inv.getPaperdollAugmentationId(0));
            this.writeD(this._inv.getPaperdollAugmentationId(1));
            if (this._airShipHelm == 0) {
                this.writeD(this._inv.getPaperdollAugmentationId(5));
                this.writeD(this._inv.getPaperdollAugmentationId(7));
            } else {
                this.writeD(0);
                this.writeD(0);
            }
            this.writeD(this._inv.getPaperdollAugmentationId(10));
            this.writeD(this._inv.getPaperdollAugmentationId(6));
            this.writeD(this._inv.getPaperdollAugmentationId(11));
            this.writeD(this._inv.getPaperdollAugmentationId(12));
            this.writeD(this._inv.getPaperdollAugmentationId(23));
            this.writeD(this._inv.getPaperdollAugmentationId(5));
            this.writeD(this._inv.getPaperdollAugmentationId(2));
            this.writeD(this._inv.getPaperdollAugmentationId(3));
            this.writeD(this._inv.getPaperdollAugmentationId(16));
            this.writeD(this._inv.getPaperdollAugmentationId(15));
            this.writeD(this._inv.getPaperdollAugmentationId(17));
            this.writeD(this._inv.getPaperdollAugmentationId(18));
            this.writeD(this._inv.getPaperdollAugmentationId(19));
            this.writeD(this._inv.getPaperdollAugmentationId(20));
            this.writeD(this._inv.getPaperdollAugmentationId(21));
            this.writeD(this._inv.getPaperdollAugmentationId(22));
            this.writeD(this._inv.getPaperdollAugmentationId(24));
            this.writeD(0);
            this.writeD(1);
            this.writeD(this._activeChar.getPvpFlag());
            this.writeD(this._activeChar.getKarma());
            this.writeD(this._mAtkSpd);
            this.writeD(this._pAtkSpd);
            this.writeD(0);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeD(this._runSpd);
            this.writeD(this._walkSpd);
            this.writeF(this._activeChar.getMovementSpeedMultiplier());
            this.writeF(this._activeChar.getAttackSpeedMultiplier());
            if (this._activeChar.getMountType() != 0) {
                this.writeF(NpcTable.getInstance().getTemplate((int)this._activeChar.getMountNpcId()).fCollisionRadius);
                this.writeF(NpcTable.getInstance().getTemplate((int)this._activeChar.getMountNpcId()).fCollisionHeight);
            } else if (this._activeChar.getTransformation() != null) {
                this.writeF(this._activeChar.getTransformation().getCollisionRadius());
                this.writeF(this._activeChar.getTransformation().getCollisionHeight());
            } else {
                this.writeF(this._activeChar.getCollisionRadius());
                this.writeF(this._activeChar.getCollisionHeight());
            }
            this.writeD(this._activeChar.getAppearance().getHairStyle());
            this.writeD(this._activeChar.getAppearance().getHairColor());
            this.writeD(this._activeChar.getAppearance().getFace());
            if (gmSeeInvis) {
                this.writeS("Invisible");
            } else {
                this.writeS(this._activeChar.getAppearance().getVisibleTitle());
            }
            if (!this._activeChar.isCursedWeaponEquipped()) {
                this.writeD(this._activeChar.getClanId());
                this.writeD(this._activeChar.getClanCrestId());
                this.writeD(this._activeChar.getAllyId());
                this.writeD(this._activeChar.getAllyCrestId());
            } else {
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
                this.writeD(0);
            }
            this.writeC(this._activeChar.isSitting() ? 0 : 1);
            this.writeC(this._activeChar.isRunning() ? 1 : 0);
            this.writeC(this._activeChar.isInCombat() ? 1 : 0);
            if (this._activeChar.isInOlympiadMode()) {
                this.writeC(0);
            } else {
                this.writeC(this._activeChar.isAlikeDead() ? 1 : 0);
            }
            if (gmSeeInvis) {
                this.writeC(0);
            } else {
                this.writeC(this._invisible ? 1 : 0);
            }
            this.writeC(this._activeChar.getMountType());
            this.writeC(this._activeChar.getPrivateStoreType());
            this.writeH(this._activeChar.getCubics().size());
            for (int id : this._activeChar.getCubics().keySet()) {
                this.writeH(id);
            }
            this.writeC(this._activeChar.isInPartyMatchRoom() ? 1 : 0);
            if (gmSeeInvis) {
                this.writeD(this._activeChar.getAbnormalEffect() | AbnormalEffect.STEALTH.getMask());
            } else {
                this.writeD(this._activeChar.getAbnormalEffect());
            }
            this.writeC(this._activeChar.isFlyingMounted() ? 2 : 0);
            this.writeH(this._activeChar.getRecomHave());
            this.writeD(this._activeChar.getMountNpcId() + 1000000);
            this.writeD(this._activeChar.getClassId().getId());
            this.writeD(0);
            this.writeC(this._activeChar.isMounted() || this._airShipHelm != 0 ? 0 : this._activeChar.getEnchantEffect());
            if (this._activeChar.getTeam() == 1) {
                this.writeC(1);
            } else if (this._activeChar.getTeam() == 2) {
                this.writeC(2);
            } else {
                this.writeC(0);
            }
            this.writeD(this._activeChar.getClanCrestLargeId());
            this.writeC(this._activeChar.isNoble() ? 1 : 0);
            this.writeC(this._activeChar.isHero() || this._activeChar.isGM() && Config.GM_HERO_AURA ? 1 : 0);
            this.writeC(this._activeChar.isFishing() ? 1 : 0);
            this.writeD(this._activeChar.getFishx());
            this.writeD(this._activeChar.getFishy());
            this.writeD(this._activeChar.getFishz());
            this.writeD(this._activeChar.getAppearance().getNameColor());
            this.writeD(this._heading);
            this.writeD(this._activeChar.getPledgeClass());
            this.writeD(this._activeChar.getPledgeType());
            this.writeD(this._activeChar.getAppearance().getTitleColor());
            if (this._activeChar.isCursedWeaponEquipped()) {
                this.writeD(CursedWeaponsManager.getInstance().getLevel(this._activeChar.getCursedWeaponEquippedId()));
            } else {
                this.writeD(0);
            }
            if (this._activeChar.getClanId() > 0) {
                this.writeD(this._activeChar.getClan().getReputationScore());
            } else {
                this.writeD(0);
            }
            this.writeD(this._activeChar.getTransformationId());
            this.writeD(this._activeChar.getAgathionId());
            this.writeD(1);
            this.writeD(this._activeChar.getSpecialEffect());
        }
    }

    @Override
    public String getType() {
        return _S__03_CHARINFO;
    }
}

