/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.status;

import com.l2jserver.Config;
import com.l2jserver.loginserver.GameServerTable;
import com.l2jserver.loginserver.L2LoginServer;
import com.l2jserver.loginserver.LoginController;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Logger;

public class LoginStatusThread
extends Thread {
    private static final Logger _log = Logger.getLogger(LoginStatusThread.class.getName());
    private Socket _cSocket;
    private PrintWriter _print;
    private BufferedReader _read;
    private boolean _redirectLogger;

    private void telnetOutput(int type, String text) {
        if (type == 1) {
            System.out.println("TELNET | " + text);
        } else if (type == 2) {
            System.out.print("TELNET | " + text);
        } else if (type == 3) {
            System.out.print(text);
        } else if (type == 4) {
            System.out.println(text);
        } else {
            System.out.println("TELNET | " + text);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidIP(Socket client) {
        boolean result = false;
        InetAddress ClientIP = client.getInetAddress();
        String clientStringIP = ClientIP.getHostAddress();
        this.telnetOutput(1, "Connection from: " + clientStringIP);
        if (Config.DEVELOPER) {
            this.telnetOutput(2, "");
        }
        InputStream telnetIS = null;
        try {
            Properties telnetSettings = new Properties();
            telnetIS = new FileInputStream(new File("./config/telnet.properties"));
            telnetSettings.load(telnetIS);
            String HostList = telnetSettings.getProperty("ListOfHosts", "127.0.0.1,localhost,::1");
            if (Config.DEVELOPER) {
                this.telnetOutput(3, "Comparing ip to list...");
            }
            String ipToCompare = null;
            for (String ip : HostList.split(",")) {
                if (result) continue;
                ipToCompare = InetAddress.getByName(ip).getHostAddress();
                if (clientStringIP.equals(ipToCompare)) {
                    result = true;
                }
                if (!Config.DEVELOPER) continue;
                this.telnetOutput(3, clientStringIP + " = " + ipToCompare + "(" + ip + ") = " + result);
            }
        }
        catch (IOException e) {
            if (Config.DEVELOPER) {
                this.telnetOutput(4, "");
            }
            this.telnetOutput(1, "Error: " + e);
        }
        finally {
            try {
                telnetIS.close();
            }
            catch (Exception e) {}
        }
        if (Config.DEVELOPER) {
            this.telnetOutput(4, "Allow IP: " + result);
        }
        return result;
    }

    public LoginStatusThread(Socket client, int uptime, String StatusPW) throws IOException {
        this._cSocket = client;
        this._print = new PrintWriter(this._cSocket.getOutputStream());
        this._read = new BufferedReader(new InputStreamReader(this._cSocket.getInputStream()));
        if (this.isValidIP(client)) {
            this.telnetOutput(1, client.getInetAddress().getHostAddress() + " accepted.");
            this._print.println("Welcome To The L2J Telnet Session.");
            this._print.println("Please Insert Your Password!");
            this._print.print("Password: ");
            this._print.flush();
            String tmpLine = this._read.readLine();
            if (tmpLine == null) {
                this._print.println("Error.");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else if (tmpLine.compareTo(StatusPW) != 0) {
                this._print.println("Incorrect Password!");
                this._print.println("Disconnected...");
                this._print.flush();
                this._cSocket.close();
            } else {
                this._print.println("Password Correct!");
                this._print.println("[L2J Login Server]");
                this._print.print("");
                this._print.flush();
                this.start();
            }
        } else {
            this.telnetOutput(5, "Connection attempt from " + client.getInetAddress().getHostAddress() + " rejected.");
            this._cSocket.close();
        }
    }

    @Override
    public void run() {
        String _usrCommand = "";
        try {
            while (_usrCommand.compareTo("quit") != 0 && _usrCommand.compareTo("exit") != 0) {
                block21: {
                    _usrCommand = this._read.readLine();
                    if (_usrCommand == null) {
                        this._cSocket.close();
                        break;
                    }
                    if (_usrCommand.equals("help")) {
                        this._print.println("The following is a list of all available commands: ");
                        this._print.println("help                - shows this help.");
                        this._print.println("status              - displays basic server statistics.");
                        this._print.println("unblock <ip>        - removes <ip> from banlist.");
                        this._print.println("shutdown\t\t\t- shuts down server.");
                        this._print.println("restart\t\t\t\t- restarts the server.");
                        this._print.println("RedirectLogger\t\t- Telnet will give you some info about server in real time.");
                        this._print.println("quit                - closes telnet session.");
                        this._print.println("");
                    } else if (_usrCommand.equals("status")) {
                        this._print.println("Registered Server Count: " + GameServerTable.getInstance().getRegisteredGameServers().size());
                    } else if (_usrCommand.startsWith("unblock")) {
                        try {
                            _usrCommand = _usrCommand.substring(8);
                            if (LoginController.getInstance().removeBanForAddress(_usrCommand)) {
                                _log.warning("IP removed via TELNET by host: " + this._cSocket.getInetAddress().getHostAddress());
                                this._print.println("The IP " + _usrCommand + " has been removed from the hack protection list!");
                                break block21;
                            }
                            this._print.println("IP not found in hack protection list...");
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            this._print.println("Please Enter the IP to Unblock!");
                        }
                    } else if (_usrCommand.startsWith("shutdown")) {
                        L2LoginServer.getInstance().shutdown(false);
                        this._print.println("Bye Bye!");
                        this._print.flush();
                        this._cSocket.close();
                    } else if (_usrCommand.startsWith("restart")) {
                        L2LoginServer.getInstance().shutdown(true);
                        this._print.println("Bye Bye!");
                        this._print.flush();
                        this._cSocket.close();
                    } else if (_usrCommand.equals("RedirectLogger")) {
                        this._redirectLogger = true;
                    } else if (!_usrCommand.equals("quit") && _usrCommand.length() != 0) {
                        this._print.println("Invalid Command");
                    }
                }
                this._print.print("");
                this._print.flush();
            }
            if (!this._cSocket.isClosed()) {
                this._print.println("Bye Bye!");
                this._print.flush();
                this._cSocket.close();
            }
            this.telnetOutput(1, "Connection from " + this._cSocket.getInetAddress().getHostAddress() + " was closed by client.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToTelnet(String msg) {
        PrintWriter printWriter = this._print;
        synchronized (printWriter) {
            this._print.println(msg);
            this._print.flush();
        }
    }

    public boolean isRedirectLogger() {
        return this._redirectLogger;
    }
}

