/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.entity.Fort;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FortUpdater
implements Runnable {
    protected static Logger _log = Logger.getLogger(FortUpdater.class.getName());
    private L2Clan _clan;
    private Fort _fort;
    private int _runCount;
    private UpdaterType _updaterType;

    public FortUpdater(Fort fort, L2Clan clan, int runCount, UpdaterType ut) {
        this._fort = fort;
        this._clan = clan;
        this._runCount = runCount;
        this._updaterType = ut;
    }

    @Override
    public void run() {
        try {
            switch (this._updaterType) {
                case PERIODIC_UPDATE: {
                    ++this._runCount;
                    if (this._fort.getOwnerClan() == null || this._fort.getOwnerClan() != this._clan) {
                        return;
                    }
                    this._fort.setBloodOathReward(this._fort.getBloodOathReward() + Config.FS_BLOOD_OATH_COUNT);
                    if (this._fort.getFortState() == 2) {
                        if (this._clan.getWarehouse().getAdena() >= (long)Config.FS_FEE_FOR_CASTLE) {
                            this._clan.getWarehouse().destroyItemByItemId("FS_fee_for_Castle", 57, Config.FS_FEE_FOR_CASTLE, null, null);
                            CastleManager.getInstance().getCastleById(this._fort.getCastleId()).addToTreasuryNoTax(Config.FS_FEE_FOR_CASTLE);
                            this._fort.raiseSupplyLvL();
                        } else {
                            this._fort.setFortState(1, 0);
                        }
                    }
                    this._fort.saveFortVariables();
                    break;
                }
                case MAX_OWN_TIME: {
                    if (this._fort.getOwnerClan() == null || this._fort.getOwnerClan() != this._clan) {
                        return;
                    }
                    if (this._fort.getOwnedTime() <= Config.FS_MAX_OWN_TIME * 3600) break;
                    this._fort.removeOwner(true);
                    this._fort.setFortState(0, 0);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public static enum UpdaterType {
        MAX_OWN_TIME,
        PERIODIC_UPDATE;

    }
}

