/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.base;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.base.Experience;
import com.l2jserver.gameserver.model.base.PlayerClass;

public final class SubClass {
    private static final byte _maxLevel = (byte)(Config.MAX_SUBCLASS_LEVEL < 86 ? Config.MAX_SUBCLASS_LEVEL : 85);
    private PlayerClass _class;
    private long _exp = Experience.LEVEL[40];
    private int _sp = 0;
    private byte _level = (byte)40;
    private int _classIndex = 1;

    public SubClass(int classId, long exp, int sp, byte level, int classIndex) {
        this._class = PlayerClass.values()[classId];
        this._exp = exp;
        this._sp = sp;
        this._level = level;
        this._classIndex = classIndex;
    }

    public SubClass(int classId, int classIndex) {
        this._class = PlayerClass.values()[classId];
        this._classIndex = classIndex;
    }

    public SubClass() {
    }

    public PlayerClass getClassDefinition() {
        return this._class;
    }

    public int getClassId() {
        return this._class.ordinal();
    }

    public long getExp() {
        return this._exp;
    }

    public int getSp() {
        return this._sp;
    }

    public byte getLevel() {
        return this._level;
    }

    public int getClassIndex() {
        return this._classIndex;
    }

    public void setClassId(int classId) {
        this._class = PlayerClass.values()[classId];
    }

    public void setExp(long expValue) {
        if (expValue > Experience.LEVEL[_maxLevel + 1] - 1L) {
            expValue = Experience.LEVEL[_maxLevel + 1] - 1L;
        }
        this._exp = expValue;
    }

    public void setSp(int spValue) {
        this._sp = spValue;
    }

    public void setClassIndex(int classIndex) {
        this._classIndex = classIndex;
    }

    public void setLevel(byte levelValue) {
        if (levelValue > _maxLevel) {
            levelValue = _maxLevel;
        } else if (levelValue < 40) {
            levelValue = (byte)40;
        }
        this._level = levelValue;
    }

    public void incLevel() {
        if (this.getLevel() == _maxLevel) {
            return;
        }
        this._level = (byte)(this._level + 1);
        this.setExp(Experience.LEVEL[this.getLevel()]);
    }

    public void decLevel() {
        if (this.getLevel() == 40) {
            return;
        }
        this._level = (byte)(this._level - 1);
        this.setExp(Experience.LEVEL[this.getLevel()]);
    }
}

