/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import java.util.Collection;

public final class RequestStopPledgeWar
extends L2GameClientPacket {
    private static final String _C__4F_REQUESTSTOPPLEDGEWAR = "[C] 4F RequestStopPledgeWar";
    private String _pledgeName;

    @Override
    protected void readImpl() {
        this._pledgeName = this.readS();
    }

    @Override
    protected void runImpl() {
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null) {
            return;
        }
        L2Clan playerClan = player.getClan();
        if (playerClan == null) {
            return;
        }
        L2Clan clan = ClanTable.getInstance().getClanByName(this._pledgeName);
        if (clan == null) {
            player.sendMessage("No such clan.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (!playerClan.isAtWarWith(clan.getClanId())) {
            player.sendMessage("You aren't at war with this clan.");
            player.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if ((player.getClanPrivileges() & 0x20) != 32) {
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.YOU_ARE_NOT_AUTHORIZED_TO_DO_THAT));
            return;
        }
        for (L2ClanMember member : playerClan.getMembers()) {
            if (member == null || member.getPlayerInstance() == null || !AttackStanceTaskManager.getInstance().getAttackStanceTask(member.getPlayerInstance())) continue;
            player.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.CANT_STOP_CLAN_WAR_WHILE_IN_COMBAT));
            return;
        }
        ClanTable.getInstance().deleteclanswars(playerClan.getClanId(), clan.getClanId());
        Collection<L2PcInstance> pls = L2World.getInstance().getAllPlayers().values();
        for (L2PcInstance cha : pls) {
            if (cha.getClan() != player.getClan() && cha.getClan() != clan) continue;
            cha.broadcastUserInfo();
        }
    }

    @Override
    public String getType() {
        return _C__4F_REQUESTSTOPPLEDGEWAR;
    }
}

