/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2SiegeClan;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;

public final class SiegeDefenderList
extends L2GameServerPacket {
    private static final String _S__CA_SiegeDefenderList = "[S] cb SiegeDefenderList";
    private Castle _castle;

    public SiegeDefenderList(Castle castle) {
        this._castle = castle;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(203);
        this.writeD(this._castle.getCastleId());
        this.writeD(0);
        this.writeD(1);
        this.writeD(0);
        int size = this._castle.getSiege().getDefenderClans().size() + this._castle.getSiege().getDefenderWaitingClans().size();
        if (size > 0) {
            L2Clan clan;
            this.writeD(size);
            this.writeD(size);
            for (L2SiegeClan siegeclan : this._castle.getSiege().getDefenderClans()) {
                clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
                if (clan == null) continue;
                this.writeD(clan.getClanId());
                this.writeS(clan.getName());
                this.writeS(clan.getLeaderName());
                this.writeD(clan.getCrestId());
                this.writeD(0);
                switch (siegeclan.getType()) {
                    case OWNER: {
                        this.writeD(1);
                        break;
                    }
                    case DEFENDER_PENDING: {
                        this.writeD(2);
                        break;
                    }
                    case DEFENDER: {
                        this.writeD(3);
                        break;
                    }
                    default: {
                        this.writeD(0);
                    }
                }
                this.writeD(clan.getAllyId());
                this.writeS(clan.getAllyName());
                this.writeS("");
                this.writeD(clan.getAllyCrestId());
            }
            for (L2SiegeClan siegeclan : this._castle.getSiege().getDefenderWaitingClans()) {
                clan = ClanTable.getInstance().getClan(siegeclan.getClanId());
                this.writeD(clan.getClanId());
                this.writeS(clan.getName());
                this.writeS(clan.getLeaderName());
                this.writeD(clan.getCrestId());
                this.writeD(0);
                this.writeD(2);
                this.writeD(clan.getAllyId());
                this.writeS(clan.getAllyName());
                this.writeS("");
                this.writeD(clan.getAllyCrestId());
            }
        } else {
            this.writeD(0);
            this.writeD(0);
        }
    }

    @Override
    public String getType() {
        return _S__CA_SiegeDefenderList;
    }
}

